/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.inviteuser.anonymization;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.plugin.inviteuser.ao.InvitationEntity;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.UserNameChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateSenderUsernameInInvitationEntityChangeHandler
implements UserNameChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(UpdateSenderUsernameInInvitationEntityChangeHandler.class);
    private final ActiveObjects ao;
    private final I18nHelper i18nHelper;

    public UpdateSenderUsernameInInvitationEntityChangeHandler(ActiveObjects ao, I18nHelper i18nHelper) {
        this.ao = ao;
        this.i18nHelper = i18nHelper;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter parameter) {
        int entitiesCount = this.ao.count(InvitationEntity.class, this.getInvitationsWithSenderQuery(parameter.getOriginal()));
        if (entitiesCount > 0) {
            return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).numberOfOccurrences(Long.valueOf(entitiesCount)).descriptionKey("inviteuser.anonymization.affected.entity.description").build());
        }
        return ImmutableList.of();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter parameter) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Context.Task task = parameter.getContext().start(null);
        try {
            InvitationEntity[] invitationEntities = this.getInvitationEntities(parameter);
            this.changeSenderUsernameForInvitationEntity(errors, invitationEntities, parameter.getTarget());
        }
        finally {
            task.complete();
        }
        return new ServiceResultImpl((ErrorCollection)errors);
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return 1;
    }

    @Nonnull
    private Query getInvitationsWithSenderQuery(@Nonnull String username) {
        return Query.select().where("SENDER_USERNAME = ?", new Object[]{username});
    }

    @Nonnull
    private InvitationEntity[] getInvitationEntities(@Nonnull UserPropertyChangeParameter parameter) {
        return (InvitationEntity[])this.ao.find(InvitationEntity.class, this.getInvitationsWithSenderQuery(parameter.getOriginal()));
    }

    @ParametersAreNonnullByDefault
    private void changeSenderUsernameForInvitationEntity(SimpleErrorCollection errors, InvitationEntity[] invitationEntities, String newUsername) {
        for (InvitationEntity invitationEntity : invitationEntities) {
            try {
                this.changeSenderUsernameForInvitationEntity(invitationEntity, newUsername);
            }
            catch (Exception ex) {
                log.error("An exception occurred during changing sender username in InvitationEntity", (Throwable)ex);
                errors.addErrorMessage(this.i18nHelper.getText("change.handler.processing.exception", ex.getMessage()));
            }
        }
    }

    @ParametersAreNonnullByDefault
    private void changeSenderUsernameForInvitationEntity(InvitationEntity invitationEntity, String newUsername) {
        invitationEntity.setSenderUsername(newUsername);
        invitationEntity.save();
    }
}

