/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.inviteuser;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.plugin.inviteuser.Invitation;
import com.atlassian.jira.plugin.inviteuser.InvitationManager;
import com.atlassian.jira.plugin.inviteuser.InvitationService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class InvitationServiceImpl
implements InvitationService {
    private final InvitationManager invitationManager;
    private final I18nHelper.BeanFactory beanFactory;

    public InvitationServiceImpl(InvitationManager invitationManager, I18nHelper.BeanFactory beanFactory) {
        this.invitationManager = invitationManager;
        this.beanFactory = beanFactory;
    }

    @Override
    public Invitation getInvitationByToken(String token) {
        return this.invitationManager.getInvitationByToken(token);
    }

    @Override
    public Collection<Invitation> getInvitationsByEmail(String emailAddress) {
        return this.invitationManager.getInvitationsByEmail(emailAddress);
    }

    @Override
    public Collection<Invitation> getAllInvitations() {
        return this.invitationManager.getAllInvitations();
    }

    @Override
    public InvitationService.SendValidationResult validateSendInvitation(ApplicationUser from, String emailAddress, InvitationService.Expiry expiry, Set<ApplicationKey> applicationKeys) {
        return this.validateSendInvitation(from, emailAddress, expiry.getExpiryDate(), applicationKeys);
    }

    @Override
    public InvitationService.SendValidationResult validateSendInvitation(ApplicationUser from, String emailAddress, Date expiry, Set<ApplicationKey> applicationKeys) {
        InvitationService.BadEmail reason = null;
        if (StringUtils.isBlank((String)emailAddress)) {
            reason = InvitationService.BadEmail.BLANK;
        } else if (!TextUtils.verifyEmail((String)emailAddress)) {
            reason = InvitationService.BadEmail.INVALID_EMAIL;
        } else if (UserUtils.getUserByEmail((String)emailAddress) != null) {
            reason = InvitationService.BadEmail.EXISTING_USER;
        }
        return new InvitationService.SendValidationResult(from, emailAddress, expiry, reason, applicationKeys);
    }

    @Override
    public Invitation sendInvitation(InvitationService.SendValidationResult createValidationResult) {
        return this.invitationManager.sendInvitation(createValidationResult.getFrom(), createValidationResult.getEmailAddress(), createValidationResult.getExpiry(), createValidationResult.getApplicationKeys());
    }

    @Override
    public InvitationService.RedeemValidationResult validateRedeemInvitation(Invitation invitation) {
        Date today = new Date();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        if (invitation == null) {
            errors.addErrorMessage(this.getI18n(null).getText("inviteuser.redeem.error.blank"));
        } else if (invitation.isRedeemed()) {
            errors.addErrorMessage(this.getI18n(null).getText("inviteuser.redeem.error.already.redeemed"));
        } else if (today.after(invitation.getExpiry())) {
            errors.addErrorMessage(this.getI18n(null).getText("inviteuser.redeem.error.expired"));
        }
        return new InvitationService.RedeemValidationResult(invitation, (ErrorCollection)errors);
    }

    @Override
    public int redeemInvitation(InvitationService.RedeemValidationResult redeemValidationResult) {
        Invitation invitation = redeemValidationResult.getInvitation();
        String emailAddress = invitation.getEmailAddress();
        return this.invitationManager.redeemInvitationsByEmail(emailAddress);
    }

    @Override
    public void removeInvitationByToken(String token) {
        this.invitationManager.removeInvitationByToken(token);
    }

    @Override
    public int removeInvitationsByEmail(String emailAddress) {
        return this.invitationManager.removeInvitationsByEmail(emailAddress);
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return this.beanFactory.getInstance(user);
    }
}

