/**
 * Binds all the header implementations of Dropdown2. Including global nav and user profile.
 */
JIRA.Dropdowns.bindHeaderDropdown2 = function () {
    AJS.$(".jira-ajax-menu").each(function() {
        var $ddtrigger = AJS.$(this);
        var $dd = AJS.$("#" + $ddtrigger.attr("aria-owns"));
        var $ajaxkey = $dd.data("aui-dropdown2-ajax-key");

        if ($ajaxkey) {
            $dd.bind("aui-dropdown2-show", function(event, options) {
                $dd.empty();
                $dd.addClass("aui-dropdown2-loading");
                JIRA.SmartAjax.makeRequest({
                    url: contextPath + "/rest/api/1.0/menus/" + $ajaxkey,
                    data: {
                        inAdminMode: AJS.Meta.getBoolean("in-admin-mode")
                    },
                    dataType: "json",
                    cache: false,
                    success: function (data) {
                        $dd.removeClass("aui-dropdown2-loading");
                        $dd.html(JIRA.Templates.Menu.Dropdowns.dropdown2Fragment(data));

                        if (options && options.selectFirst) {
                            $dd.find("a:not(.disabled)").filter(":first").addClass("active")
                        }
                    }
                });
            });
        }
    });
};

AJS.$(function(){
    JIRA.Dropdowns.bindHeaderDropdown2();
});
