/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.customcontentlinks.admin;

import com.atlassian.jira.plugin.headernav.customcontentlinks.CustomContentLinkServiceFactory;
import com.atlassian.jira.plugin.headernav.customcontentlinks.admin.ContentLinkAdminDescriptionProvider;
import com.atlassian.jira.plugin.webfragment.CacheableContextProvider;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class SummaryContextProvider
implements CacheableContextProvider {
    static final Pattern PATTERN = Pattern.compile("/*project-config/+([^/]+)");
    private final ProjectManager projectManager;
    private final CustomContentLinkServiceFactory customContentLinkServiceFactory;
    private final VelocityRequestContextFactory requestContextFactory;
    private ContentLinkAdminDescriptionProvider contentLinkAdminDescriptionProvider;

    public SummaryContextProvider(ProjectManager projectManager, CustomContentLinkServiceFactory customContentLinkServiceFactory, VelocityRequestContextFactory requestContextFactory, ContentLinkAdminDescriptionProvider contentLinkAdminDescriptionProvider) {
        this.projectManager = projectManager;
        this.customContentLinkServiceFactory = customContentLinkServiceFactory;
        this.requestContextFactory = requestContextFactory;
        this.contentLinkAdminDescriptionProvider = contentLinkAdminDescriptionProvider;
    }

    public String getUniqueContextKey(Map<String, Object> context) {
        return this.getProjectKey();
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>(context);
        List allLinks = this.customContentLinkServiceFactory.getCustomContentLinkService().getCustomContentLinks(this.getProjectKey());
        List shownLinks = allLinks.subList(0, Math.min(5, allLinks.size()));
        contextMap.put("totalSize", allLinks.size());
        contextMap.put("shownSize", shownLinks.size());
        contextMap.put("links", shownLinks);
        contextMap.put("manageCustomContentLinksLink", this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl() + "/plugins/servlet/custom-content-links-admin?entityKey=" + this.getProjectKey());
        contextMap.put("description", this.contentLinkAdminDescriptionProvider.getDescription());
        return contextMap;
    }

    private String getProjectKey() {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request != null) {
            Matcher matcher = PATTERN.matcher(request.getPathInfo());
            if (matcher.find()) {
                return matcher.group(1);
            }
            throw new IllegalArgumentException("Expected URL '" + request.getPathInfo() + " to match /project-config/KEY");
        }
        throw new IllegalStateException("No HTTP request is running");
    }
}

