/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.customcontentlinks.admin;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.util.UserManager;

public class ProjectAdminPermissionChecker {
    private PermissionManager permissionManager;
    private ProjectManager projectManager;
    private UserManager userManager;

    public ProjectAdminPermissionChecker(PermissionManager permissionManager, ProjectManager projectManager, UserManager userManager) {
        this.permissionManager = permissionManager;
        this.projectManager = projectManager;
        this.userManager = userManager;
    }

    public boolean canAdminister(String projectKey, String userName) {
        User user;
        Project jiraProject = this.projectManager.getProjectObjByKey(projectKey);
        if (jiraProject != null && (user = this.userManager.getUser(userName)) != null) {
            return this.permissionManager.hasPermission(23, jiraProject, user);
        }
        return false;
    }
}

