/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.headernav.customcontentlinks.admin;

import com.atlassian.jira.plugin.headernav.customcontentlinks.CustomContentLinkServiceFactory;
import com.atlassian.jira.plugin.headernav.customcontentlinks.admin.CustomContentLinkData;
import com.atlassian.jira.plugin.headernav.customcontentlinks.admin.MoveBean;
import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.CustomContentLink;
import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.NoAdminPermissionException;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="/customcontentlinks")
public class CustomContentLinksRestResource {
    private final CustomContentLinkServiceFactory customContentLinkServiceFactory;
    private final I18nResolver i18nResolver;

    public CustomContentLinksRestResource(CustomContentLinkServiceFactory customContentLinkServiceFactory, I18nResolver i18nResolver) {
        this.customContentLinkServiceFactory = customContentLinkServiceFactory;
        this.i18nResolver = i18nResolver;
    }

    @Path(value="{projectKey}/list")
    @GET
    public Response list(@PathParam(value="projectKey") String projectKey) {
        Iterable l = Iterables.transform((Iterable)this.customContentLinkServiceFactory.getCustomContentLinkService().getCustomContentLinks(projectKey), this.converter());
        return Response.ok((Object)l).build();
    }

    private Function<CustomContentLink, CustomContentLinkData> converter() {
        return new Function<CustomContentLink, CustomContentLinkData>(){

            public CustomContentLinkData apply(@Nullable CustomContentLink c) {
                return new CustomContentLinkData(Integer.toString(c.getId()), c.getContentKey(), c.getLinkLabel(), c.getLinkUrl());
            }
        };
    }

    @Path(value="{projectKey}/{id}")
    @GET
    public Response get(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") String id, @Context HttpServletRequest request) {
        try {
            CustomContentLink link = this.customContentLinkServiceFactory.getCustomContentLinkService().getById(Integer.parseInt(id));
            if (link == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)this.converter().apply((Object)link)).build();
        }
        catch (NumberFormatException e) {
            return this.reportBadId(id);
        }
    }

    private Response reportBadId(String id) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Bad id '" + id + "'")).build();
    }

    private Response handleNoPermission() {
        return Response.status((int)403).build();
    }

    @Path(value="{projectKey}/{id}")
    @DELETE
    public Response delete(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") String id, @Context HttpServletRequest request) {
        try {
            this.customContentLinkServiceFactory.getCustomContentLinkService().removeById(Integer.parseInt(id));
        }
        catch (NumberFormatException e) {
            return this.reportBadId(id);
        }
        catch (NoAdminPermissionException e) {
            return this.handleNoPermission();
        }
        return Response.ok().build();
    }

    @Path(value="{projectKey}")
    @POST
    public Response create(@PathParam(value="projectKey") String projectKey, CustomContentLinkData data) {
        try {
            CustomContentLink link = this.dataToLink(projectKey, data).build();
            return Response.ok((Object)this.converter().apply((Object)this.customContentLinkServiceFactory.getCustomContentLinkService().addCustomContentLink(link))).build();
        }
        catch (NoAdminPermissionException e) {
            return this.handleNoPermission();
        }
        catch (ValidationException ve) {
            return this.validationErrorResponse(ve);
        }
    }

    private CustomContentLink.Builder dataToLink(String projectKey, CustomContentLinkData data) throws ValidationException {
        if (StringUtils.isBlank((String)data.linkUrl)) {
            throw new ValidationException("linkUrl", this.i18nResolver.getText("must.not.be.empty"));
        }
        if (StringUtils.isBlank((String)data.linkLabel)) {
            throw new ValidationException("linkLabel", this.i18nResolver.getText("must.not.be.empty"));
        }
        return CustomContentLink.builder().key(projectKey).url(data.linkUrl).label(data.linkLabel);
    }

    @Path(value="{projectKey}/{id}")
    @PUT
    public Response update(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") String idString, CustomContentLinkData data, @Context HttpServletRequest request) {
        try {
            int id = Integer.parseInt(idString);
            CustomContentLink currentLink = this.customContentLinkServiceFactory.getCustomContentLinkService().getById(id);
            if (currentLink == null) {
                return Response.status((int)404).build();
            }
            if (data.linkLabel == null) {
                data.linkLabel = currentLink.getLinkLabel();
            }
            if (data.linkUrl == null) {
                data.linkUrl = currentLink.getLinkUrl();
            }
            CustomContentLink link = this.dataToLink(projectKey, data).id(id).build();
            this.customContentLinkServiceFactory.getCustomContentLinkService().update(link);
            return Response.ok((Object)this.converter().apply((Object)link)).build();
        }
        catch (NumberFormatException e) {
            return this.reportBadId(idString);
        }
        catch (NoAdminPermissionException e) {
            return this.handleNoPermission();
        }
        catch (ValidationException e) {
            return this.validationErrorResponse(e);
        }
    }

    @POST
    @Path(value="{projectKey}/{id}/move")
    public Response movePosition(@PathParam(value="projectKey") String projectKey, @PathParam(value="id") Integer id, @Context HttpServletRequest request, MoveBean bean) {
        try {
            if (bean.after != null) {
                int idToMoveAfter = this.extractIdFromLink(bean.after.getPath());
                this.customContentLinkServiceFactory.getCustomContentLinkService().moveAfter(id.intValue(), idToMoveAfter);
            } else {
                switch (bean.position) {
                    case Earlier: 
                    case Later: 
                    case Last: {
                        throw new IllegalArgumentException("Unexpected position '" + (Object)((Object)bean.position) + "'");
                    }
                    case First: {
                        this.customContentLinkServiceFactory.getCustomContentLinkService().moveToStart(id.intValue());
                    }
                }
            }
            return Response.ok().build();
        }
        catch (NoAdminPermissionException e) {
            return this.handleNoPermission();
        }
    }

    private int extractIdFromLink(String path) {
        String idString = path.substring(path.lastIndexOf(47) + 1);
        try {
            return Integer.parseInt(idString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Failed to parse id from path '" + path + "'");
        }
    }

    private Response validationErrorResponse(ValidationException e) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errors\": {\"" + e.getField() + "\": \"" + e.getValidationError() + "\"}}")).build();
    }

    private static class ValidationException
    extends Exception {
        private final String field;
        private final String message;

        public ValidationException(String field, String message) {
            this.field = field;
            this.message = message;
        }

        public String getField() {
            return this.field;
        }

        public String getValidationError() {
            return this.message;
        }
    }
}

