/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.assertions.TableAssertions;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.atlassian.jira.webtests.table.AndCell;
import com.atlassian.jira.webtests.table.LinkCell;
import com.atlassian.jira.webtests.table.StrictTextCell;
import com.atlassian.jira.webtests.table.TextCell;

public class TestWorkflowEditor
extends JIRAWebTest {
    private static final String WORKFLOW_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE workflow PUBLIC \"-//OpenSymphony Group//DTD OSWorkflow 2.8//EN\" \"http://www.opensymphony.com/osworkflow/workflow_2_8.dtd\">\n<workflow>\n  <meta name=\"jira.update.author.name\">admin</meta>\n  <meta name=\"jira.description\"></meta>\n  <meta name=\"jira.updated.date\">1196830052833</meta>\n  <initial-actions>\n    <action id=\"1\" name=\"Create\">\n      <validators>\n        <validator name=\"\" type=\"class\">\n          <arg name=\"class.name\">com.atlassian.jira.workflow.validator.PermissionValidator</arg>\n          <arg name=\"permission\">Create Issue</arg>\n        </validator>\n      </validators>\n      <results>\n        <unconditional-result old-status=\"null\" status=\"open\" step=\"1\">\n          <post-functions>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueCreateFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.issue.IssueReindexFunction</arg>\n            </function>\n            <function type=\"class\">\n              <arg name=\"class.name\">com.atlassian.jira.workflow.function.event.FireIssueEventFunction</arg>\n              <arg name=\"eventTypeId\">1</arg>\n            </function>\n          </post-functions>\n        </unconditional-result>\n      </results>\n    </action>\n  </initial-actions>\n  <steps>\n    <step id=\"1\" name=\"Open\">\n      <meta name=\"jira.status.id\">1</meta>\n    </step>\n  </steps>\n</workflow>";
    TableAssertions tableAssertions;

    public TestWorkflowEditor(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestWorkflowEditor.xml");
        this.tableAssertions = new TableAssertions(this.tester, this.environmentData);
    }

    public void testWorkflowListingEnterprise() {
        this.gotoWorkFlow();
        TestWorkflowEditor.assertEquals((int)5, (int)this.getWebTableWithID("workflows_table").getRowCount());
        this.assertTableRowEquals(this.getWebTableWithID("workflows_table"), 0, new Object[]{new TextCell("Name"), new TextCell("Description"), new TextCell("Status"), new TextCell("Schemes"), new TextCell("Number of steps"), new TextCell("Operations")});
        this.assertTableRowEquals(this.getWebTableWithID("workflows_table"), 1, new Object[]{new TextCell("jira", "Read-only System Workflow"), new TextCell("The default JIRA workflow."), new TextCell("Inactive"), new TextCell("Used by projects with no associated workflow scheme and by workflow schemes with unassigned issue types."), new TextCell("5"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=jira", "Steps"), new XsrfLinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=jira", "XML"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=jira", "Copy"))});
        this.assertTableRowEquals(this.getWebTableWithID("workflows_table"), 2, new Object[]{new TextCell("Workflow1", "Last modified on"), new StrictTextCell(""), new TextCell("Active"), new LinkCell("EditWorkflowSchemeEntities!default.jspa?schemeId=10010", "WorkflowScheme_Workflow1"), new TextCell("1"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Workflow1", "Steps"), new XsrfLinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=Workflow1", "XML"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Workflow1", "Copy"), new XsrfLinkCell("CreateDraftWorkflow.jspa?draftWorkflowName=Workflow1", "Create Draft"))});
        this.assertTableRowEquals(this.getWebTableWithID("workflows_table"), 3, new Object[]{new TextCell("Workflow2", "Last modified on"), new StrictTextCell(""), new TextCell("Inactive"), new StrictTextCell(""), new TextCell("1"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Workflow2", "Steps"), new XsrfLinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=Workflow2", "XML"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Workflow2", "Copy"), new XsrfLinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=Workflow2", "Edit"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=Workflow2", "Delete"))});
        this.assertTableRowEquals(this.getWebTableWithID("workflows_table"), 4, new Object[]{new TextCell("Workflow3", "Last modified on"), new StrictTextCell(""), new TextCell("Inactive"), new StrictTextCell(""), new TextCell("1"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=Workflow3", "Steps"), new XsrfLinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=Workflow3", "XML"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=Workflow3", "Copy"), new XsrfLinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=Workflow3", "Edit"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=Workflow3", "Delete"))});
        this.clickLink("copy_Workflow3");
        this.assertTextPresent("Copy Workflow: Workflow3");
        this.setFormElement("newWorkflowName", "XX Copy Of Workflow3");
        this.setFormElement("description", "Description of Workflow 3 copy");
        this.submit("Copy");
        this.assertTextPresent("View Workflows");
        this.assertTableRowEquals(this.getWebTableWithID("workflows_table"), 5, new Object[]{new TextCell("XX Copy Of Workflow3"), new TextCell("Description of Workflow 3 copy"), new TextCell("Inactive"), new StrictTextCell(""), new TextCell("1"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=XX+Copy+Of+Workflow3", "Steps"), new XsrfLinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=XX+Copy+Of+Workflow3", "XML"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=XX+Copy+Of+Workflow3", "Copy"), new XsrfLinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=XX+Copy+Of+Workflow3", "Edit"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=XX+Copy+Of+Workflow3", "Delete"))});
        this.clickLink("del_Workflow2");
        this.assertTextPresent("Delete Workflow");
        this.assertTextPresent("Confirm that you want to delete the workflow <strong>Workflow2</strong>.");
        this.assertLinkPresentWithText("do a full backup");
        this.assertLinkPresentWithText("export");
        this.submit("Delete");
        this.assertTextNotPresent("Worfklow2");
        this.clickLink("xml_Workflow3");
        TestWorkflowEditor.assertEquals((int)200, (int)this.getDialog().getResponse().getResponseCode());
        this.gotoWorkFlow();
        this.setFormElement("newWorkflowName", "ZZ This is a new Workflow!");
        this.setFormElement("description", "A new Workflow.");
        this.submit("Add");
        this.assertTextPresent("View Workflows");
        this.assertTableRowEquals(this.getWebTableWithID("workflows_table"), 5, new Object[]{new TextCell("ZZ This is a new Workflow!"), new TextCell("A new Workflow."), new TextCell("Inactive"), new StrictTextCell(""), new TextCell("1"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=ZZ+This+is+a+new+Workflow%21", "Steps"), new XsrfLinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=ZZ+This+is+a+new+Workflow%21", "XML"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=ZZ+This+is+a+new+Workflow%21", "Copy"), new XsrfLinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=ZZ+This+is+a+new+Workflow%21", "Edit"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=ZZ+This+is+a+new+Workflow%21", "Delete"))});
        this.clickLinkWithText("import a workflow from XML");
        this.setFormElement("name", "ZZZ Imported workflow");
        this.setFormElement("description", "This was imported from XML!");
        this.setFormElement("workflowXML", "Invalid input");
        this.submit("Import");
        this.assertTextPresent("Error parsing workflow XML");
        this.setFormElement("workflowXML", WORKFLOW_XML);
        this.submit("Import");
        this.assertTableRowEquals(this.getWebTableWithID("workflows_table"), 6, new Object[]{new TextCell("ZZZ Imported workflow"), new TextCell("This was imported from XML!"), new TextCell("Inactive"), new StrictTextCell(""), new TextCell("1"), new AndCell(new XsrfLinkCell("ViewWorkflowSteps.jspa?workflowMode=live&workflowName=ZZZ+Imported+workflow", "Steps"), new XsrfLinkCell("ViewWorkflowXml.jspa?workflowMode=live&workflowName=ZZZ+Imported+workflow", "XML"), new XsrfLinkCell("CloneWorkflow!default.jspa?workflowMode=live&workflowName=ZZZ+Imported+workflow", "Copy"), new XsrfLinkCell("EditWorkflow!default.jspa?workflowMode=live&workflowName=ZZZ+Imported+workflow", "Edit"), new XsrfLinkCell("DeleteWorkflow.jspa?workflowMode=live&workflowName=ZZZ+Imported+workflow", "Delete"))});
    }

    public void testActiveWorkflowCantBeEdited() {
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow1");
        this.assertTextSequence(new String[]{"View Workflow Steps", "Workflow1"});
        this.assertLinkNotPresentWithText("Add Transition");
        this.assertLinkNotPresentWithText("Edit");
        this.assertTextNotPresent("Add New Step");
        this.clickLinkWithText("View Properties");
        this.assertTextPresent("View Workflow Step Properties: Open");
        this.assertTextNotPresent("Add New Property");
        this.clickLinkWithText("Open");
        this.assertTextSequence(new String[]{"View Workflow Step", "Open"});
        this.assertLinkNotPresentWithText("Add");
        this.assertLinkNotPresentWithText("Edit");
        this.clickLink("view_properties_1");
        this.assertTextPresent("View Workflow Step Properties: Open");
        this.assertTextNotPresent("Add New Property");
        this.clickLinkWithText("workflow steps");
        this.clickLinkWithText("Open");
        this.clickLink("view_transition_1");
        this.assertTextPresent("Transition: Create");
        this.assertLinkNotPresentWithText("Edit");
        this.assertLinkNotPresentWithText("Delete");
        this.clickLinkWithText("properties of this transition");
        this.assertTextPresent("View Workflow Transition Properties: Create");
        this.assertTextNotPresent("Add New Property");
        this.gotoPage("secure/admin/workflows/EditWorkflow!default.jspa?workflowMode=live&workflowName=Workflow1");
        this.navigation.checkWebSudoWithLastPassword();
        this.setFormElement("newWorkflowName", "HackingTheActiveWorkflow");
        this.submit("Edit");
        this.assertTextPresent("Workflow cannot be edited as it is not editable.");
        this.gotoWorkFlow();
        this.assertTextNotPresent("HackingTheActiveWorkflow");
        this.gotoPage("secure/admin/workflows/AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow1&workflowStep=1");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertTextPresent("Add Workflow Transition");
        this.setFormElement("transitionName", "New transition");
        this.submit("Add");
        this.assertTextPresent("The workflow you are trying to update is not editable.");
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow1");
        this.assertTextNotPresent("New transition");
        this.gotoWorkFlow();
        this.clickLink("createDraft_Workflow1");
        this.setFormElement("stepName", "New Step");
        this.submit("Add");
        this.clickLinkWithText("Add Transition");
        this.setFormElement("transitionName", "Dude Transition");
        this.submit("Add");
        this.gotoWorkFlow();
        this.clickLink("publishDraft_Workflow1");
        this.checkCheckbox("enableBackup", "false");
        this.submit("Publish");
        this.gotoPage("secure/admin/workflows/DeleteWorkflowTransitions!confirm.jspa?workflowMode=live&workflowName=Workflow1&transitionIds=11&workflowStep=2");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertTextPresent("Delete Workflow Transitions");
        this.submit("Delete");
        this.assertTextPresent("The workflow you are trying to update is not editable.");
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow1");
        this.assertTextPresent("Dude Transition");
        this.gotoPage("secure/admin/workflows/EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow1&workflowStep=1");
        this.navigation.checkWebSudoWithLastPassword();
        this.setFormElement("stepName", "EditedWorkflowStep");
        this.submit("Update");
        this.assertTextPresent("The workflow you are trying to update is not editable.");
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow1");
        this.assertTextNotPresent("EditedWorkflowStep");
        this.gotoPage("secure/admin/workflows/DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow1&workflowStep=1");
        this.navigation.checkWebSudoWithLastPassword();
        this.submit("Delete");
        this.assertTextPresent("Cannot delete step. This workflow is not editable.");
        this.gotoPage("secure/admin/workflows/ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow1&workflowStep=1");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertTextSequence(new String[]{"View Workflow Step", "Open"});
        this.assertTextSequence(new String[]{"This page shows the details of the", "Open", "step."});
    }

    public void testViewWorkflowSteps() {
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow3");
        this.assertTextSequence(new String[]{"View Workflow Steps", "Workflow3"});
        this.assertTextPresent("This shows all of the steps for <b>Workflow3</b>.");
        this.assertLinkPresentWithText("workflows.");
        this.assertLinkPresentWithText("statuses.");
        TestWorkflowEditor.assertEquals((int)2, (int)this.getWebTableWithID("steps_table").getRowCount());
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 0, new Object[]{new TextCell("Step Name", "(id)"), new TextCell("Linked Status"), new TextCell("Transitions", "(id)"), new TextCell("Operations")});
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 1, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "Open"), new TextCell("(1)")), new TextCell("Open"), new StrictTextCell(""), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "Add Transition"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=1", "View Properties"))});
        this.setFormElement("stepName", "");
        this.submit("Add");
        this.assertTextPresent("Step name must be specified.");
        this.setFormElement("stepName", "Resolved");
        this.selectOption("stepStatus", "Resolved");
        this.submit("Add");
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Resolved"), new TextCell("(2)")), new TextCell("Resolved"), new StrictTextCell(""), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add Transition"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"), new XsrfLinkCell("DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Step"))});
        this.clickLink("add_trans_2");
        this.setFormElement("transitionName", "Re-open");
        this.setFormElement("description", "This transition re-opens a resolved issue.");
        this.selectOption("view", "Default Screen");
        this.submit("Add");
        this.assertTextSequence(new String[]{"View Workflow Steps", "Workflow3"});
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Resolved"), new TextCell("(2)")), new TextCell("Resolved"), new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=11&workflowStep=2", "Re-open"), new TextCell("(11)", "Open")), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add Transition"), new XsrfLinkCell("DeleteWorkflowTransitions!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Transitions"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"), new XsrfLinkCell("DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Step"))});
        this.clickLink("edit_step_2");
        this.assertTextPresent("Update Workflow Step");
        this.assertTextPresent("This page allows you to update the <b>Resolved</b> step.");
        this.setFormElement("stepName", "Actually Closed");
        this.selectOption("stepStatus", "Closed");
        this.submit("Update");
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Actually Closed"), new TextCell("(2)")), new TextCell("Closed"), new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=11&workflowStep=2", "Re-open"), new TextCell("(11)", "Open")), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add Transition"), new XsrfLinkCell("DeleteWorkflowTransitions!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Transitions"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"), new XsrfLinkCell("DeleteWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Step"))});
        this.clickLink("add_trans_2");
        this.assertTextPresent("Add Workflow Transition");
        this.assertTextPresent("Create a transition from <b>Actually Closed</b> to another step.");
        this.setFormElement("transitionName", "Closed it again");
        this.setFormElement("description", "");
        this.selectOption("destinationStep", "Actually Closed");
        this.submit("Add");
        this.assertTableRowEquals(this.getWebTableWithID("steps_table"), 2, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Actually Closed"), new TextCell("(2)")), new TextCell("Closed"), new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=11&workflowStep=2", "Re-open"), new TextCell("(11)", "Open"), new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow3&workflowTransition=21&workflowStep=2", "Closed it again"), new TextCell("21", "Actually Closed")), new AndCell(new XsrfLinkCell("AddWorkflowTransition!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Add Transition"), new XsrfLinkCell("DeleteWorkflowTransitions!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Delete Transitions"), new XsrfLinkCell("EditWorkflowStep!default.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "Edit"), new XsrfLinkCell("ViewWorkflowStepMetaAttributes.jspa?workflowMode=live&workflowName=Workflow3&workflowStep=2", "View Properties"))});
        this.clickLink("del_trans_2");
        this.assertTextPresent("Delete Workflow Transitions");
        this.assertTextPresent("Please select transitions to delete from the <b>Actually Closed</b> step.");
        this.selectOption("transitionIds", "Closed it again");
        this.submit("Delete");
        this.assertTextSequence(new String[]{"View Workflow Steps", "Workflow3"});
        this.assertTextNotPresent("Closed it again");
    }

    public void testStepProperties() {
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow2");
        this.clickLinkWithText("View Properties");
        this.assertTextPresent("View Workflow Step Properties: Open");
        this.assertLinkPresentWithText("workflow steps");
        this.assertTextPresent("There are currently no defined properties.");
        this.assertTextPresent("Add New Property");
        this.submit("Add");
        this.assertTextPresent("Attribute key must be set.");
        this.setFormElement("attributeKey", "test.key");
        this.setFormElement("attributeValue", "");
        this.submit("Add");
        this.assertTextNotPresent("There are currently no defined properties.");
        TestWorkflowEditor.assertEquals((int)2, (int)this.getWebTableWithID("metas_table").getRowCount());
        this.tableAssertions.assertTableRowEquals(this.getWebTableWithID("metas_table"), 0, new Object[]{new TextCell("Property Key"), new TextCell("Property Value"), new TextCell("Operations")});
        this.tableAssertions.assertTableRowEquals(this.getWebTableWithID("metas_table"), 1, new Object[]{new TextCell("test.key"), new StrictTextCell(""), new XsrfLinkCell("RemoveWorkflowStepMetaAttribute.jspa?workflowName=Workflow2&workflowMode=live&workflowStep=1&attributeKey=test.key", "Delete")});
        this.setFormElement("attributeKey", "another.key");
        this.setFormElement("attributeValue", "This is a value.");
        this.submit("Add");
        this.assertTextNotPresent("There are currently no defined properties.");
        TestWorkflowEditor.assertEquals((int)3, (int)this.getWebTableWithID("metas_table").getRowCount());
        this.assertTableHasMatchingRow(this.getWebTableWithID("metas_table"), new Object[]{new TextCell("another.key"), new StrictTextCell("This is a value."), new XsrfLinkCell("RemoveWorkflowStepMetaAttribute.jspa?workflowName=Workflow2&workflowMode=live&workflowStep=1&attributeKey=another.key", "Delete")});
        this.setFormElement("attributeKey", "another.key");
        this.submit("Add");
        this.assertions.getJiraFormAssertions().assertFieldErrMsg("Attribute key 'another.key' already exists.");
        this.clickLink("del_meta_another.key");
        TestWorkflowEditor.assertEquals((int)2, (int)this.getWebTableWithID("metas_table").getRowCount());
        this.assertTextNotPresent("another.key");
        this.assertTextNotPresent("This is a value.");
    }

    public void testEditSingleStepAndTransition() {
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow2");
        this.setFormElement("stepName", "Resolved");
        this.selectOption("stepStatus", "Resolved");
        this.submit("Add");
        this.clickLinkWithText("Open");
        this.assertTextSequence(new String[]{"View Workflow Step", "Open"});
        this.assertTextPresent("This page shows the details of the <b>Open</b> step.");
        this.assertTextSequence(new String[]{"The step is linked to status:", "Open"});
        this.assertTextPresent("Workflow Browser");
        this.assertTableRowEquals(this.getWebTableWithID("inbound_trans"), 0, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=1", "Create"), new TextCell("(1)"))});
        this.assertTableCellHasText("workflow_browser", 0, 1, "Open");
        this.assertTableRowEquals(this.getWebTableWithID("outgoing_trans"), 0, new Object[]{null, new TextCell("No Transitions")});
        this.clickLinkWithText("Add");
        this.setFormElement("transitionName", "Resolve");
        this.selectOption("destinationStep", "Resolved");
        this.submit("Add");
        this.assertTextSequence(new String[]{"View Workflow Step", "Open"});
        this.assertTableRowEquals(this.getWebTableWithID("inbound_trans"), 0, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=1", "Create"), new TextCell("(1)"))});
        this.assertTableCellHasText("workflow_browser", 0, 1, "Open");
        this.assertTableRowEquals(this.getWebTableWithID("outgoing_trans"), 0, new Object[]{null, new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=11&workflowStep=1", "Resolve"), new TextCell("(11)"))});
        this.clickLinkWithText("Add");
        this.setFormElement("transitionName", "resolveitsomemore");
        this.selectOption("destinationStep", "Resolved");
        this.submit("Add");
        this.assertTableRowEquals(this.getWebTableWithID("inbound_trans"), 0, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=1", "Create"), new TextCell("(1)"))});
        this.assertTableCellHasText("workflow_browser", 0, 1, "Open");
        this.assertTableRowEquals(this.getWebTableWithID("outgoing_trans"), 0, new Object[]{null, new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=11&workflowStep=1", "Resolve"), new TextCell("(11)"))});
        this.assertTableRowEquals(this.getWebTableWithID("outgoing_trans"), 1, new Object[]{null, new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=21&workflowStep=1", "resolveitsomemore"), new TextCell("(21)"))});
        this.clickLinkWithText("Add");
        this.setFormElement("transitionName", "opensomemore");
        this.submit("Add");
        this.assertTableRowEquals(this.getWebTableWithID("inbound_trans"), 0, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=1", "Create"), new TextCell("(1)"))});
        this.assertTableRowEquals(this.getWebTableWithID("inbound_trans"), 1, new Object[]{new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=31&workflowStep=1", "opensomemore"), new TextCell("(31)"))});
        this.assertTableCellHasText("workflow_browser", 0, 1, "Open");
        this.assertTableRowEquals(this.getWebTableWithID("outgoing_trans"), 0, new Object[]{null, new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=11&workflowStep=1", "Resolve"), new TextCell("(11)"))});
        this.assertTableRowEquals(this.getWebTableWithID("outgoing_trans"), 1, new Object[]{null, new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=21&workflowStep=1", "resolveitsomemore"), new TextCell("(21)"))});
        this.assertTableRowEquals(this.getWebTableWithID("outgoing_trans"), 2, new Object[]{null, new AndCell(new XsrfLinkCell("ViewWorkflowTransition.jspa?workflowMode=live&workflowName=Workflow2&workflowTransition=31&workflowStep=1", "opensomemore"), new TextCell("(31)"))});
        this.clickLinkWithText("resolveitsomemore");
        this.assertTextPresent("Transition: resolveitsomemore");
        this.assertTextSequence(new String[]{"Transition View", "None", "it will happen instantly"});
        this.assertTextPresent("Workflow Browser");
        this.assertTableRowEquals(this.getWebTableWithID("orig_steps"), 0, new Object[]{new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow2&workflowStep=1", "Open")});
        this.assertTableCellHasText("workflow_browser", 0, 1, "resolveitsomemore");
        this.assertTableCellHasText("workflow_browser", 0, 1, "(21)");
        this.assertTableRowEquals(this.getWebTableWithID("dest_steps"), 0, new Object[]{null, new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow2&workflowStep=2", "Resolved")});
        this.clickLinkWithText("Edit");
        this.setFormElement("transitionName", "resolveitalittleless");
        this.submit("Update");
        this.assertTableRowEquals(this.getWebTableWithID("orig_steps"), 0, new Object[]{new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow2&workflowStep=1", "Open")});
        this.assertTableCellHasText("workflow_browser", 0, 1, "resolveitalittleless");
        this.assertTableCellHasText("workflow_browser", 0, 1, "(21)");
        this.assertTableRowEquals(this.getWebTableWithID("dest_steps"), 0, new Object[]{null, new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow2&workflowStep=2", "Resolved")});
        this.clickLinkWithText("Open");
        this.clickLinkWithText("opensomemore");
        this.assertTableRowEquals(this.getWebTableWithID("orig_steps"), 0, new Object[]{new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow2&workflowStep=1", "Open")});
        this.assertTableCellHasText("workflow_browser", 0, 1, "opensomemore");
        this.assertTableCellHasText("workflow_browser", 0, 1, "(31)");
        this.assertTableRowEquals(this.getWebTableWithID("dest_steps"), 0, new Object[]{null, new XsrfLinkCell("ViewWorkflowStep.jspa?workflowMode=live&workflowName=Workflow2&workflowStep=1", "Open")});
        this.clickLinkWithText("Delete");
        this.assertTextPresent("Delete Workflow Transitions");
        this.assertTextSequence(new String[]{"Confirm that you want to delete", "opensomemore", "transition(s)."});
        this.submit("Delete");
        this.assertTextSequence(new String[]{"View Workflow Steps", "Workflow2"});
        this.assertTextNotPresent("opensomemore");
        this.assertLinkPresentWithText("Resolve");
        this.assertLinkPresentWithText("resolveitalittleless");
    }

    public void testValidatorsConditionsAndPostFunctions() {
        this.gotoWorkFlow();
        this.clickLink("steps_live_Workflow2");
        this.clickLink("add_trans_1");
        this.setFormElement("transitionName", "testtransition");
        this.submit("Add");
        this.clickLinkWithText("testtransition");
        this.assertTextPresent("Transition: testtransition");
        this.assertLinkPresentWithText("Validators");
        this.assertLinkPresentWithText("Post Functions");
        this.assertLinkPresentWithText("All");
        this.assertLinkPresentWithText("Add");
        this.clickLinkWithText("Add");
        this.assertTextPresent("Add Condition To Transition");
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Only Assignee Condition"), new TextCell("Condition to allow only the assignee to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Only Reporter Condition"), new TextCell("Condition to allow only the reporter to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Permission Condition"), new TextCell("Condition to allow only users with a certain permission to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Sub-Task Blocking Condition"), new TextCell("Condition to block parent issue transition depending on sub-task status.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Is In Group"), new TextCell("Condition to allow only users in a given group to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Is In Group Custom Field"), new TextCell("Condition to allow only users in a custom field-specified group to execute a transition.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Is In Project Role"), new TextCell("Condition to allow only users in a given project role to execute a transition.")});
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:onlyassignee-condition");
        this.submit("Add");
        this.assertTextPresent("Only the <b>assignee</b> of the issue can execute this transition.");
        this.clickLinkWithText("Add");
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:isuserinprojectrole-condition");
        this.submit("Add");
        this.assertTextPresent("Add Parameters To Condition");
        this.assertTextPresent("Add required parameters to the Condition.");
        this.selectOption("jira.projectrole.id", "Developers");
        this.submit("Add");
        this.assertTextPresent("Only users in project role <b>Developers</b> can execute this transition.");
        this.assertTextSequence(new String[]{"Only the <b>assignee</b> of the issue can execute this transition.", "AND", "Switch to OR", "Only users in project role <b>Developers</b> can execute this transition."});
        this.clickLinkWithText("Switch to OR");
        this.assertTextSequence(new String[]{"Only the <b>assignee</b> of the issue can execute this transition.", "OR", "Switch to AND", "Only users in project role <b>Developers</b> can execute this transition."});
        this.clickLinkWithText("Add grouped condition");
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:onlyassignee-condition");
        this.submit("Add");
        this.assertTextSequence(new String[]{"Only the <b>assignee</b> of the issue can execute this transition.", "AND", "Switch to OR", "Only the <b>assignee</b> of the issue can execute this transition.", "OR", "Switch to AND", "Only users in project role <b>Developers</b> can execute this transition."});
        this.clickLink("view_all_trans");
        this.assertTextSequence(new String[]{"Conditions", "Validators", "Post Functions"});
        this.assertTextSequence(new String[]{"Conditions", "Add", "a new condition to restrict when this transition can be performed.", "Only the <b>assignee</b> of the issue can execute this transition.", "Add grouped condition", "Delete", "AND", "Add condition to group", "Switch to OR", "Only the <b>assignee</b> of the issue can execute this transition.", "Add grouped condition", "Delete", "OR", "Add condition to group", "Switch to AND", "Only users in project role <b>Developers</b> can execute this transition.", "Add grouped condition", "Edit", "Delete"});
        this.assertTextSequence(new String[]{"Validators", "Add", "a new validator to check the input parameters before this transition is executed.", "No input parameters checks will be done before this transition is executed."});
        this.assertTextSequence(new String[]{"Post Functions", "Add", "a new post function to the unconditional result of the transition.", "Set issue status to the linked status of the destination workflow step.", "THEN", "Add a comment to an issue if one is entered during a transition.", "THEN", "Update change history for an issue and store the issue in the database.", "THEN", "Re-index an issue to keep indexes in sync with the database.", "THEN", "Fire a", "Generic Event", "event that can be processed by the listeners.", "Edit"});
        this.clickLinkWithText("Validators");
        this.clickLinkWithText("Add");
        this.assertTextPresent("Add Validator To Transition");
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Permission Validator"), new TextCell("Validates that the user has a permission.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("User Permission Validator"), new TextCell("Validates that the user has a permission, where the OSWorkflow variable holding the username is configurable. Obsolete.")});
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:permission-validator");
        this.submit("Add");
        this.assertTextPresent("Add Parameters To Validator");
        this.assertTextPresent("Add required parameters to the Validator.");
        this.selectOption("permission", "Assignable User");
        this.submit("Add");
        this.assertTextSequence(new String[]{"Add", "a new validator to check the input parameters before this transition is executed.", "Only users with <b>Assignable User</b> permission can execute this transition.", "Edit", "Delete"});
        this.clickLinkWithText("Post Functions");
        this.clickLinkWithText("Add");
        this.assertTextPresent("Add Post Function To Transition");
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Assign to Current User"), new TextCell("Assigns the issue to the current user if the current user has the 'Assignable User' permission.")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Assign to Lead Developer"), new TextCell("Assigns the issue to the project/component lead developer")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Assign to Reporter"), new TextCell("Assigns the issue to the reporter")});
        this.assertTableHasMatchingRow(this.getWebTableWithID("descriptors_table"), new Object[]{null, new TextCell("Update Issue Field"), new TextCell("Updates a simple issue field to a given value.")});
        this.checkCheckbox("type", "com.atlassian.jira.plugin.system.workflow:assigntocurrentuser-function");
        this.submit("Add");
        this.assertTextSequence(new String[]{"Add", "a new post function to the unconditional result of the transition.", "Set issue status to the linked status of the destination workflow step.", "THEN", "Assign the issue to the current user. Please note that the issue will only be assigned to the current user if the current user has the 'Assignable User' permission.", "Move Up", "Move Down", "Delete", "THEN", "Add a comment to an issue if one is entered during a transition.", "THEN", "Update change history for an issue and store the issue in the database.", "THEN", "Re-index an issue to keep indexes in sync with the database.", "THEN", "Fire a", "Generic Event", "event that can be processed by the listeners.", "Edit"});
        this.clickLinkWithText("Move Up");
        this.assertLinkWithTextNotPresent("Move Up");
        this.assertTextSequence(new String[]{"Add", "a new post function to the unconditional result of the transition.", "Assign the issue to the current user. Please note that the issue will only be assigned to the current user if the current user has the 'Assignable User' permission.", "Move Down", "Delete", "THEN", "Set issue status to the linked status of the destination workflow step.", "THEN", "Add a comment to an issue if one is entered during a transition.", "THEN", "Update change history for an issue and store the issue in the database.", "THEN", "Re-index an issue to keep indexes in sync with the database.", "THEN", "Fire a", "Generic Event", "event that can be processed by the listeners.", "Edit"});
        this.clickLinkWithText("Move Down");
        this.clickLinkWithText("Move Down");
        this.clickLinkWithText("Move Down");
        this.clickLinkWithText("Move Down");
        this.clickLinkWithText("Move Down");
        this.assertLinkNotPresentWithText("Move Down");
        this.assertTextSequence(new String[]{"Add", "a new post function to the unconditional result of the transition.", "Set issue status to the linked status of the destination workflow step.", "THEN", "Add a comment to an issue if one is entered during a transition.", "THEN", "Update change history for an issue and store the issue in the database.", "THEN", "Re-index an issue to keep indexes in sync with the database.", "THEN", "Fire a", "Generic Event", "event that can be processed by the listeners.", "Edit", "THEN", "Assign the issue to the current user. Please note that the issue will only be assigned to the current user if the current user has the 'Assignable User' permission.", "Move Up", "Delete"});
    }

    private class XsrfLinkCell
    extends LinkCell {
        private XsrfLinkCell(String url, String label) {
            super(TestWorkflowEditor.this.page.addXsrfToken(url), label);
        }
    }
}

