/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestUserProfile
extends JIRAWebTest {
    public TestUserProfile(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    @Override
    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testUrlPropertyRendersAsLink() {
        String[] links = new String[]{"http://www.atlassian.com/uniqueLinkForThisTest", "www.atlassian-func-tests.com"};
        for (int i = 0; i < links.length; ++i) {
            String link = links[i];
            this.addUserProperty("homePage" + i, link);
            this.clickOnUserProfile();
            this.assertLinkWithTextUrlEndsWith(link, link);
        }
    }

    public void testBadUrlPropertyDoesntRenderAsLink() {
        String linkUrl = "htp:/bad.url.com";
        this.addUserProperty("homePage", "htp:/bad.url.com");
        this.clickOnUserProfile();
        this.assertLinkNotPresentWithText("htp:/bad.url.com");
    }

    public void testUserChangePassword() {
        this.clickOnUserProfile();
        this.clickLinkWithText("Change Password");
        this.setFormElement("current", "");
        this.setFormElement("password", "");
        this.setFormElement("confirm", "");
        this.submit();
        this.assertTextPresent("The current password specified is incorrect.");
        this.assertTextPresent("The new password cannot be blank.");
        this.setFormElement("current", "invalid");
        this.setFormElement("password", "password");
        this.setFormElement("confirm", "mismatch");
        this.submit();
        this.assertTextPresent("The current password specified is incorrect.");
        this.assertTextPresent("The password and confirmation do not match.");
        String NEW_PASSWORD = "newpassword";
        this.setFormElement("current", "admin");
        this.setFormElement("password", NEW_PASSWORD);
        this.setFormElement("confirm", NEW_PASSWORD);
        this.submit();
        this.assertTextPresent("Your password has successfully been changed");
        this.logout();
        this.login("admin", "admin");
        this.assertTextPresent("Sorry, your username and password are incorrect - please try again.");
        this.login("admin", NEW_PASSWORD);
        XPathLocator anchorLocator = new XPathLocator(this.tester, "//div[@id='header-details-user']/a");
        TestUserProfile.assertEquals((String)"Administrator", (String)anchorLocator.getText());
    }

    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("German (Germany)");
        this.clickOnUserProfile();
        this.text.assertTextPresent(new IdLocator(this.tester, "up-p-locale"), "Deutsch (Deutschland) [Default]");
        this.tester.clickLink("edit_prefs_lnk");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("userLocale", "Deutsch (Deutschland) [Default]");
    }

    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("German (Germany)");
        this.navigation.login("fred");
        this.clickOnUserProfile();
        this.text.assertTextPresent(new IdLocator(this.tester, "up-p-locale"), "espa\u00f1ol (Espa\u00f1a)");
        this.tester.clickLink("edit_prefs_lnk");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("userLocale", "espa\u00f1ol (Espa\u00f1a)");
    }

    public void testChangeUserProfileRequiresPassword() {
        String NEW_FULL_NAME = "New FullName";
        String NEW_EMAIL = "newemail@example.com";
        this.updateUserProfileForm("admin", "New FullName", "newemail@example.com", "wrongpassword");
        this.tester.assertTextPresent("The password you entered is incorrect.");
        this.updateUserProfileForm("admin", "New FullName", "newemail@example.com", "");
        this.tester.assertTextPresent("The password you entered is incorrect.");
        this.updateUserProfileForm("admin", "New FullName", "newemail@example.com", "admin");
        this.text.assertTextSequence(this.locator.page(), "Profile", "New FullName", "Full Name", "New FullName", "Email", "newemail@example.com");
    }

    private void updateUserProfileForm(String userName, String fullName, String email, String password) {
        this.tester.gotoPage("secure/EditProfile!default.jspa?username=" + userName);
        this.tester.setFormElement("fullName", fullName);
        this.tester.setFormElement("email", email);
        this.tester.setFormElement("password", password);
        this.tester.submit();
    }

    private void addUserProperty(String key, String value) {
        this.gotoPage("/secure/admin/user/EditUserProperties.jspa?name=admin");
        this.navigation.checkWebSudoWithLastPassword();
        this.setFormElement("key", key);
        this.setFormElement("value", value);
        this.submit();
    }
}

