/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;
import org.xml.sax.SAXException;

public class TestGroupSelector
extends JIRAWebTest {
    public static final String GROUP_PICKER_CF_NAME = "mypickerofgroups";
    public static final String INVALID_GROUP_NAME = "invalid_group_name";
    public static final String ISSUE_SUMMARY = "This is my summary";
    private String groupPickerId = null;

    public TestGroupSelector(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        HttpUnitOptions.setScriptingEnabled((boolean)true);
        this.groupPickerId = this.addCustomField("grouppicker", "global", GROUP_PICKER_CF_NAME, null, null, null, null);
        this.addFieldToFieldScreen("Default Screen", GROUP_PICKER_CF_NAME);
    }

    public void testCreateIssueWithGroupPicker() throws SAXException {
        this.clickLink("create_link");
        this.submit("Next");
        this.setFormElement("summary", ISSUE_SUMMARY);
        this.assertLinkPresent("customfield_" + this.groupPickerId + "-trigger");
        this.setFormElement("customfield_" + this.groupPickerId, INVALID_GROUP_NAME);
        this.submit("Create");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("Could not find group with name 'invalid_group_name'");
        this.setFormElement("customfield_" + this.groupPickerId, "jira-users");
        this.submit("Create");
        this.assertTextPresent(ISSUE_SUMMARY);
        this.assertTextPresent(GROUP_PICKER_CF_NAME);
        this.assertLinkPresentWithText("jira-users");
    }

    public void testIssueNavWithGroupPicker() {
        this.clickLink("create_link");
        this.submit("Next");
        this.setFormElement("summary", ISSUE_SUMMARY);
        this.setFormElement("customfield_" + this.groupPickerId, "jira-users");
        this.submit("Create");
        this.clickLink("find_link");
        this.assertTextPresent(GROUP_PICKER_CF_NAME);
        this.assertLinkPresent("searcher-customfield_" + this.groupPickerId + "-trigger");
        this.setFormElement("customfield_" + this.groupPickerId, INVALID_GROUP_NAME);
        this.submit("show");
        this.assertions.getTextAssertions().assertTextPresentHtmlEncoded("Could not find group with name 'invalid_group_name'");
        this.assertTextPresent("There are errors with your search query on the left, please correct them before continuing.");
        this.setFormElement("customfield_" + this.groupPickerId, "jira-users");
        this.submit("show");
        this.assertTextPresent("HSP-1");
    }
}

