/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

public class TestEditUserGroups
extends JIRAWebTest {
    public static final String ERROR_LEAVING_ALL_ADMIN_GROUPS = "You are trying to leave all of the administration groups jira-administrators. You cannot delete your own administration permission";
    public static final String ERROR_LEAVING_ALL_SYS_ADMIN_GROUPS = "You are trying to leave all of the system administration groups jira-administrators. You cannot delete your own system administration permission";

    public TestEditUserGroups(String name) {
        super(name);
    }

    public void testEditUserGroupsJoinAndLeaveAtSameTime() throws SAXException {
        this.restoreBlankInstance();
        this.navigateToUser("admin");
        this.clickLink("editgroups_link");
        this.selectOption("groupsToLeave", "jira-developers");
        this.submit("leave");
        this.assertOptionPresent("groupsToJoin", "jira-developers");
        this.assertOptionPresent("groupsToLeave", "jira-administrators");
        this.assertOptionPresent("groupsToLeave", "jira-users");
        this.selectOption("groupsToLeave", "jira-users");
        this.selectOption("groupsToJoin", "jira-developers");
        this.submit("join");
        this.assertOptionPresent("groupsToLeave", "jira-developers");
        this.assertOptionPresent("groupsToLeave", "jira-administrators");
        this.assertOptionPresent("groupsToLeave", "jira-users");
    }

    public void testEditUserGroupsRemoveLastSysAdminGroup() {
        this.restoreBlankInstance();
        this.navigateToUser("admin");
        this.clickLink("editgroups_link");
        this.selectOption("groupsToLeave", "jira-administrators");
        this.submit("leave");
        this.assertTextPresent(ERROR_LEAVING_ALL_SYS_ADMIN_GROUPS);
        this.assertOptionPresent("groupsToLeave", "jira-administrators");
    }

    public void testEditUserGroupsRemoveSysAdminGroupWithAnotherPresent() {
        this.restoreBlankInstance();
        this.createGroup("sys-admin-group2");
        this.grantGlobalPermission(44, "sys-admin-group2");
        this.addUserToGroup("admin", "sys-admin-group2");
        this.removeUserFromGroup("admin", "jira-administrators");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditUserGroupsWithNoSysAdminPermRemoveLastAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("admin");
            this.clickLink("editgroups_link");
            this.selectOption("groupsToLeave", "jira-administrators");
            this.submit("leave");
            this.assertTextPresent(ERROR_LEAVING_ALL_ADMIN_GROUPS);
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testEditUserGroupsWithNoSysAdminPermRemoveAdmin() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.createGroup("admin-group2");
            this.grantGlobalPermission(0, "admin-group2");
            this.addUserToGroup("admin", "admin-group2");
            this.removeUserFromGroup("admin", "jira-administrators");
            this.assertOptionNotPresent("groupsToLeave", "jira-administrators");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSysAdminEditGroups() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.logout();
            this.login("root", "root");
            this.navigateToUser("admin");
            this.clickLink("editgroups_link");
            this.assertOptionPresent("groupsToJoin", "jira-sys-admins");
            this.assertOptionNotPresent("groupsToLeave", "jira-sys-admins");
            this.navigateToUser("root");
            this.clickLink("editgroups_link");
            this.assertOptionNotPresent("groupsToJoin", "jira-sys-admins");
            this.assertOptionPresent("groupsToLeave", "jira-sys-admins");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminEditGroups() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.navigateToUser("admin");
            this.clickLink("editgroups_link");
            this.assertOptionNotPresent("groupsToJoin", "jira-sys-admins");
            this.assertOptionNotPresent("groupsToLeave", "jira-sys-admins");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToJoin=jira-sys-admins&join=true"));
            this.assertTextPresent("You cannot add users to groups which are not visible to you.");
            this.navigateToUser("root");
            this.clickLink("editgroups_link");
            this.assertOptionNotPresent("groupsToJoin", "jira-sys-admins");
            this.assertOptionNotPresent("groupsToLeave", "jira-sys-admins");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=root&groupsToLeave=jira-sys-admins&leave=true"));
            this.assertTextPresent("You can not remove a group from this user as it is not visible to you.");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testFredEditGroups() {
        try {
            this.restoreData("TestWithSystemAdmin.xml");
            this.login("fred", "fred");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToJoin=jira-sys-admins&join=true"));
            this.assertTextPresent("my login on this computer");
            this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=root&groupsToLeave=jira-sys-admins&leave=true"));
            this.assertTextPresent("my login on this computer");
        }
        finally {
            this.logout();
            this.login("root", "root");
            this.restoreBlankInstance();
        }
    }

    public void testEditGroupsUserDoesNotExist() {
        this.restoreBlankInstance();
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=foo&groupsToJoin=jira-developers&join=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("This user does not exist please select a user from the user browser.");
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=foo&groupsToLeave=jira-developers&leave=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("This user does not exist please select a user from the user browser.");
    }

    public void testEditGroupsGroupDoesNotExist() {
        this.restoreBlankInstance();
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToJoin=invalid&join=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The group 'invalid' is not a valid group.");
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToLeave=invalid&leave=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("The group 'invalid' is not a valid group.");
    }

    public void testEditGroupsCanNotJoinAlreadyAMemeber() {
        this.restoreBlankInstance();
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=admin&groupsToJoin=jira-administrators&join=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Cannot add user 'admin', user is already a member of 'jira-administrators'");
    }

    public void testEditGroupsCanNotLeaveNotAMemeber() {
        this.restoreBlankInstance();
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=fred&groupsToLeave=jira-administrators&leave=true"));
        this.assertions.getJiraFormAssertions().assertFormErrMsg("Cannot remove user 'fred' from group 'jira-administrators' since user is not a member of 'jira-administrators'");
    }

    public void testEditGroupsMustSelectAGroup() {
        this.restoreBlankInstance();
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/EditUserGroups.jspa?name=fred"));
        this.submit("join");
        this.assertTextPresent("You must select at least one group to join.");
        this.submit("leave");
        this.assertTextPresent("You must select at least one group to leave.");
    }
}

