/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade;

import com.atlassian.jira.functest.config.CheckOptions;
import com.atlassian.jira.functest.config.CheckOptionsUtils;
import com.atlassian.jira.functest.config.ConfigFile;
import com.atlassian.jira.functest.config.ConfigFileWalker;
import com.atlassian.jira.functest.config.ConfigurationDefaults;
import com.atlassian.jira.functest.config.JiraConfig;
import com.atlassian.jira.functest.framework.FuncTestCase;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.junit.Ignore;

@Ignore(value="This test is run manually to update stored XML")
public class TestUpgradeXmlData
extends FuncTestCase
implements ConfigFileWalker.ConfigVisitor {
    private static final Logger log = Logger.getLogger(TestUpgradeXmlData.class);
    private static final String CHECKID_UPGRADE = "upgrade";
    private List<File> brokenFiles = new LinkedList<File>();
    private long buildNumber;
    private File dataLocation;

    public void testUpgradeTestData() throws Exception {
        this.dataLocation = TestUpgradeXmlData.normalizeFile(ConfigurationDefaults.getDefaultXmlDataLocation());
        this.buildNumber = this.administration.getBuildNumber();
        ConfigFileWalker fileWalker = new ConfigFileWalker(this.dataLocation, this);
        fileWalker.setExcludes(ConfigurationDefaults.getDefaultExcludedFilters());
        fileWalker.walk();
        if (!this.brokenFiles.isEmpty()) {
            StringWriter writer = new StringWriter();
            PrintWriter builder = new PrintWriter(writer);
            builder.println("Unable to update all the XML.");
            for (File brokenFile : this.brokenFiles) {
                builder.format("\t%s%n", brokenFile.getAbsolutePath());
            }
            builder.close();
            TestUpgradeXmlData.fail((String)writer.toString());
        }
        this.dataLocation = null;
        this.brokenFiles = null;
    }

    @Override
    public void visitConfig(ConfigFile configFile) {
        File file = configFile.getFile();
        Document document = configFile.readConfig();
        CheckOptions checkOptions = CheckOptionsUtils.parseOptions(document);
        if (checkOptions.checkEnabled(CHECKID_UPGRADE)) {
            if (!JiraConfig.isJiraXml(document)) {
                this.brokenFiles.add(file);
                log.error((Object)String.format("Not upgrading '%s' as it does not appear to be a JIRA backup.", file));
                return;
            }
            JiraConfig config = new JiraConfig(document, file);
            long number = config.getBuildNumber();
            if (number < this.buildNumber) {
                Set<String> names = config.getSystemAdmins();
                if (this.restoreDataSafely(file, names)) {
                    File newFile = this.administration.exportDataToFile(file.getName(), TestUpgradeXmlData.isZip(file));
                    ConfigFile newConfigFile = ConfigFile.create(newFile);
                    Document newDocument = newConfigFile.readConfig();
                    CheckOptionsUtils.writeOptions(newDocument, checkOptions);
                    newConfigFile.writeFile(newDocument);
                    TestUpgradeXmlData.assertTrue((boolean)file.delete());
                    TestUpgradeXmlData.moveFile(newFile, file);
                } else {
                    this.brokenFiles.add(file);
                }
            }
        } else {
            log.info((Object)String.format("Not upgrading '%s' as it contains the '%s' suppresscheck flag.", file, CHECKID_UPGRADE));
        }
    }

    @Override
    public void visitConfigError(File file, ConfigFile.ConfigFileException e) {
        throw e;
    }

    private boolean restoreDataSafely(File file, Set<String> admins) {
        try {
            if (admins.isEmpty()) {
                this.administration.restoreData(TestUpgradeXmlData.getRelativeFile(this.dataLocation, file));
            } else {
                this.administration.restoreDataAndLogin(TestUpgradeXmlData.getRelativeFile(this.dataLocation, file), admins.iterator().next());
            }
            return true;
        }
        catch (Throwable e) {
            log.error((Object)("Unable to restore '" + file.getAbsolutePath() + "'."), e);
            return false;
        }
    }

    private static String getRelativeFile(File base, File file) {
        String basePath = base.getPath();
        String filePath = file.getPath();
        if (filePath != null && filePath.startsWith(basePath)) {
            String s = filePath.substring(basePath.length());
            if (s.startsWith(File.separator)) {
                s = s.substring(File.separator.length());
            }
            return s;
        }
        return file.getName();
    }

    private static void moveFile(File src, File dest) {
        try {
            FileUtils.moveFile((File)src, (File)dest);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isZip(File file) {
        return "zip".equalsIgnoreCase(FilenameUtils.getExtension((String)file.getName()));
    }

    private static File normalizeFile(File importFile) {
        try {
            return importFile.getCanonicalFile();
        }
        catch (IOException e) {
            return importFile.getAbsoluteFile();
        }
    }
}

