/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.webtests.ztests.tpm.ldap.AbstractTpmLdapTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;

public class TestTpmLdapAdvanced
extends AbstractTpmLdapTest {
    public void testDisabledDirectory() throws Exception {
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.log("User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.navigation.gotoAdminSection("user_directories");
        this.tester.clickLinkWithText("Disable");
        this.assertions.getTextAssertions().assertTextPresent("LDAP Directory  <em>(inactive)</em>");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection("user_directories");
        this.tester.clickLinkWithText("Enable");
        this.assertions.getTextAssertions().assertTextNotPresent("LDAP Directory (inactive)");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.deleteUser("wilma");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
    }

    public void testSynchroniseDirectory() throws Exception {
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.log("User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection("user_directories");
        this.assertions.getTextAssertions().assertTextNotPresent("Never synchronised");
        if (this.isActiveDirectory()) {
            this.log("Attempting to add an Active Directory LDAP User Directory...");
            this.addActiveDirectory("LDAP Directory 2");
        } else {
            this.log("Attempting to add an Open LDAP User Directory...");
            this.addOpenLdap("LDAP Directory 2");
        }
        WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "LDAP Directory");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, "JIRA Internal Directory");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 1, "LDAP Directory 2");
        this.assertions.getTextAssertions().assertTextPresent("Never synchronised");
        this.synchroniseDirectory3();
        this.navigation.gotoAdminSection("user_browser");
        this.tester.clickLink("add_user");
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.navigation.gotoAdminSection("user_directories");
        this.tester.clickLinkWithText("Disable");
        this.assertions.getTextAssertions().assertTextPresent("LDAP Directory  <em>(inactive)</em>");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.synchroniseDirectory3();
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory 2");
        this.navigation.gotoAdminSection("user_directories");
        this.tester.clickLinkWithText("Enable");
        this.assertions.getTextAssertions().assertTextNotPresent("LDAP Directory  <em>(inactive)</em>");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.navigation.gotoAdminSection("user_directories");
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        WebLink link = tblDirectoryList.getTableCell(3, 4).getLinkWith("Disable");
        this.navigation.clickLink(link);
        tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        link = tblDirectoryList.getTableCell(3, 4).getLinkWith("Remove");
        this.navigation.clickLink(link);
        this.deleteUser("wilma");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
    }

    private void synchroniseDirectory3() throws InterruptedException {
        this.navigation.gotoAdminSection("user_directories");
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        WebLink link = tblDirectoryList.getTableCell(3, 4).getLinkWith("Synchronise");
        this.log("Attempting to synchronise Directory 3");
        this.navigation.clickLink(link);
        int attempts = 0;
        while (true) {
            Thread.sleep(1000L);
            this.navigation.gotoAdminSection("user_directories");
            String cellText = new UserDirectoryTable(this).getTableCell(3, 4).asText();
            if (!cellText.contains("Synchronising for")) break;
            if (++attempts > 10) {
                TestTpmLdapAdvanced.fail((String)("Directory did not finish synchronising. Giving up after " + attempts + " retries."));
            }
            this.log("Still synchronising ...");
        }
        this.assertions.getTextAssertions().assertTextNotPresent("Never synchronised");
    }

    private void addActiveDirectory(String name) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", name);
        this.tester.selectOption("type", "Microsoft Active Directory");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "636");
        this.tester.checkCheckbox("useSSL", "true");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapUserObjectclass", "user");
        this.tester.setFormElement("ldapUserFilter", "(&(objectCategory=Person)(sAMAccountName=*))");
        this.tester.setFormElement("ldapUserUsername", "sAMAccountName");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "unicodePwd");
        this.tester.setFormElement("ldapGroupObjectclass", "group");
        this.tester.setFormElement("ldapGroupFilter", "(objectCategory=Group)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "member");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
    }

    private void addOpenLdap(String name) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", name);
        this.tester.selectOption("type", "OpenLDAP");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapUserObjectclass", "inetorgperson");
        this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)");
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "userPassword");
        this.tester.setFormElement("ldapGroupObjectclass", "groupOfUniqueNames");
        this.tester.setFormElement("ldapGroupFilter", "(objectclass=groupOfUniqueNames)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "uniqueMember");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
    }

    private void deleteUser(String username) {
        this.gotoViewUser(username);
        this.tester.clickLink("deleteuser_link");
        this.tester.submit("Delete");
    }

    private void gotoViewUser(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
        this.navigation.checkWebSudoWithLastPassword();
    }
}

