/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.webtests.ztests.tpm.ldap.AbstractTpmLdapTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;

public class TestLdapDirectoryMaintenance
extends AbstractTpmLdapTest {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testAddLdapDirectory() {
        this.navigation.gotoAdmin();
        this.addDirectory();
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap", this.getLdapDisplayName() + " (Read-Only)").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        TestLdapDirectoryMaintenance.assertEquals((String)"First Ldap", (String)this.tester.getDialog().getElement("configure-ldap-form-name").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)this.getLdapServer(), (String)this.tester.getDialog().getElement("configure-ldap-form-hostname").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"389", (String)this.tester.getDialog().getElement("configure-ldap-form-port").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)this.getBaseDn(), (String)this.tester.getDialog().getElement("configure-ldap-form-ldapBasedn").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)this.getUserDn(), (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserdn").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)this.getPassword(), (String)this.tester.getDialog().getElement("configure-ldap-form-ldapPassword").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"inetorgperson", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserObjectclass").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"(objectclass=inetorgperson)", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserFilter").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"cn", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserUsername").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"cn", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserUsernameRdn").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"givenName", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserFirstname").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"sn", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserLastname").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"displayName", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserDisplayname").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"mail", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserEmail").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"memberOf", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserGroup").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"userPassword", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserPassword").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"groupOfUniqueNames", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupObjectclass").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"(objectclass=groupOfUniqueNames)", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupFilter").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"cn", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupName").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"description", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupDescription").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"uniqueMember", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupUsernames").getAttribute("value"));
    }

    private void addDirectory() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("port", "");
        this.tester.submit("test");
        this.text.assertTextPresent("Name is a required field.");
        this.text.assertTextPresent("Hostname is a required field.");
        this.text.assertTextPresent("Port is a required field.");
        this.text.assertTextPresent("Username is a required field.");
        this.text.assertTextPresent("Password is a required field.");
        this.text.assertTextPresent("User object class is a required field.");
        this.text.assertTextPresent("User object filter is a required field.");
        this.text.assertTextPresent("User name attribute is a required field.");
        this.text.assertTextPresent("First name attribute is a required field.");
        this.text.assertTextPresent("Last name attribute is a required field.");
        this.text.assertTextPresent("User display name attribute is a required field.");
        this.text.assertTextPresent("User email attribute is a required field.");
        this.text.assertTextPresent("User group attribute is a required field.");
        this.text.assertTextPresent("User password attribute is a required field.");
        this.text.assertTextPresent("Group object class is a required field.");
        this.text.assertTextPresent("Group object filter is a required field.");
        this.text.assertTextPresent("Group name attribute is a required field.");
        this.text.assertTextPresent("Group description attribute is a required field.");
        this.text.assertTextPresent("Group members attribute is a required field.");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", "First Ldap");
        if (this.isActiveDirectory()) {
            this.tester.selectOption("type", "Microsoft Active Directory");
        } else {
            this.tester.selectOption("type", "OpenLDAP");
        }
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapUserObjectclass", "inetorgperson");
        this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)");
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "userPassword");
        this.tester.setFormElement("ldapGroupObjectclass", "groupOfUniqueNames");
        this.tester.setFormElement("ldapGroupFilter", "(objectclass=groupOfUniqueNames)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "uniqueMember");
        this.tester.submit("test");
        this.tester.submit("save");
    }

    public void testEditLdapDirectory() {
        this.navigation.gotoAdminSection("user_directories");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        WebLink link = tblDirectoryList.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", "First Ldap X");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapUserObjectclass", "inetorgpersonX");
        this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)X");
        this.tester.setFormElement("ldapUserUsername", "cnX");
        this.tester.setFormElement("ldapUserUsernameRdn", "cnX");
        this.tester.setFormElement("ldapUserFirstname", "givenNameX");
        this.tester.setFormElement("ldapUserLastname", "snX");
        this.tester.setFormElement("ldapUserDisplayname", "displayNameX");
        this.tester.setFormElement("ldapUserEmail", "mailX");
        this.tester.setFormElement("ldapUserGroup", "memberOfX");
        this.tester.setFormElement("ldapUserPassword", "userPasswordX");
        this.tester.setFormElement("ldapGroupObjectclass", "groupOfUniqueNamesX");
        this.tester.setFormElement("ldapGroupFilter", "(objectclass=groupOfUniqueNames)X");
        this.tester.setFormElement("ldapGroupName", "cnX");
        this.tester.setFormElement("ldapGroupDescription", "descriptionX");
        this.tester.setFormElement("ldapGroupUsernames", "uniqueMemberX");
        this.tester.submit("test");
        this.tester.submit("save");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap X", this.getLdapDisplayName() + " (Read-Only)").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        link = tblDirectoryList.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        TestLdapDirectoryMaintenance.assertEquals((String)"First Ldap X", (String)this.tester.getDialog().getElement("configure-ldap-form-name").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)this.getLdapServer(), (String)this.tester.getDialog().getElement("configure-ldap-form-hostname").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"389", (String)this.tester.getDialog().getElement("configure-ldap-form-port").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)this.getBaseDn(), (String)this.tester.getDialog().getElement("configure-ldap-form-ldapBasedn").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)this.getUserDn(), (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserdn").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)this.getPassword(), (String)this.tester.getDialog().getElement("configure-ldap-form-ldapPassword").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"inetorgpersonX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserObjectclass").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"(objectclass=inetorgperson)X", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserFilter").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"cnX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserUsername").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"cnX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserUsernameRdn").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"givenNameX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserFirstname").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"snX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserLastname").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"displayNameX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserDisplayname").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"mailX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserEmail").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"memberOfX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserGroup").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"userPasswordX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapUserPassword").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"groupOfUniqueNamesX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupObjectclass").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"(objectclass=groupOfUniqueNames)X", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupFilter").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"cnX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupName").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"descriptionX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupDescription").getAttribute("value"));
        TestLdapDirectoryMaintenance.assertEquals((String)"uniqueMemberX", (String)this.tester.getDialog().getElement("configure-ldap-form-ldapGroupUsernames").getAttribute("value"));
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("hostname", "");
        this.tester.setFormElement("port", "");
        this.tester.setFormElement("ldapBasedn", "");
        this.tester.setFormElement("ldapUserdn", "");
        this.tester.setFormElement("ldapPassword", "");
        this.tester.setFormElement("ldapUserObjectclass", "");
        this.tester.setFormElement("ldapUserFilter", "");
        this.tester.setFormElement("ldapUserUsername", "");
        this.tester.setFormElement("ldapUserUsernameRdn", "");
        this.tester.setFormElement("ldapUserFirstname", "");
        this.tester.setFormElement("ldapUserLastname", "");
        this.tester.setFormElement("ldapUserDisplayname", "");
        this.tester.setFormElement("ldapUserEmail", "");
        this.tester.setFormElement("ldapUserGroup", "");
        this.tester.setFormElement("ldapUserPassword", "");
        this.tester.setFormElement("ldapGroupObjectclass", "");
        this.tester.setFormElement("ldapGroupFilter", "");
        this.tester.setFormElement("ldapGroupName", "");
        this.tester.setFormElement("ldapGroupDescription", "");
        this.tester.setFormElement("ldapGroupUsernames", "");
        this.tester.submit("test");
        this.text.assertTextPresent("Name is a required field.");
        this.text.assertTextPresent("Hostname is a required field.");
        this.text.assertTextPresent("Port is a required field.");
        this.text.assertTextPresent("Username is a required field.");
        this.text.assertTextPresent("Password is a required field.");
        this.text.assertTextPresent("User object class is a required field.");
        this.text.assertTextPresent("User object filter is a required field.");
        this.text.assertTextPresent("User name attribute is a required field.");
        this.text.assertTextPresent("First name attribute is a required field.");
        this.text.assertTextPresent("Last name attribute is a required field.");
        this.text.assertTextPresent("User display name attribute is a required field.");
        this.text.assertTextPresent("User email attribute is a required field.");
        this.text.assertTextPresent("User group attribute is a required field.");
        this.text.assertTextPresent("User password attribute is a required field.");
        this.text.assertTextPresent("Group object class is a required field.");
        this.text.assertTextPresent("Group object filter is a required field.");
        this.text.assertTextPresent("Group name attribute is a required field.");
        this.text.assertTextPresent("Group description attribute is a required field.");
        this.text.assertTextPresent("Group members attribute is a required field.");
        this.tester.clickLink("configure-ldap-form-cancel");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap X", this.getLdapDisplayName() + " (Read-Only)").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        link = tblDirectoryList.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.submit("test");
        this.tester.submit("save");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap X", this.getLdapDisplayName() + " (Read-Only)").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
    }

    public void testDeleteLdapDirectory() {
        this.navigation.gotoAdminSection("user_directories");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Disable");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Ldap (inactive)", this.getLdapDisplayName() + " (Read-Only)").hasMoveUp(true).hasMoveDown(false).hasEnableEditRemoveSynchroniseOperations();
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Remove");
        this.navigation.clickLink(link);
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(false).hasOnlyEditOperation();
        this.text.assertTextNotPresent(new IdLocator(this.tester, "embcwd"), "First Ldap");
    }
}

