/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.webtests.ztests.tpm.ldap.AbstractTpmLdapTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;

public class TestDelegatingLdapDirectoryMaintenance
extends AbstractTpmLdapTest {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testAddDelegatingLdapDirectory() {
        this.navigation.gotoAdmin();
        this.addDirectory();
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Delegating Ldap", "LDAP Delegated Authentication").hasMoveUp(true).hasMoveDown(false).hasDisableEditOperations();
    }

    private void addDirectory() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/delegatingldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-delegating-ldap-form");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("port", "");
        this.tester.submit("test");
        this.text.assertTextPresent("Name is a required field.");
        this.text.assertTextPresent("Hostname is a required field.");
        this.text.assertTextPresent("Port is a required field.");
        this.text.assertTextPresent("Username is a required field.");
        this.text.assertTextPresent("Password is a required field.");
        this.text.assertTextPresent("User name attribute is a required field");
        this.tester.setWorkingForm("configure-delegating-ldap-form");
        this.tester.setFormElement("name", "First Delegating Ldap");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.submit("test");
        this.tester.submit("save");
    }

    public void testEditDelegatingLdapDirectory() {
        this.navigation.gotoAdminSection("user_directories");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setFormElement("name", "First Delegating Ldap X");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.submit("test");
        this.tester.submit("save");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Delegating Ldap X", "LDAP Delegated Authentication").hasMoveUp(true).hasMoveDown(false).hasDisableEditOperations();
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setFormElement("name", "");
        this.tester.setFormElement("hostname", "");
        this.tester.setFormElement("port", "");
        this.tester.setFormElement("ldapUserdn", "");
        this.tester.setFormElement("ldapPassword", "");
        this.tester.setFormElement("ldapBasedn", "");
        this.tester.setFormElement("ldapUserUsername", "");
        this.tester.submit("test");
        this.text.assertTextPresent("Name is a required field.");
        this.text.assertTextPresent("Hostname is a required field.");
        this.text.assertTextPresent("Port is a required field.");
        this.text.assertTextPresent("Username is a required field.");
        this.text.assertTextPresent("Password is a required field.");
        this.text.assertTextPresent("Base DN is a required field.");
        this.text.assertTextPresent("User name attribute is a required field");
        this.tester.clickLink("configure-delegating-ldap-form-cancel");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Delegating Ldap X", "LDAP Delegated Authentication").hasMoveUp(true).hasMoveDown(false).hasDisableEditOperations();
    }

    public void testDeleteDelegatingLdapDirectory() {
        this.navigation.gotoAdminSection("user_directories");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.addDirectory();
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        WebLink link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Disable");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "First Delegating Ldap (inactive)", "LDAP Delegated Authentication").hasMoveUp(true).hasMoveDown(false).hasEnableEditRemoveOperations();
        link = userDirectoryTable.getTableCell(2, 4).getLinkWith("Remove");
        this.navigation.clickLink(link);
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(false).hasOnlyEditOperation();
        this.text.assertTextNotPresent(new IdLocator(this.tester, "embcwd"), "First Delegating Ldap");
    }
}

