/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.modern;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.IdLocator;

public class TestTimeTrackingIsOptional
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestTimeTrackingBase.xml");
        this.administration.timeTracking().disable();
        this.administration.timeTracking().enable(TimeTracking.Mode.MODERN);
        this.administration.fieldConfigurations().defaultFieldConfiguration().getScreens("Log Work").addFieldToScreen("Default Screen");
    }

    public void testEmptyEstimatesOnCreateAreAccepted() throws Exception {
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "Test Empty Original And Remaining Estimates Are Accepted On Create");
        this.tester.submit("Create");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "Test Empty Remaining Estimate Is Accepted On Create");
        this.tester.setFormElement("timetracking_originalestimate", "1d");
        this.tester.submit("Create");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().goToCreateIssueForm("homosapien", "Improvement");
        this.tester.setFormElement("summary", "Test Empty Original Estimate Is Accepted On Create");
        this.tester.setFormElement("timetracking_remainingestimate", "1d");
        this.tester.submit("Create");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
    }

    public void testEmptyEstimatesOnEditAreAccepted() throws Exception {
        this.navigation.issue().setEstimates("HSP-5", "", "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().setRemainingEstimate("HSP-5", "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().setOriginalEstimate("HSP-5", "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
    }

    public void testEmptyEstimatesOnTransitionAreAccepted() throws Exception {
        this.addTimeTrackingFieldToResolveIssueScreen();
        this.navigation.issue().resolveIssue("HSP-5", "Fixed", "Resolving With Empty Estimates", "", "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().resolveIssue("HSP-4", "Fixed", "Resolving With Empty Remaining Estimate", null, "");
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
        this.navigation.issue().resolveIssue("HSP-10", "Fixed", "Resolving With Empty Original Estimate", "", null);
        this.assertIsRequiredErrorMessagesAreNotPresent();
        this.assertIssueHasBeenCreatedOrEditedSuccessfully();
    }

    private void addTimeTrackingFieldToResolveIssueScreen() {
        this.navigation.gotoAdminSection("field_screens");
        this.tester.assertLinkPresent("configure_fieldscreen_Resolve Issue Screen");
        this.tester.clickLink("configure_fieldscreen_Resolve Issue Screen");
        this.tester.selectOption("fieldId", "Time Tracking");
        this.tester.clickButton("add_field_submit");
    }

    private void assertIssueHasBeenCreatedOrEditedSuccessfully() {
        String issueKeyTagId = "key-val";
        this.tester.assertElementPresent("key-val");
        TestTimeTrackingIsOptional.assertNotNull((Object)new IdLocator(this.tester, "key-val"));
    }

    private void assertIsRequiredErrorMessagesAreNotPresent() {
        this.text.assertTextNotPresent("Original Estimate is required.");
        this.text.assertTextNotPresent("Remaining Estimate is required.");
    }
}

