/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.FuncTestCase;

public class TestWorkLogTabPanelVisibility
extends FuncTestCase {
    private static final String BUG = "HSP-1";
    private static final String NEW_FEATURE = "HSP-2";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestWorkLogVisibility.xml");
    }

    public void testWorkLogTabPanelVisibility() {
        this.navigation.issue().viewIssue(BUG);
        this.assertTabLinkPresent();
        this.navigation.issue().viewIssue(NEW_FEATURE);
        this.assertTabLinkNotPresent();
        this.flipVisibilityInFieldConfigEnterprise();
        this.navigation.issue().viewIssue(BUG);
        this.assertTabLinkNotPresent();
        this.navigation.issue().viewIssue(NEW_FEATURE);
        this.assertTabLinkPresent();
    }

    public void testDirectUrlAccessTakesVisibilityIntoAccount() {
        this.assertTabPresent(BUG);
        this.assertTabNotPresent(NEW_FEATURE);
        this.flipVisibilityInFieldConfigEnterprise();
        this.assertTabNotPresent(BUG);
        this.assertTabPresent(NEW_FEATURE);
    }

    private void flipVisibilityInFieldConfigEnterprise() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("field_configuration");
        this.tester.clickLink("configure-Default Field Configuration");
        this.tester.clickLink("show_17");
        this.tester.clickLink("view_fieldlayouts");
        this.tester.clickLink("configure-Bug Field Configuration");
        this.tester.clickLink("hide_17");
    }

    private void assertTabPresent(String issueKey) {
        this.tester.gotoPage("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.text.assertTextSequence(this.locator.page(), new String[]{"Time Spent", BUG.equals(issueKey) ? "2 hours" : "1 hour", "No comment"});
    }

    private void assertTabNotPresent(String issueKey) {
        this.tester.gotoPage("/browse/" + issueKey + "?page=com.atlassian.jira.plugin.system.issuetabpanels:worklog-tabpanel");
        this.tester.assertTextNotPresent("Time Spent");
        this.tester.assertTextNotPresent(BUG.equals(issueKey) ? "2 hours" : "1 hour");
        this.tester.assertTextNotPresent("No comment");
    }

    private void assertTabLinkNotPresent() {
        this.tester.assertLinkNotPresentWithText("Work Log");
    }

    private void assertTabLinkPresent() {
        this.tester.assertLinkPresentWithText("Work Log");
    }
}

