/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timetracking.legacy;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.changehistory.ChangeHistoryList;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;

public class TestCreateWorklog
extends FuncTestCase {
    private static final String HSP_1 = "HSP-1";
    private static final String WORK_LOG_COMMENT_1 = "This is a comment generated for a first work log.";
    private static final String WORK_LOG_COMMENT_2 = "This is a comment generated for a second work log.";
    private static final String ROLE_DEVELOPERS = "Developers";
    private static final String GROUP_ADMINISTRATORS = "jira-administrators";
    private String timeFormat;

    public TestCreateWorklog(String name) {
        this.setName(name);
    }

    @Override
    public void setUpTest() {
        this.administration.restoreData("TestLogWork.xml");
        this.administration.generalConfiguration().setCommentVisibility(GeneralConfiguration.CommentVisibility.GROUPS_PROJECT_ROLES);
    }

    public void testWorklogNoPermToCreate() {
        this.administration.permissionSchemes().defaultScheme();
        this.tester.clickLink("del_perm_20_jira-developers");
        this.tester.submit("Delete");
        this.tester.gotoPage("/secure/CreateWorklog!default.jspa?id=10000");
        this.tester.assertTextPresent("It seems that you have tried to perform an operation which you are not permitted to perform");
    }

    public void testLogWorkNoteCorrect() {
        this.tester.gotoPage("/secure/ShowTimeTrackingHelp.jspa?decorator=popup#LogWork");
        this.text.assertTextPresent("Your current conversion rates are 1w = 7d and 1d = 24h.");
        this.administration.timeTracking().disable();
        this.tester.clickLink("admin_link");
        this.tester.clickLink("timetracking");
        this.tester.setFormElement("hoursPerDay", "6");
        this.tester.setFormElement("daysPerWeek", "5");
        this.tester.submit("Activate");
        this.tester.gotoPage("/secure/ShowTimeTrackingHelp.jspa?decorator=popup#LogWork");
        this.text.assertTextPresent("Your current conversion rates are 1w = 5d and 1d = 6h.");
    }

    public void testMandatoryFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", "");
        this.tester.setFormElement("startDate", "");
        this.tester.setFormElement("newEstimate", "");
        this.tester.checkCheckbox("adjustEstimate", "new");
        this.tester.submit();
        this.text.assertTextPresent("You must indicate the time spent working.");
        this.text.assertTextPresent("You must specify a date on which the work occurred.");
        this.text.assertTextPresent("You must supply a valid new estimate.");
    }

    public void testInvalidFormattedDurationFields() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "16 Candles");
        this.getTester().setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.getTester().setFormElement("newEstimate", "Six Days, Seven Nights");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().submit();
        this.text.assertTextPresent("Invalid time duration entered.");
        this.text.assertTextPresent("Invalid new estimate entered.");
    }

    public void testNegativeDuration() {
        this.navigation.issue().logWork(HSP_1, "-2h");
        this.text.assertTextPresent("Invalid time duration entered.");
    }

    public void testBadFractionDuration() {
        String[] badDurations;
        for (String badDuration : badDurations = new String[]{"5.3756h"}) {
            this.navigation.issue().logWork(HSP_1, badDuration);
            this.text.assertTextPresent("Invalid time duration entered.");
        }
    }

    public void testGoodFractionDuration() throws Exception {
        this.navigation.issue().logWork(HSP_1, "2.5h");
        this.assertTextSequence(new String[]{"Time Spent", "2 hours, 30 minutes"});
        this.navigation.issue().logWork(HSP_1, "2.5h 30m");
        this.assertTextSequence(new String[]{"Time Spent", "5 hours, 30 minutes"});
        this.navigation.issue().logWork(HSP_1, "1.5d");
        this.assertTextSequence(new String[]{"Time Spent", "1 day, 17 hours, 30 minutes"});
    }

    public void testInvalidTimeSpentZero() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "0");
        this.getTester().setFormElement("startDate", "18/Jun/07 10:49 AM");
        this.getTester().submit();
        this.text.assertTextPresent("Time Spent can not be zero.");
    }

    public void testInvalidStartDateField() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h");
        this.getTester().setFormElement("startDate", "The Day After Tomorrow");
        this.getTester().checkCheckbox("adjustEstimate", "leave");
        this.getTester().submit();
        this.text.assertTextPresent("You must specify a date on which the work occurred.");
    }

    public void testAutoAdjustEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("editIssue");
        this.getTester().setFormElement("timetracking", "4d");
        this.getTester().submit("Update");
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h 30m");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "3 days, 19 hours, 30 minutes", "Time Spent", "4 hours, 30 minutes"});
    }

    public void testNewEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("editIssue");
        this.getTester().setFormElement("timetracking", "4d");
        this.getTester().submit("Update");
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h 30m");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "1d 5h");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "1 day, 5 hours", "Time Spent", "4 hours, 30 minutes"});
    }

    public void testLeaveExistingEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("editIssue");
        this.getTester().setFormElement("timetracking", "4d");
        this.getTester().submit("Update");
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h 30m");
        this.getTester().checkCheckbox("adjustEstimate", "leave");
        this.getTester().submit("Log");
        this.assertTextSequence(new String[]{"Original Estimate", "4 days", "Remaining Estimate", "4 days", "Time Spent", "4 hours, 30 minutes"});
    }

    public void testLogWorkVisibleToAll() {
        this.reconfigureTimetracking("pretty");
        this.execLogWorkVisibleToAll();
    }

    public void testLogWorkVisibleToAllDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execLogWorkVisibleToAll();
    }

    public void testLogWorkVisibleToAllHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execLogWorkVisibleToAll();
    }

    private void execLogWorkVisibleToAll() {
        this.navigation.issue().viewIssue(HSP_1);
        this.oldway_consider_porting.logWorkOnIssueWithComment(HSP_1, "2d", WORK_LOG_COMMENT_1);
        this.getTester().clickLinkWithText("Work Log");
        this.text.assertTextPresent(WORK_LOG_COMMENT_1);
        if ("pretty".equals(this.timeFormat)) {
            this.text.assertTextPresent("2 days");
        } else if ("days".equals(this.timeFormat)) {
            this.oldway_consider_porting.assertTextPresentAfterText("2d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.oldway_consider_porting.assertTextPresentAfterText("48h", "Time Spent");
        }
    }

    public void testLogWorkVisibleToRole() {
        this.reconfigureTimetracking("pretty");
        this.execLogWorkVisibleToRole();
    }

    public void testLogWorkVisibleToRoleDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execLogWorkVisibleToRole();
    }

    public void testLogWorkVisibleToRoleHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execLogWorkVisibleToRole();
    }

    public void execLogWorkVisibleToRole() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "2d");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "2w");
        this.getTester().setFormElement("comment", WORK_LOG_COMMENT_1);
        this.getTester().selectOption("commentLevel", ROLE_DEVELOPERS);
        this.getTester().submit();
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "3d");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "2w");
        this.getTester().setFormElement("comment", WORK_LOG_COMMENT_2);
        this.getTester().selectOption("commentLevel", ROLE_DEVELOPERS);
        this.getTester().submit();
        this.getTester().clickLinkWithText("Work Log");
        this.text.assertTextPresent(WORK_LOG_COMMENT_1);
        this.text.assertTextPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.text.assertTextPresent("2 days");
            this.text.assertTextPresent("3 days");
            this.text.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.oldway_consider_porting.assertTextPresentAfterText("2d", "Time Spent");
            this.oldway_consider_porting.assertTextPresentAfterText("3d", "Time Spent");
            this.oldway_consider_porting.assertTextPresentAfterText("5d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.oldway_consider_porting.assertTextPresentAfterText("48h", "Time Spent");
            this.oldway_consider_porting.assertTextPresentAfterText("72h", "Time Spent");
            this.oldway_consider_porting.assertTextPresentAfterText("120h", "Time Spent");
        }
        this.navigation.login("fred", "fred");
        this.navigation.issue().viewIssue(HSP_1);
        this.text.assertTextNotPresent(WORK_LOG_COMMENT_1);
        this.text.assertTextNotPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.text.assertTextNotPresent("2 days");
            this.text.assertTextNotPresent("3 days");
            this.text.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.text.assertTextNotPresent(" 2d ");
            this.text.assertTextNotPresent(" 3d ");
            this.oldway_consider_porting.assertTextPresentAfterText("5d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.text.assertTextNotPresent(" 48h ");
            this.text.assertTextNotPresent(" 72h ");
            this.oldway_consider_porting.assertTextPresentAfterText("120h", "Time Spent");
        }
    }

    public void testLogWorkVisibleToGroup() {
        this.reconfigureTimetracking("pretty");
        this.execLogWorkVisibleToGroup();
    }

    public void testLogWorkVisibleToGroupDaysTimeFormat() {
        this.reconfigureTimetracking("days");
        this.execLogWorkVisibleToGroup();
    }

    public void testLogWorkVisibleToGroupHoursTimeFormat() {
        this.reconfigureTimetracking("hours");
        this.execLogWorkVisibleToGroup();
    }

    public void testLogWorkDateIsStartDate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "2d");
        this.getTester().setFormElement("startDate", "1/Jun/06 12:00 PM");
        this.getTester().submit();
        this.getTester().clickLinkWithText("Work Log");
        this.text.assertTextPresent("01/Jun/06 12:00 PM");
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "2d");
        this.getTester().setFormElement("startDate", "1/Jun/05 12:00 PM");
        this.getTester().submit();
        this.oldway_consider_porting.assertTextPresentBeforeText("1/Jun/05 12:00 PM", "01/Jun/06 12:00 PM");
    }

    public void execLogWorkVisibleToGroup() {
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "2d");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "2w");
        this.getTester().setFormElement("comment", WORK_LOG_COMMENT_1);
        this.getTester().selectOption("commentLevel", GROUP_ADMINISTRATORS);
        this.getTester().submit();
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "3d");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "2w");
        this.getTester().setFormElement("comment", WORK_LOG_COMMENT_2);
        this.getTester().selectOption("commentLevel", GROUP_ADMINISTRATORS);
        this.getTester().submit();
        this.getTester().clickLinkWithText("Work Log");
        this.getTester().assertTextPresent(WORK_LOG_COMMENT_1);
        this.getTester().assertTextPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.text.assertTextPresent("2 days");
            this.text.assertTextPresent("3 days");
            this.text.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.oldway_consider_porting.assertTextPresentAfterText("2d", "Time Spent");
            this.oldway_consider_porting.assertTextPresentAfterText("3d", "Time Spent");
            this.oldway_consider_porting.assertTextPresentAfterText("5d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.oldway_consider_porting.assertTextPresentAfterText("48h", "Time Spent");
            this.oldway_consider_porting.assertTextPresentAfterText("72h", "Time Spent");
            this.oldway_consider_porting.assertTextPresentAfterText("120h", "Time Spent");
        }
        this.navigation.login("fred", "fred");
        this.navigation.issue().viewIssue(HSP_1);
        this.text.assertTextNotPresent(WORK_LOG_COMMENT_1);
        this.text.assertTextNotPresent(WORK_LOG_COMMENT_2);
        if ("pretty".equals(this.timeFormat)) {
            this.text.assertTextNotPresent("2 days");
            this.text.assertTextNotPresent("3 days");
            this.text.assertTextPresent("5 days");
        } else if ("days".equals(this.timeFormat)) {
            this.text.assertTextNotPresent(" 2d ");
            this.text.assertTextNotPresent(" 3d ");
            this.oldway_consider_porting.assertTextPresentAfterText("5d", "Time Spent");
        } else if ("hours".equals(this.timeFormat)) {
            this.text.assertTextNotPresent(" 48h ");
            this.text.assertTextNotPresent(" 72h ");
            this.oldway_consider_porting.assertTextPresentAfterText("120h", "Time Spent");
        }
    }

    public void reconfigureTimetracking(String format) {
        this.oldway_consider_porting.reconfigureTimetracking(format);
        this.timeFormat = format;
    }

    public void testChangeHistory() throws Exception {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        this.navigation.issue().viewIssue(HSP_1);
        this.getTester().clickLink("editIssue");
        this.getTester().setFormElement("timetracking", "4d");
        this.getTester().submit("Update");
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.getTester().clickLink("log-work");
        this.getTester().setFormElement("timeLogged", "4h 30m");
        this.getTester().checkCheckbox("adjustEstimate", "new");
        this.getTester().setFormElement("newEstimate", "1d 5h");
        this.getTester().submit("Log");
        this.getTester().clickLinkWithText("History");
        ChangeHistoryList expectedList = new ChangeHistoryList();
        expectedList.addChangeSet("Administrator").add("Original Estimate", "4 days [ 345600 ]").add("Remaining Estimate", "4 days [ 345600 ]");
        expectedList.addChangeSet("Administrator").add("Time Spent", "4 hours, 30 minutes [ 16200 ]").add("Remaining Estimate", "1 day, 5 hours [ 104400 ]");
        ChangeHistoryList list = this.parse.issue().parseChangeHistory();
        list.assertContainsSomeOf(expectedList);
    }

    public void testManuallyReduceEstimate() {
        this.navigation.issue().viewIssue(HSP_1);
        this.tester.clickLink("editIssue");
        this.tester.setFormElement("timetracking", "2d");
        this.tester.submit("Update");
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", "12h");
        this.tester.checkCheckbox("adjustEstimate", "manual");
        this.tester.setWorkingForm("log-work");
        this.tester.submit();
        this.text.assertTextPresent("You must supply a valid amount of time to adjust the estimate by.");
        this.tester.setFormElement("adjustmentAmount", "1cow");
        this.tester.setWorkingForm("log-work");
        this.tester.submit();
        this.text.assertTextPresent("Invalid time entered for adjusting the estimate.");
        this.tester.setFormElement("adjustmentAmount", "6h");
        this.tester.setWorkingForm("log-work");
        this.tester.submit();
        this.text.assertTextSequence(new IdLocator(this.tester, "tt_single_table_info"), "Estimated:", "2d", "Remaining:", "1d 18h", "Logged:", "12h");
    }

    private void assertTextSequence(String[] strings) {
        this.oldway_consider_porting.assertTextSequence(strings);
    }
}

