/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.subtask;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueToSubTaskConversionVariousOperations
extends JIRAWebTest {
    public TestIssueToSubTaskConversionVariousOperations(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueToSubtaskConversionVariousOperations.xml");
    }

    public void testAddNewSubtaskToExistingIssueWithSubtask() {
        this.gotoIssue("HSP-2");
        this.assertTextPresent("Sub-Tasks");
        this.assertTextPresentBeforeText("1.", "My sub-task summary");
        this.assertTextPresentBeforeText("2.", "Second subtask");
        this.assertTextNotPresent("A new issue");
        this.gotoIssue("HSP-1");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", "HSP-2");
        this.submit("Next >>");
        this.selectOption("components", "New Component 1");
        this.submit("Next >>");
        this.submit("Finish");
        this.gotoIssue("HSP-2");
        this.assertTextPresentBeforeText("1.", "My sub-task summary");
        this.assertTextPresentBeforeText("2.", "Second subtask");
        this.assertTextPresentBeforeText("3.", "A new issue");
        this.setFormElement("summary", "The new manually added subtask");
        this.submit("");
        this.setFormElement("description", "A test Desc");
        this.selectOption("components", "New Component 1");
        this.selectOption("versions", "New Version 1");
        this.submit("Create");
        this.gotoIssue("HSP-2");
        this.assertTextPresentBeforeText("1.", "My sub-task summary");
        this.assertTextPresentBeforeText("2.", "Second subtask");
        this.assertTextPresentBeforeText("3.", "A new issue");
        this.assertTextPresentBeforeText("4.", "The new manually added subtask");
    }

    public void testCancelFirstStep() {
        this.gotoIssue("HSP-1");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", "HSP-2");
        this.gotoPage("/secure/ConvertIssue!cancel.jspa?id=10000");
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("A new issue");
        this.assertTextPresentBeforeText("Type", "Bug");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", "HSP-2");
        this.submit("Next >>");
        this.selectOption("components", "New Component 1");
        this.submit("Next >>");
        this.submit("Finish");
        this.text.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "HSP-2 A second issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "HSP-1");
        this.text.assertTextPresent(new IdLocator(this.tester, "issue_header_summary"), "A new issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "type-val"), "Sub-task");
    }

    public void testCancelThirdStep() {
        this.gotoIssue("HSP-1");
        this.clickLink("issue-to-subtask");
        this.assertSubTaskConversionPanelSteps("HSP-1", 1);
        this.setFormElement("parentIssueKey", "HSP-2");
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps("HSP-1", 3);
        this.gotoPage("/secure/ConvertIssue!cancel.jspa?id=10000");
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("A new issue");
        this.assertTextPresentBeforeText("Type", "Bug");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", "HSP-2");
        this.submit("Next >>");
        this.selectOption("components", "New Component 1");
        this.submit("Next >>");
        this.submit("Finish");
        this.text.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "HSP-2 A second issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "HSP-1");
        this.text.assertTextPresent(new IdLocator(this.tester, "issue_header_summary"), "A new issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "type-val"), "Sub-task");
    }

    public void testCancelLastStep() {
        this.gotoIssue("HSP-1");
        this.clickLink("issue-to-subtask");
        this.assertSubTaskConversionPanelSteps("HSP-1", 1);
        this.setFormElement("parentIssueKey", "HSP-2");
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps("HSP-1", 3);
        this.selectOption("components", "New Component 1");
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps("HSP-1", 4);
        this.gotoPage("/secure/ConvertIssue!cancel.jspa?id=10000");
        this.assertTextPresent("HSP-1");
        this.assertTextPresent("A new issue");
        this.assertTextPresentBeforeText("Type", "Bug");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", "HSP-2");
        this.submit("Next >>");
        this.selectOption("components", "New Component 1");
        this.submit("Next >>");
        this.submit("Finish");
        this.text.assertTextPresent(new IdLocator(this.tester, "parent_issue_summary"), "HSP-2 A second issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "key-val"), "HSP-1");
        this.text.assertTextPresent(new IdLocator(this.tester, "issue_header_summary"), "A new issue");
        this.text.assertTextPresent(new IdLocator(this.tester, "type-val"), "Sub-task");
    }

    public void testConversionWithoutBrowsePermission() {
        this.logout();
        this.login("fred", "fred");
        this.gotoPage("/secure/ConvertIssue.jspa?id=10080");
        this.setFormElement("parentIssueKey", "CAT-3");
        this.submit("Next >>");
        this.submit("Next >>");
        this.submit("Finish");
        this.assertTextPresent("You have successfully converted the issue (CAT-1), however you do not have the permission to view the converted issue");
    }

    public void testConversionWithHiddenField() {
        this.gotoIssue("CAT-1");
        this.clickLink("editIssue");
        this.setFormElement("environment", "Test environment");
        this.submit("Update");
        this.gotoAdmin();
        this.clickLink("field_configuration");
        this.clickLinkWithText("Default Field Configuration");
        this.clickLink("hide_7");
        this.gotoIssue("CAT-1");
        this.clickLink("issue-to-subtask");
        this.setFormElement("parentIssueKey", "CAT-2");
        this.submit("Next >>");
        this.submit("Next >>");
        this.assertSubTaskConversionPanelSteps("CAT-1", 4);
        this.assertTextPresent("Environment");
    }
}

