/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project.version;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;

public class TestAddVersion
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
    }

    public void testAddVersionValidation() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLink("manage_versions");
        this.tester.submit("Add");
        this.tester.assertTextPresent("You must specify a valid version name");
        this.tester.setFormElement("name", "Another version");
        this.tester.setFormElement("releaseDate", "inadsfasdf");
        this.tester.submit("Add");
        this.tester.assertTextPresent("Please enter the date in the following format: d/MMM/yy");
    }

    public void testAddVersionSuccess() {
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLink("manage_versions");
        this.tester.setFormElement("name", "Final Release");
        this.tester.setFormElement("description", "Description about the latest version");
        this.tester.setFormElement("releaseDate", "10/Sep/15");
        this.tester.submit("Add");
        this.text.assertTextSequence(new TableLocator(this.tester, "versions_table"), new String[]{"Final Release", "Description about the latest version", "10/Sep/15", "New Version 5", "Test Version Description 5"});
    }

    public void testAddVersionNoPermission() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/project/AddVersion.jspa?pid=10000&name=newversion");
    }
}

