/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.joda.time.DateTime;
import org.w3c.dom.Node;

public class TestSummaryProjectTabPanel
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testProjectDescription() throws Exception {
        this.navigation.browseProject("HSP");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragprojectdescription']//p"), "project for homosapiens");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Edit", 0);
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("description", "");
        this.tester.submit();
        this.navigation.browseProject("HSP");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='fragprojectdescription']//p"), "project for homosapiens");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Edit", 0);
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("description", "project <b>for</b> homosapiens");
        this.tester.submit();
        this.navigation.browseProject("HSP");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='fragprojectdescription']//p").getHTML(), "project <b>for</b> homosapiens");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='fragprojectdescription']//p").getHTML(), "project &lt;b&gt;for&lt;/b&gt; homosapiens");
    }

    public void testProjectUrl() throws Exception {
        this.navigation.browseProject("HSP");
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//div[@id='primary']/div[1]//li"), "URL:");
        this.navigation.gotoAdminSection("view_projects");
        this.tester.clickLinkWithText("Edit", 0);
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement("url", "http://www.homosapien.com");
        this.tester.submit();
        this.navigation.browseProject("HSP");
        this.text.assertTextPresent(new XPathLocator(this.tester, "//div[@id='primary']/div[1]//li"), "URL:");
        this.tester.assertLinkPresentWithText("http://www.homosapien.com");
    }

    public void testProjectKey() throws Exception {
        this.navigation.browseProject("HSP");
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='primary']/div[1]//li"), new String[]{"Key:", "HSP"});
    }

    public void testProjectLead() throws Exception {
        this.navigation.browseProject("HSP");
        this.assertions.assertProfileLinkPresent("project_summary_admin", "Administrator");
        this.administration.restoreData("TestProjectLeadWithNoFullName.xml");
        this.navigation.browseProject("MKY");
        this.tester.assertLinkPresent("project_summary_fred");
        this.tester.assertLinkNotPresentWithText("Fred Normal");
        this.administration.restoreData("TestNonExistantLead.xml");
        this.navigation.browseProject("HSP");
        this.tester.assertLinkNotPresent("project_summary_adminXXX");
        this.tester.assertLinkNotPresentWithText("adminXXX");
    }

    public void testDueIssues() throws Exception {
        DateTime cal = new DateTime();
        SimpleDateFormat dateFormat = new SimpleDateFormat("d/MMM/yy EEEE", Locale.getDefault());
        cal = cal.minusDays(14);
        DateTuple twoWeeksAgo = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(7);
        DateTuple oneWeekAgo = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(6);
        DateTuple yesterday = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(1);
        DateTuple today = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(1);
        DateTuple tomorrow = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(6);
        DateTuple oneWeekLater = new DateTuple(dateFormat.format(cal.toDate()));
        cal = cal.plusDays(7);
        DateTuple twoWeeksLater = new DateTuple(dateFormat.format(cal.toDate()));
        this.assertFragmentNotPresent("fragdueissues");
        String issue1 = this.createIssueAndSetDueDate("homosapien", twoWeeksAgo, "Bug due two weeks ago");
        String issue2 = this.createIssueAndSetDueDate("homosapien", oneWeekAgo, "Bug due one week ago");
        String issue3 = this.createIssueAndSetDueDate("homosapien", yesterday, "Bug due yesterday");
        String issue4 = this.createIssueAndSetDueDate("homosapien", today, "Bug due today");
        String issue5 = this.createIssueAndSetDueDate("homosapien", tomorrow, "Bug due tomorrow");
        String issue6 = this.createIssueAndSetDueDate("homosapien", oneWeekLater, "Bug due one week later");
        String issue7 = this.createIssueAndSetDueDate("homosapien", twoWeeksLater, "Bug due two weeks later");
        String issueOtherProject = this.createIssueAndSetDueDate("monkey", twoWeeksLater, "Bug due two weeks later");
        this.assertTop3DueIssues(issue1, twoWeeksAgo.dateString, issue2, "Last " + oneWeekAgo.dayOfWeek, issue3, "Yesterday", issue4, issue5, issue6, issue7, issueOtherProject);
        this.setDueDateAndPriority(issue2, yesterday.dateString, "Blocker");
        this.setDueDateAndPriority(issue3, yesterday.dateString, "Minor");
        this.setDueDateAndPriority(issue1, yesterday.dateString, "Trivial");
        this.assertTop3DueIssues(issue2, "Yesterday", issue3, "Yesterday", issue1, "Yesterday", issue4, issue5, issue6, issue7, issueOtherProject);
        this.resolveIssue(issue1);
        this.resolveIssue(issue2);
        this.resolveIssue(issue3);
        this.assertTop3DueIssues(issue4, "Today", issue5, "Tomorrow", issue6, oneWeekLater.dayOfWeek, issue1, issue2, issue3, issue7, issueOtherProject);
        this.setDueDateAndPriority(issue4, "", null);
        this.assertTop3DueIssues(issue5, "Tomorrow", issue6, oneWeekLater.dayOfWeek, issue7, twoWeeksLater.dateString, issue1, issue2, issue3, issue4, issueOtherProject);
        this.setDueDateAndPriority(issue5, "", null);
        this.assertTop3DueIssues(issue6, oneWeekLater.dayOfWeek, issue7, twoWeeksLater.dateString, issue4, "", issue1, issue2, issue3, issue5, issueOtherProject);
        this.setDueDateAndPriority(issue5, "", "Blocker");
        this.assertTop3DueIssues(issue6, oneWeekLater.dayOfWeek, issue7, twoWeeksLater.dateString, issue5, "", issue1, issue2, issue3, issue4, issueOtherProject);
        this.tester.clickLink("fragdueissues_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearcherField("fieldresolution", "Unresolved");
        this.assertSearchOrder("Due Date ascending", "then Priority descending", "then Created ascending");
    }

    public void testRecentlyUpdatedIssues() throws Exception {
        this.assertFragmentNotPresent("fragrecentissues");
        this.administration.restoreData("TestRecentlyUpdatedIssuesFragment.xml");
        this.assertTop3RecentIssues("HSP-4", "HSP-2", "HSP-3", "HSP-1");
        this.setDueDateAndPriority("HSP-1", "", "Blocker");
        this.assertTop3RecentIssues("HSP-1", "HSP-4", "HSP-2", "HSP-3");
        this.tester.clickLink("fragrecentissues_more");
        this.assertSearcherField("fieldpid", "homosapien");
        this.assertSearchOrder("Updated descending", "then Priority descending", "then Created ascending");
    }

    public void testDueVersions() throws Exception {
        this.administration.restoreData("TestSummaryProjectTabPanel_DueVersions.xml");
        this.assertTop3DueVersions(new String[]{"New Version 1", "New Version 4", "New Version 5"}, "New Version 7");
        this.administration.project().archiveVersion("homosapien", "New Version 1");
        this.assertTop3DueVersions(new String[]{"New Version 4", "New Version 5", "New Version 7"}, "New Version 1");
        this.administration.project().releaseVersion("homosapien", "New Version 5", null);
        this.assertTop3DueVersions(new String[]{"New Version 4", "New Version 7"}, "New Version 1", "New Version 5");
        this.administration.project().releaseVersion("homosapien", "New Version 4", null);
        this.administration.project().archiveVersion("homosapien", "New Version 4");
        this.assertTop3DueVersions(new String[]{"New Version 7"}, "New Version 1", "New Version 4", "New Version 5");
        this.administration.project().releaseVersion("homosapien", "New Version 7", null);
        this.administration.project().archiveVersion("homosapien", "New Version 7");
        this.assertFragmentNotPresent("fragdueversions");
        this.administration.project().unreleaseVersion("homosapien", "New Version 5", null);
        this.assertTop3DueVersions(new String[]{"New Version 5"}, "New Version 1", "New Version 4", "New Version 7");
        this.tester.gotoPage("/secure/admin/IssueFieldHide.jspa?hide=8");
        this.navigation.checkWebSudoWithLastPassword();
        this.assertFragmentNotPresent("fragdueversions");
    }

    public void testDueVersionsNoVersions() throws Exception {
        this.administration.project().deleteVersion("homosapien", "New Version 1");
        this.administration.project().deleteVersion("homosapien", "New Version 4");
        this.administration.project().deleteVersion("homosapien", "New Version 5");
        this.assertFragmentNotPresent("fragdueversions");
    }

    public void testCreatedVsResolved() {
        this.navigation.browseProject("HSP");
        this.tester.assertTextPresent("Issues: 30 Day Summary");
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='fragcreatedvsresolved']//div"), "Issues", "0", "created and ", "0", "resolved");
        this.navigation.issue().createIssue("homosapien", "Bug", "Test summary");
        this.navigation.browseProject("HSP");
        this.tester.assertTextPresent("Issues: 30 Day Summary");
        this.text.assertTextSequence(new XPathLocator(this.tester, "//div[@id='fragcreatedvsresolved']//div"), "Issues", "1", "created and ", "0", "resolved");
    }

    private void assertTop3DueVersions(String[] presentVersions, String ... notPresentVersions) {
        this.navigation.browseProject("HSP");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragdueversions' ]//ul[@class='issues']/li");
        for (String version : notPresentVersions) {
            this.text.assertTextNotPresent(pathLocator, version);
        }
        this.text.assertTextSequence(pathLocator, presentVersions);
    }

    private void assertFragmentNotPresent(String fragmentId) {
        this.navigation.browseProject("HSP");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='" + fragmentId + "']/h3");
        Node[] nodes = pathLocator.getNodes();
        TestSummaryProjectTabPanel.assertTrue((nodes == null || nodes.length == 0 ? 1 : 0) != 0);
    }

    private void assertTop3DueIssues(String firstIssue, String firstDueDate, String secondIssue, String secondDueDate, String thirdIssue, String thirdDueDate, String ... issuesNotPresent) {
        this.navigation.browseProject("HSP");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragdueissues']//ul[@class='issues']/li");
        this.text.assertTextSequence(pathLocator, new String[]{firstIssue, firstDueDate, secondIssue, secondDueDate, thirdIssue, thirdDueDate});
        for (String issue : issuesNotPresent) {
            this.text.assertTextNotPresent(pathLocator, issue);
        }
    }

    private void assertTop3RecentIssues(String firstIssue, String secondIssue, String thirdIssue, String ... issuesNotPresent) {
        this.navigation.browseProject("HSP");
        XPathLocator pathLocator = new XPathLocator(this.tester, "//div[@id='fragrecentissues']//ul[@class='issues']/li");
        this.text.assertTextSequence(pathLocator, new String[]{firstIssue, secondIssue, thirdIssue});
        for (String issue : issuesNotPresent) {
            this.text.assertTextNotPresent(pathLocator, issue);
        }
    }

    private String createIssueAndSetDueDate(String projectName, DateTuple dateTuple, String summary) {
        String key = this.navigation.issue().createIssue(projectName, "Bug", summary);
        this.setDueDateAndPriority(key, dateTuple.dateString, null);
        return key;
    }

    private void setDueDateAndPriority(String key, String dueDate, String priority) {
        this.navigation.issue().viewIssue(key);
        this.tester.clickLink("editIssue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("duedate", dueDate);
        if (priority != null) {
            this.tester.selectOption("priority", priority);
        }
        this.tester.submit();
    }

    private void resolveIssue(String key) {
        this.navigation.issue().viewIssue(key);
        this.tester.clickLinkWithText("Resolve Issue");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.tester.submit("Transition");
    }

    private void assertSearchOrder(String ... expectedSequence) {
        XPathLocator pathLocator = new XPathLocator(this.tester, "//*[@id='filter-summary']/div");
        this.text.assertTextSequence(pathLocator, "Sorted by", expectedSequence);
    }

    private void assertSearcherField(String elementId, String expectedText) {
        this.text.assertTextPresent(new XPathLocator(this.tester, "//span[@id='" + elementId + "']"), expectedText);
    }

    private static class DateTuple {
        String dateString;
        String dayOfWeek;

        DateTuple(String format) {
            String[] parts = format.split(" ");
            this.dateString = parts[0];
            this.dayOfWeek = parts[1];
        }
    }
}

