/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.project;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;

public class TestIssuesTabPanelsIrrelevantIssues
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssuesTabPanelsIrrelevantIssues.xml");
    }

    public void testProjectIssues() throws Exception {
        this.navigation.browseProjectTabPanel("ANA", "issues");
        this.assertPriorityBreakdown("Major", "4", "100%");
        this.assertAssigneeBreakdown("Admin", "4", "100%");
        this.assertFixVersionBreakdown("1", "Aversion 1", "1", "Aversion 2", "1", "Aversion 3", "1", "Unscheduled");
        this.assertComponentBreakdown("1", "Acomponent 1", "3", "No Component");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Assignee");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Component/s");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Fix Version/s");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Priority");
        this.administration.reIndex();
        this.navigation.browseProjectTabPanel("ANA", "issues");
        this.assertPriorityBreakdown("Major", "2", "50%", "Irrelevant", "2", "50%");
        this.assertAssigneeBreakdown("Admin", "2", "50%", "Irrelevant", "2", "50%");
        this.assertFixVersionBreakdown("1", "Aversion 2", "1", "Aversion 3", "2", "Irrelevant");
        this.assertComponentBreakdown("1", "Acomponent 1", "1", "No Component", "2", "Irrelevant");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//div[@id='project-tab']", "Irrelevant");
    }

    public void testVersionIssues() throws Exception {
        this.navigation.browseVersionTabPanel("ANA", "Aversion 1", "issues");
        this.assertPriorityBreakdown("Major", "1", "100%");
        this.assertAssigneeBreakdown("Admin", "1", "100%");
        this.assertComponentBreakdown("1", "No Component");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Assignee");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Component/s");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields("Priority");
        this.administration.reIndex();
        this.navigation.browseVersionTabPanel("ANA", "Aversion 1", "issues");
        this.assertPriorityBreakdown("Irrelevant", "1", "100%");
        this.assertAssigneeBreakdown("Irrelevant", "1", "100%");
        this.assertComponentBreakdown("1", "Irrelevant");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//div[@id='project-tab']", "Irrelevant");
    }

    public void testComponentIssues() throws Exception {
        this.navigation.browseComponentTabPanel("ANA", "Acomponent 1", "issues");
        this.assertPriorityBreakdown("Major", "1", "100%");
        this.assertAssigneeBreakdown("Admin", "1", "100%");
        this.assertFixVersionBreakdown("1", "Aversion 3");
        this.administration.fieldConfigurations().fieldConfiguration("Copy of Default Field Configuration").hideFields("Assignee");
        this.administration.fieldConfigurations().fieldConfiguration("Copy of Default Field Configuration").hideFields("Fix Version/s");
        this.administration.fieldConfigurations().fieldConfiguration("Copy of Default Field Configuration").hideFields("Priority");
        this.administration.reIndex();
        this.navigation.browseComponentTabPanel("ANA", "Acomponent 1", "issues");
        this.assertPriorityBreakdown("Irrelevant", "1", "100%");
        this.assertAssigneeBreakdown("Irrelevant", "1", "100%");
        this.assertFixVersionBreakdown("1", "Irrelevant");
        this.assertions.getLinkAssertions().assertLinkNotPresentWithExactText("//div[@id='project-tab']", "Irrelevant");
    }

    private void assertAssigneeBreakdown(String ... breakdown) {
        this.text.assertTextSequence(new IdLocator(this.tester, "fragunresolvedissuesbyassignee"), breakdown);
    }

    private void assertFixVersionBreakdown(String ... breakdown) {
        this.text.assertTextSequence(new IdLocator(this.tester, "fragunresolvedissuesbyfixversion"), breakdown);
    }

    private void assertPriorityBreakdown(String ... breakdown) {
        this.text.assertTextSequence(new IdLocator(this.tester, "fragunresolvedissuesbypriority"), breakdown);
    }

    private void assertComponentBreakdown(String ... breakdown) {
        this.text.assertTextSequence(new IdLocator(this.tester, "fragunresolvedissuesbycomponent"), breakdown);
    }
}

