/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.admin.WorkflowSteps;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.WorkflowTestConstants;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="Disabling till we resolve memory leak")
public class TestWorkflowValidatorModuleEnabling
extends AbstractReloadablePluginsTest {
    private static final String TEST_ISSUE_NAME = "Test issue";
    private static final String ERROR_FORM_CSS_LOCATOR = "div.content-body.jira-error";

    private void setUpWorkflowValidator(boolean result) {
        WorkflowSteps steps = this.administration.workflows().goTo().copyWorkflow(WorkflowTestConstants.DEFAULT_WORKFLOW_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME).workflowSteps(WorkflowTestConstants.TEST_WORKFLOW_NAME);
        steps.editTransition(1, 4).addWorkflowValidator(ReferencePluginConstants.WORKFLOW_VALIDATOR_KEY, (Map<String, String>)ImmutableMap.of((Object)WorkflowTestConstants.REFERENCE_MODULE_RESULT_PARAM, (Object)Boolean.toString(result)));
    }

    private void setUpTestScheme() {
        this.administration.workflowSchemes().goTo().addWorkflowScheme(WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME, WorkflowTestConstants.TEST_WORKFLOW_SCHEME_DESC);
        this.administration.workflowSchemes().goTo().assignWorkflowToAllIssueTypes(WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME);
    }

    public void testShouldNotBeVisibleInTheAdminWorkflowsSectionGivenPluginNotEnabled() throws Exception {
        WorkflowSteps steps = this.administration.workflows().goTo().copyWorkflow(WorkflowTestConstants.DEFAULT_WORKFLOW_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME).workflowSteps(WorkflowTestConstants.TEST_WORKFLOW_NAME);
        TestWorkflowValidatorModuleEnabling.assertFalse((boolean)steps.editTransition(1, 4).canAddWorkflowValidator(ReferencePluginConstants.WORKFLOW_VALIDATOR_KEY));
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenPluginEnabled() throws Exception {
        this.enableReferencePlugin();
        WorkflowSteps steps = this.administration.workflows().goTo().copyWorkflow(WorkflowTestConstants.DEFAULT_WORKFLOW_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME).workflowSteps(WorkflowTestConstants.TEST_WORKFLOW_NAME);
        TestWorkflowValidatorModuleEnabling.assertTrue((boolean)steps.editTransition(1, 4).canAddWorkflowValidator(ReferencePluginConstants.WORKFLOW_VALIDATOR_KEY));
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenTrueReturnValue() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowValidator(true);
        this.text.assertTextSequence(this.transitionTableTabLocator(), ReferencePluginConstants.WORKFLOW_VALIDATOR_NAME, "will always validate as true");
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSectionGivenFalseReturnValue() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowValidator(false);
        this.text.assertTextSequence(this.transitionTableTabLocator(), ReferencePluginConstants.WORKFLOW_VALIDATOR_NAME, "will always validate as false");
    }

    public void testShouldBeExecutedOnViewIssueAndAllowTransition() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowValidator(true);
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", TEST_ISSUE_NAME);
        this.assertStartProgressTransitionIsExecuted(issueKey);
    }

    public void testShouldBeExecutedOnViewIssueAndPreventTransition() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowValidator(false);
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", TEST_ISSUE_NAME);
        this.assertStartProgressTransitionIsNotExecuted(issueKey);
    }

    private void assertStartProgressTransitionIsExecuted(String issueKey) {
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage(issueKey);
        this.tester.clickLink(WorkflowTestConstants.START_PROGRESS_LINK_ID);
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage(issueKey);
        this.assertions.getViewIssueAssertions().assertStatus("In Progress");
    }

    private void assertStartProgressTransitionIsNotExecuted(String issueKey) {
        this.assertions.getViewIssueAssertions().assertOnViewIssuePage(issueKey);
        this.tester.clickLink(WorkflowTestConstants.START_PROGRESS_LINK_ID);
        this.assertions.assertNodeExists(this.errorFormLocator());
        this.assertions.getTextAssertions().assertTextPresent(this.errorMessageLocator(), ReferencePluginConstants.WORKFLOW_VALIDATOR_ERROR_MESSAGE);
    }

    private Locator transitionTableTabLocator() {
        return this.locator.id(WorkflowTestConstants.TRANSITION_TAB_TABLE_ID);
    }

    private Locator errorFormLocator() {
        return this.locator.css(ERROR_FORM_CSS_LOCATOR);
    }

    private Locator errorMessageLocator() {
        return this.locator.css("div.content-body.jira-error div.aui-message.warning");
    }
}

