/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.admin.WorkflowSteps;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.WorkflowTestConstants;
import java.util.Collections;
import org.junit.Ignore;

@Ignore(value="Disabling till we resolve memory leak")
public class TestWorkflowFunctionModuleEnabling
extends AbstractReloadablePluginsTest {
    private void setUpWorkflowFunction() {
        WorkflowSteps steps = this.administration.workflows().goTo().copyWorkflow(WorkflowTestConstants.DEFAULT_WORKFLOW_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME).workflowSteps(WorkflowTestConstants.TEST_WORKFLOW_NAME);
        steps.editTransition(1, 4).addWorkflowFunction(ReferencePluginConstants.WORKFLOW_FUNCTION_KEY);
    }

    private void setUpTestScheme() {
        this.administration.workflowSchemes().goTo().addWorkflowScheme(WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME, WorkflowTestConstants.TEST_WORKFLOW_SCHEME_DESC);
        this.administration.workflowSchemes().goTo().assignWorkflowToAllIssueTypes(WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME);
    }

    public void testShouldNotBeVisibleInTheAdminWorkflowsSectionGivenPluginNotEnabled() throws Exception {
        WorkflowSteps steps = this.administration.workflows().goTo().copyWorkflow(WorkflowTestConstants.DEFAULT_WORKFLOW_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME).workflowSteps(WorkflowTestConstants.TEST_WORKFLOW_NAME);
        TestWorkflowFunctionModuleEnabling.assertFalse((boolean)steps.editTransition(1, 4).canAddWorkflowFunction(ReferencePluginConstants.WORKFLOW_FUNCTION_KEY));
    }

    public void testShouldBeVisibleInTheAddWorkflowFunctionScreen() throws Exception {
        this.enableReferencePlugin();
        WorkflowSteps steps = this.administration.workflows().goTo().copyWorkflow(WorkflowTestConstants.DEFAULT_WORKFLOW_NAME, WorkflowTestConstants.TEST_WORKFLOW_NAME).workflowSteps(WorkflowTestConstants.TEST_WORKFLOW_NAME);
        TestWorkflowFunctionModuleEnabling.assertTrue((boolean)steps.editTransition(1, 4).canAddWorkflowFunction(ReferencePluginConstants.WORKFLOW_FUNCTION_KEY));
    }

    public void testShouldBeVisibleInTheAdminWorkflowsSection() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowFunction();
        this.text.assertTextPresent(this.transitionTableTabLocator(), ReferencePluginConstants.WORKFLOW_FUNCTION_NAME);
    }

    public void testShouldBeExecutedOnIssueTransition() throws Exception {
        this.enableReferencePlugin();
        this.setUpWorkflowFunction();
        this.setUpTestScheme();
        this.administration.project().associateWorkflowScheme("homosapien", WorkflowTestConstants.TEST_WORKFLOW_SCHEME_NAME);
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", "Test issue");
        this.startProgress();
        this.assertions.comments(Collections.singletonList(this.workflowFunctionComment(issueKey))).areVisibleTo("admin", issueKey);
    }

    private String workflowFunctionComment(String issueKey) {
        return String.format("[ReferenceWorkflowFunction] transition ID %d of issue %s by %s", 4, issueKey, "admin");
    }

    private void startProgress() {
        this.tester.clickLink(WorkflowTestConstants.START_PROGRESS_LINK_ID);
    }

    private Locator transitionTableTabLocator() {
        return this.locator.id(WorkflowTestConstants.TRANSITION_TAB_TABLE_ID);
    }
}

