/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractReloadablePluginsTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import org.junit.Ignore;

@Ignore(value="Disabling till we resolve memory leak")
public class TestModuleTypeModuleEnabling
extends AbstractReloadablePluginsTest {
    private static final int HTTP_ERROR_CODE = 404;
    private static final String MODULE_TYPE_ACTION_URL = "/ReferenceModuleTypeAction.jspa";
    private static final String MODULE_LIST_CONTAINER_ID = "reference-moduletypes-list";
    private static final ModuleOutputVerifier INTERNAL_WITH_I18N = new ModuleOutputVerifier(ReferencePluginConstants.REFERENCE_INTERNAL_MODULE_WITH_I18N_KEY, ReferencePluginConstants.REFERENCE_INTERNAL_MODULE_WITH_I18N_NAME, ReferencePluginConstants.REFERENCE_INTERNAL_MODULE_WITH_I18N_DESC);
    private static final ModuleOutputVerifier INTERNAL_WITHOUT_I18N = new ModuleOutputVerifier(ReferencePluginConstants.REFERENCE_INTERNAL_MODULE_WITHOUT_I18N_KEY, ReferencePluginConstants.REFERENCE_INTERNAL_MODULE_WITHOUT_I18N_NAME, ReferencePluginConstants.REFERENCE_INTERNAL_MODULE_WITHOUT_I18N_DESC);
    private static final ModuleOutputVerifier EXTERNAL_WITH_I18N = new ModuleOutputVerifier(ReferencePluginConstants.REFERENCE_EXTERNAL_MODULE_WITH_I18N_KEY, ReferencePluginConstants.REFERENCE_EXTERNAL_MODULE_WITH_I18N_NAME, ReferencePluginConstants.REFERENCE_EXTERNAL_MODULE_WITH_I18N_DESC);
    private static final ModuleOutputVerifier EXTERNAL_WITHOUT_I18N = new ModuleOutputVerifier(ReferencePluginConstants.REFERENCE_EXTERNAL_MODULE_WITHOUT_I18N_KEY, ReferencePluginConstants.REFERENCE_EXTERNAL_MODULE_WITHOUT_I18N_NAME, ReferencePluginConstants.REFERENCE_EXTERNAL_MODULE_WITHOUT_I18N_DESC);

    public void testShouldNotDisplayModuleTypeActionContentsGivenReferencePluginDisabled() {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.tester.gotoPage(MODULE_TYPE_ACTION_URL);
        TestModuleTypeModuleEnabling.assertEquals((int)this.tester.getDialog().getResponse().getResponseCode(), (int)404);
    }

    public void testShouldDisplayInternalImplementationGivenReferencePluginOnlyEnabled() {
        this.enableReferencePlugin();
        this.tester.gotoPage(MODULE_TYPE_ACTION_URL);
        this.text.assertTextSequence(this.locator.id(MODULE_LIST_CONTAINER_ID), INTERNAL_WITH_I18N.assertionText(), INTERNAL_WITHOUT_I18N.assertionText());
    }

    public void testShouldDisplayInternalAndExternalImplementationGivenReferencePluginAndReferenceDependentPluginEnabled() {
        this.enableReferencePlugin();
        this.enableReferenceDependentPlugin();
        this.tester.gotoPage(MODULE_TYPE_ACTION_URL);
        this.text.assertTextSequence(this.locator.id(MODULE_LIST_CONTAINER_ID), EXTERNAL_WITH_I18N.assertionText(), EXTERNAL_WITHOUT_I18N.assertionText(), INTERNAL_WITH_I18N.assertionText(), INTERNAL_WITHOUT_I18N.assertionText());
    }

    private static class ModuleOutputVerifier {
        private final String moduleKey;
        private final String moduleName;
        private final String moduleDesc;

        public ModuleOutputVerifier(String moduleKey, String moduleName, String moduleDesc) {
            this.moduleKey = moduleKey;
            this.moduleName = moduleName;
            this.moduleDesc = moduleDesc;
        }

        String assertionText() {
            return this.moduleKey + ": " + this.moduleName + ": " + this.moduleDesc;
        }
    }
}

