/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.Locator;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.AbstractCustomFieldPluginTest;
import com.atlassian.jira.webtests.ztests.plugin.reloadable.ReferencePluginConstants;
import java.util.Map;
import org.junit.Ignore;

@Ignore(value="Disabling till we resolve memory leak")
public class TestCustomFieldTypeSearcherEnabling
extends AbstractCustomFieldPluginTest {
    private static final String TEST_XML = "ReloadablePluginsWithCustomTypesAndSearchersDisabled.xml";
    private static final String TEST_FIELD_INSTANCE_NAME = "Test reference labels field";
    private static final String CFTYPE_SELECT_MODULE_KEY = "reference-select";
    private static final String CFTYPE_LABELS_MODULE_KEY = "reference-labels";
    private static final String CFTYPE_USERPICKER_MODULE_KEY = "reference-userpicker";
    private static final String CFTYPE_DATETIME_MODULE_KEY = "reference-datetime";
    private static final String CFTYPE_TEXTAREA_MODULE_KEY = "reference-textarea";
    private static final String CFTYPE_MULTIGROUPPICKER_KEY = "reference-multigrouppicker";
    private static final String CFTYPE_CASCADINGSELECT_MODULE_KEY = "reference-cascadingselect";
    private static final String CFTYPE_USERPICKERSEARCHER_MODULE_KEY = "reference-userpickersearcher";
    private static final String CFTYPE_DATEIMESEARCHER_MODULE_KEY = "reference-datetimesearcher";
    private static final String CFTYPE_TEXTAREASEARCHER_MODULE_KEY = "reference-textsearcher";
    private static final String CFTYPE_LABELSSEARCHER_MODULE_KEY = "reference-labelsearcher";
    private static final String CUSTOMFIELD_SEARCH_SECTION_ID = "navigator-filter-subheading-customfields";
    private static final String QUERY_STRING = "\"Test reference labels field\" = Fred";
    private static final String JQL_ERROR = "Field 'Test reference labels field' is not searchable, it is only sortable.";
    private final Map<String, String> searchersForCFTypes = MapBuilder.newBuilder().add("reference-labels", "reference-labelsearcher").add("reference-userpicker", "reference-userpickersearcher").add("reference-datetime", "reference-datetimesearcher").add("reference-textarea", "reference-textsearcher").add("reference-cascadingselect", "reference-labelsearcher").add("reference-select", "reference-labelsearcher").add("reference-multigrouppicker", "reference-labelsearcher").toMap();
    private final String[] LABELS_VALUES = new String[]{"Fred", "Barney", "Wilma"};

    @Override
    protected void setUpTest() {
        this.administration.restoreDataSlowOldWay(TEST_XML);
        this.navigation.login("admin", "admin");
        this.doRunTest = true;
    }

    public void testEnableAllCustomFieldTypemodules() throws Exception {
        for (String moduleKey : this.searchersForCFTypes.keySet()) {
            TestCustomFieldTypeSearcherEnabling.assertFalse((String)String.format("Plugin: %s should be disabled", moduleKey), (boolean)this.administration.plugins().isPluginModuleEnabled(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey(moduleKey)));
            this.administration.plugins().enablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey(moduleKey));
            TestCustomFieldTypeSearcherEnabling.assertTrue((String)String.format("Plugin: %s should be enabled", moduleKey), (boolean)this.administration.plugins().isPluginModuleEnabled(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey(moduleKey)));
        }
    }

    public void testEnabledCustomFieldTypeWithNoSearcher() {
        this.enableLabelCustomType();
        this.setUpCustomFieldInstance(this.completeKey(CFTYPE_LABELS_MODULE_KEY), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this.navigation.issueNavigator().displayAllIssues();
        this._assertCustomFieldSearcherNotVisibleInIssueNav();
    }

    public void testEnabledCustomFieldTypeWithSearcher() {
        this.enableLabelCustomType();
        this.enableCustomLabelTypeSearcher();
        this.setUpCustomFieldInstance(this.completeKey(CFTYPE_LABELS_MODULE_KEY), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this.navigation.issueNavigator().displayAllIssues();
        this._assertCustomFieldSearcherVisibleInIssueNav();
    }

    private void enableCustomLabelTypeSearcher() {
        this.administration.plugins().enablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey(CFTYPE_LABELSSEARCHER_MODULE_KEY));
    }

    public void testJqlSearchWithNoSearcher() {
        this.enableLabelCustomType();
        this.setUpCustomFieldInstance(this.completeKey(CFTYPE_LABELS_MODULE_KEY), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this.navigation.issue().createIssue("homosapien", "Bug", "Can't search labels field", MapBuilder.newBuilder().add(this.customFieldId, this.LABELS_VALUES).toMap());
        this.navigation.issueNavigator().createSearch(QUERY_STRING);
        this.text.assertTextPresent(new IdLocator(this.tester, "jqlerror"), JQL_ERROR);
    }

    public void testJqlSearchWithSearcher() {
        this.enableLabelCustomType();
        this.enableCustomLabelTypeSearcher();
        this.setUpCustomFieldInstance(this.completeKey(CFTYPE_LABELS_MODULE_KEY), TEST_FIELD_INSTANCE_NAME, null, new String[0]);
        this.navigation.issue().createIssue("homosapien", "Bug", "Can't search labels field", MapBuilder.newBuilder().add(this.customFieldId, this.LABELS_VALUES).toMap());
        this.navigation.issueNavigator().createSearch(QUERY_STRING);
        this._assertSearchWithResults(QUERY_STRING, "HSP-1");
    }

    private void _assertCustomFieldSearcherNotVisibleInIssueNav() {
        TestCustomFieldTypeSearcherEnabling.assertFalse((String)"There should be no custom fields searcher", (boolean)this.issueNavigatorCustomFieldSearchLocator().exists());
    }

    private void _assertCustomFieldSearcherVisibleInIssueNav() {
        TestCustomFieldTypeSearcherEnabling.assertTrue((String)"There should be a custom fields searcher", (boolean)this.issueNavigatorCustomFieldSearchLocator().exists());
    }

    void _assertSearchWithResults(String jqlString, String ... issueKeys) {
        this.navigation.issueNavigator().createSearch(jqlString);
        this.assertions.getIssueNavigatorAssertions().assertExactIssuesInResults(issueKeys);
    }

    private void enableLabelCustomType() {
        this.administration.plugins().enablePluginModule(ReferencePluginConstants.REFERENCE_PLUGIN_KEY, this.completeKey(CFTYPE_LABELS_MODULE_KEY));
    }

    private String completeKey(String moduleKey) {
        return ReferencePluginConstants.REFERENCE_PLUGIN_KEY + ":" + moduleKey;
    }

    private Locator issueNavigatorCustomFieldSearchLocator() {
        return this.locator.id(CUSTOMFIELD_SEARCH_SECTION_ID);
    }
}

