/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.plugin.reloadable;

import com.atlassian.jira.util.lang.JiraStringUtils;

public final class ReferencePluginConstants {
    public static final String REFERENCE_PLUGIN_KEY = JiraStringUtils.asString(new Object[]{"com.atlassian.jira.dev.reference-plugin"});
    public static final String REFERENCE_DEPENDENT_PLUGIN_KEY = JiraStringUtils.asString(new Object[]{"com.atlassian.jira.dev.reference-dependent-plugin"});
    public static final String REFERENCE_LANGUAGE_PACK_KEY = JiraStringUtils.asString(new Object[]{"com.atlassian.jira.jira-reference-language-pack"});
    public static final String SELECT_CUSTOM_FIELD_TYPE_KEY = ReferencePluginConstants.completeKey("reference-select");
    public static final String SELECT_CUSTOM_FIELD_TYPE_NAME = JiraStringUtils.asString(new Object[]{"Reference Custom Field Type"});
    public static final String WORKFLOW_FUNCTION_KEY = ReferencePluginConstants.completeKey("reference-workflow-function");
    public static final String WORKFLOW_FUNCTION_NAME = JiraStringUtils.asString(new Object[]{"Reference Workflow Function"});
    public static final String WORKFLOW_CONDITION_KEY = ReferencePluginConstants.completeKey("reference-workflow-condition");
    public static final String WORKFLOW_CONDITION_NAME = JiraStringUtils.asString(new Object[]{"Reference Workflow Condition"});
    public static final String WORKFLOW_VALIDATOR_KEY = ReferencePluginConstants.completeKey("reference-workflow-validator");
    public static final String WORKFLOW_VALIDATOR_NAME = JiraStringUtils.asString(new Object[]{"Reference Workflow Validator"});
    public static final String WORKFLOW_VALIDATOR_ERROR_MESSAGE = JiraStringUtils.asString(new Object[]{"Somebody configured me to fail:)"});
    public static final String REFERENCE_INTERNAL_MODULE_WITH_I18N_KEY = ReferencePluginConstants.completeKey("internal-reference-module-with-i18n");
    public static final String REFERENCE_INTERNAL_MODULE_WITH_I18N_NAME = JiraStringUtils.asString(new Object[]{"Internal Reference Module (with i18n)"});
    public static final String REFERENCE_INTERNAL_MODULE_WITH_I18N_DESC = JiraStringUtils.asString(new Object[]{"A reference internal 'implementation' of reference module type (with i18n)."});
    public static final String REFERENCE_INTERNAL_MODULE_WITHOUT_I18N_KEY = ReferencePluginConstants.completeKey("internal-reference-module-without-i18n");
    public static final String REFERENCE_INTERNAL_MODULE_WITHOUT_I18N_NAME = JiraStringUtils.asString(new Object[]{"Internal Reference Module (without i18n)"});
    public static final String REFERENCE_INTERNAL_MODULE_WITHOUT_I18N_DESC = JiraStringUtils.asString(new Object[]{"A reference internal 'implementation' of reference module type (without i18n)."});
    public static final String REFERENCE_EXTERNAL_MODULE_WITH_I18N_KEY = ReferencePluginConstants.completeDependentKey("external-reference-module-with-i18n");
    public static final String REFERENCE_EXTERNAL_MODULE_WITH_I18N_NAME = JiraStringUtils.asString(new Object[]{"External Reference Module (with i18n)"});
    public static final String REFERENCE_EXTERNAL_MODULE_WITH_I18N_DESC = JiraStringUtils.asString(new Object[]{"A reference external 'implementation' of reference module type (with i18n)."});
    public static final String REFERENCE_EXTERNAL_MODULE_WITHOUT_I18N_KEY = ReferencePluginConstants.completeDependentKey("external-reference-module-without-i18n");
    public static final String REFERENCE_EXTERNAL_MODULE_WITHOUT_I18N_NAME = JiraStringUtils.asString(new Object[]{"External Reference Module (without i18n)"});
    public static final String REFERENCE_EXTERNAL_MODULE_WITHOUT_I18N_DESC = JiraStringUtils.asString(new Object[]{"A reference external 'implementation' of reference module type (without i18n)."});
    public static final String REFERENCE_PORTLET_KEY = ReferencePluginConstants.completeKey("reference-portlet");
    public static final String REFERENCE_PORTLET_NAME = JiraStringUtils.asString(new Object[]{"Reference Portlet"});
    public static final String REFERENCE_RESOURCE_KEY = JiraStringUtils.asString(new Object[]{"reference.resource"});
    public static final String REFERENCE_DEPENDENT_RESOURCE_KEY = JiraStringUtils.asString(new Object[]{"reference.dependent.resource"});

    private ReferencePluginConstants() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    private static String completeKey(String moduleKey) {
        return REFERENCE_PLUGIN_KEY + ":" + moduleKey;
    }

    private static String completeDependentKey(String moduleKey) {
        return REFERENCE_DEPENDENT_PLUGIN_KEY + ":" + moduleKey;
    }
}

