/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.AssigneeCondition;
import com.atlassian.jira.functest.framework.navigator.ComponentCondition;
import com.atlassian.jira.functest.framework.navigator.GenericQueryCondition;
import com.atlassian.jira.functest.framework.navigator.IssueTypeCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearchBuilder;
import com.atlassian.jira.functest.framework.navigator.PriorityCondition;
import com.atlassian.jira.functest.framework.navigator.ProjectCondition;
import com.atlassian.jira.functest.framework.navigator.QuerySearchCondition;
import com.atlassian.jira.functest.framework.navigator.ReporterCondition;
import com.atlassian.jira.functest.framework.navigator.ResolutionCondition;
import com.atlassian.jira.functest.framework.navigator.StatusCondition;
import com.atlassian.jira.functest.framework.navigator.VersionCondition;
import com.atlassian.jira.functest.framework.util.url.URLUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

@Splitable
public class TestSimpleAdvancedView
extends FuncTestCase {
    public void testSystemFieldErrors() throws Exception {
        this.administration.restoreBlankInstance();
        this.assertJql(new NavigatorSearchBuilder().addQueryString("*start").addQueryField(QuerySearchCondition.QueryField.SUMMARY).createSearch(), "summary ~ \"*start\"", "The text query '*start' for field 'summary' is not allowed to start with '*'.");
        this.assertJql(new NavigatorSearchBuilder().addQueryString("*start").addQueryField(QuerySearchCondition.QueryField.DESCRIPTION).createSearch(), "description ~ \"*start\"", "The text query '*start' for field 'description' is not allowed to start with '*'.");
        this.assertJql(new NavigatorSearchBuilder().addQueryString("*start").addQueryField(QuerySearchCondition.QueryField.COMMENTS).createSearch(), "comment ~ \"*start\"", "The text query '*start' for field 'comment' is not allowed to start with '*'.");
        this.assertJql(new NavigatorSearchBuilder().addQueryString("*start").addQueryField(QuerySearchCondition.QueryField.ENVIRONMENT).createSearch(), "environment ~ \"*start\"", "The text query '*start' for field 'environment' is not allowed to start with '*'.");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new ReporterCondition().setUser("INVALID")), "reporter = INVALID", "The value 'INVALID' does not exist for the field 'reporter'.");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new AssigneeCondition().setUser("INVALID")), "assignee = INVALID", "The value 'INVALID' does not exist for the field 'assignee'.");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("created:before").setQuery("17/FAKE/09")), "created <= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'created' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("created:after").setQuery("17/FAKE/09")), "created >= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'created' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("created:previous").setQuery("17/FAKE/09")), "created >= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'created' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("created:next").setQuery("17/FAKE/09")), "created <= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'created' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("updated:before").setQuery("17/FAKE/09")), "updated <= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'updated' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("updated:after").setQuery("17/FAKE/09")), "updated >= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'updated' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("updated:previous").setQuery("17/FAKE/09")), "updated >= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'updated' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("updated:next").setQuery("17/FAKE/09")), "updated <= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'updated' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("duedate:before").setQuery("17/FAKE/09")), "due <= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'due' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("duedate:after").setQuery("17/FAKE/09")), "due >= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'due' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("duedate:previous").setQuery("17/FAKE/09")), "due >= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'due' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("duedate:next").setQuery("17/FAKE/09")), "due <= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'due' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("resolutiondate:before").setQuery("17/FAKE/09")), "resolved <= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'resolved' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("resolutiondate:after").setQuery("17/FAKE/09")), "resolved >= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'resolved' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("resolutiondate:previous").setQuery("17/FAKE/09")), "resolved >= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'resolved' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("resolutiondate:next").setQuery("17/FAKE/09")), "resolved <= \"17/FAKE/09\"", "Date value '17/FAKE/09' for field 'resolved' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'");
        this.assertJql(new NavigatorSearch(new ReporterCondition().setUser("INVALID"), new AssigneeCondition().setUser("INVALID"), new GenericQueryCondition("created:before").setQuery("17/FAKE/09"), new GenericQueryCondition("updated:after").setQuery("17/FAKE/09"), new GenericQueryCondition("duedate:previous").setQuery("17/FAKE/09"), new GenericQueryCondition("resolutiondate:next").setQuery("17/FAKE/09")), "assignee = INVALID AND reporter = INVALID AND due >= \"17/FAKE/09\" AND created <= \"17/FAKE/09\" AND updated >= \"17/FAKE/09\" AND resolved <= \"17/FAKE/09\"", "The value 'INVALID' does not exist for the field 'assignee'.", "The value 'INVALID' does not exist for the field 'reporter'.", "Date value '17/FAKE/09' for field 'due' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'.", "Date value '17/FAKE/09' for field 'created' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'.", "Date value '17/FAKE/09' for field 'updated' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'.", "Date value '17/FAKE/09' for field 'resolved' is invalid. Valid formats include: 'yyyy/MM/dd HH:mm', 'yyyy-MM-dd HH:mm', 'yyyy/MM/dd', 'yyyy-MM-dd', or a period format e.g. '-5d', '4w 2d'.");
    }

    public void testSystemFieldsCombo() throws Exception {
        String[] parameterNames;
        this.administration.restoreBlankInstance();
        QuerySearchCondition searchCondition = new QuerySearchCondition("query");
        searchCondition.addField(QuerySearchCondition.QueryField.SUMMARY);
        searchCondition.addField(QuerySearchCondition.QueryField.ENVIRONMENT);
        searchCondition.addField(QuerySearchCondition.QueryField.COMMENTS);
        searchCondition.addField(QuerySearchCondition.QueryField.DESCRIPTION);
        NavigatorCondition[] conditions = new NavigatorCondition[]{new ProjectCondition().addProject("homosapien").addProject("monkey"), new IssueTypeCondition().addIssueType(IssueTypeCondition.IssueType.BUG), new ReporterCondition().setUser("admin"), new AssigneeCondition().setCurrentUser(), new StatusCondition().addStatus(StatusCondition.Type.OPEN).addStatus(StatusCondition.Type.REOPENED), new ResolutionCondition().addResolution(ResolutionCondition.Type.CANNOT_REPRODUCE).addResolution(ResolutionCondition.Type.DUPLICATE), new GenericQueryCondition("created:before").setQuery("17/Jul/09"), new GenericQueryCondition("updated:next").setQuery("-1h"), new GenericQueryCondition("duedate:previous").setQuery("-1h"), new GenericQueryCondition("resolutiondate:after").setQuery("17/Jul/09"), searchCondition};
        this.executeBasicAssertJql("project in (HSP, MKY) AND (summary ~ query OR description ~ query OR comment ~ query OR environment ~ query) AND issuetype = Bug AND resolution in (Duplicate, \"Cannot Reproduce\") AND assignee = currentUser() AND reporter = admin AND due >= -1h AND status in (Open, Reopened) AND created <= 2009-07-17 AND updated <= -1h AND resolved >= 2009-07-17", new String[]{"Query", "\"query\"", "in", "Description", "Environment", "Summary", "Comments", "Project", "homosapien", "monkey", "Issue Type", "Bug", "Reporter", "admin", "Assignee", "Current User", "Status", "Open", "Reopened", "Resolutions", "Duplicate", "Cannot Reproduce", "Created", "Before", "17/Jul/09", "Due", "Date", "From", "1 hour ago", "to", "anytime", "Resolved", "After", "17/Jul/09"}, new NavigatorSearch(conditions));
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        HashMap<String, String[]> expectedForm = new HashMap<String, String[]>();
        expectedForm.put("summary", new String[]{"true"});
        expectedForm.put("body", new String[]{"true"});
        expectedForm.put("query", new String[]{"query"});
        expectedForm.put("duedate:next", new String[]{""});
        expectedForm.put("updated:after", new String[]{""});
        expectedForm.put("show", new String[0]);
        expectedForm.put("resolution", new String[]{"3", "5"});
        expectedForm.put("type", new String[]{"1"});
        expectedForm.put("created:previous", new String[]{""});
        expectedForm.put("updated:before", new String[]{""});
        expectedForm.put("reporter", new String[]{"admin"});
        expectedForm.put("reporterSelect", new String[]{"specificuser"});
        expectedForm.put("updated:previous", new String[]{""});
        expectedForm.put("hide", new String[0]);
        expectedForm.put("description", new String[]{"true"});
        expectedForm.put("priority", new String[0]);
        expectedForm.put("reset", new String[]{"update"});
        expectedForm.put("updated:next", new String[]{"-1h"});
        expectedForm.put("resolutiondate:previous", new String[]{""});
        expectedForm.put("refreshFilter", new String[]{"false"});
        expectedForm.put("resolutiondate:before", new String[]{""});
        expectedForm.put("created:before", new String[]{"17/Jul/09"});
        expectedForm.put("duedate:after", new String[]{""});
        expectedForm.put("status", new String[]{"1", "4"});
        expectedForm.put("resolutiondate:next", new String[]{""});
        expectedForm.put("assignee", new String[]{""});
        expectedForm.put("pid", new String[]{"10000", "10001"});
        expectedForm.put("created:next", new String[]{""});
        expectedForm.put("resolutiondate:after", new String[]{"17/Jul/09"});
        expectedForm.put("duedate:previous", new String[]{"-1h"});
        expectedForm.put("assigneeSelect", new String[]{"issue_current_user"});
        expectedForm.put("workratio:min", new String[]{""});
        expectedForm.put("environment", new String[]{"true"});
        expectedForm.put("created:after", new String[]{""});
        expectedForm.put("duedate:before", new String[]{""});
        expectedForm.put("workratio:max", new String[]{""});
        expectedForm.put("usercreated", new String[]{"true"});
        expectedForm.put("labels", new String[]{""});
        expectedForm.put("atl_token", new String[]{URLUtil.decode(this.page.getXsrfToken())});
        for (String name : parameterNames = this.tester.getDialog().getForm().getParameterNames()) {
            Object[] actual;
            Object[] expected = (String[])expectedForm.get(name);
            if (Arrays.equals(expected, actual = this.tester.getDialog().getForm().getParameterValues(name))) continue;
            TestSimpleAdvancedView.fail((String)String.format("%s: form parameter values %s did not match expected values %s", name, Arrays.toString(actual), Arrays.toString(expected)));
        }
    }

    public void testFieldsWithIdValues() throws Exception {
        this.administration.restoreBlankInstance();
        String singleVersionCFId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:version", "Single Version Picker");
        String multiVersionCFId = this.administration.customFields().addCustomField("com.atlassian.jira.plugin.system.customfieldtypes:multiversion", "Multi Version Picker");
        ComponentCondition componentCondition = new ComponentCondition();
        componentCondition.addOption("New Component 1");
        VersionCondition fixForVersionCondition = new VersionCondition("fixfor");
        fixForVersionCondition.addOption("New Version 1");
        VersionCondition singleVersionCondition = new VersionCondition(singleVersionCFId);
        singleVersionCondition.addOption("New Version 1");
        VersionCondition multiVersionCondition = new VersionCondition(multiVersionCFId);
        multiVersionCondition.addOption("New Version 1");
        VersionCondition affectedVersionCondition = new VersionCondition("version");
        affectedVersionCondition.addOption("New Version 1");
        NavigatorCondition[] conditions = new NavigatorCondition[]{new ProjectCondition().addProject("homosapien"), new IssueTypeCondition().addIssueType("Bug"), new PriorityCondition().addPriority(PriorityCondition.Type.CRITICAL), new StatusCondition().addStatus(StatusCondition.Type.OPEN), new ResolutionCondition().addResolution(ResolutionCondition.Type.DUPLICATE), fixForVersionCondition, affectedVersionCondition, componentCondition, singleVersionCondition, multiVersionCondition};
        String expectedJql = "project = HSP AND issuetype = Bug AND priority = Critical AND resolution = Duplicate AND affectedVersion = 10000 AND fixVersion = 10000 AND component = \"New Component 1\" AND status = Open AND \"Multi Version Picker\" = \"New Version 1\" AND \"Single Version Picker\" = \"New Version 1\"";
        String[] expectedSummary = new String[]{"Project", "homosapien", "Issue Type", "Bug", "Fix For:", "New Version 1", "Components", "New Component 1", "Affects Versions:", "New Version 1", "Status", "Open", "Resolutions", "Duplicate", "Priorities:", "Critical", "Multi Version Picker:", "New Version 1", "Single Version Picker:", "New Version 1"};
        this.executeBasicAssertJql("project = HSP AND issuetype = Bug AND priority = Critical AND resolution = Duplicate AND affectedVersion = 10000 AND fixVersion = 10000 AND component = \"New Component 1\" AND status = Open AND \"Multi Version Picker\" = \"New Version 1\" AND \"Single Version Picker\" = \"New Version 1\"", expectedSummary, new NavigatorSearch(conditions));
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        LinkedHashMap<String, String[]> expectedForm = new LinkedHashMap<String, String[]>();
        expectedForm.put("component", new String[]{"10000"});
        expectedForm.put("resolution", new String[]{"3"});
        expectedForm.put("type", new String[]{"1"});
        expectedForm.put("priority", new String[]{"2"});
        expectedForm.put("status", new String[]{"1"});
        expectedForm.put("pid", new String[]{"10000"});
        expectedForm.put("fixfor", new String[]{"10000"});
        expectedForm.put("version", new String[]{"10000"});
        expectedForm.put(multiVersionCFId, new String[]{"10000"});
        expectedForm.put(singleVersionCFId, new String[]{"10000"});
        Set parameterNames = expectedForm.keySet();
        for (String name : parameterNames) {
            Object[] actual;
            Object[] expected = (String[])expectedForm.get(name);
            if (Arrays.equals(expected, actual = this.tester.getDialog().getForm().getParameterValues(name))) continue;
            TestSimpleAdvancedView.fail((String)String.format("%s: form parameter values %s did not match expected values %s", name, Arrays.toString(actual), Arrays.toString(expected)));
        }
    }

    public void testCustomFieldsSimple() throws Exception {
        this.administration.restoreData("TestCustomFieldDefaultSortOrderings.xml");
        this.executeBasicAssertJql("CSF in cascadeOption(10000, 10001)", new String[]{"CSF (parent)", "parent", "CSF (child)", "child"}, new NavigatorSearch(new GenericQueryCondition("customfield_10000").setQuery("10000"), new GenericQueryCondition("customfield_10000:1").setQuery("10001")));
        this.executeBasicAssertJql("DP <= 2009-07-17", new String[]{"DP (before)", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10001:before").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("DP >= 2009-07-17", new String[]{"DP (after)", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10001:after").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("DP >= -1h", new String[]{"DP", "From 1 hour ago", "to", "anytime"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10001:previous").setQuery("-1h")));
        this.executeBasicAssertJql("DP <= 1h", new String[]{"DP", "From anytime to 1 hour from now"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10001:next").setQuery("1h")));
        this.executeBasicAssertJql("DT <= \"2009-07-21 11:07\"", new String[]{"DT (before)", "21/Jul/09 11:07 AM"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10002:before").setQuery("21/Jul/09 11:07 AM")));
        this.executeBasicAssertJql("DT >= \"2009-07-21 11:07\"", new String[]{"DT (after)", "21/Jul/09 11:07 AM"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10002:after").setQuery("21/Jul/09 11:07 AM")));
        this.executeBasicAssertJql("DT >= \"-2d 30m\"", new String[]{"DT", "From 2 days, 30 minutes ago", "to", "anytime"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10002:previous").setQuery("-2d 30m")));
        this.executeBasicAssertJql("DT <= \"2d 30m\"", new String[]{"DT", "From anytime to 2 days, 30 minutes from now"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10002:next").setQuery("2d 30m")));
        this.executeBasicAssertJql("FTF ~ query", new String[]{"FTF", "query"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10003").setQuery("query")));
        this.executeBasicAssertJql("GP = jira-administrators", new String[]{"GP", "jira-administrators"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10004").setQuery("jira-administrators")));
        this.executeBasicAssertJql("II = \"10\"", new String[]{"II", "10"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10005").setQuery("10")));
        this.executeBasicAssertJql("MC = opt1", new String[]{"MC", "opt1"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10006").setQuery("opt1")));
        this.executeBasicAssertJql("MGP = jira-users", new String[]{"MGP", "jira-users"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10007").setQuery("jira-users")));
        this.executeBasicAssertJql("MS = select1", new String[]{"MS", "select1"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10008").setQuery("select1")));
        this.executeBasicAssertJql("MUP = admin", new String[]{"MUP", "admin"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10009").setQuery("admin")));
        this.executeBasicAssertJql("NF = \"10\"", new String[]{"NF", "10"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10010").setQuery("10")));
        this.executeBasicAssertJql("PP = EIGHT", new String[]{"PP", "eight"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10011").setQuery("10017")));
        this.executeBasicAssertJql("RB = rad1", new String[]{"RB", "rad1"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10012").setQuery("rad1")));
        this.executeBasicAssertJql("ROTF ~ query", new String[]{"ROTF", "query"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10013").setQuery("query")));
        this.executeBasicAssertJql("SL = select1", new String[]{"SL", "select1"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10014").setQuery("select1")));
        this.executeBasicAssertJql("TF ~ query", new String[]{"TF", "query"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10016").setQuery("query")));
        this.executeBasicAssertJql("URL = \"http://query\"", new String[]{"URL", "http://query"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10017").setQuery("http://query")));
        this.executeBasicAssertJql("UP = admin", new String[]{"UP", "admin"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10018").setQuery("admin")));
    }

    public void testCustomFieldsWithNonUniqueNames() throws Exception {
        this.administration.restoreData("TestCustomFieldsWithNonUniqueNames.xml");
        this._testCustomFieldWithNonUniqueNames("10000", new NavigatorSearch(new GenericQueryCondition("customfield_10000").setQuery("10000"), new GenericQueryCondition("customfield_10000:1").setQuery("10001")), "%s in cascadeOption(10000, 10001)", new String[]{"%s (parent)", "parent", "%s (child)", "child"});
        this._testCustomFieldWithNonUniqueNames("10001", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10001:before").setQuery("17/Jul/09")), "%s <= 2009-07-17", new String[]{"%s (before)", "17/Jul/09"});
        this._testCustomFieldWithNonUniqueNames("10002", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10002:before").setQuery("21/Jul/09 11:07 AM")), "%s <= \"2009-07-21 11:07\"", new String[]{"%s (before)", "21/Jul/09 11:07 AM"});
        this._testCustomFieldWithNonUniqueNames("10003", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10003").setQuery("query")), "%s ~ query", new String[]{"%s", "query"});
        this._testCustomFieldWithNonUniqueNames("10004", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10004").setQuery("jira-administrators")), "%s = jira-administrators", new String[]{"%s", "jira-administrators"});
        this._testCustomFieldWithNonUniqueNames("10005", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10005").setQuery("10")), "%s = \"10\"", new String[]{"%s", "10"});
        this._testCustomFieldWithNonUniqueNames("10006", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10006").setQuery("opt1")), "%s = opt1", new String[]{"%s", "opt1"});
        this._testCustomFieldWithNonUniqueNames("10007", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10007").setQuery("jira-users")), "%s = jira-users", new String[]{"%s", "jira-users"});
        this._testCustomFieldWithNonUniqueNames("10008", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10008").setQuery("select1")), "%s = select1", new String[]{"%s", "select1"});
        this._testCustomFieldWithNonUniqueNames("10009", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10009").setQuery("admin")), "%s = admin", new String[]{"%s", "admin"});
        this._testCustomFieldWithNonUniqueNames("10010", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10010").setQuery("10")), "%s = \"10\"", new String[]{"%s", "10"});
        this._testCustomFieldWithNonUniqueNames("10011", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10011").setQuery("10017")), "%s = EIGHT", new String[]{"%s", "eight"});
        this._testCustomFieldWithNonUniqueNames("10012", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10012").setQuery("rad1")), "%s = rad1", new String[]{"%s", "rad1"});
        this._testCustomFieldWithNonUniqueNames("10013", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10013").setQuery("query")), "%s ~ query", new String[]{"%s", "query"});
        this._testCustomFieldWithNonUniqueNames("10014", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10014").setQuery("select1")), "%s = select1", new String[]{"%s", "select1"});
        VersionCondition versionCondition = new VersionCondition("customfield_10015");
        versionCondition.addOption("v1");
        this._testCustomFieldWithNonUniqueNames("10015", new NavigatorSearch(new ProjectCondition().addProject("sixteen"), versionCondition), "project = SIXTEEN AND %s = v1", new String[]{"Project", "sixteen", "%s", "v1"});
        this._testCustomFieldWithNonUniqueNames("10016", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10016").setQuery("query")), "%s ~ query", new String[]{"%s", "query"});
        this._testCustomFieldWithNonUniqueNames("10017", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10017").setQuery("http://query")), "%s = \"http://query\"", new String[]{"%s", "http://query"});
        this._testCustomFieldWithNonUniqueNames("10018", new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("customfield_10018").setQuery("admin")), "%s = admin", new String[]{"%s", "admin"});
        versionCondition = new VersionCondition("customfield_10019");
        versionCondition.addOption("v1");
        this._testCustomFieldWithNonUniqueNames("10019", new NavigatorSearch(new ProjectCondition().addProject("twenty"), versionCondition), "project = TWENTY AND %s = v1", new String[]{"Project", "twenty", "%s", "v1"});
    }

    private void _testCustomFieldWithNonUniqueNames(String numericCustomFieldId, NavigatorSearch search, String jqlFormat, String[] expectedSummary) {
        this.navigation.login("admin");
        ArrayList<String> expectedEnvironmentSummary = new ArrayList<String>();
        ArrayList<String> expectedOtherSummary = new ArrayList<String>();
        for (String s : expectedSummary) {
            if (s.contains("%s")) {
                expectedEnvironmentSummary.add(String.format(s, "environment"));
                expectedOtherSummary.add(String.format(s, "OTHER"));
                continue;
            }
            expectedEnvironmentSummary.add(s);
            expectedOtherSummary.add(s);
        }
        String oldName = this.administration.customFields().renameCustomField(numericCustomFieldId, "environment");
        String clauseNameCFNotation = "cf[" + numericCustomFieldId + "]";
        this.executeBasicAssertJql(String.format(jqlFormat, clauseNameCFNotation), expectedEnvironmentSummary, search);
        this.administration.customFields().renameCustomField(numericCustomFieldId, "OTHER");
        this.executeBasicAssertJql(String.format(jqlFormat, clauseNameCFNotation), expectedOtherSummary, search);
        this.navigation.login("fred");
        this.executeBasicAssertJql(String.format(jqlFormat, "OTHER"), expectedOtherSummary, search);
        this.navigation.login("admin");
        this.administration.customFields().renameCustomField(numericCustomFieldId, oldName);
    }

    public void testSystemFieldsSimple() throws Exception {
        this.administration.restoreBlankInstance();
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        this.administration.generalConfiguration().enableVoting();
        this.administration.generalConfiguration().enableWatching();
        this.executeBasicAssertJql("project = MKY", new String[]{"Project", "monkey"}, new NavigatorSearch((NavigatorCondition)new ProjectCondition().addProject("monkey")));
        this.executeBasicAssertJql("project in (HSP, MKY)", new String[]{"Project", "homosapien", "monkey"}, new NavigatorSearch((NavigatorCondition)new ProjectCondition().addProject("homosapien").addProject("monkey")));
        this.executeBasicAssertJql("issuetype = Bug", new String[]{"Issue Type", "Bug"}, new NavigatorSearch((NavigatorCondition)new IssueTypeCondition().addIssueType("Bug")));
        this.executeBasicAssertJql("issuetype in (Bug, Task)", new String[]{"Issue Type", "Bug", "Task"}, new NavigatorSearch((NavigatorCondition)new IssueTypeCondition().addIssueType("Bug").addIssueType("Task")));
        QuerySearchCondition summarySearchCondition = new QuerySearchCondition("query");
        summarySearchCondition.addField(QuerySearchCondition.QueryField.SUMMARY);
        this.executeBasicAssertJql("summary ~ query", new String[]{"Query", "\"query\"", "Summary"}, new NavigatorSearch((NavigatorCondition)summarySearchCondition));
        QuerySearchCondition descriptionSearchCondition = new QuerySearchCondition("query");
        descriptionSearchCondition.addField(QuerySearchCondition.QueryField.DESCRIPTION);
        this.executeBasicAssertJql("description ~ query", new String[]{"Query", "\"query\"", "Description"}, new NavigatorSearch((NavigatorCondition)descriptionSearchCondition));
        QuerySearchCondition commentsSearchCondition = new QuerySearchCondition("query");
        commentsSearchCondition.addField(QuerySearchCondition.QueryField.COMMENTS);
        this.executeBasicAssertJql("comment ~ query", new String[]{"Query", "\"query\"", "Comments"}, new NavigatorSearch((NavigatorCondition)commentsSearchCondition));
        QuerySearchCondition environmentSearchCondition = new QuerySearchCondition("query");
        environmentSearchCondition.addField(QuerySearchCondition.QueryField.ENVIRONMENT);
        this.executeBasicAssertJql("environment ~ query", new String[]{"Query", "\"query\"", "Environment"}, new NavigatorSearch((NavigatorCondition)environmentSearchCondition));
        this.executeBasicAssertJql("summary ~ query OR description ~ query OR comment ~ query OR environment ~ query", new String[]{"Query", "\"query\"", "in", "Description", "Environment", "Summary", "Comments"}, new NavigatorSearchBuilder().addQueryString("query").addQueryField(QuerySearchCondition.QueryField.SUMMARY).addQueryField(QuerySearchCondition.QueryField.DESCRIPTION).addQueryField(QuerySearchCondition.QueryField.COMMENTS).addQueryField(QuerySearchCondition.QueryField.ENVIRONMENT).createSearch());
        this.executeBasicAssertJql("reporter = admin", new String[]{"Reporter", "admin"}, new NavigatorSearch((NavigatorCondition)new ReporterCondition().setUser("admin")));
        this.executeBasicAssertJql("", new String[]{""}, new NavigatorSearch((NavigatorCondition)new ReporterCondition().setAnyUser()));
        this.executeBasicAssertJql("reporter is EMPTY", new String[]{"Reporter", "No Reporter"}, new NavigatorSearch((NavigatorCondition)new ReporterCondition().setNoReporter()));
        this.executeBasicAssertJql("reporter = currentUser()", new String[]{"Reporter", "Current User"}, new NavigatorSearch((NavigatorCondition)new ReporterCondition().setCurrentUser()));
        this.executeBasicAssertJql("assignee = admin", new String[]{"Assignee", "admin"}, new NavigatorSearch((NavigatorCondition)new AssigneeCondition().setUser("admin")));
        this.executeBasicAssertJql("", new String[]{""}, new NavigatorSearch((NavigatorCondition)new AssigneeCondition().setAnyUser()));
        this.executeBasicAssertJql("assignee is EMPTY", new String[]{"Assignee", "Unassigned"}, new NavigatorSearch((NavigatorCondition)new AssigneeCondition().setNoReporter()));
        this.executeBasicAssertJql("assignee = currentUser()", new String[]{"Assignee", "Current User"}, new NavigatorSearch((NavigatorCondition)new AssigneeCondition().setCurrentUser()));
        this.executeBasicAssertJql("status = Open", new String[]{"Status", "Open"}, new NavigatorSearch((NavigatorCondition)new StatusCondition().addStatus(StatusCondition.Type.OPEN)));
        this.executeBasicAssertJql("status in (Open, Reopened)", new String[]{"Status", "Open", ",", "Reopened"}, new NavigatorSearch((NavigatorCondition)new StatusCondition().addStatus(StatusCondition.Type.OPEN).addStatus(StatusCondition.Type.REOPENED)));
        this.executeBasicAssertJql("resolution = Unresolved", new String[]{"Resolution", "Unresolved"}, new NavigatorSearch((NavigatorCondition)new ResolutionCondition().addResolution(ResolutionCondition.Type.UNRESOLVED)));
        this.executeBasicAssertJql("resolution = \"Cannot Reproduce\"", new String[]{"Resolution", "Cannot Reproduce"}, new NavigatorSearch((NavigatorCondition)new ResolutionCondition().addResolution(ResolutionCondition.Type.CANNOT_REPRODUCE)));
        this.executeBasicAssertJql("resolution in (Duplicate, \"Cannot Reproduce\")", new String[]{"Resolutions", "Duplicate", ",", "Cannot Reproduce"}, new NavigatorSearch((NavigatorCondition)new ResolutionCondition().addResolution(ResolutionCondition.Type.CANNOT_REPRODUCE).addResolution(ResolutionCondition.Type.DUPLICATE)));
        this.executeBasicAssertJql("priority = Blocker", new String[]{"Priorities", "Blocker"}, new NavigatorSearch((NavigatorCondition)new PriorityCondition().addPriority(PriorityCondition.Type.BLOCKER)));
        this.executeBasicAssertJql("priority in (Blocker, Critical)", new String[]{"Priorities", "Blocker", ",", "Critical"}, new NavigatorSearch((NavigatorCondition)new PriorityCondition().addPriority(PriorityCondition.Type.BLOCKER).addPriority(PriorityCondition.Type.CRITICAL)));
        this.executeBasicAssertJql("created <= 2009-07-17", new String[]{"Created Before", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("created:before").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("created >= 2009-07-17", new String[]{"Created After", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("created:after").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("created >= -1h", new String[]{"Created", "From 1 hour ago", "to", "anytime"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("created:previous").setQuery("-1h")));
        this.executeBasicAssertJql("created <= -1h", new String[]{"Created", "From anytime to 1 hour ago"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("created:next").setQuery("-1h")));
        this.executeBasicAssertJql("updated <= 2009-07-17", new String[]{"Updated Before", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("updated:before").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("updated >= 2009-07-17", new String[]{"Updated After", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("updated:after").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("updated >= -1h", new String[]{"Updated", "From 1 hour ago", "to", "anytime"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("updated:previous").setQuery("-1h")));
        this.executeBasicAssertJql("updated <= -1h", new String[]{"Updated", "From anytime to 1 hour ago"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("updated:next").setQuery("-1h")));
        this.executeBasicAssertJql("due <= 2009-07-17", new String[]{"Due Before", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("duedate:before").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("due >= 2009-07-17", new String[]{"Due After", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("duedate:after").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("due >= -1h", new String[]{"Due Date", "From 1 hour ago", "to", "anytime"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("duedate:previous").setQuery("-1h")));
        this.executeBasicAssertJql("due <= -1h", new String[]{"Due Date", "From anytime to 1 hour ago"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("duedate:next").setQuery("-1h")));
        this.executeBasicAssertJql("resolved <= 2009-07-17", new String[]{"Resolved Before", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("resolutiondate:before").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("resolved >= 2009-07-17", new String[]{"Resolved After", "17/Jul/09"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("resolutiondate:after").setQuery("17/Jul/09")));
        this.executeBasicAssertJql("resolved >= -1h", new String[]{"Resolved", "From 1 hour ago", "to", "anytime"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("resolutiondate:previous").setQuery("-1h")));
        this.executeBasicAssertJql("resolved <= -1h", new String[]{"Resolved", "From anytime to 1 hour ago"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("resolutiondate:next").setQuery("-1h")));
        this.executeBasicAssertJql("workratio >= \"10\"", new String[]{"Work Ratio Min", "10%"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("workratio:min").setQuery("10")));
        this.executeBasicAssertJql("workratio <= \"10\"", new String[]{"Work Ratio Max", "10%"}, new NavigatorSearch((NavigatorCondition)new GenericQueryCondition("workratio:max").setQuery("10")));
        this.executeBasicAssertJql("workratio >= \"10\" AND workratio <= \"50\"", new String[]{"Work Ratio Min", "10%", "Work Ratio Max", "50%"}, new NavigatorSearch(new GenericQueryCondition("workratio:min").setQuery("10"), new GenericQueryCondition("workratio:max").setQuery("50")));
    }

    private String extractCFId(String multiVersionCFId) {
        return multiVersionCFId.substring(multiVersionCFId.indexOf(95) + 1);
    }

    private void executeBasicAssertJql(String expectedJqlQuery, String[] expectedSummary, NavigatorSearch search) {
        this.navigation.issueNavigator().createSearch(search);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertNoJqlErrors();
        this.assertions.getIssueNavigatorAssertions().assertAdvancedSearch(this.tester, expectedJqlQuery);
        this.tester.clickLink("viewfilter");
        this.assertions.assertNodeExists("//a[@id='filtersavenew']");
        this.assertions.getTextAssertions().assertTextSequence(new XPathLocator(this.tester, "//div[@id='filter-summary']"), expectedSummary);
    }

    private void executeBasicAssertJql(String expectedJqlQuery, List<String> expectedSummary, NavigatorSearch search) {
        String[] expectedSummaryArray = new String[expectedSummary.size()];
        this.executeBasicAssertJql(expectedJqlQuery, expectedSummary.toArray(expectedSummaryArray), search);
    }

    private void assertJql(NavigatorSearch search, String expectedJql, String ... expectedJqlErrors) {
        this.navigation.issueNavigator().createSearch(search);
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.clickLink("switchnavtype");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.ADVANCED);
        this.assertions.getIssueNavigatorAssertions().assertJqlErrors(expectedJqlErrors);
        String jqlValue = this.tester.getDialog().getFormParameterValue("jqlQuery");
        TestSimpleAdvancedView.assertEquals((String)expectedJql, (String)jqlValue);
    }
}

