/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.ComponentCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.ProjectCondition;
import com.atlassian.jira.functest.framework.navigator.VersionCondition;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

public class TestIssueNavigatorContextSwitching
extends AbstractJqlFuncTest {
    public void testAffectedVersion() throws Exception {
        this.administration.restoreData("TestIssueNavigatorContextSwitching.xml");
        ProjectCondition projectCondition = new ProjectCondition().addProject("homosapien");
        VersionCondition versionCondition = new VersionCondition("version");
        versionCondition.addOption("New Version 1");
        NavigatorSearch search = new NavigatorSearch(projectCondition, versionCondition);
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("monkey").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues(new String[0]);
        this.assertJqlQueryInTextArea("project = MKY AND affectedVersion = 10000");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("All projects").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("affectedVersion = \"New Version 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("affectedVersion = \"New Version 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }

    public void testFixForVersion() throws Exception {
        this.administration.restoreData("TestIssueNavigatorContextSwitching.xml");
        ProjectCondition projectCondition = new ProjectCondition().addProject("homosapien");
        VersionCondition versionCondition = new VersionCondition("fixfor");
        versionCondition.addOption("New Version 1");
        NavigatorSearch search = new NavigatorSearch(projectCondition, versionCondition);
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("monkey").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues(new String[0]);
        this.assertJqlQueryInTextArea("project = MKY AND fixVersion = 10000");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("All projects").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("fixVersion = \"New Version 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("fixVersion = \"New Version 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }

    public void testComponents() throws Exception {
        this.administration.restoreData("TestIssueNavigatorContextSwitching.xml");
        ProjectCondition projectCondition = new ProjectCondition().addProject("homosapien");
        ComponentCondition componentCondition = new ComponentCondition();
        componentCondition.addOption("New Component 1");
        NavigatorSearch search = new NavigatorSearch(projectCondition, componentCondition);
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("monkey").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues(new String[0]);
        this.assertJqlQueryInTextArea("project = MKY AND component = 10000");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("All projects").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("component = \"New Component 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("component = \"New Component 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }

    public void testVersionCF() throws Exception {
        this.administration.restoreData("TestIssueNavigatorContextSwitching.xml");
        ProjectCondition projectCondition = new ProjectCondition().addProject("homosapien");
        VersionCondition versionCondition = new VersionCondition("customfield_10000");
        versionCondition.addOption("New Version 1");
        NavigatorSearch search = new NavigatorSearch(projectCondition, versionCondition);
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("monkey").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues(new String[0]);
        this.assertJqlQueryInTextArea("project = MKY AND \"Version CF\" = 10000");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("All projects").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("\"Version CF\" = \"New Version 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("\"Version CF\" = \"New Version 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }

    public void testMultiVersionCF() throws Exception {
        this.administration.restoreData("TestIssueNavigatorContextSwitching.xml");
        ProjectCondition projectCondition = new ProjectCondition().addProject("homosapien");
        VersionCondition versionCondition = new VersionCondition("customfield_10001");
        versionCondition.addOption("New Version 1");
        NavigatorSearch search = new NavigatorSearch(projectCondition, versionCondition);
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("monkey").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues(new String[0]);
        this.assertJqlQueryInTextArea("project = MKY AND \"Multi Version CF\" = 10000");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().addProject("All projects").setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("\"Multi Version CF\" = \"New Version 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
        this.navigation.issueNavigator().createSearch(search);
        this.assertIssues("HSP-1");
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.tester.setWorkingForm("issue-filter");
        new ProjectCondition().setForm(this.tester);
        this.tester.clickButton("issue-filter-submit");
        this.assertIssues("MKY-1", "HSP-1");
        this.assertJqlQueryInTextArea("\"Multi Version CF\" = \"New Version 1\"");
        this.assertions.getIssueNavigatorAssertions().assertJqlTooComplex();
    }
}

