/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator.jql;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Splitable;
import com.atlassian.jira.functest.framework.navigator.ColumnsCondition;
import com.atlassian.jira.functest.framework.navigator.ContainsIssueKeysCondition;
import com.atlassian.jira.functest.framework.navigator.NumberOfIssuesCondition;
import com.atlassian.jira.functest.framework.navigator.SearchResultsCondition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Splitable
public class TestContextColumns
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreDataSlowOldWay("TestJqlContextFields.xml");
    }

    public void testProjectField() throws Exception {
        this.assertJqlColumns("project = one", new Context().addProject(Project.ONE), this.getIssuesForProjects(Project.ONE));
        this.assertJqlColumns("project = two", new Context().addProject(Project.TWO), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("project = three", new Context().addProject(Project.THREE), this.getIssuesForProjects(Project.THREE));
        this.assertJqlColumns("project != two", new Context().addProjects(this.getProjectsAndRemove(Project.TWO)), this.getIssuesAndRemoveProject(Project.TWO));
        this.assertJqlColumns("project != four", new Context().addProjects(this.getProjectsAndRemove(Project.FOUR)), this.getIssuesAndRemoveProject(Project.FOUR));
        this.assertJqlColumns("project != one", new Context().addProjects(this.getProjectsAndRemove(Project.ONE)), this.getIssuesAndRemoveProject(Project.ONE));
        this.assertJqlColumns("project in (one, three)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("project = one or project = three", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("project not in (one, two)", new Context().addProjects(this.getProjectsAndRemove(Project.ONE, Project.TWO)), this.getIssuesAndRemoveProject(Project.ONE, Project.TWO));
        this.assertJqlColumns("project != one and project != two", new Context().addProjects(this.getProjectsAndRemove(Project.ONE, Project.TWO)), this.getIssuesAndRemoveProject(Project.ONE, Project.TWO));
        this.assertJqlColumns("project not in (one, two, three)", new Context().addProjects(this.getProjectsAndRemove(Project.ONE, Project.TWO, Project.THREE)), this.getIssuesAndRemoveProject(Project.ONE, Project.THREE, Project.TWO));
        this.assertJqlColumns("project != one and project != two and project != three", new Context().addProjects(this.getProjectsAndRemove(Project.ONE, Project.TWO, Project.THREE)), this.getIssuesAndRemoveProject(Project.ONE, Project.THREE, Project.TWO));
        this.assertJqlColumns("project in (empty, two)", new Context().addProject(Project.TWO), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("project = empty or project = two", new Context().addProject(Project.TWO), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("project is not empty", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("project != empty", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("project != null", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("project not in (empty)", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("project not in (empty, three)", new Context().addProjects(this.getProjectsAndRemove(Project.THREE)), this.getIssuesAndRemoveProject(Project.THREE));
        this.assertJqlColumns("project != empty and project != three", new Context().addProjects(this.getProjectsAndRemove(Project.THREE)), this.getIssuesAndRemoveProject(Project.THREE));
        this.assertJqlColumns("(project != one or project != two)", new Context().addProjects(Project.values()), Issue.ALL_ISSUES);
        this.assertJqlColumns("project != one or project = one", new Context().addProjects(Project.values()), Issue.ALL_ISSUES);
        this.assertJqlColumns("project in (one, two) and project = one", new Context().addProject(Project.ONE), this.getIssuesForProjects(Project.ONE));
        this.assertJqlColumns("project in (one, two) and project not in (three, one)", new Context().addProject(Project.TWO), this.getIssuesForProjects(Project.TWO));
        this.assertFilterColumns(10020L, new Context().addProject(Project.ONE), Issue.ONE1);
        this.navigation.login("fred");
        this.assertJqlColumns("project != two", new Context().addProjects(this.getProjectsAndRemove(Project.THREE, Project.TWO)), Issue.ONE1, Issue.FOUR3);
    }

    public void testIssueType() throws Exception {
        this.assertJqlColumns("type = bug", new Context().addType(IssueType.BUG), Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type = task", new Context().addType(IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("type = new\\ feature", new Context().addType(IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("type != bug", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.BUG)), this.getIssuesAndRemoveIssues(Issue.THREE2, Issue.ONE1, Issue.FOUR3));
        this.assertJqlColumns("type != task", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.TASK)), this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("type != new\\ feature", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.FEATURE)), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("type in (bug, task)", new Context().addTypes(new IssueType[]{IssueType.BUG, IssueType.TASK}), Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type = bug or type = task", new Context().addTypes(new IssueType[]{IssueType.BUG, IssueType.TASK}), Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type in ('new feature', task)", new Context().addTypes(new IssueType[]{IssueType.FEATURE, IssueType.TASK}), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("type = 'new feature' or type = task", new Context().addTypes(new IssueType[]{IssueType.FEATURE, IssueType.TASK}), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("type not in (bug, task)", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.BUG, IssueType.TASK)), Issue.TWO2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("not (type = bug or type = task)", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.BUG, IssueType.TASK)), Issue.TWO2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("type not in ('new feature', task)", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.FEATURE, IssueType.TASK)), Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("type != 'new feature' and not type = task", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.FEATURE, IssueType.TASK)), Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("type in (empty, bug)", new Context().addType(IssueType.BUG), Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type = empty or type = bug", new Context().addType(IssueType.BUG), Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type is not empty", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("type != empty", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("type not in (empty)", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("type not in (empty, bug)", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.BUG)), this.getIssuesAndRemoveIssues(Issue.THREE2, Issue.ONE1, Issue.FOUR3));
        this.assertJqlColumns("type is not empty and type != bug", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.BUG)), this.getIssuesAndRemoveIssues(Issue.THREE2, Issue.ONE1, Issue.FOUR3));
        this.assertFilterColumns(10030L, new Context().addTypes(new IssueType[]{IssueType.BUG, IssueType.TASK}), Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("type in (bug, task) and type = task", new Context().addTypes(new IssueType[]{IssueType.TASK}), Issue.TWO1);
        this.assertJqlColumns("type in (bug, task) and type not in (task, 'new feature')", new Context().addTypes(new IssueType[]{IssueType.BUG}), Issue.THREE2, Issue.ONE1, Issue.FOUR3);
    }

    public void testFieldsWithNoContext() throws Exception {
        List<Issue> issues = this.getIssuesAndRemoveIssues(Issue.ONE1);
        this.assertJqlColumns("assignee = admin", Context.GLOBAL, issues);
        this.assertJqlColumns("assignee != fred", Context.GLOBAL, issues);
        this.assertJqlColumns("assignee is not empty", Context.GLOBAL, issues);
        this.assertJqlColumns("assignee is empty", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("assignee in (admin, empty)", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("assignee not in (fred, empty)", Context.GLOBAL, issues);
        this.assertJqlColumns("comment ~ donkey", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("comment !~ JIRA order by key asc", Context.GLOBAL, Issue.FOUR2, Issue.THREE1);
        this.assertJqlColumns("created < 7d", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("created <= 7d", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("created > 1000", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("created >= 1000", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("created != now()", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("created is not empty", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("created != null", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("created not in (1881, 34883)", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("created not in (empty, 47458)", Context.GLOBAL, Issue.ALL_ISSUES);
        issues = Arrays.asList(Issue.TWO1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("duedate = empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(issues));
        this.assertJqlColumns("duedate is empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(issues));
        this.assertJqlColumns("duedate in (empty)", Context.GLOBAL, this.getIssuesAndRemoveIssues(issues));
        this.assertJqlColumns("duedate < 7d", Context.GLOBAL, issues);
        this.assertJqlColumns("duedate <= 7d", Context.GLOBAL, issues);
        this.assertJqlColumns("duedate > 1000", Context.GLOBAL, issues);
        this.assertJqlColumns("duedate >= 1000", Context.GLOBAL, issues);
        this.assertJqlColumns("duedate != now()", Context.GLOBAL, issues);
        this.assertJqlColumns("duedate is not empty", Context.GLOBAL, issues);
        this.assertJqlColumns("duedate != null", Context.GLOBAL, issues);
        this.assertJqlColumns("duedate not in (1881, 34883)", Context.GLOBAL, issues);
        this.assertJqlColumns("duedate not in (empty, 47458)", Context.GLOBAL, issues);
        this.assertJqlColumns("description ~ suns", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("description !~ suns", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("description is empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.THREE1, Issue.ONE1));
        this.assertJqlColumns("description is not empty", Context.GLOBAL, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("environment ~ jira", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("environment !~ jira", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("environment is empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.ONE1));
        this.assertJqlColumns("environment is not empty", Context.GLOBAL, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("originalEstimate = 5m", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("originalEstimate != 5m", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("originalEstimate in (5m, '5h 3m')", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("originalEstimate not in (5m, '5h 3m')", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("originalEstimate is empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("originalEstimate = empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("originalEstimate in (empty, 5m)", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("originalEstimate is not empty", Context.GLOBAL, Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("originalEstimate != empty", Context.GLOBAL, Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("originalEstimate not in (empty, 5m)", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("originalEstimate < 1d", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("originalEstimate <= 1d", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("originalEstimate > 5d", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("originalEstimate >= 5d", Context.GLOBAL, Issue.THREE1);
        issues = Arrays.asList(Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2);
        this.assertJqlColumns("priority = major", Context.GLOBAL, issues);
        this.assertJqlColumns("priority != major", Context.GLOBAL, this.getIssuesAndRemoveIssues(issues));
        issues = Arrays.asList(Issue.TWO2, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2);
        this.assertJqlColumns("priority in (major, critical)", Context.GLOBAL, issues);
        this.assertJqlColumns("priority not in (major, critical)", Context.GLOBAL, this.getIssuesAndRemoveIssues(issues));
        issues = Arrays.asList(Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2);
        this.assertJqlColumns("priority in (major, empty)", Context.GLOBAL, issues);
        this.assertJqlColumns("priority is not empty", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("priority != empty", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("priority not in (empty, trivial)", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("priority >= major", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.FOUR1));
        this.assertJqlColumns("priority > major", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("priority < major", Context.GLOBAL, Issue.TWO1, Issue.FOUR1);
        this.assertJqlColumns("priority <= major", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("remainingEstimate = 4m", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("remainingEstimate != 4m", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("remainingEstimate in (4m, '5h 3m')", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("remainingEstimate not in (4m, '5h 3m')", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("remainingEstimate is empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("remainingEstimate = empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("remainingEstimate in (empty, 4m)", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("remainingEstimate is not empty", Context.GLOBAL, Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("remainingEstimate != empty", Context.GLOBAL, Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("remainingEstimate not in (empty, 4m)", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("remainingEstimate < 1d", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("remainingEstimate <= 1d", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("remainingEstimate > 5d", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("remainingEstimate >= 5d", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("reporter = admin", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("reporter != admin", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("reporter in (admin, fred)", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("reporter not in (fred, dylan)", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("reporter is empty", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("reporter = empty", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("reporter in (empty, fred)", Context.GLOBAL, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("reporter is not empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1));
        this.assertJqlColumns("reporter != empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1));
        this.assertJqlColumns("reporter not in (empty, fred)", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("resolution = \"Won't Fix\"", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("resolution != \"Won't Fix\"", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("resolution in (\"Won't Fix\", fixed)", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("resolution not in (duplicate, fixed)", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("resolution is empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolution = empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolution in (empty, duplicate)", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1));
        this.assertJqlColumns("resolution is NOT empty", Context.GLOBAL, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolution != empty", Context.GLOBAL, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolution not in (empty, duplicate)", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("resolutionDate < '2009/08/02'", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("resolutionDate <= '2009/08/02'", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("resolutionDate > '2009/08/02'", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("resolutionDate >= '2009/08/02'", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("resolutionDate != now()", Context.GLOBAL, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolutionDate not in (now(), '2009/02/20')", Context.GLOBAL, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolutionDate is empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolutionDate = empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolutionDate in (empty, now())", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("resolutionDate is not empty", Context.GLOBAL, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolutionDate != null", Context.GLOBAL, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("resolutionDate not in (null, now())", Context.GLOBAL, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("summary ~ suns", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("summary !~ suns order by key desc", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("summary is not empty order by key desc", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("timeSpent = 1m", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("timeSpent != 1m", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("timeSpent in (1m, '5h 3m')", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("timeSpent not in (1m, '5h 3m')", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("timeSpent is empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("timeSpent = empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("timeSpent in (empty, 1m)", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("timeSpent is not empty", Context.GLOBAL, Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("timeSpent != empty", Context.GLOBAL, Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("timeSpent not in (empty, 1m)", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("timeSpent < 1d", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("timeSpent <= 1d", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("timeSpent > 5d", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("timeSpent >= 5d", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("updated < 7d", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("updated <= 7d", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("updated > 1000", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("updated >= 1000", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("updated != 2004-08-10", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("updated is not empty", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("updated != null", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("updated not in (1881, 34883)", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("updated not in (empty, 47458)", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("votes = 0", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("votes != 0", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("votes in (0, 2, 4)", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("votes not in (0, 2, 4)", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("votes < 1", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("votes <= 1", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("votes > 0", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("votes >= 0", Context.GLOBAL, Issue.ALL_ISSUES);
        this.assertJqlColumns("workRatio = 20", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("workRatio != 20", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("workRatio in (20, 21)", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("workRatio not in (20, 39393)", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("workRatio is empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("workRatio = empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1, Issue.THREE1));
        this.assertJqlColumns("workRatio in (empty, 20)", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("workRatio is not empty", Context.GLOBAL, Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("workRatio != empty", Context.GLOBAL, Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("workRatio not in (empty, 20)", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("workRatio < 10", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("workRatio <= 10", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("workRatio > 10", Context.GLOBAL, Issue.TWO1);
        this.assertJqlColumns("workRatio >= 10", Context.GLOBAL, Issue.TWO1);
    }

    public void testCategoryContext() throws Exception {
        this.assertJqlColumns("category = catone", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("category = cattwo", new Context().addProject(Project.FOUR), this.getIssuesForProjects(Project.FOUR));
        this.assertJqlColumns("category != catone", new Context().addProjects(new Project[]{Project.FOUR}), this.getIssuesForProjects(Project.FOUR));
        this.assertJqlColumns("category != catthree", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category in (catone, cattwo)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category = catone or category = cattwo", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category not in (cattwo, catthree)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("not category = cattwo and category != catthree", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.assertJqlColumns("category is empty", new Context().addProject(Project.TWO), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("category = empty", new Context().addProject(Project.TWO), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("category in (empty)", new Context().addProject(Project.TWO), this.getIssuesForProjects(Project.TWO));
        this.assertJqlColumns("category in (empty, catone)", new Context().addProjects(new Project[]{Project.TWO, Project.ONE, Project.THREE}), this.getIssuesForProjects(Project.TWO, Project.ONE, Project.THREE));
        this.assertJqlColumns("category = empty or category = catone", new Context().addProjects(new Project[]{Project.TWO, Project.ONE, Project.THREE}), this.getIssuesForProjects(Project.TWO, Project.ONE, Project.THREE));
        this.assertJqlColumns("category in (empty, catone, catthree)", new Context().addProjects(new Project[]{Project.TWO, Project.ONE, Project.THREE}), this.getIssuesForProjects(Project.TWO, Project.ONE, Project.THREE));
        this.assertJqlColumns("category is not empty", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category != empty", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category not in (empty)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category not in (empty, catthree)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category != empty and category != catthree", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), this.getIssuesForProjects(Project.ONE, Project.THREE, Project.FOUR));
        this.assertJqlColumns("category not in (empty, catone)", new Context().addProjects(new Project[]{Project.FOUR}), this.getIssuesForProjects(Project.FOUR));
        this.assertJqlColumns("not (category is empty or category = catone)", new Context().addProjects(new Project[]{Project.FOUR}), this.getIssuesForProjects(Project.FOUR));
        this.assertFilterColumns(10040L, new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), this.getIssuesForProjects(Project.ONE, Project.THREE));
        this.navigation.login("fred");
        this.assertJqlColumns("category = catone", new Context().addProject(Project.ONE), this.getIssuesForProjects(Project.ONE));
        this.assertJqlColumns("category != catthree", new Context().addProjects(new Project[]{Project.ONE, Project.FOUR}), Issue.ONE1, Issue.FOUR3);
    }

    public void testAffectedVersion() throws Exception {
        this.assertSystemVersionField("affectedVersion", 10050L);
    }

    public void testFixVersion() {
        this.assertSystemVersionField("fixVersion", 10060L);
    }

    public void testComponent() throws Exception {
        this.assertJqlColumns("component = one", new Context().addProject(Project.ONE), Issue.ONE1);
        this.assertJqlColumns("component = two", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.ONE1);
        this.assertJqlColumns("component = three", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component = twoonly", new Context().addProjects(new Project[]{Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("component != one", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.TWO1, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component != two", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.TWO1, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component != three", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("component != twoonly", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component in (one, two)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.ONE1);
        this.assertJqlColumns("component = one or component = two", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.ONE1);
        this.assertJqlColumns("component in (one, three)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component = one or component = three", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component in (twoonly)", new Context().addProjects(new Project[]{Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("component = twoonly", new Context().addProjects(new Project[]{Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("component not in (one, two)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.TWO1, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("not (component = one or component = two)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.TWO1, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component not in (twoonly, two)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component != twoonly and component != two", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("component not in (one, two, three)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("component != one and not (component = two or component = three)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("component is empty", Context.GLOBAL, Issue.TWO2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component = empty", Context.GLOBAL, Issue.TWO2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component in (empty, twoonly)", new Context().addProject(Project.TWO), Issue.TWO2, Issue.TWO1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component is empty or component = twoonly", new Context().addProject(Project.TWO), Issue.TWO2, Issue.TWO1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component in (empty, two)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("not (component is not empty and component != two)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO2, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("component is not empty", Context.GLOBAL, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component != null", Context.GLOBAL, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("component not in (empty, three)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("not (component = empty or component = three)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("component not in (empty, two, three, one)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("component is not empty and component != two and component != three and component != one", new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1);
        this.assertFilterColumns(10070L, new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.ONE1);
    }

    public void testIssueContext() throws Exception {
        this.assertJqlColumns("issuekey = 'one-1'", new Context().addContext(Project.ONE, IssueType.BUG), Issue.ONE1);
        this.assertJqlColumns("issuekey = 'two-1'", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("issuekey = 'three-1'", new Context().addContext(Project.THREE, IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("issuekey = 'three-2'", new Context().addContext(Project.THREE, IssueType.BUG), Issue.THREE2);
        this.assertJqlColumns("issuekey = 'four-1'", new Context().addContext(Project.FOUR, IssueType.IMPROVEMENT), Issue.FOUR1);
        this.assertJqlColumns("issuekey != 'one-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1));
        this.assertJqlColumns("issuekey != 'two-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("issuekey != 'three-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("issuekey != 'three-2'", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.THREE2));
        this.assertJqlColumns("issuekey != 'four-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.FOUR1));
        this.assertJqlColumns("issuekey in ('one-1', 'two-1')", new Context().addContext(Project.ONE, IssueType.BUG).addContext(Project.TWO, IssueType.TASK), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("issuekey = 'one-1' or key = 'two-1'", new Context().addContext(Project.ONE, IssueType.BUG).addContext(Project.TWO, IssueType.TASK), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("issuekey in ('three-2', 'three-1')", new Context().addContext(Project.THREE, IssueType.FEATURE).addContext(Project.THREE, IssueType.BUG), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("issuekey = 'three-2' or key = 'three-1'", new Context().addContext(Project.THREE, IssueType.FEATURE).addContext(Project.THREE, IssueType.BUG), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("issuekey not in ('one-1', 'two-1')", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1, Issue.TWO1));
        this.assertJqlColumns("issuekey not in ('four-1', 'three-1')", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.FOUR1, Issue.THREE1));
        this.assertJqlColumns("issuekey in (empty, \"one-1\")", new Context().addContext(Project.ONE, IssueType.BUG), Issue.ONE1);
        this.assertJqlColumns("issuekey = empty or key = \"one-1\"", new Context().addContext(Project.ONE, IssueType.BUG), Issue.ONE1);
        this.assertJqlColumns("issuekey is not empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(new Issue[0]));
        this.assertJqlColumns("issuekey != empty", Context.GLOBAL, this.getIssuesAndRemoveIssues(new Issue[0]));
        this.assertJqlColumns("issuekey not in (empty, 'one-1')", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.ONE1));
        this.assertJqlColumns("key > 'three-1'", new Context().addProject(Project.THREE), Issue.THREE2);
        this.assertJqlColumns("key < 'three-2'", new Context().addProject(Project.THREE), Issue.THREE1);
        this.assertJqlColumns("key >= 'three-1'", new Context().addProject(Project.THREE), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("key >= 'one-1'", new Context().addProject(Project.ONE), Issue.ONE1);
        this.assertJqlColumns("key <= 'three-1'", new Context().addProject(Project.THREE), Issue.THREE1);
        this.assertJqlColumns("key <= 'two-1'", new Context().addProject(Project.TWO), Issue.TWO1);
        this.assertFilterColumns(10071L, new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
    }

    public void testLevelContext() throws Exception {
        this.assertJqlColumns("level = oneadmin", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.ONE1);
        this.assertJqlColumns("level = threeonly", new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2);
        this.assertJqlColumns("level = fouronly", new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != oneadmin", new Context().addProjects(new Project[]{Project.TWO, Project.THREE, Project.FOUR}), Issue.THREE2, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != threeonly", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.TWO, Project.FOUR}), Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != fouronly", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns("level in (oneadmin, threeonly)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns("level = oneadmin or level = threeonly", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns("level in (fouronly)", new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level = fouronly", new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (oneadmin, threeonly)", new Context().addProjects(new Project[]{Project.TWO, Project.FOUR, Project.THREE}), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != oneadmin and level != threeonly", new Context().addProjects(new Project[]{Project.TWO, Project.FOUR, Project.THREE}), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (oneadmin, fouronly)", new Context().addProjects(new Project[]{Project.TWO, Project.THREE}), Issue.THREE2);
        this.assertJqlColumns("level != oneadmin and level != fouronly", new Context().addProjects(new Project[]{Project.TWO, Project.THREE}), Issue.THREE2);
        this.assertJqlColumns("level is empty", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level = empty", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level in (empty)", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level in (empty, threeonly)", new Context().addProject(Project.THREE), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level is empty or level = threeonly", new Context().addProject(Project.THREE), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR3);
        this.assertJqlColumns("level is not empty", Context.GLOBAL, Issue.THREE2, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != empty", Context.GLOBAL, Issue.THREE2, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (empty)", Context.GLOBAL, Issue.THREE2, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (empty, empty)", Context.GLOBAL, Issue.THREE2, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level not in (empty, threeonly)", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE, Project.FOUR}), Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("level != empty and level != threeonly", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE, Project.FOUR}), Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertFilterColumns(10072L, new Context().addProject(Project.FOUR), Issue.FOUR2, Issue.FOUR1);
        this.navigation.login("fred");
        this.assertJqlColumns("level = oneadmin", new Context().addProject(Project.ONE), Issue.ONE1);
    }

    public void testParentContext() throws Exception {
        this.assertJqlColumns("parent = 'two-1'", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO2);
        this.assertJqlColumns("parent = 'four-1'", new Context().addContext(Project.FOUR, IssueType.IMPROVEMENT), Issue.FOUR2);
        this.assertJqlColumns("parent != 'four-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.FOUR2));
        this.assertJqlColumns("parent != 'three-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(new Issue[0]));
        this.assertJqlColumns("parent != 'two-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO2));
        this.assertJqlColumns("parent in ('two-1', 'three-1')", new Context().addContext(Project.TWO, IssueType.TASK).addContext(Project.THREE, IssueType.FEATURE), Issue.TWO2);
        this.assertJqlColumns("parent = 'two-1' or parent = 'three-1'", new Context().addContext(Project.TWO, IssueType.TASK).addContext(Project.THREE, IssueType.FEATURE), Issue.TWO2);
        this.assertJqlColumns("parent = 'two-1' or parent = 'four-1'", new Context().addContext(Project.TWO, IssueType.TASK).addContext(Project.FOUR, IssueType.IMPROVEMENT), Issue.TWO2, Issue.FOUR2);
        this.assertJqlColumns("parent not in ('two-1', 'three-1')", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO2));
        this.assertJqlColumns("parent != 'two-1' and  parent != 'three-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.TWO2));
        this.assertJqlColumns("parent not in ('two-1', 'four-1')", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.FOUR2, Issue.TWO2));
        this.assertJqlColumns("parent != 'two-1' and  parent != 'four-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(Issue.FOUR2, Issue.TWO2));
        this.assertJqlColumns("parent not in ('one-1', 'three-1')", Context.GLOBAL, this.getIssuesAndRemoveIssues(new Issue[0]));
        this.assertJqlColumns("not parent = 'one-1' and parent != 'three-1'", Context.GLOBAL, this.getIssuesAndRemoveIssues(new Issue[0]));
        this.assertFilterColumns(10080L, new Context().addContext(Project.FOUR, IssueType.IMPROVEMENT), Issue.FOUR2);
    }

    public void testSavedFilter() throws Exception {
        this.assertJqlColumns("savedFilter = taskfilter", new Context().addType(IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("savedFilter = onefilter", new Context().addProject(Project.TWO).addContext(Project.ONE, IssueType.BUG), Issue.TWO2, Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("savedFilter = threefilter", new Context().addProject(Project.THREE), Issue.THREE1);
        this.assertJqlColumns("savedFilter != taskfilter", new Context().addTypes(this.getIssueTypesAndRemove(IssueType.TASK)), this.getIssuesAndRemoveIssues(Issue.TWO1));
        this.assertJqlColumns("savedFilter != onefilter", new Context().addProjects(this.getProjectsAndRemove(Project.TWO)), this.getIssuesAndRemoveIssues(Issue.TWO2, Issue.TWO1, Issue.ONE1));
        this.assertJqlColumns("savedFilter != threefilter", new Context().addProject(Project.THREE), this.getIssuesAndRemoveIssues(Issue.THREE1));
        this.assertJqlColumns("savedFilter in (taskfilter, threefilter)", new Context().addProject(Project.THREE).addType(IssueType.TASK), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("savedFilter = taskfilter or filter = threefilter", new Context().addProject(Project.THREE).addType(IssueType.TASK), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("savedFilter in (onefilter, threefilter)", new Context().addProjects(new Project[]{Project.THREE, Project.TWO}).addContext(Project.ONE, IssueType.BUG), Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("savedFilter = onefilter or filter = threefilter", new Context().addProjects(new Project[]{Project.THREE, Project.TWO}).addContext(Project.ONE, IssueType.BUG), Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("savedFilter not in (taskfilter, threefilter)", new Context().addContexts(Project.THREE, (Collection<IssueType>)this.getIssueTypesAndRemove(IssueType.TASK)), this.getIssuesAndRemoveIssues(Issue.THREE1, Issue.TWO1));
        this.assertJqlColumns("savedFilter != taskfilter and savedFilter != threefilter", new Context().addContexts(Project.THREE, (Collection<IssueType>)this.getIssueTypesAndRemove(IssueType.TASK)), this.getIssuesAndRemoveIssues(Issue.THREE1, Issue.TWO1));
        this.assertJqlColumns("savedFilter not   in (onefilter, threefilter)", new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("savedFilter != onefilter and filter != threefilter", new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("savedFilter not   in (onefilter, taskfilter)", new Context().addContexts(this.getProjectsAndRemove(Project.TWO), (Collection<IssueType>)this.getIssueTypesAndRemove(IssueType.TASK)), Issue.THREE2, Issue.THREE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("savedFilter != onefilter and savedFilter != taskfilter", new Context().addContexts(this.getProjectsAndRemove(Project.TWO), (Collection<IssueType>)this.getIssueTypesAndRemove(IssueType.TASK)), Issue.THREE2, Issue.THREE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertFilterColumns(10090L, new Context().addContext(Project.ONE, IssueType.BUG).addProject(Project.TWO).addType(IssueType.TASK), Issue.TWO2, Issue.TWO1, Issue.ONE1);
        this.navigation.login("fred");
        this.assertJqlColumns("savedFilter = onefilter", new Context().addProject(Project.TWO), Issue.TWO2, Issue.TWO1);
    }

    public void testStatusContext() throws Exception {
        this.assertJqlColumns("status = open", Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("status = two", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("status = three", new Context().addProjects(new Project[]{Project.FOUR, Project.THREE}), Issue.THREE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status != open", Context.GLOBAL, Issue.TWO1, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status != two", Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("status != three", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("status in (open, two)", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("status = open or status = two", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("status in (two, three)", new Context().addContext(Project.TWO, IssueType.TASK).addProjects(new Project[]{Project.THREE, Project.FOUR}), Issue.TWO1, Issue.THREE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status = two or status = three", new Context().addContext(Project.TWO, IssueType.TASK).addProjects(new Project[]{Project.THREE, Project.FOUR}), Issue.TWO1, Issue.THREE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status not in (open, two)", Context.GLOBAL, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status != open and status != two", Context.GLOBAL, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR1);
        this.assertJqlColumns("status not in (three, two)", Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("status != three and status != two", Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("status not in (three, two, open)", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("not (status = three or status = two or status = open)", Context.GLOBAL, Issue.ONE1);
        this.assertJqlColumns("status in (empty, two)", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("status = empty or status = two", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("status is not empty", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("status not in (empty)", Context.GLOBAL, Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("status not in (empty, three, two)", Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("not (status = empty or status = three or status = two)", Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.ONE1, Issue.FOUR2);
        this.assertFilterColumns(10091L, Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.FOUR2);
        this.navigation.login("fred");
        this.assertJqlColumns("status = three", new Context().addProject(Project.FOUR), Issue.FOUR3);
    }

    public void testDatePicker() throws Exception {
        this.assertDateCustomField("datepickerglobal", "2009-08-15", Context.GLOBAL, Issue.TWO1, Issue.ONE1, Issue.FOUR1);
        this.assertDateCustomField("DatePickerComplex", "2009-08-15", new Context().addType(IssueType.TASK).addProject(Project.ONE).addContext(Project.TWO, IssueType.IMPROVEMENT), Issue.ONE1);
        this.assertDateCustomField("DatePickerBoth", "2009-08-15", new Context().addContext(Project.ONE, IssueType.BUG), Issue.ONE1);
        this.assertDateCustomField("DatePickerProject", "2009-08-15", new Context().addProject(Project.TWO).addProject(Project.THREE), Issue.TWO1, Issue.THREE1);
        this.assertDateCustomField("DatePickerType", "2009-08-15", new Context().addType(IssueType.IMPROVEMENT), Issue.FOUR1);
        this.assertFilterColumns(10100L, new Context().addType(IssueType.TASK).addProject(Project.ONE).addContext(Project.TWO, IssueType.IMPROVEMENT), Issue.TWO1, Issue.ONE1, Issue.FOUR1);
        this.navigation.login("fred");
        this.assertJqlColumns("DatePickerProject = 2009-08-15", new Context().addProject(Project.TWO), Issue.TWO1);
    }

    public void testDateTimePicker() throws Exception {
        this.assertDateCustomField("DateTimeGlobal", "2009-08-07", Context.GLOBAL, Issue.ONE1, Issue.FOUR3);
        this.assertDateCustomField("DateTimeComplex", "2009-08-07", new Context().addContext(Project.FOUR, IssueType.IMPROVEMENT).addProject(Project.THREE).addType(IssueType.TASK), Issue.TWO1);
        this.assertDateCustomField("DateTimeBoth", "2009-08-07", new Context().addContext(Project.FOUR, IssueType.BUG), Issue.FOUR3);
        this.assertDateCustomField("DateTimeProject", "2009-08-07", new Context().addProject(Project.ONE), Issue.ONE1);
        this.assertDateCustomField("DateTimeType", "2009-08-07", new Context().addType(IssueType.FEATURE), Issue.THREE1);
        this.assertFilterColumns(10101L, new Context().addContext(Project.FOUR, IssueType.BUG), Issue.FOUR3);
        this.navigation.login("fred");
        this.assertJqlColumns("DateTimeComplex = 2009-08-07", new Context().addContext(Project.FOUR, IssueType.IMPROVEMENT).addType(IssueType.TASK), Issue.TWO1);
    }

    public void testFreeTextField() throws Exception {
        this.assertTextField("freetextglobal", Context.GLOBAL, Issue.THREE1);
        this.assertTextField("FreeTextBoth", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertTextField("FreeTextProject", new Context().addProjects(new Project[]{Project.FOUR, Project.THREE}), Issue.THREE2, Issue.FOUR3, Issue.FOUR1);
        this.assertTextField("FreeTextType", new Context().addType(IssueType.BUG), Issue.THREE2, Issue.ONE1);
        this.assertTextField("FreeTextComplex", new Context().addType(IssueType.BUG).addProject(Project.FOUR).addContext(Project.ONE, IssueType.FEATURE), Issue.FOUR1);
        this.assertFilterColumns(10102L, new Context().addProjects(new Project[]{Project.FOUR, Project.THREE}), Issue.THREE1);
        this.navigation.login("fred");
        this.assertJqlColumns("freetextproject ~ match order by key desc", new Context().addProject(Project.FOUR), Issue.FOUR3);
    }

    public void testTextField() throws Exception {
        this.assertTextField("textglobal", Context.GLOBAL, Issue.TWO2, Issue.ONE1);
        this.assertTextField("TextBoth", new Context().addContext(Project.TWO, IssueType.SUBTASK), Issue.TWO2);
        this.assertTextField("TextProject", new Context().addProjects(new Project[]{Project.ONE}), Issue.ONE1);
        this.assertTextField("TextType", new Context().addType(IssueType.IMPROVEMENT), Issue.FOUR1);
        this.assertTextField("TextComplex", new Context().addType(IssueType.TASK).addContext(Project.THREE, IssueType.FEATURE), Issue.TWO1);
        this.assertFilterColumns(10103L, new Context().addType(IssueType.IMPROVEMENT), Issue.TWO2, Issue.ONE1);
        this.navigation.login("fred");
        this.assertJqlColumns("TextComplex ~ match order by key desc", new Context().addType(IssueType.TASK), Issue.TWO1);
    }

    public void testAllTextClause() throws Exception {
        List<Field> fieldsInSystem = this.getDefaultFields();
        List<Field> textFields = this.getTextFields();
        fieldsInSystem.removeAll(textFields);
        for (Field field : textFields) {
            this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields(field.getFieldName());
        }
        this.administration.reIndex();
        String jqlClause = "text ~ 'match' order by key desc";
        this.navigation.issueNavigator().createSearch("text ~ 'match' order by key desc");
        this.assertColumns("text ~ 'match' order by key desc", this.calculateColumnsForContext(Context.GLOBAL, fieldsInSystem), Issue.ONE1);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields(Field.READ_TEXT_BOTH.getFieldName());
        this.administration.reIndex();
        fieldsInSystem.add(fieldsInSystem.indexOf(Field.CHECKBOX_COMPLEX), Field.READ_TEXT_BOTH);
        this.navigation.issueNavigator().createSearch("text ~ 'match' order by key desc");
        List<String> columnNames = this.calculateColumnsForContext(new Context().addContext(Field.READ_TEXT_BOTH.getFieldContext()), fieldsInSystem);
        this.assertColumns("text ~ 'match' order by key desc", columnNames, Issue.THREE2, Issue.ONE1);
        this.assertFilterColumns(10140L, columnNames, Issue.THREE1);
        this.navigation.login("fred");
        fieldsInSystem.remove(Field.READ_TEXT_BOTH);
        this.navigation.issueNavigator().createSearch("text ~ 'match' order by key desc");
        this.assertColumns("text ~ 'match' order by key desc", this.calculateColumnsForContext(Context.GLOBAL, fieldsInSystem), Issue.ONE1);
        this.navigation.login("admin");
        this.administration.fieldConfigurations().defaultFieldConfiguration().hideFields(Field.READ_TEXT_BOTH.getFieldName());
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields(Field.FREE_TEXT_BOTH.getFieldName());
        this.administration.reIndex();
        fieldsInSystem.add(fieldsInSystem.indexOf(Field.SELECT_LIST_COMPLEX), Field.FREE_TEXT_BOTH);
        Context compoundContext = new Context().addContext(Field.FREE_TEXT_BOTH.getFieldContext());
        this.navigation.issueNavigator().createSearch("text ~ 'match' order by key desc");
        columnNames = this.calculateColumnsForContext(compoundContext, fieldsInSystem);
        this.assertColumns("text ~ 'match' order by key desc", columnNames, Issue.TWO1, Issue.ONE1);
        this.assertFilterColumns(10140L, columnNames, Issue.THREE1);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields(Field.FREE_TEXT_COMPLEX.getFieldName());
        this.administration.reIndex();
        fieldsInSystem.add(fieldsInSystem.indexOf(Field.SELECT_LIST_COMPLEX), Field.FREE_TEXT_COMPLEX);
        compoundContext.addContext(Field.FREE_TEXT_COMPLEX.getFieldContext());
        this.navigation.issueNavigator().createSearch("text ~ 'match' order by key desc");
        columnNames = this.calculateColumnsForContext(compoundContext, fieldsInSystem);
        this.assertColumns("text ~ 'match' order by key desc", columnNames, Issue.TWO1, Issue.ONE1, Issue.FOUR1);
        this.assertFilterColumns(10140L, columnNames, Issue.THREE1);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields(Field.FREE_TEXT_GLOBAL.getFieldName());
        this.administration.reIndex();
        fieldsInSystem.add(fieldsInSystem.indexOf(Field.SELECT_LIST_COMPLEX), Field.FREE_TEXT_GLOBAL);
        this.navigation.issueNavigator().createSearch("text ~ 'match' order by key desc");
        columnNames = this.calculateColumnsForContext(compoundContext, fieldsInSystem);
        this.assertColumns("text ~ 'match' order by key desc", columnNames, Issue.TWO1, Issue.THREE1, Issue.ONE1, Issue.FOUR1);
        this.assertFilterColumns(10140L, columnNames, Issue.THREE1);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields(Field.FREE_TEXT_PROJECT.getFieldName());
        this.administration.reIndex();
        fieldsInSystem.add(fieldsInSystem.indexOf(Field.SELECT_LIST_COMPLEX), Field.FREE_TEXT_PROJECT);
        compoundContext.addContext(Field.FREE_TEXT_PROJECT.getFieldContext());
        this.navigation.issueNavigator().createSearch("text ~ 'match' order by key desc");
        columnNames = this.calculateColumnsForContext(compoundContext, fieldsInSystem);
        this.assertColumns("text ~ 'match' order by key desc", columnNames, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR1);
        this.assertFilterColumns(10140L, columnNames, Issue.THREE1);
        this.administration.fieldConfigurations().defaultFieldConfiguration().showFields(Field.FREE_TEXT_TYPE.getFieldName());
        this.administration.reIndex();
        fieldsInSystem.add(fieldsInSystem.indexOf(Field.SELECT_LIST_COMPLEX), Field.FREE_TEXT_TYPE);
        compoundContext.addContext(Field.FREE_TEXT_TYPE.getFieldContext());
        this.navigation.issueNavigator().createSearch("text ~ 'match' order by key desc");
        columnNames = this.calculateColumnsForContext(compoundContext, fieldsInSystem);
        this.assertColumns("text ~ 'match' order by key desc", columnNames, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR1);
        this.assertFilterColumns(10140L, columnNames, Issue.THREE1);
    }

    public void testUrlField() throws Exception {
        this.assertUrlField("urlglobal", Context.GLOBAL, Issue.FOUR2);
        this.assertUrlField("urlBoth", new Context().addContext(Project.FOUR, IssueType.SUBTASK), Issue.FOUR2);
        this.assertUrlField("urlProject", new Context().addProjects(new Project[]{Project.TWO, Project.THREE}), Issue.TWO1, Issue.THREE1);
        this.assertUrlField("urlType", new Context().addType(IssueType.BUG), Issue.ONE1);
        this.assertUrlField("urlComplex", new Context().addType(IssueType.IMPROVEMENT).addProject(Project.THREE), Issue.THREE1);
        this.assertFilterColumns(10104L, new Context().addContext(Project.FOUR, IssueType.SUBTASK), Issue.FOUR2);
        this.navigation.login("fred");
        this.assertJqlColumns("urlProject = 'http://match.com'", new Context().addProject(Project.TWO), Issue.TWO1);
    }

    public void testReadOnlyField() throws Exception {
        this.assertTextField("readtextglobal", Context.GLOBAL, Issue.FOUR1);
        this.assertTextField("readtextBoth", new Context().addContext(Project.THREE, IssueType.BUG), Issue.THREE2);
        this.assertTextField("readtextProject", new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR1);
        this.assertTextField("readtextType", new Context().addTypes(new IssueType[]{IssueType.FEATURE, IssueType.TASK}), Issue.TWO1);
        this.assertTextField("readtextComplex", new Context().addType(IssueType.IMPROVEMENT).addProjects(new Project[]{Project.THREE, Project.TWO}), Issue.TWO2);
        this.assertFilterColumns(10105L, new Context().addType(IssueType.IMPROVEMENT).addProjects(new Project[]{Project.THREE, Project.TWO}), Issue.TWO2);
        this.navigation.login("fred");
        this.assertJqlColumns("ReadTextComplex ~ 'match'", new Context().addType(IssueType.IMPROVEMENT).addProject(Project.TWO), Issue.TWO2);
    }

    public void testUserPickerField() throws Exception {
        this.assertUserField("UserGlobal", Context.GLOBAL, Issue.ONE1);
        this.assertUserField("userBoth", new Context().addContext(Project.TWO, IssueType.SUBTASK), Issue.TWO2);
        this.assertUserField("userProject", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.ONE1);
        this.assertUserField("userType", new Context().addTypes(new IssueType[]{IssueType.FEATURE}), Issue.THREE1);
        this.assertUserField("userComplex", new Context().addContext(Project.TWO, IssueType.TASK).addType(IssueType.BUG), Issue.ONE1);
        this.assertFilterColumns(10106L, new Context().addContext(Project.TWO, IssueType.SUBTASK), Issue.ONE1);
        this.navigation.login("fred");
        this.assertJqlColumns("userProject = 'admin'", new Context().addProject(Project.ONE), Issue.ONE1);
    }

    public void testMultiUserPickerField() throws Exception {
        this.assertUserField("MultiUserGlobal", Context.GLOBAL, Issue.TWO1, Issue.FOUR3);
        this.assertUserField("multiuserBoth", new Context().addContext(Project.FOUR, IssueType.BUG), Issue.FOUR3);
        this.assertUserField("multiuserProject", new Context().addProjects(new Project[]{Project.TWO, Project.THREE}), Issue.TWO1);
        this.assertUserField("multiuserType", new Context().addTypes(new IssueType[]{IssueType.TASK}), Issue.TWO1);
        this.assertUserField("multiuserComplex", new Context().addContext(Project.ONE, IssueType.BUG).addProject(Project.THREE), Issue.THREE2);
        this.assertFilterColumns(10107L, new Context().addContext(Project.FOUR, IssueType.BUG), Issue.TWO1, Issue.FOUR3);
        this.navigation.login("fred");
        this.assertJqlColumns("multiuserProject = 'admin'", new Context().addProject(Project.TWO), Issue.TWO1);
    }

    public void testGroupPickerField() throws Exception {
        this.assertGroupField("GroupGlobal", Context.GLOBAL, Issue.TWO2);
        this.assertGroupField("GroupBoth", new Context().addContext(Project.THREE, IssueType.BUG), Issue.THREE2);
        this.assertGroupField("GroupProject", new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR1);
        this.assertGroupField("GroupType", new Context().addTypes(new IssueType[]{IssueType.FEATURE}), Issue.THREE1);
        this.assertGroupField("GroupComplex", new Context().addContext(Project.ONE, IssueType.BUG).addProject(Project.THREE), Issue.THREE2, Issue.ONE1);
        this.assertFilterColumns(10108L, new Context().addType(IssueType.FEATURE), Issue.THREE1);
        this.navigation.login("fred");
        this.assertJqlColumns("GroupComplex = 'jira-developers'", new Context().addContext(Project.ONE, IssueType.BUG), Issue.ONE1);
    }

    public void testMultiGroupPickerField() throws Exception {
        this.assertGroupField("MultiGroupGlobal", Context.GLOBAL, Issue.TWO1);
        this.assertGroupField("MultiGroupBoth", new Context().addContext(Project.THREE, IssueType.BUG), Issue.THREE2);
        this.assertGroupField("MultiGroupProject", new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR3);
        this.assertGroupField("MultiGroupType", new Context().addTypes(new IssueType[]{IssueType.FEATURE}), Issue.THREE1);
        this.assertGroupField("MultiGroupComplex", new Context().addContext(Project.ONE, IssueType.BUG).addProject(Project.THREE), Issue.ONE1);
        this.assertFilterColumns(10109L, new Context().addContext(Project.THREE, IssueType.BUG), Issue.TWO1);
        this.navigation.login("fred");
        this.assertJqlColumns("GroupComplex = 'jira-developers'", new Context().addContext(Project.ONE, IssueType.BUG), Issue.ONE1);
    }

    public void testNumberField() throws Exception {
        this.assertNumberField("NumberGlobal", 67, Context.GLOBAL, Issue.THREE1);
        this.assertNumberField("NumberBoth", 67, new Context().addContext(Project.FOUR, IssueType.SUBTASK), Issue.FOUR2);
        this.assertNumberField("NumberProject", 67, new Context().addProjects(new Project[]{Project.FOUR, Project.THREE}), Issue.THREE1);
        this.assertNumberField("NumberType", 67, new Context().addTypes(new IssueType[]{IssueType.FEATURE}), Issue.THREE1);
        this.assertNumberField("NumberComplex", 67, new Context().addContext(Project.THREE, IssueType.FEATURE).addContext(Project.ONE, IssueType.BUG), Issue.THREE1, Issue.ONE1);
        this.assertFilterColumns(10110L, new Context().addContext(Project.THREE, IssueType.FEATURE).addContext(Project.ONE, IssueType.BUG), Issue.THREE1);
        this.navigation.login("fred");
        this.assertJqlColumns("NumberComplex = 67", new Context().addContext(Project.ONE, IssueType.BUG), Issue.ONE1);
    }

    public void testImportIdField() {
        this.assertNumberField("ImportGlobal", 48, Context.GLOBAL, Issue.TWO1);
        this.assertNumberField("ImportBoth", 48, new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertNumberField("ImportProject", 48, new Context().addProjects(new Project[]{Project.ONE}), Issue.ONE1);
        this.assertNumberField("ImportType", 48, new Context().addTypes(new IssueType[]{IssueType.BUG}), Issue.ONE1);
        this.assertNumberField("ImportComplex", 48, new Context().addContext(Project.THREE, IssueType.BUG).addProject(Project.FOUR), Issue.FOUR3);
        this.assertFilterColumns(10111L, new Context().addProject(Project.ONE), Issue.TWO1);
        this.navigation.login("fred");
        this.assertJqlColumns("ImportComplex = 48", new Context().addProject(Project.FOUR), Issue.FOUR3);
    }

    public void testProjectPicker() throws Exception {
        this.assertProjectPicker("projectglobal", Context.GLOBAL, Issue.THREE1);
        this.assertProjectPicker("projectBoth", new Context().addContext(Project.THREE, IssueType.FEATURE), Issue.THREE1);
        this.assertProjectPicker("ProjectProject", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE1, Issue.ONE1);
        this.assertProjectPicker("PROJECTType", new Context().addTypes(new IssueType[]{IssueType.SUBTASK}), Issue.TWO2);
        this.assertProjectPicker("PROJectComplex", new Context().addContext(Project.TWO, IssueType.SUBTASK).addProject(Project.FOUR), Issue.TWO2);
        this.assertFilterColumns(10112L, new Context().addContext(Project.THREE, IssueType.FEATURE), Issue.THREE1);
        this.navigation.login("fred");
        this.assertJqlColumns("ProjectProject = one", new Context().addProject(Project.ONE), Issue.ONE1);
    }

    public void testSingleVersionPicker() throws Exception {
        this.assertFilterColumns(10113L, new Context().addType(IssueType.BUG), Issue.TWO2, Issue.FOUR3);
        this.assertSingleVersionPicker("SingleVersionGlobal", Context.GLOBAL);
        this.assertSingleVersionPicker("SingleVersionProject", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}));
        this.assertSingleVersionPicker("SingleVersionType", new Context().addType(IssueType.BUG));
        this.assertSingleVersionPicker("SingleVersionBoth", new Context().addContext(Project.THREE, IssueType.BUG));
        this.assertSingleVersionPicker("SingleVersionComplex", new Context().addProject(Project.TWO).addType(IssueType.SUBTASK));
        this.navigation.login("fred");
        this.assertJqlColumns("singleversionproject = one", new Context().addProject(Project.ONE), Issue.ONE1);
    }

    public void testMultipleVersionPicker() {
        this.assertFilterColumns(10120L, Field.MULTI_VERSION_COMPLEX.getFieldContext(), Issue.THREE1);
        this.assertMultiVersionField(Field.MULTI_VERSION_GLOBAL.getFieldContext(), Field.MULTI_VERSION_GLOBAL.getFieldName());
        this.assertMultiVersionField(Field.MULTI_VERSION_BOTH.getFieldContext(), Field.MULTI_VERSION_BOTH.getFieldName());
        this.assertMultiVersionField(Field.MULTI_VERSION_PROJECT.getFieldContext(), Field.MULTI_VERSION_PROJECT.getFieldName());
        this.assertMultiVersionField(Field.MULTI_VERSION_TYPE.getFieldContext(), Field.MULTI_VERSION_TYPE.getFieldName());
        this.assertMultiVersionField(Field.MULTI_VERSION_COMPLEX.getFieldContext(), Field.MULTI_VERSION_COMPLEX.getFieldName());
    }

    public void testSelectSingleOption() {
        this.assertFilterColumns(10130L, Field.SELECT_LIST_COMPLEX.getFieldContext(), Issue.THREE1);
        this.assertCustomFieldOption("SelectList");
    }

    public void testRadioOption() {
        this.assertFilterColumns(10131L, Field.RADIO_COMPLEX.getFieldContext(), Issue.THREE1);
        this.assertCustomFieldOption("Radio");
    }

    public void testCheckboxOption() {
        this.assertFilterColumns(10132L, Field.CHECKBOX_COMPLEX.getFieldContext(), Issue.THREE1);
        this.assertCustomFieldOption("Checkbox");
    }

    public void testMultiSelectOption() {
        this.assertFilterColumns(10133L, Field.MULTI_SELECT_COMPLEX.getFieldContext(), Issue.THREE1);
        this.assertCustomFieldOption("Multiselect");
    }

    public void testCascadingSelect() throws Exception {
        this.assertJqlColumns("CascasingSelectComplex = one", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex = onetwo", new Context().addProjects(new Project[]{Project.THREE, Project.TWO}), Issue.TWO1);
        this.assertJqlColumns("CascasingSelectComplex = two", new Context().addProjects(new Project[]{Project.THREE, Project.TWO}), Issue.THREE2);
        this.assertJqlColumns("CascasingSelectComplex != one", new Context().addProjects(new Project[]{Project.THREE, Project.TWO}), Issue.THREE2);
        this.assertJqlColumns("CascasingSelectComplex != onetwo", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex != oneone", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex != two", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex in (one, two)", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex = one or  CascasingSelectComplex = two", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex not in (two, oneone)", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectComplex != two and not CascasingSelectComplex = oneone", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectCOMPlex is empty", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex = empty", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex in (empty)", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex in (empty, oneone)", new Context().addProjects(new Project[]{Project.TWO, Project.THREE}), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex is empty or CascasingSelectCOMPlex = oneone", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex in (empty, onetwo)", new Context().addProjects(new Project[]{Project.TWO, Project.THREE}), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex = empty or CascasingSelectCOMPlex = onetwo", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO1, Issue.THREE1);
        this.assertJqlColumns("CascasingSelectCOMPlex is not empty", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectCOMPlex != empty", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectCOMPlex not in (empty)", Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.FOUR2);
        this.assertJqlColumns("CascasingSelectCOMPlex not in (empty, one)", new Context().addProjects(new Project[]{Project.TWO, Project.THREE}), Issue.THREE2);
        this.assertJqlColumns("CascasingSelectCOMPlex != empty and CascasingSelectCOMPlex != one", new Context().addProjects(new Project[]{Project.TWO, Project.THREE}), Issue.THREE2);
        this.assertJqlColumns("CascadingSelectProject = one", new Context().addProjects(new Project[]{Project.ONE, Project.FOUR}), Issue.ONE1);
        this.assertJqlColumns("CascadingSelectProject = two", new Context().addProjects(new Project[]{Project.TWO, Project.THREE, Project.FOUR}), Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.FOUR2);
        this.assertJqlColumns("CascadingSelectProject = three", new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("CascadingSelectProject = four", new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject != one", new Context().addProjects(new Project[]{Project.TWO, Project.THREE, Project.FOUR}), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject != two", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), Issue.THREE2, Issue.ONE1, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject != three", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.FOUR}), Issue.TWO2, Issue.TWO1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject != four", new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("CascadingSelectProject in (one, three)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("CascadingSelectProject = one or CascadingSelectProject = three", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("CascadingSelectProject in (cascadeoption(one), three)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("CascadingSelectProject in cascadeoption(one) or CascadingSelectProject = three", new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumns("cascadingselectproject not in (one, two)", new Context().addProjects(new Project[]{Project.THREE, Project.FOUR}), Issue.THREE2, Issue.FOUR1);
        this.assertJqlColumns("not cascadingselectproject = one and cascadingselectproject != two", new Context().addProjects(new Project[]{Project.THREE, Project.FOUR}), Issue.THREE2, Issue.FOUR1);
        this.assertJqlColumns("cascadingselectproject is empty", Field.CASCADING_SELECT_PROJECT.getFieldContext(), Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject = empty", Field.CASCADING_SELECT_PROJECT.getFieldContext(), Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject in (empty)", Field.CASCADING_SELECT_PROJECT.getFieldContext(), Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject in (empty, cascadeoption(one))", new Context().addProjects(new Project[]{Project.ONE}), Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject is empty or cascadingselectproject in       cascadeoption(one)", Field.CASCADING_SELECT_PROJECT.getFieldContext(), Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("cascadingselectproject is not empty", Field.CASCADING_SELECT_PROJECT.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("cascadingselectproject != empty", Field.CASCADING_SELECT_PROJECT.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("cascadingselectproject not in (empty)", Field.CASCADING_SELECT_PROJECT.getFieldContext(), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("cascadingselectproject not in (empty, one)", new Context().addProjects(new Project[]{Project.TWO, Project.THREE, Project.FOUR}), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject IN cascadeoption(four, none)", new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject IN cascadeoption(two, none)", new Context().addProjects(new Project[]{Project.TWO}), Issue.TWO2);
        this.assertJqlColumns("CascadingSelectProject IN cascadeoption(four, two)", new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR2);
        this.assertJqlColumns("CascadingSelectProject IN cascadeoption(two)", new Context().addProjects(new Project[]{Project.TWO}), Issue.TWO2, Issue.TWO1);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(four, none)", new Context().addProjects(Project.values()), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(one, none)", new Context().addProjects(new Project[]{Project.TWO, Project.FOUR, Project.THREE}), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(four, two)", new Context().addProjects(Project.values()), Issue.TWO2, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(two, two)", new Context().addProjects(Project.values()), Issue.TWO2, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("CascadingSelectProject NOT IN cascadeoption(two)", new Context().addProjects(new Project[]{Project.ONE, Project.THREE, Project.FOUR}), Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertFilterColumns(10150L, Field.CASCADING_SELECT_COMPLEX.getFieldContext(), Issue.THREE1);
        this.navigation.login("fred");
        this.assertJqlColumns("CascadingSelectProject != one", new Context().addProjects(new Project[]{Project.TWO, Project.FOUR}), Issue.TWO2, Issue.TWO1);
    }

    public void testInvalidField() throws Exception {
        this.assertFilterColumns(10161L, new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE1);
        this.assertFilterColumns(10160L, new Context().addProjects(new Project[]{Project.THREE, Project.TWO}), Issue.TWO2, Issue.TWO1, Issue.THREE1);
        this.navigation.login("fred");
        this.assertFilterColumns(10160L, new Context().addProjects(new Project[]{Project.TWO}), Issue.TWO2, Issue.TWO1);
    }

    public void testLogicalOperatorsAndContext() throws Exception {
        this.assertJqlColumns("summary ~ suns and comment ~ suns order by key desc", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("project = three and summary ~ suns order by key desc", new Context().addProject(Project.THREE), Issue.THREE1);
        this.assertJqlColumns("type = 'new feature' and summary ~ suns order by key desc", new Context().addType(IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("key = 'three-1' and summary ~ suns order by key desc", new Context().addContext(Project.THREE, IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("summary ~ suns and project = three order by key desc", new Context().addProject(Project.THREE), Issue.THREE1);
        this.assertJqlColumns("type = 'task' and project = two", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("key = one-1 and project = one", new Context().addContext(Project.ONE, IssueType.BUG), Issue.ONE1);
        this.assertJqlColumns("summary ~ suns and type = 'new feature' order by key desc", new Context().addType(IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("project = two and type = 'task'", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("key = one-1 and type = 'bug'", new Context().addContext(Project.ONE, IssueType.BUG), Issue.ONE1);
        this.assertJqlColumns("summary ~ suns and key = three-1 order by key desc", new Context().addContext(Project.THREE, IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("project = two and key = two-1", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("type = task and key = two-1", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("key = two-1 and key = two-1", new Context().addContext(Project.TWO, IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("summary ~ suns or comment ~ suns order by key desc", Context.GLOBAL, Issue.THREE1);
        this.assertJqlColumns("project = three or summary ~ suns order by key desc", new Context().addProject(Project.THREE), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("type = 'new feature' or summary ~ suns order by key desc", new Context().addType(IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("key = 'three-1' or summary ~ suns order by key desc", new Context().addContext(Project.THREE, IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("summary ~ suns or project = three order by key desc", new Context().addProject(Project.THREE), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns("project = four or category = cattwo", new Context().addProject(Project.FOUR), Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns("type = 'task' or project = two", new Context().addType(IssueType.TASK).addProject(Project.TWO), Issue.TWO2, Issue.TWO1);
        this.assertJqlColumns("key = one-1 or project = one", new Context().addContext(Project.ONE, IssueType.BUG).addProject(Project.ONE), Issue.ONE1);
        this.assertJqlColumns("summary ~ suns or type = 'new feature' order by key desc", new Context().addType(IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("project = two or type = 'task'", new Context().addProject(Project.TWO).addType(IssueType.TASK), Issue.TWO2, Issue.TWO1);
        this.assertJqlColumns("type = task or type = 'bug'", new Context().addTypes(new IssueType[]{IssueType.TASK, IssueType.BUG}), Issue.TWO1, Issue.THREE2, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumns("key = one-1 or type = 'task'", new Context().addContext(Project.ONE, IssueType.BUG).addType(IssueType.TASK), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("summary ~ suns or key = three-1 order by key desc", new Context().addContext(Project.THREE, IssueType.FEATURE), Issue.THREE1);
        this.assertJqlColumns("project = two or key = two-1", new Context().addContext(Project.TWO, IssueType.TASK).addProject(Project.TWO), Issue.TWO2, Issue.TWO1);
        this.assertJqlColumns("type = task or key = two-1", new Context().addContext(Project.TWO, IssueType.TASK).addType(IssueType.TASK), Issue.TWO1);
        this.assertJqlColumns("key = two-1 or key = one-1", new Context().addContext(Project.TWO, IssueType.TASK).addContext(Project.ONE, IssueType.BUG), Issue.TWO1, Issue.ONE1);
        Context ctx = new Context().addContext(Project.ONE, IssueType.BUG).addContext(Project.TWO, IssueType.TASK);
        List<Issue> issues = Arrays.asList(Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("project = one and type = bug or type = task and project = two", ctx, issues);
        this.assertJqlColumns("(project = one and type = bug) or (type = task and project = two)", ctx, issues);
        this.assertJqlColumns("type = bug and project = one or type = task and project = two", ctx, issues);
        this.assertJqlColumns("(project = two and type = task  ) or (project = one and type = bug)", ctx, issues);
        ctx = new Context().addContext(Project.ONE, IssueType.BUG).addContext(Project.THREE, IssueType.BUG);
        issues = Arrays.asList(Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns("type = bug and (project = one or key >= three-1)", ctx, issues);
        this.assertJqlColumns("type = bug and project = one or type = bug and issue >= three-1", ctx, issues);
        this.assertJqlColumns("project = one and type = bug or type = task", new Context().addContext(Project.ONE, IssueType.BUG).addType(IssueType.TASK), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("project = one and type = bug or type = task and project = two", new Context().addContext(Project.ONE, IssueType.BUG).addContext(Project.TWO, IssueType.TASK), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns("project in (one, three) and type = bug or type = \"New Feature\"", new Context().addContext(Project.ONE, IssueType.BUG).addContext(Project.THREE, IssueType.BUG).addType(IssueType.FEATURE), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        Set<IssueType> types = this.getIssueTypesAndRemove(IssueType.BUG);
        ctx = new Context().addContexts(Arrays.asList(Project.ONE, Project.THREE), (Collection<IssueType>)types);
        this.assertJqlColumns("project in (one, three) and type != 'bug'", ctx, Issue.THREE1);
        types = EnumSet.of(IssueType.FEATURE, IssueType.IMPROVEMENT, IssueType.TASK);
        ctx = new Context().addContexts(Arrays.asList(Project.ONE, Project.THREE), (Collection<IssueType>)types);
        this.assertJqlColumns("project in (one, three) and type in ('new feature', Improvement, task)", ctx, Issue.THREE1);
        types = this.getIssueTypesAndRemove(IssueType.BUG);
        ctx = new Context().addContexts(Arrays.asList(Project.ONE, Project.TWO), (Collection<IssueType>)types);
        this.assertJqlColumns("project in (one, two) and type not in (bug)", ctx, Issue.TWO2, Issue.TWO1);
        ctx = new Context().addContexts(this.getProjectsAndRemove(Project.ONE), (Collection<IssueType>)this.getIssueTypesAndRemove(IssueType.BUG));
        this.assertJqlColumns("project != one and type != bug", ctx, Issue.TWO2, Issue.TWO1, Issue.THREE1, Issue.FOUR2, Issue.FOUR1);
        this.navigation.login("fred");
        ctx = new Context().addContexts(this.getProjectsAndRemove(Project.ONE, Project.THREE), (Collection<IssueType>)this.getIssueTypesAndRemove(IssueType.BUG));
        this.assertJqlColumns("project != one and type != bug", ctx, Issue.TWO2, Issue.TWO1);
    }

    private void assertTextField(String fieldName, Context context, Issue ... issues) {
        this.assertJqlColumns(String.format("%s ~ 'match' order by key desc", fieldName), context, issues);
        List<Issue> contextIssues = this.getIssuesInContext(context);
        contextIssues.removeAll(Arrays.asList(issues));
        if (!contextIssues.isEmpty()) {
            this.assertJqlColumns(String.format("%s ~ empty order by key desc", fieldName), context, contextIssues);
            this.assertJqlColumns(String.format("%s is empty order by key desc", fieldName), context, contextIssues);
            this.assertJqlColumns(String.format("%s ~ null order by key desc", fieldName), context, contextIssues);
        }
        this.assertJqlColumns(String.format("%s !~ empty order by key desc", fieldName), context, issues);
        this.assertJqlColumns(String.format("%s is not empty order by key desc", fieldName), context, issues);
        this.assertJqlColumns(String.format("%s is not null order by key desc", fieldName), context, issues);
    }

    private void assertProjectPicker(String fieldName, Context context, Issue ... issues) {
        this.assertStringEqualsField(fieldName, "one", "two", context, issues);
    }

    private void assertUserField(String fieldName, Context context, Issue ... issues) {
        this.assertStringEqualsField(fieldName, "admin", "fred", context, issues);
    }

    private void assertGroupField(String fieldName, Context context, Issue ... issues) {
        this.assertStringEqualsField(fieldName, "jira-developers", "jira-administrators", context, issues);
    }

    private void assertUrlField(String fieldName, Context context, Issue ... issues) {
        this.assertStringEqualsField(fieldName, "http://match.com", "other", context, issues);
    }

    private void assertStringEqualsField(String fieldName, String match, String notMatch, Context context, Issue ... issues) {
        this.assertJqlColumns(String.format("%s = '%s'", fieldName, match), context, issues);
        this.assertJqlColumns(String.format("%1$s in ('%2$s', '%3$s')", fieldName, match, notMatch), context, issues);
        this.assertJqlColumns(String.format("%1$s = '%2$s' or %1$s = '%3$s'", fieldName, match, notMatch), context, issues);
        this.assertJqlColumns(String.format("%s != '%s'", fieldName, notMatch), context, issues);
        this.assertJqlColumns(String.format("%1$s not in ('%2$s')", fieldName, notMatch), context, issues);
        List<Issue> contextIssues = this.getIssuesInContext(context);
        contextIssues.removeAll(Arrays.asList(issues));
        if (!contextIssues.isEmpty()) {
            this.assertJqlColumns(String.format("%s is empty", fieldName), context, contextIssues);
            this.assertJqlColumns(String.format("%s = empty", fieldName), context, contextIssues);
            this.assertJqlColumns(String.format("%s = null", fieldName), context, contextIssues);
        }
        this.assertJqlColumns(String.format("%s != empty", fieldName), context, issues);
        this.assertJqlColumns(String.format("%s is not empty", fieldName), context, issues);
        this.assertJqlColumns(String.format("%s is not null", fieldName), context, issues);
    }

    private List<Issue> getIssuesInContext(Context context) {
        return this.getIssuesInContext(Issue.ALL_ISSUES, context);
    }

    private List<Issue> getIssuesInContext(Collection<Issue> input, Context ctx) {
        ArrayList<Issue> issues = new ArrayList<Issue>();
        for (Issue issue : input) {
            if (!issue.inContext(ctx)) continue;
            issues.add(issue);
        }
        return issues;
    }

    private void assertCustomFieldOption(String fieldName) {
        this.assertJqlColumns(String.format("%scomplex = one", fieldName), new Context().addContext(Project.TWO, IssueType.TASK).addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumns(String.format("%scomplex = two", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE1);
        this.assertJqlColumns(String.format("%sComplex = global", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2);
        this.assertJqlColumns(String.format("%sType = one", fieldName), new Context().addType(IssueType.IMPROVEMENT), Issue.FOUR1);
        this.assertJqlColumns(String.format("%sProjectGlobal = two", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE1);
        this.assertJqlColumns(String.format("%sProjectGlobal = three", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2);
        this.assertJqlColumns(String.format("%sProjectGlobal = global", fieldName), Context.GLOBAL, Issue.TWO2);
        this.assertJqlColumns(String.format("%scomplex != one", fieldName), new Context().addProjects(new Project[]{Project.THREE, Project.ONE}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns(String.format("%scomplex != two", fieldName), new Context().addContext(Project.TWO, IssueType.TASK).addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.TWO1, Issue.THREE2, Issue.ONE1);
        this.assertJqlColumns(String.format("%sProjectGlobal != global", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns(String.format("%sProjectGlobal != three", fieldName), Context.GLOBAL, Issue.TWO2, Issue.THREE1);
        this.assertJqlColumns(String.format("%sProjectGlobal != two", fieldName), Context.GLOBAL, Issue.TWO2, Issue.THREE2);
        this.assertJqlColumnsForIn(String.format("%sProjectGlobal", fieldName), Arrays.asList("two", "global"), new Context().addProjects(new Project[]{Project.THREE}), Issue.TWO2, Issue.THREE1);
        this.assertJqlColumnsForNotIn(String.format("%scomplex", fieldName), Arrays.asList("one", "two"), new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2);
        this.assertJqlColumnsForNotIn(String.format("%sProjectGlobal", fieldName), Arrays.asList("global", "two"), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2);
        this.assertJqlColumns(String.format("%sProjectGlobal is empty", fieldName), Context.GLOBAL, Issue.TWO1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns(String.format("%sProjectGlobal = empty", fieldName), Context.GLOBAL, Issue.TWO1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumns(String.format("%sProjectGlobal in (empty)", fieldName), Context.GLOBAL, Issue.TWO1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsForIn(String.format("%sProjectGlobal", fieldName), Arrays.asList("empty", "two"), new Context().addProject(Project.THREE), Issue.TWO1, Issue.THREE1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsForIn(String.format("%scomplex", fieldName), Arrays.asList("empty", "global"), new Context().addContext(Project.TWO, IssueType.TASK).addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2);
        this.assertJqlColumns(String.format("%sProjectGlobal is not empty", fieldName), Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns(String.format("%sProjectGlobal != empty", fieldName), Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumns(String.format("%sProjectGlobal not in (empty)", fieldName), Context.GLOBAL, Issue.TWO2, Issue.THREE2, Issue.THREE1);
        this.assertJqlColumnsForNotIn(String.format("%sProjectGlobal", fieldName), Arrays.asList("empty", "global"), new Context().addProject(Project.THREE), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumnsForNotIn(String.format("%sProjectGlobal", fieldName), Arrays.asList("empty", "two"), Context.GLOBAL, Issue.TWO2, Issue.THREE2);
        this.assertJqlColumnsForNotIn(String.format("%scomplex", fieldName), Arrays.asList("empty", "global"), new Context().addContext(Project.TWO, IssueType.TASK).addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.TWO1, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsForNotIn(String.format("%scomplex", fieldName), Arrays.asList("empty", "one"), new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.navigation.login("fred");
        this.assertJqlColumns(String.format("%scomplex != two", fieldName), new Context().addContext(Project.TWO, IssueType.TASK).addProjects(new Project[]{Project.ONE}), Issue.TWO1, Issue.ONE1);
    }

    private void assertSystemVersionField(String fieldName, long badFilterId) {
        this.assertFilterColumns(badFilterId, new Context().addProjects(new Project[]{Project.TWO, Project.THREE, Project.ONE}), Issue.THREE2, Issue.ONE1);
        this.assertMultiVersionField(Context.GLOBAL, fieldName);
    }

    private void assertMultiVersionField(Context context, String fieldName) {
        this.assertJqlColumnsContext(context, String.format("%s = twoonly", fieldName), new Context().addProject(Project.TWO), Issue.TWO1);
        this.assertJqlColumnsContext(context, String.format("%s = two", fieldName), new Context().addProjects(new Project[]{Project.TWO, Project.ONE}), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s != two", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE, Project.FOUR}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("%s != fouronly", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s in (fouronly, three)", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.FOUR, Project.THREE}), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%1$s = fouronly or %1$s = three", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.FOUR, Project.THREE}), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s in (fouronly, threeonly)", fieldName), new Context().addProjects(new Project[]{Project.FOUR, Project.THREE}), Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("(%1$s  = fouronly or %1$s = threeonly)", fieldName), new Context().addProjects(new Project[]{Project.FOUR, Project.THREE}), Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("%s not in (fouronly, threeonly)", fieldName), new Context().addProjects(new Project[]{Project.THREE, Project.ONE, Project.TWO}), Issue.TWO1, Issue.THREE2, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("not(%1$s = fouronly or %1$s = threeonly)", fieldName), new Context().addProjects(new Project[]{Project.THREE, Project.ONE, Project.TWO}), Issue.TWO1, Issue.THREE2, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s not in (one, two, twoonly)", fieldName), new Context().addProjects(new Project[]{Project.THREE, Project.FOUR, Project.ONE, Project.TWO}), Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("not %1$s = one and %1$s != two and %1$s != twoonly", fieldName), new Context().addProjects(new Project[]{Project.THREE, Project.FOUR, Project.ONE, Project.TWO}), Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("%s is empty", fieldName), Context.GLOBAL, Issue.TWO2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s = empty", fieldName), Context.GLOBAL, Issue.TWO2, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s in (empty, two)", fieldName), new Context().addContext(Context.GLOBAL).addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO2, Issue.TWO1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%1$s = empty or %1$s = two", fieldName), new Context().addContext(Context.GLOBAL).addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO2, Issue.TWO1, Issue.ONE1, Issue.FOUR3, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s is not empty", fieldName), Context.GLOBAL, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s != null", fieldName), Context.GLOBAL, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s not in (null, one, two, three)", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE, Project.FOUR}), Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("%1$s not in (null, one) and %1$s != two and not %1$s = three", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE, Project.FOUR}), Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("%s > one", fieldName), new Context().addProject(Project.ONE), Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s > two", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s > three", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("%s > threeonly", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2);
        this.assertJqlColumnsContext(context, String.format("%s < one", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("%s < two", fieldName), new Context().addProjects(new Project[]{Project.ONE}), Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s < three", fieldName), new Context().addProjects(new Project[]{Project.ONE}), Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s < twoonly", fieldName), new Context().addProjects(new Project[]{Project.TWO}), Issue.TWO1);
        this.assertJqlColumnsContext(context, String.format("%s < threeonly", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2);
        this.assertJqlColumnsContext(context, String.format("%s >= one", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s >= two", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s >= three", fieldName), new Context().addProjects(new Project[]{Project.THREE, Project.ONE}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s >= twoonly", fieldName), new Context().addProjects(new Project[]{Project.TWO}), Issue.TWO1);
        this.assertJqlColumnsContext(context, String.format("%s >= threeonly", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("%s <= one", fieldName), new Context().addProjects(new Project[]{Project.THREE, Project.ONE}), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s <= two", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s <= three", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE2, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s <= twoonly", fieldName), new Context().addProjects(new Project[]{Project.TWO}), Issue.TWO1);
        this.assertJqlColumnsContext(context, String.format("%s <= threeonly", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.navigation.login("fred");
        this.assertJqlColumnsContext(context, String.format("%s >= three", fieldName), new Context().addProject(Project.ONE), Issue.ONE1);
        this.navigation.login("admin");
    }

    private void assertSingleVersionPicker(String fieldName, Context context) throws Exception {
        this.assertJqlColumnsContext(context, String.format("%s = one", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s = two", fieldName), new Context().addProjects(new Project[]{Project.ONE, Project.TWO}), Issue.TWO1);
        this.assertJqlColumnsContext(context, String.format("%s = threeonly", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2);
        this.assertJqlColumnsContext(context, String.format("%s = fouronly", fieldName), new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s != one", fieldName), new Context().addProjects(Project.values()), Issue.TWO1, Issue.THREE2, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s != two", fieldName), new Context().addProjects(Project.values()), Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s != three", fieldName), new Context().addProjects(Project.values()), Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s != threeonly", fieldName), new Context().addProjects(Project.values()), Issue.TWO1, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s != fouronly", fieldName), new Context().addProjects(this.getProjectsAndRemove(Project.FOUR)), Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s = empty", fieldName), Context.GLOBAL, Issue.TWO2, Issue.FOUR3);
        this.assertJqlColumnsContext(context, String.format("%s is empty", fieldName), Context.GLOBAL, Issue.TWO2, Issue.FOUR3);
        this.assertJqlColumnsContext(context, String.format("%s is empty", fieldName), Context.GLOBAL, Issue.TWO2, Issue.FOUR3);
        this.assertJqlColumnsForInContext(context, fieldName, Arrays.asList("one", "two"), new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.TWO1, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsForInContext(context, fieldName, Arrays.asList("one", "two", "threeonly"), new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE}), Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsForInContext(context, fieldName, Arrays.asList("one", "two", "fouronly"), new Context().addProjects(new Project[]{Project.ONE, Project.TWO, Project.THREE, Project.FOUR}), Issue.TWO1, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsForNotInContext(context, fieldName, Arrays.asList("one", "two"), new Context().addProjects(Project.values()), Issue.THREE2, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsForNotInContext(context, fieldName, Arrays.asList("two", "twoonly", "fouronly"), new Context().addProjects(this.getProjectsAndRemove(Project.FOUR)), Issue.THREE2, Issue.THREE1, Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s = empty", fieldName), Context.GLOBAL, Issue.TWO2, Issue.FOUR3);
        this.assertJqlColumnsContext(context, String.format("%s is empty", fieldName), Context.GLOBAL, Issue.TWO2, Issue.FOUR3);
        this.assertJqlColumnsContext(context, String.format("%s in (empty)", fieldName), Context.GLOBAL, Issue.TWO2, Issue.FOUR3);
        this.assertJqlColumnsForInContext(context, fieldName, Arrays.asList("one", "empty"), new Context().addProjects(new Project[]{Project.ONE, Project.THREE}), Issue.TWO2, Issue.THREE1, Issue.ONE1, Issue.FOUR3);
        this.assertJqlColumnsContext(context, String.format("%s != empty", fieldName), Context.GLOBAL, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s is not empty", fieldName), Context.GLOBAL, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s not in (empty)", fieldName), Context.GLOBAL, Issue.TWO1, Issue.THREE2, Issue.THREE1, Issue.ONE1, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsForNotInContext(context, fieldName, Arrays.asList("one", "empty"), new Context().addProjects(Project.values()), Issue.TWO1, Issue.THREE2, Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s < two", fieldName), new Context().addProjects(new Project[]{Project.ONE}), Issue.ONE1);
        this.assertJqlColumnsContext(context, String.format("%s > three", fieldName), new Context().addProjects(new Project[]{Project.THREE}), Issue.THREE2, Issue.THREE1);
        this.assertJqlColumnsContext(context, String.format("%s <= fouronly", fieldName), new Context().addProjects(new Project[]{Project.FOUR}), Issue.FOUR2, Issue.FOUR1);
        this.assertJqlColumnsContext(context, String.format("%s >= two", fieldName), new Context().addProjects(new Project[]{Project.TWO, Project.ONE}), Issue.TWO1);
    }

    private void assertJqlColumnsContext(Context andContext, String jqlQuery, Context ctx, Issue ... issues) {
        Context actualContext = Context.intersect(andContext, ctx);
        List<Issue> actualIssues = this.getIssuesInContext(Arrays.asList(issues), andContext);
        if (!actualIssues.isEmpty()) {
            this.assertJqlColumns(jqlQuery, actualContext, actualIssues);
        }
    }

    private void assertJqlColumnsForInContext(Context andContext, String fieldName, Collection<String> values, Context ctx, Issue ... issues) {
        Context actualContext = Context.intersect(andContext, ctx);
        List<Issue> actualIssues = this.getIssuesInContext(Arrays.asList(issues), andContext);
        if (!actualIssues.isEmpty()) {
            this.assertJqlColumnsForIn(fieldName, values, actualContext, actualIssues);
        }
    }

    private void assertJqlColumnsForIn(String fieldName, Collection<String> values, Context ctx, Issue ... issues) {
        this.assertJqlColumnsForIn(fieldName, values, ctx, Arrays.asList(issues));
    }

    private void assertJqlColumnsForIn(String fieldName, Collection<String> values, Context ctx, Collection<Issue> issues) {
        StringBuilder inBuilder = new StringBuilder(fieldName).append(" in (");
        StringBuilder orBuilder = new StringBuilder();
        Iterator<String> i = values.iterator();
        while (i.hasNext()) {
            String value = i.next();
            inBuilder.append(value);
            orBuilder.append(fieldName).append(" = ").append(value);
            if (!i.hasNext()) continue;
            inBuilder.append(", ");
            orBuilder.append(" or ");
        }
        inBuilder.append(")");
        this.assertJqlColumns(inBuilder.toString(), ctx, issues);
        this.assertJqlColumns(orBuilder.toString(), ctx, issues);
    }

    private void assertJqlColumnsForNotInContext(Context andContext, String fieldName, Collection<String> values, Context ctx, Issue ... issues) {
        Context actualContext = Context.intersect(andContext, ctx);
        List<Issue> actualIssues = this.getIssuesInContext(Arrays.asList(issues), andContext);
        if (!actualIssues.isEmpty()) {
            this.assertJqlColumnsForNotIn(fieldName, values, actualContext, actualIssues);
        }
    }

    private void assertJqlColumnsForNotIn(String fieldName, Collection<String> values, Context ctx, Issue ... issues) {
        this.assertJqlColumnsForNotIn(fieldName, values, ctx, Arrays.asList(issues));
    }

    private void assertJqlColumnsForNotIn(String fieldName, Collection<String> values, Context ctx, Collection<Issue> issues) {
        StringBuilder inBuilder = new StringBuilder(fieldName).append(" not in (");
        StringBuilder orBuilder = new StringBuilder();
        Iterator<String> i = values.iterator();
        while (i.hasNext()) {
            String value = i.next();
            inBuilder.append(value);
            orBuilder.append(fieldName).append(" != ").append(value);
            if (!i.hasNext()) continue;
            inBuilder.append(", ");
            orBuilder.append(" aNd ");
        }
        inBuilder.append(")");
        this.assertJqlColumns(inBuilder.toString(), ctx, issues);
        this.assertJqlColumns(orBuilder.toString(), ctx, issues);
    }

    private void assertDateCustomField(String fieldName, String date, Context ctx, Issue ... includeIssues) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date parsedDate = dateFormat.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(parsedDate);
        cal.add(2, -1);
        String previousDate = dateFormat.format(cal.getTime());
        cal.setTime(parsedDate);
        cal.add(2, 1);
        String nextDate = dateFormat.format(cal.getTime());
        this.assertRangeField(fieldName, previousDate, date, nextDate, ctx, includeIssues);
    }

    private void assertNumberField(String fieldName, int value, Context ctx, Issue ... issues) {
        this.assertRangeField(fieldName, String.valueOf(value - 2), String.valueOf(value), String.valueOf(value + 100), ctx, issues);
    }

    private void assertRangeField(String fieldName, String prev, String value, String next, Context ctx, Issue ... issues) {
        this.assertJqlColumns(String.format("%s = %s", fieldName, value), ctx, issues);
        this.assertJqlColumns(String.format("%s != %s", fieldName, prev), ctx, issues);
        this.assertJqlColumns(String.format("%s >= %s", fieldName, value), ctx, issues);
        this.assertJqlColumns(String.format("%s <= %s", fieldName, value), ctx, issues);
        this.assertJqlColumns(String.format("%s < %s", fieldName, next), ctx, issues);
        this.assertJqlColumns(String.format("%s > %s", fieldName, prev), ctx, issues);
        this.assertJqlColumns(String.format("%s in (%s)", fieldName, value), ctx, issues);
        this.assertJqlColumns(String.format("%s in (%s, %s)", fieldName, value, next), ctx, issues);
        this.assertJqlColumns(String.format("%1$s = %2$s or %1$s = %3$s", fieldName, value, next), ctx, issues);
        this.assertJqlColumns(String.format("%s not in (%s)", fieldName, prev), ctx, issues);
        this.assertJqlColumns(String.format("%s not in (%s, %s)", fieldName, prev, next), ctx, issues);
        this.assertJqlColumns(String.format("%1$s != %2$s and %1$s != %3$s", fieldName, prev, next), ctx, issues);
        List<Issue> emptyIssues = this.getIssuesInContext(ctx);
        emptyIssues.removeAll(Arrays.asList(issues));
        if (!emptyIssues.isEmpty()) {
            this.assertJqlColumns(String.format("%s is empty", fieldName), ctx, emptyIssues);
            this.assertJqlColumns(String.format("%s = empty", fieldName), ctx, emptyIssues);
            this.assertJqlColumns(String.format("%s = null", fieldName), ctx, emptyIssues);
            this.assertJqlColumns(String.format("%s in (empty, %s)", fieldName, prev), ctx, emptyIssues);
            this.assertJqlColumns(String.format("%1$s is empty or %1$s = %2$s", fieldName, prev), ctx, emptyIssues);
        }
        this.assertJqlColumns(String.format("%s is not empty", fieldName), ctx, issues);
        this.assertJqlColumns(String.format("%s != empty", fieldName), ctx, issues);
        this.assertJqlColumns(String.format("%s != null", fieldName), ctx, issues);
        this.assertJqlColumns(String.format("%s not in (empty, %s)", fieldName, prev), ctx, issues);
        this.assertJqlColumns(String.format("%1$s is not empty and %1$s != %2$s", fieldName, prev), ctx, issues);
    }

    private Set<IssueType> getIssueTypesAndRemove(IssueType ... remove) {
        EnumSet<IssueType> types = EnumSet.allOf(IssueType.class);
        types.removeAll(Arrays.asList(remove));
        return types;
    }

    private Set<Project> getProjectsAndRemove(Project ... remove) {
        EnumSet<Project> projects = EnumSet.allOf(Project.class);
        projects.removeAll(Arrays.asList(remove));
        return projects;
    }

    private List<Issue> getIssuesAndRemoveIssues(Issue ... remove) {
        ArrayList<Issue> issues = new ArrayList<Issue>(Issue.ALL_ISSUES);
        issues.removeAll(Arrays.asList(remove));
        return issues;
    }

    private List<Issue> getIssuesAndRemoveIssues(Collection<Issue> remove) {
        ArrayList<Issue> issues = new ArrayList<Issue>(Issue.ALL_ISSUES);
        issues.removeAll(remove);
        return issues;
    }

    private List<Issue> getIssuesAndRemoveProject(Project ... projects) {
        if (projects.length == 0) {
            return Issue.ALL_ISSUES;
        }
        EnumSet<Project> projectCheck = EnumSet.copyOf(Arrays.asList(projects));
        ArrayList<Issue> issues = new ArrayList<Issue>(Issue.ALL_ISSUES.size());
        for (Issue issue : Issue.ALL_ISSUES) {
            if (projectCheck.contains((Object)issue.getProject())) continue;
            issues.add(issue);
        }
        return issues;
    }

    private List<Issue> getIssuesForProjects(Project ... projects) {
        if (projects.length == 0) {
            return Issue.ALL_ISSUES;
        }
        EnumSet<Project> projectCheck = EnumSet.copyOf(Arrays.asList(projects));
        ArrayList<Issue> issues = new ArrayList<Issue>(Issue.ALL_ISSUES.size());
        for (Issue issue : Issue.ALL_ISSUES) {
            if (!projectCheck.contains((Object)issue.getProject())) continue;
            issues.add(issue);
        }
        return issues;
    }

    private void assertFilterColumns(long filterId, Context ctx, Issue ... issues) {
        this.navigation.issueNavigator().loadFilter(filterId, null);
        this.assertColumns(String.format("Filter: %d", filterId), ctx, issues);
    }

    private void assertFilterColumns(long filterId, List<String> columns, Issue ... issues) {
        this.navigation.issueNavigator().loadFilter(filterId, null);
        this.assertColumns(String.format("Filter: %d", filterId), columns, issues);
    }

    private void assertFilterColumns(long filterId, Context ctx, Collection<Issue> issues) {
        this.assertFilterColumns(filterId, ctx, issues.toArray(new Issue[issues.size()]));
    }

    private void assertJqlColumns(String jqlQuery, Context ctx, Collection<Issue> issues) {
        this.assertJqlColumns(jqlQuery, ctx, issues.toArray(new Issue[issues.size()]));
    }

    private void assertJqlColumns(String jqlQuery, Context ctx, Issue ... issues) {
        this.navigation.issueNavigator().createSearch(jqlQuery);
        this.assertColumns(jqlQuery, ctx, issues);
    }

    private void assertColumns(String msg, Context ctx, Issue ... issues) {
        this.assertColumns(msg, this.calculateColumnsForContext(ctx), issues);
    }

    private void assertColumns(String msg, List<String> columnNames, Issue ... issues) {
        ArrayList<SearchResultsCondition> condition = new ArrayList<SearchResultsCondition>();
        condition.add(new ColumnsCondition(columnNames));
        condition.add(new ContainsIssueKeysCondition(this.text, TestContextColumns.issuesToKeys(issues)));
        condition.add(new NumberOfIssuesCondition(this.text, issues.length));
        this.log(String.format("Checking that columns '%s' are visible for '%s'", columnNames, msg));
        this.assertions.getIssueNavigatorAssertions().assertSearchResults(condition);
    }

    private static String[] issuesToKeys(Issue ... issues) {
        String[] keys = new String[issues.length];
        int i = 0;
        for (Issue issue : issues) {
            keys[i++] = issue.getKey();
        }
        return keys;
    }

    private List<String> calculateColumnsForContext(Context ctx) {
        return this.calculateColumnsForContext(ctx, this.getDefaultFields());
    }

    private List<String> calculateColumnsForContext(Context ctx, List<Field> defaultFields) {
        ArrayList<String> column = new ArrayList<String>();
        column.addAll(Arrays.asList("T", "Key", "Status"));
        for (Field defaultField : defaultFields) {
            if (!defaultField.isVisible(ctx)) continue;
            column.add(defaultField.getFieldName());
        }
        return column;
    }

    private List<Field> getTextFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Field.FREE_TEXT_BOTH);
        fields.add(Field.FREE_TEXT_COMPLEX);
        fields.add(Field.FREE_TEXT_GLOBAL);
        fields.add(Field.FREE_TEXT_PROJECT);
        fields.add(Field.FREE_TEXT_TYPE);
        fields.add(Field.TEXT_BOTH);
        fields.add(Field.TEXT_COMPLEX);
        fields.add(Field.TEXT_GLOBAL);
        fields.add(Field.TEXT_PROJECT);
        fields.add(Field.TEXT_TYPE);
        fields.add(Field.READ_TEXT_BOTH);
        fields.add(Field.READ_TEXT_COMPLEX);
        fields.add(Field.READ_TEXT_GLOBAL);
        fields.add(Field.READ_TEXT_PROJECT);
        fields.add(Field.READ_TEXT_TYPE);
        return fields;
    }

    private List<Field> getDefaultFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(Field.DATE_PICKER_BOTH);
        fields.add(Field.DATE_PICKER_COMPLEX);
        fields.add(Field.DATE_PICKER_GLOBAL);
        fields.add(Field.DATE_PICKER_PROJECT);
        fields.add(Field.DATE_PICKER_TYPE);
        fields.add(Field.DATE_TIME_BOTH);
        fields.add(Field.DATE_TIME_COMPLEX);
        fields.add(Field.DATE_TIME_GLOBAL);
        fields.add(Field.DATE_TIME_PROJECT);
        fields.add(Field.DATE_TIME_TYPE);
        fields.add(Field.URL_BOTH);
        fields.add(Field.URL_COMPLEX);
        fields.add(Field.URL_GLOBAL);
        fields.add(Field.URL_PROJECT);
        fields.add(Field.URL_TYPE);
        fields.add(Field.USER_BOTH);
        fields.add(Field.USER_COMPLEX);
        fields.add(Field.USER_GLOBAL);
        fields.add(Field.USER_PROJECT);
        fields.add(Field.USER_TYPE);
        fields.add(Field.MULTI_USER_BOTH);
        fields.add(Field.MULTI_USER_COMPLEX);
        fields.add(Field.MULTI_USER_GLOBAL);
        fields.add(Field.MULTI_USER_PROJECT);
        fields.add(Field.MULTI_USER_TYPE);
        fields.add(Field.GROUP_BOTH);
        fields.add(Field.GROUP_COMPLEX);
        fields.add(Field.GROUP_GLOBAL);
        fields.add(Field.GROUP_PROJECT);
        fields.add(Field.GROUP_TYPE);
        fields.add(Field.MULTI_GROUP_BOTH);
        fields.add(Field.MULTI_GROUP_COMPLEX);
        fields.add(Field.MULTI_GROUP_GLOBAL);
        fields.add(Field.MULTI_GROUP_PROJECT);
        fields.add(Field.MULTI_GROUP_TYPE);
        fields.add(Field.NUMBER_BOTH);
        fields.add(Field.NUMBER_COMPLEX);
        fields.add(Field.NUMBER_GLOBAL);
        fields.add(Field.NUMBER_PROJECT);
        fields.add(Field.NUMBER_TYPE);
        fields.add(Field.IMPORT_BOTH);
        fields.add(Field.IMPORT_COMPLEX);
        fields.add(Field.IMPORT_GLOBAL);
        fields.add(Field.IMPORT_PROJECT);
        fields.add(Field.IMPORT_TYPE);
        fields.add(Field.PROJECT_BOTH);
        fields.add(Field.PROJECT_COMPLEX);
        fields.add(Field.PROJECT_GLOBAL);
        fields.add(Field.PROJECT_PROJECT);
        fields.add(Field.PROJECT_TYPE);
        fields.add(Field.SINGLE_VERSION_BOTH);
        fields.add(Field.SINGLE_VERSION_COMPLEX);
        fields.add(Field.SINGLE_VERSION_GLOBAL);
        fields.add(Field.SINGLE_VERSION_PROJECT);
        fields.add(Field.SINGLE_VERSION_TYPE);
        fields.add(Field.MULTI_VERSION_BOTH);
        fields.add(Field.MULTI_VERSION_COMPLEX);
        fields.add(Field.MULTI_VERSION_GLOBAL);
        fields.add(Field.MULTI_VERSION_PROJECT);
        fields.add(Field.MULTI_VERSION_TYPE);
        fields.add(Field.FREE_TEXT_BOTH);
        fields.add(Field.FREE_TEXT_COMPLEX);
        fields.add(Field.FREE_TEXT_GLOBAL);
        fields.add(Field.FREE_TEXT_PROJECT);
        fields.add(Field.FREE_TEXT_TYPE);
        fields.add(Field.SELECT_LIST_COMPLEX);
        fields.add(Field.SELECT_LIST_PROJECT_GLOBAL);
        fields.add(Field.SELECT_LIST_TYPE);
        fields.add(Field.RADIO_COMPLEX);
        fields.add(Field.RADIO_PROJECT_GLOBAL);
        fields.add(Field.RADIO_TYPE);
        fields.add(Field.READ_TEXT_BOTH);
        fields.add(Field.READ_TEXT_COMPLEX);
        fields.add(Field.READ_TEXT_GLOBAL);
        fields.add(Field.READ_TEXT_PROJECT);
        fields.add(Field.READ_TEXT_TYPE);
        fields.add(Field.TEXT_BOTH);
        fields.add(Field.TEXT_COMPLEX);
        fields.add(Field.TEXT_GLOBAL);
        fields.add(Field.TEXT_PROJECT);
        fields.add(Field.TEXT_TYPE);
        fields.add(Field.CHECKBOX_COMPLEX);
        fields.add(Field.CHECKBOX_PROJECT_GLOBAL);
        fields.add(Field.CHECKBOX_TYPE);
        fields.add(Field.MULTI_SELECT_COMPLEX);
        fields.add(Field.MULTI_SELECT_PROJECT_GLOBAL);
        fields.add(Field.MULTI_SELECT_TYPE);
        fields.add(Field.CASCADING_SELECT_COMPLEX);
        fields.add(Field.CASCADING_SELECT_PROJECT);
        fields.add(Field.INVISIBLE_FIELD);
        return fields;
    }

    private static class ContextEntry {
        private static final ContextEntry GLOBAL = new ContextEntry(null, null);
        private final Project project;
        private final IssueType type;

        private ContextEntry(Project project, IssueType type) {
            this.project = project;
            this.type = type;
        }

        private boolean projectMatches(ContextEntry entry) {
            return this.project == null || this.project == entry.getProject();
        }

        private boolean typeMatches(ContextEntry entry) {
            return this.type == null || this.type == entry.getType();
        }

        private Project getProject() {
            return this.project;
        }

        public boolean isAnyProject() {
            return this.project == null;
        }

        private IssueType getType() {
            return this.type;
        }

        private boolean isAnyType() {
            return this.type == null;
        }

        public String toString() {
            return String.format("[Project: %s, Type: %s]", new Object[]{this.project, this.type});
        }

        private static ContextEntry forProject(Project project) {
            return new ContextEntry(project, null);
        }

        private static ContextEntry forType(IssueType type) {
            return new ContextEntry(null, type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContextEntry that = (ContextEntry)o;
            if (this.project != that.project) {
                return false;
            }
            return this.type == that.type;
        }

        public int hashCode() {
            int result = this.project != null ? this.project.hashCode() : 0;
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }

        static /* synthetic */ ContextEntry access$11600() {
            return GLOBAL;
        }
    }

    private static class Context {
        private static final Context GLOBAL = new Context().addEntry(ContextEntry.access$11600());
        private final Set<ContextEntry> entries;

        private Context() {
            this.entries = new HashSet<ContextEntry>();
        }

        private Context(Context context, boolean lock) {
            HashSet<ContextEntry> copyEntries = new HashSet<ContextEntry>(context.entries);
            this.entries = lock ? Collections.unmodifiableSet(copyEntries) : copyEntries;
        }

        private Context addEntry(ContextEntry entry) {
            this.entries.add(entry);
            return this;
        }

        private Context addContexts(Collection<Project> projects, Collection<IssueType> types) {
            for (Project project : projects) {
                this.addContexts(project, types);
            }
            return this;
        }

        private Context addContexts(Project project, Collection<IssueType> types) {
            for (IssueType type : types) {
                this.addContext(project, type);
            }
            return this;
        }

        private Context addContext(Project project, IssueType type) {
            this.entries.add(new ContextEntry(project, type));
            return this;
        }

        private Context addContext(Context context) {
            this.entries.addAll(context.entries);
            return this;
        }

        private Context addProjects(Project ... projects) {
            for (Project project : projects) {
                this.addProject(project);
            }
            return this;
        }

        private Context addProjects(Collection<Project> projects) {
            for (Project project : projects) {
                this.addProject(project);
            }
            return this;
        }

        private Context addProject(Project project) {
            this.entries.add(ContextEntry.forProject(project));
            return this;
        }

        private Context addTypes(IssueType ... types) {
            for (IssueType type : types) {
                this.addType(type);
            }
            return this;
        }

        private Context addTypes(Collection<IssueType> types) {
            for (IssueType type : types) {
                this.addType(type);
            }
            return this;
        }

        private Context addType(IssueType type) {
            this.entries.add(ContextEntry.forType(type));
            return this;
        }

        private Set<ContextEntry> getEntries() {
            return this.entries;
        }

        private boolean matches(Context context) {
            for (ContextEntry otherEntry : context.getEntries()) {
                if (!this.matches(otherEntry)) continue;
                return true;
            }
            return false;
        }

        private boolean matches(ContextEntry checkEntry) {
            boolean containsExplicitProject = false;
            boolean implicitProjectMatch = false;
            for (ContextEntry entry : this.entries) {
                boolean explicitProject;
                boolean projectMatches = entry.projectMatches(checkEntry);
                boolean typeMatches = entry.typeMatches(checkEntry);
                if (!projectMatches) continue;
                boolean bl = explicitProject = !entry.isAnyProject();
                if (typeMatches) {
                    if (explicitProject) {
                        return true;
                    }
                    implicitProjectMatch = true;
                    continue;
                }
                containsExplicitProject |= explicitProject;
            }
            return implicitProjectMatch && !containsExplicitProject;
        }

        private static Context intersect(Context ctx, Context otherCtx) {
            Context newCtx = new Context();
            for (ContextEntry entry : ctx.getEntries()) {
                for (ContextEntry otherEntry : otherCtx.getEntries()) {
                    if (!Context.shouldInterset(entry, otherEntry)) continue;
                    newCtx.addEntry(Context.combine(entry, otherEntry));
                }
            }
            return newCtx;
        }

        private static boolean shouldInterset(ContextEntry one, ContextEntry two) {
            return !(!one.isAnyType() && !two.isAnyType() && one.getType() != two.getType() || !one.isAnyProject() && !two.isAnyProject() && one.getProject() != two.getProject());
        }

        private static ContextEntry combine(ContextEntry one, ContextEntry two) {
            Object type = one.isAnyType() ? (two.isAnyType() ? null : two.getType()) : one.getType();
            Object project = one.isAnyProject() ? (two.isAnyProject() ? null : two.getProject()) : one.getProject();
            return new ContextEntry((Project)((Object)project), (IssueType)((Object)type));
        }

        public String toString() {
            return "Context [" + this.entries + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Context context = (Context)o;
            return ((Object)this.entries).equals(context.entries);
        }

        public int hashCode() {
            return ((Object)this.entries).hashCode();
        }
    }

    private static class Field {
        private static final Field DATE_PICKER_BOTH = new Field("DatePickerBoth", Context.access$1700(new Context(), Project.ONE, IssueType.BUG));
        private static final Field DATE_PICKER_COMPLEX = new Field("DatePickerComplex", Context.access$1700(Context.access$100(Context.access$800(new Context(), IssueType.TASK), Project.ONE), Project.TWO, IssueType.IMPROVEMENT));
        private static final Field DATE_PICKER_GLOBAL = new Field("DatePickerGlobal", Context.access$400());
        private static final Field DATE_PICKER_PROJECT = new Field("DatePickerProject", Context.access$100(Context.access$100(new Context(), Project.TWO), Project.THREE));
        private static final Field DATE_PICKER_TYPE = new Field("DatePickerType", Context.access$800(new Context(), IssueType.IMPROVEMENT));
        private static final Field DATE_TIME_BOTH = new Field("DateTimeBoth", Context.access$1700(new Context(), Project.FOUR, IssueType.BUG));
        private static final Field DATE_TIME_COMPLEX = new Field("DateTimeComplex", Context.access$800(Context.access$100(Context.access$1700(new Context(), Project.FOUR, IssueType.IMPROVEMENT), Project.THREE), IssueType.TASK));
        private static final Field DATE_TIME_GLOBAL = new Field("DateTimeGlobal", Context.access$400());
        private static final Field DATE_TIME_PROJECT = new Field("DateTimeProject", Context.access$100(new Context(), Project.ONE));
        private static final Field DATE_TIME_TYPE = new Field("DateTimeType", Context.access$800(new Context(), IssueType.FEATURE));
        private static final Field FREE_TEXT_BOTH = new Field("FreeTextBoth", Context.access$1700(new Context(), Project.TWO, IssueType.TASK));
        private static final Field FREE_TEXT_COMPLEX = new Field("FreeTextComplex", Context.access$800(Context.access$100(Context.access$1700(new Context(), Project.ONE, IssueType.FEATURE), Project.FOUR), IssueType.BUG));
        private static final Field FREE_TEXT_GLOBAL = new Field("FreeTextGlobal", Context.access$400());
        private static final Field FREE_TEXT_PROJECT = new Field("FreeTextProject", Context.access$300(new Context(), new Project[]{Project.THREE, Project.FOUR}));
        private static final Field FREE_TEXT_TYPE = new Field("FreeTextType", Context.access$800(new Context(), IssueType.BUG));
        private static final Field TEXT_BOTH = new Field("TextBoth", Context.access$1700(new Context(), Project.TWO, IssueType.SUBTASK));
        private static final Field TEXT_COMPLEX = new Field("TextComplex", Context.access$800(Context.access$1700(new Context(), Project.THREE, IssueType.FEATURE), IssueType.TASK));
        private static final Field TEXT_GLOBAL = new Field("TextGlobal", Context.access$400());
        private static final Field TEXT_PROJECT = new Field("TextProject", Context.access$300(new Context(), new Project[]{Project.ONE}));
        private static final Field TEXT_TYPE = new Field("TextType", Context.access$800(new Context(), IssueType.IMPROVEMENT));
        private static final Field URL_BOTH = new Field("UrlBoth", Context.access$1700(new Context(), Project.FOUR, IssueType.SUBTASK));
        private static final Field URL_COMPLEX = new Field("UrlComplex", Context.access$800(Context.access$100(new Context(), Project.THREE), IssueType.IMPROVEMENT));
        private static final Field URL_GLOBAL = new Field("UrlGlobal", Context.access$400());
        private static final Field URL_PROJECT = new Field("UrlProject", Context.access$300(new Context(), new Project[]{Project.TWO, Project.THREE}));
        private static final Field URL_TYPE = new Field("UrlType", Context.access$800(new Context(), IssueType.BUG));
        private static final Field READ_TEXT_COMPLEX = new Field("ReadTextComplex", Context.access$800(Context.access$300(new Context(), new Project[]{Project.THREE, Project.TWO}), IssueType.IMPROVEMENT));
        private static final Field READ_TEXT_BOTH = new Field("ReadTextBoth", Context.access$1700(new Context(), Project.THREE, IssueType.BUG));
        private static final Field READ_TEXT_GLOBAL = new Field("ReadTextGlobal", Context.access$400());
        private static final Field READ_TEXT_PROJECT = new Field("ReadTextProject", Context.access$300(new Context(), new Project[]{Project.FOUR}));
        private static final Field READ_TEXT_TYPE = new Field("ReadTextType", Context.access$1300(new Context(), new IssueType[]{IssueType.FEATURE, IssueType.TASK}));
        private static final Field USER_BOTH = new Field("UserBoth", Context.access$1700(new Context(), Project.TWO, IssueType.SUBTASK));
        private static final Field USER_COMPLEX = new Field("UserComplex", Context.access$800(Context.access$1700(new Context(), Project.TWO, IssueType.TASK), IssueType.BUG));
        private static final Field USER_GLOBAL = new Field("UserGlobal", Context.access$400());
        private static final Field USER_PROJECT = new Field("UserProject", Context.access$300(new Context(), new Project[]{Project.ONE, Project.THREE}));
        private static final Field USER_TYPE = new Field("UserType", Context.access$1300(new Context(), new IssueType[]{IssueType.FEATURE}));
        private static final Field MULTI_USER_BOTH = new Field("MultiUserBoth", Context.access$1700(new Context(), Project.FOUR, IssueType.BUG));
        private static final Field MULTI_USER_COMPLEX = new Field("MultiUserComplex", Context.access$1700(Context.access$100(new Context(), Project.THREE), Project.ONE, IssueType.BUG));
        private static final Field MULTI_USER_GLOBAL = new Field("MultiUserGlobal", Context.access$400());
        private static final Field MULTI_USER_PROJECT = new Field("MultiUserProject", Context.access$300(new Context(), new Project[]{Project.TWO, Project.THREE}));
        private static final Field MULTI_USER_TYPE = new Field("MultiUserType", Context.access$1300(new Context(), new IssueType[]{IssueType.TASK}));
        private static final Field GROUP_BOTH = new Field("GroupBoth", Context.access$1700(new Context(), Project.THREE, IssueType.BUG));
        private static final Field GROUP_COMPLEX = new Field("GroupComplex", Context.access$1700(Context.access$100(new Context(), Project.THREE), Project.ONE, IssueType.BUG));
        private static final Field GROUP_GLOBAL = new Field("GroupGlobal", Context.access$400());
        private static final Field GROUP_PROJECT = new Field("GroupProject", Context.access$300(new Context(), new Project[]{Project.FOUR}));
        private static final Field GROUP_TYPE = new Field("GroupType", Context.access$1300(new Context(), new IssueType[]{IssueType.FEATURE}));
        private static final Field MULTI_GROUP_BOTH = new Field("MultiGroupBoth", Context.access$1700(new Context(), Project.THREE, IssueType.BUG));
        private static final Field MULTI_GROUP_COMPLEX = new Field("MultiGroupComplex", Context.access$1700(Context.access$100(new Context(), Project.THREE), Project.ONE, IssueType.BUG));
        private static final Field MULTI_GROUP_GLOBAL = new Field("MultiGroupGlobal", Context.access$400());
        private static final Field MULTI_GROUP_PROJECT = new Field("MultiGroupProject", Context.access$300(new Context(), new Project[]{Project.FOUR}));
        private static final Field MULTI_GROUP_TYPE = new Field("MultiGroupType", Context.access$1300(new Context(), new IssueType[]{IssueType.FEATURE}));
        private static final Field NUMBER_BOTH = new Field("NumberBoth", Context.access$1700(new Context(), Project.FOUR, IssueType.SUBTASK));
        private static final Field NUMBER_COMPLEX = new Field("NumberComplex", Context.access$1700(Context.access$1700(new Context(), Project.THREE, IssueType.FEATURE), Project.ONE, IssueType.BUG));
        private static final Field NUMBER_GLOBAL = new Field("NumberGlobal", Context.access$400());
        private static final Field NUMBER_PROJECT = new Field("NumberProject", Context.access$300(new Context(), new Project[]{Project.FOUR, Project.THREE}));
        private static final Field NUMBER_TYPE = new Field("NumberType", Context.access$1300(new Context(), new IssueType[]{IssueType.FEATURE}));
        private static final Field IMPORT_BOTH = new Field("ImportBoth", Context.access$1700(new Context(), Project.TWO, IssueType.TASK));
        private static final Field IMPORT_COMPLEX = new Field("ImportComplex", Context.access$100(Context.access$1700(new Context(), Project.THREE, IssueType.BUG), Project.FOUR));
        private static final Field IMPORT_GLOBAL = new Field("ImportGlobal", Context.access$400());
        private static final Field IMPORT_PROJECT = new Field("ImportProject", Context.access$300(new Context(), new Project[]{Project.ONE}));
        private static final Field IMPORT_TYPE = new Field("ImportType", Context.access$1300(new Context(), new IssueType[]{IssueType.BUG}));
        private static final Field PROJECT_BOTH = new Field("ProjectBoth", Context.access$1700(new Context(), Project.THREE, IssueType.FEATURE));
        private static final Field PROJECT_COMPLEX = new Field("ProjectComplex", Context.access$100(Context.access$1700(new Context(), Project.TWO, IssueType.SUBTASK), Project.FOUR));
        private static final Field PROJECT_GLOBAL = new Field("ProjectGlobal", Context.access$400());
        private static final Field PROJECT_PROJECT = new Field("ProjectProject", Context.access$300(new Context(), new Project[]{Project.THREE, Project.ONE}));
        private static final Field PROJECT_TYPE = new Field("ProjectType", Context.access$1300(new Context(), new IssueType[]{IssueType.SUBTASK}));
        private static final Field SINGLE_VERSION_BOTH = new Field("SingleVersionBoth", Context.access$1700(new Context(), Project.THREE, IssueType.BUG));
        private static final Field SINGLE_VERSION_COMPLEX = new Field("SingleVersionComplex", Context.access$800(Context.access$100(new Context(), Project.TWO), IssueType.SUBTASK));
        private static final Field SINGLE_VERSION_GLOBAL = new Field("SingleVersionGlobal", Context.access$400());
        private static final Field SINGLE_VERSION_PROJECT = new Field("SingleVersionProject", Context.access$300(new Context(), new Project[]{Project.THREE, Project.ONE}));
        private static final Field SINGLE_VERSION_TYPE = new Field("SingleVersionType", Context.access$800(new Context(), IssueType.BUG));
        private static final Field MULTI_VERSION_BOTH = new Field("MultiVersionBoth", Context.access$1700(new Context(), Project.THREE, IssueType.FEATURE));
        private static final Field MULTI_VERSION_COMPLEX = new Field("MultiVersionComplex", Context.access$800(Context.access$1700(new Context(), Project.ONE, IssueType.BUG), IssueType.IMPROVEMENT));
        private static final Field MULTI_VERSION_GLOBAL = new Field("MultiVersionGlobal", Context.access$400());
        private static final Field MULTI_VERSION_PROJECT = new Field("MultiVersionProject", Context.access$300(new Context(), new Project[]{Project.ONE, Project.TWO, Project.FOUR}));
        private static final Field MULTI_VERSION_TYPE = new Field("MultiVersionType", Context.access$800(new Context(), IssueType.BUG));
        private static final Field SELECT_LIST_COMPLEX = new Field("SelectListComplex", Context.access$300(Context.access$1700(new Context(), Project.TWO, IssueType.TASK), new Project[]{Project.ONE, Project.THREE}));
        private static final Field SELECT_LIST_PROJECT_GLOBAL = new Field("SelectListProjectGlobal", Context.access$2200(Context.access$300(new Context(), new Project[]{Project.THREE}), Context.access$400()));
        private static final Field SELECT_LIST_TYPE = new Field("SelectListType", Context.access$800(new Context(), IssueType.IMPROVEMENT));
        private static final Field RADIO_COMPLEX = new Field("RadioComplex", Context.access$300(Context.access$1700(new Context(), Project.TWO, IssueType.TASK), new Project[]{Project.ONE, Project.THREE}));
        private static final Field RADIO_PROJECT_GLOBAL = new Field("RadioProjectGlobal", Context.access$2200(Context.access$300(new Context(), new Project[]{Project.THREE}), Context.access$400()));
        private static final Field RADIO_TYPE = new Field("RadioType", Context.access$800(new Context(), IssueType.IMPROVEMENT));
        private static final Field CHECKBOX_COMPLEX = new Field("CheckboxComplex", Context.access$300(Context.access$1700(new Context(), Project.TWO, IssueType.TASK), new Project[]{Project.ONE, Project.THREE}));
        private static final Field CHECKBOX_PROJECT_GLOBAL = new Field("CheckboxProjectGlobal", Context.access$2200(Context.access$300(new Context(), new Project[]{Project.THREE}), Context.access$400()));
        private static final Field CHECKBOX_TYPE = new Field("CheckboxType", Context.access$800(new Context(), IssueType.IMPROVEMENT));
        private static final Field MULTI_SELECT_COMPLEX = new Field("MultiSelectComplex", Context.access$300(Context.access$1700(new Context(), Project.TWO, IssueType.TASK), new Project[]{Project.ONE, Project.THREE}));
        private static final Field MULTI_SELECT_PROJECT_GLOBAL = new Field("MultiSelectProjectGlobal", Context.access$2200(Context.access$300(new Context(), new Project[]{Project.THREE}), Context.access$400()));
        private static final Field MULTI_SELECT_TYPE = new Field("MultiSelectType", Context.access$800(new Context(), IssueType.IMPROVEMENT));
        private static final Field CASCADING_SELECT_COMPLEX = new Field("CascasingSelectComplex", Context.access$300(Context.access$1700(new Context(), Project.FOUR, IssueType.SUBTASK), new Project[]{Project.THREE, Project.TWO}));
        private static final Field CASCADING_SELECT_PROJECT = new Field("CascadingSelectProject", Context.access$300(new Context(), Project.values()));
        private static final Field INVISIBLE_FIELD = new Field("InvisibleField", Context.access$300(new Context(), new Project[]{Project.THREE}));
        private final String fieldName;
        private final Context fieldContext;

        private Field(String fieldName, Context fieldContext) {
            this.fieldName = fieldName;
            this.fieldContext = new Context(fieldContext, true);
        }

        boolean isVisible(Context contex) {
            return this.fieldContext.matches(contex);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Context getFieldContext() {
            return this.fieldContext;
        }

        public String toString() {
            return String.format("Field Config: %s {%s}.%n", this.fieldName, this.fieldContext);
        }
    }

    private static class Issue
    implements Comparable<Issue> {
        private static final Issue TWO2 = new Issue("TWO-2", Project.TWO, IssueType.SUBTASK);
        private static final Issue TWO1 = new Issue("TWO-1", Project.TWO, IssueType.TASK);
        private static final Issue THREE2 = new Issue("THREE-2", Project.THREE, IssueType.BUG);
        private static final Issue THREE1 = new Issue("THREE-1", Project.THREE, IssueType.FEATURE);
        private static final Issue ONE1 = new Issue("ONE-1", Project.ONE, IssueType.BUG);
        private static final Issue FOUR3 = new Issue("FOUR-3", Project.FOUR, IssueType.BUG);
        private static final Issue FOUR2 = new Issue("FOUR-2", Project.FOUR, IssueType.SUBTASK);
        private static final Issue FOUR1 = new Issue("FOUR-1", Project.FOUR, IssueType.IMPROVEMENT);
        private static final List<Issue> ALL_ISSUES = Arrays.asList(TWO2, TWO1, THREE2, THREE1, ONE1, FOUR3, FOUR2, FOUR1);
        private final String key;
        private final Project project;
        private final IssueType type;

        private Issue(String key, Project project, IssueType type) {
            this.key = key;
            this.project = project;
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public Project getProject() {
            return this.project;
        }

        public IssueType getType() {
            return this.type;
        }

        public String toString() {
            return this.key;
        }

        public boolean inContext(Context ctx) {
            return ctx.matches(new ContextEntry(this.project, this.type));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Issue issue = (Issue)o;
            return !(this.key == null ? issue.key != null : !this.key.equals(issue.key));
        }

        public int hashCode() {
            return this.key != null ? this.key.hashCode() : 0;
        }

        @Override
        public int compareTo(Issue o) {
            return this.key.compareTo(o.key);
        }
    }

    private static enum IssueType {
        BUG,
        IMPROVEMENT,
        FEATURE,
        TASK,
        SUBTASK;

    }

    private static enum Project {
        ONE,
        TWO,
        THREE,
        FOUR;

    }
}

