/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.navigator;

import com.atlassian.jira.webtests.JIRAWebTest;
import org.xml.sax.SAXException;

public class TestGenericProjectConstantsSearcher
extends JIRAWebTest {
    public static final String VERSION_ONE_VALUE = "10000";
    public static final String VERSION_FOUR_VALUE = "10001";
    public static final String COMPONENT_ONE_VALUE = "10000";
    public static final String COMPONENT_TWO_VALUE = "10001";
    public static final String NO_VERSION_VALUE = "-1";
    public static final String UNRELEASED_VERSION_VALUE = "-2";
    public static final String NO_COMPONENT_VALUE = "-1";
    public static final String NO_VERSIONS = "no versions";
    public static final String UNRELEASED_VERSIONS = "all unreleased versions";
    public static final String NO_COMPONENTS = "no components";

    public TestGenericProjectConstantsSearcher(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestGenericProjectConstantsSearcher.xml");
    }

    @Override
    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testLinkMultipleFixForVersions() throws SAXException {
        this.clickLink("find_link");
        this.selectMultiOptionByValue("fixfor", "10000");
        this.selectMultiOptionByValue("fixfor", "10001");
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.assertLinkPresentWithText("New Version 1");
        this.assertLinkPresentWithText("New Version 4");
        this.clickLinkWithText("New Version 1");
        TestGenericProjectConstantsSearcher.assertEquals((String)"homosapien: New Version 1 - jWebTest JIRA installation", (String)this.getDialog().getResponse().getTitle().trim());
    }

    public void testLinkMultipleComponents() throws SAXException {
        this.clickLink("find_link");
        this.selectMultiOptionByValue("component", "10000");
        this.selectMultiOptionByValue("component", "10001");
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.assertLinkPresentWithText("New Component 1");
        this.assertLinkPresentWithText("New Component 2");
        this.clickLinkWithText("New Component 1");
        TestGenericProjectConstantsSearcher.assertEquals((String)"homosapien: New Component 1 - jWebTest JIRA installation", (String)this.getDialog().getResponse().getTitle().trim());
    }

    public void testNoLinkMultipleAffectsVersions() {
        this.clickLink("find_link");
        this.selectMultiOptionByValue("version", "10000");
        this.selectMultiOptionByValue("version", "10001");
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.assertTextPresent("New Version 1");
        this.assertLinkNotPresentWithText("New Version 1");
        this.assertTextPresent("New Version 4");
        this.assertLinkNotPresentWithText("New Version 4");
    }

    public void testNoLinkUnreleasedNoComponentsAndVersions() {
        this.clickLink("find_link");
        this.selectMultiOptionByValue("fixfor", "-1");
        this.selectMultiOptionByValue("fixfor", UNRELEASED_VERSION_VALUE);
        this.selectMultiOptionByValue("component", "-1");
        this.selectMultiOptionByValue("version", "-1");
        this.selectMultiOptionByValue("version", UNRELEASED_VERSION_VALUE);
        this.tester.submit("show");
        this.tester.clickLink("viewfilter");
        this.assertTextPresent(NO_VERSIONS);
        this.assertLinkNotPresentWithText(NO_VERSIONS);
        this.assertTextPresent(UNRELEASED_VERSIONS);
        this.assertLinkNotPresentWithText(UNRELEASED_VERSIONS);
        this.assertTextPresent(NO_COMPONENTS);
        this.assertLinkNotPresentWithText(NO_COMPONENTS);
    }
}

