/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.HttpUnitOptions;

public class TestXSSInFullName
extends JIRAWebTest {
    private static final String FULLNAME = "Alan <script>alert('I am a script')</script> Sapinsly";
    private static final String ESCAPED_FULLNAME = "Alan &lt;script&gt;alert(&#39;I am a script&#39;)&lt;/script&gt; Sapinsly";
    private static final String TEST_PROJECT = "Test";
    private static final String NEW_PROJECT = "New Project";
    private static final String ALANS_USERNAME = "alans";
    public static final String ALANS_PASSWORD = "alans";

    public TestXSSInFullName(String string) {
        super(string);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestXSSData.xml");
        this.enableCommentGroupVisibility(Boolean.TRUE);
        HttpUnitOptions.setScriptingEnabled((boolean)true);
    }

    @Override
    public void tearDown() {
        super.tearDown();
        HttpUnitOptions.setScriptingEnabled((boolean)false);
    }

    public void testFullNameWithScript() {
        this._testFullUsernameInComment();
        this._testEditAssigneeField();
        this._testAssigneeNavigatorView();
        this._testAssigneeFieldinMoveOperation();
        this._testChangeHistoryTab();
        this._testDeveloperWorkloadReport();
        this._testWorklogTab();
        this._testUserPickerCustomField();
        this._testReporterInNavigatorView();
        this._testWatchersTable();
        this._testDashboardPortlets();
        this._testReporterInBulkEdit();
        this._testMultiUserCustomFieldView();
        this._testTimeTrackingExcel();
    }

    public void _testFullUsernameInComment() {
        this.logout();
        this.login("alans", "alans");
        this.gotoIssue("TST-1");
        this.clickLink("comment-issue");
        this.setWorkingForm("comment-add");
        this.setFormElement("comment", "Testing scripting error");
        this.submit("Add");
        this.checkName();
        this.assertTextPresent("Testing scripting error");
    }

    public void _testEditAssigneeField() {
        this.clickLink("create_link");
        this.selectOption("pid", NEW_PROJECT);
        this.submit("Next");
        this.checkName();
    }

    public void _testAssigneeNavigatorView() {
        this.createIssue(NEW_PROJECT);
        this.clickLink("find_link");
        this.submit("show");
        this.checkName();
    }

    public void _testAssigneeFieldinMoveOperation() {
        this.createIssue(TEST_PROJECT);
        this.clickLink("move-issue");
        this.selectOption("pid", NEW_PROJECT);
        this.submit("Next >>");
        this.checkName();
        this.selectOption("assignee", FULLNAME);
        this.submit("Next >>");
        this.checkName();
    }

    public void _testChangeHistoryTab() {
        this.createIssue(TEST_PROJECT);
        this.logout();
        this.login("alans", "alans");
        this.gotoIssue("TST-1");
        this.clickLink("action_id_5");
        this.setWorkingForm("issue-workflow-transition");
        this.submit("Transition");
        this.clickLinkWithText("History");
        this.checkName();
    }

    public void _testDeveloperWorkloadReport() {
        this.clickLink("create_link");
        this.selectOption("pid", NEW_PROJECT);
        this.submit("Next");
        this.setFormElement("summary", TEST_PROJECT);
        this.setFormElement("timetracking", "1h");
        this.submit("Create");
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:developer-workload");
        this.setFormElement("developer", "alans");
        this.submit("Next");
        this.checkName();
    }

    public void _testWorklogTab() {
        this.clickLink("create_link");
        this.selectOption("pid", NEW_PROJECT);
        this.submit("Next");
        this.setFormElement("summary", TEST_PROJECT);
        this.setFormElement("timetracking", "1h");
        this.submit("Create");
        this.logout();
        this.login("alans", "alans");
        this.gotoIssue("NP-1");
        this.clickLink("log-work");
        this.setFormElement("timeLogged", "1h");
        this.submit();
        this.clickLinkWithText("Work Log");
        this.checkName();
    }

    public void _testUserPickerCustomField() {
        this.clickLink("create_link");
        this.submit("Next");
        this.setFormElement("summary", TEST_PROJECT);
        this.setFormElement("customfield_10000", "alans");
        this.submit("Create");
        this.checkName();
    }

    public void _testReporterInNavigatorView() {
        this.logout();
        this.login("alans", "alans");
        this.createIssue(TEST_PROJECT);
        this.clickLink("find_link");
        this.submit("show");
        this.checkName();
    }

    public void _testWatchersTable() {
        this.logout();
        this.login("alans", "alans");
        this.gotoIssue("TST-1");
        this.clickLink("toggle-watch-issue");
        this.clickLink("view-watcher-list");
        this.checkName();
    }

    public void _testDashboardPortlets() {
        this.logout();
        this.login("alans", "alans");
        this.clickLink("create_link");
        this.submit("Next");
        this.setFormElement("summary", TEST_PROJECT);
        this.setFormElement("customfield_10000", "alans");
        this.submit("Create");
        this.clickLink("home_link");
        this.checkName();
    }

    public void _testReporterInBulkEdit() {
        this.logout();
        this.login("alans", "alans");
        this.clickLink("find_link");
        this.submit("show");
        this.clickLink("bulkedit_all");
        this.checkCheckbox("all", "on");
        this.submit("Next");
        this.checkCheckbox("operation", "bulk.edit.operation.name");
        this.submit("Next");
        this.checkCheckbox("actions", "reporter");
        this.setFormElement("reporter", "alans");
        this.submit("Next");
        this.checkName();
    }

    public void _testMultiUserCustomFieldView() {
        this.clickLink("create_link");
        this.selectOption("pid", TEST_PROJECT);
        this.submit("Next");
        this.setFormElement("summary", "Bug 1");
        this.setFormElement("customfield_10010", "alans");
        this.submit("Create");
        this.checkName();
    }

    public void _testTimeTrackingExcel() {
        this.logout();
        this.login("alans", "alans");
        this.clickLink("create_link");
        this.selectOption("pid", NEW_PROJECT);
        this.submit("Next");
        this.setFormElement("summary", TEST_PROJECT);
        this.setFormElement("timetracking", "1h");
        this.submit("Create");
        this.gotoPage("/secure/ConfigureReport!default.jspa?selectedProjectId=10000&reportKey=com.atlassian.jira.plugin.system.reports:time-tracking");
        this.submit("Next");
        this.clickLinkWithText("Excel View");
        this.checkName();
    }

    private void createIssue(String projectKey) {
        this.clickLink("create_link");
        this.selectOption("pid", projectKey);
        this.submit("Next");
        this.setFormElement("summary", "Bug 1");
        this.submit("Create");
    }

    private void checkName() {
        this.assertTextNotPresent(FULLNAME);
        this.assertTextPresent(ESCAPED_FULLNAME);
    }
}

