/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestShowConstantsHelp
extends JIRAWebTest {
    public TestShowConstantsHelp(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestShowConstantsHelp.xml");
    }

    public void testShowConstantsHelpHasPermission() {
        this.gotoPage("secure/ShowConstantsHelp.jspa");
        this.assertTextPresent("JIRA can be used to track many different types of issues");
    }

    public void testShowConstantsHelpDoesNotHavePermission() {
        this.restoreBlankInstance();
        this.logout();
        this.gotoPage("secure/ShowConstantsHelp.jspa");
        this.assertTextPresent("You are not logged in");
        this.login("admin", "admin");
    }

    public void testShowConstantsHelpSecurityLevels() {
        this.createIssueStep1();
        this.gotoPage("secure/ShowConstantsHelp.jspa");
        this.assertTextPresent("Security Levels");
        this.assertTextPresentBeforeText("Security Level 1", "Only developers are allowed to view this issue");
        this.assertTextPresentBeforeText("Security Level 2", "All users are allowed to view this issue");
    }

    public void testShowConstantsHelpSecurityLevelsSecurity() {
        this.logout();
        this.login("fred");
        this.createIssueStep1();
        this.gotoPage("secure/ShowConstantsHelp.jspa");
        this.assertTextPresent("Security Levels");
        this.assertTextPresentBeforeText("Security Level 2", "All users are allowed to view this issue");
        this.assertTextNotPresent("Security Level 1");
        this.assertTextNotPresent("Only developers are allowed to view this issue");
    }
}

