/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.JIRAWebTest;
import org.junit.Ignore;

@Ignore(value="These tests cannot be fully automated. They require Perforce to be setup and configured.")
public class TestPerforcePlugin
extends JIRAWebTest {
    public TestPerforcePlugin(String name) {
        super(name);
    }

    public void testVerifyPluginInstalled() {
        this.restoreData("TestPerforceData.xml");
        this.gotoAdmin();
        this.clickLink("plugins");
        this.assertTextPresent("Perforce Plugin");
        this.clickLinkWithText("Perforce Plugin");
        this.assertTextPresent("JIRA Perforce Plugin");
    }

    public void testVerifyP4TabDetails() {
        this.restoreData("TestPerforceData.xml");
        this.gotoIssue("TST-1");
        this.assertTextPresent("P4 Changes");
        this.clickLinkWithText("P4 Changes");
        this.assertTextPresent("Change 2 by");
        this.assertTextPresent("Change 7 by");
        this.assertTextPresent("Change 23 by");
        this.assertTextPresent("Change 25 by");
        this.assertTextPresent("Change 29 by");
        this.assertTextPresent("Change - for <a href=\"http://dogbolter:8080/browse/TST-1\" title=\"Test\">TST-1</a>.");
    }

    public void testVerifyP4JobDetails() {
        this.restoreData("TestPerforceData.xml");
        this.createP4CustomField();
        this.gotoIssue("TST-1");
        this.clickLink("editIssue");
        this.assertTextPresent("Create Perforce job");
        this.submit("Update");
        this.assertTextPresent("P4 Job");
        this.assertTextPresent("No Perforce job exists for this issue.");
        this.assertLinkWithTextNotPresent("P4 Job");
    }

    public void testVerifyP4PostFunctionAvailable() {
        this.restoreData("TestPerforceData.xml");
        this.gotoAdmin();
        this.clickLink("workflows");
        this.clickLink("copy_jira");
        this.setFormElement("newWorkflowName", "Test Workflow");
        this.submit("Copy");
        this.setFormElement("newWorkflowName", "");
        this.clickLink("steps_live_Test Workflow");
        this.clickLinkWithText("Open");
        this.clickLinkWithText("Create Issue");
        this.clickLinkWithText("Post Functions");
        this.clickLinkWithText("Add");
        this.checkCheckbox("type", "com.atlassian.jira.plugin.ext.perforce:createjob-function");
        this.submit("Add");
        this.assertTextPresent("Creates a Perforce job for this issue (if required) during a transition.");
    }

    public void testP4JobCreation() {
        this.restoreData("TestPerforceWorkflow.xml");
        this.createP4CustomField();
        this.clickLink("create_link");
        this.submit("Next");
        this.setFormElement("summary", "Test");
        this.assertTextPresent("Create Perforce job");
        this.submit("Create");
        this.assertTextPresent("P4 Job:");
        this.assertTextPresent("Perforce job exists");
        this.clickLinkWithText("P4 Job");
        this.assertTextPresent("This shows all of the change lists associated with this issue's Perforce job");
    }

    public void testP4JobHiddenCreation() {
        this.restoreData("TestPerforceWorkflow.xml");
        this.createHiddenP4CustomField();
        this.clickLink("create_link");
        this.submit("Next");
        this.setFormElement("summary", "Test");
        this.assertTextNotPresent("Create Perforce job");
        this.submit("Create");
        this.assertTextPresent("P4 Job:");
        this.assertTextPresent("Perforce job exists");
        this.clickLinkWithText("P4 Job");
        this.assertTextPresent("This shows all of the change lists associated with this issue's Perforce job");
    }

    public void testP4IssueNavColumns() {
        this.restoreData("TestPerforceNav.xml");
        this.clickLink("find_link");
        this.submit("show");
        this.clickLinkWithText("Configure");
        this.selectOption("fieldId", "P4 Job");
        this.submit("add");
        this.assertTextPresent("P4 Job");
        this.clickLink("find_link");
        this.selectOption("customfield_10000", "with or without");
        this.submit("show");
        this.assertTextPresent("<a href=\"/browse/TST-1\">TST-1</a>");
        this.assertTextPresent("<a href=\"/browse/TST-2\">TST-2</a>");
        this.assertTextPresent("No Perforce job exists for this issue.");
        this.assertTextPresent("Perforce job exists");
        this.assertTextPresent("<a href=\"/browse/TST-1?page=com.atlassian.jira.plugin.ext.perforce:perforce-job-tabpanel\">view details</a>.");
        this.selectOption("customfield_10000", "with");
        this.submit("show");
        this.assertTextPresent("<a href=\"/browse/TST-1\">TST-1</a>");
        this.assertTextPresent("Perforce job exists");
        this.assertTextPresent("<a href=\"/browse/TST-1?page=com.atlassian.jira.plugin.ext.perforce:perforce-job-tabpanel\">view details</a>.");
        this.assertTextNotPresent("<a href=\"/browse/TST-2\">TST-2</a>");
        this.assertTextNotPresent("No Perforce job exists for this issue.");
        this.selectOption("customfield_10000", "without");
        this.submit("show");
        this.assertTextNotPresent("<a href=\"/browse/TST-1\">TST-1</a>");
        this.assertTextNotPresent("<a href=\"/browse/TST-1?page=com.atlassian.jira.plugin.ext.perforce:perforce-job-tabpanel\">view details</a>.");
        this.assertTextPresent("<a href=\"/browse/TST-2\">TST-2</a>");
        this.assertTextPresent("No Perforce job exists for this issue.");
    }

    private void createP4CustomField() {
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.ext.perforce:jobcheckbox");
        this.submit("nextBtn");
        this.setFormElement("fieldName", "P4 Job");
        this.submit("nextBtn");
        this.checkCheckbox("associatedScreens", "1");
        this.submit("Update");
        this.assertTextPresent("P4 Job");
        this.assertTextPresent("Job Checkbox");
    }

    private void createHiddenP4CustomField() {
        this.gotoAdmin();
        this.clickLink("view_custom_fields");
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.ext.perforce:hiddenjobswitch");
        this.submit("nextBtn");
        this.setFormElement("fieldName", "Hidden P4 Job");
        this.submit("nextBtn");
        this.checkCheckbox("associatedScreens", "1");
        this.submit("Update");
        this.assertTextPresent("Hidden P4 Job");
        this.assertTextPresent("Hidden Job Switch");
    }
}

