/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.misc;

import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class TestForgotLoginDetails
extends EmailFuncTestCase {
    @Override
    protected void setUpTest() {
        this.navigation.login("admin");
        this.administration.restoreBlankInstance();
        this.configureAndStartSmtpServer();
    }

    public void testShouldBlockResettingLoginDetailsIfExternalUserManagementIsOn() {
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.assertLinkNotPresent("Can't access your account?");
    }

    public void testShouldBlockResettingLoginDetailsIfExternalPasswordManagementIsOn() {
        this.administration.generalConfiguration().setExternalPasswordManagement(true);
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.assertLinkNotPresent("Can't access your account?");
    }

    public void testShouldFailWhenTheActionIsInvokedDirectlyIfExternalUserManagementIsOn() {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.tester.gotoPage("secure/ForgotLoginDetails.jspa");
        this.text.assertTextPresent(this.locator.page(), "User login details can not be reset for this JIRA site.");
    }

    public void testShouldFailWhenTheActionIsInvokedDirectlyIfExternalPasswordManagementIsOn() {
        this.tester.getDialog().getWebClient().setExceptionsThrownOnErrorStatus(false);
        this.administration.generalConfiguration().setExternalPasswordManagement(true);
        this.tester.gotoPage("secure/ForgotLoginDetails.jspa");
        this.text.assertTextPresent(this.locator.page(), "User login details can not be reset for this JIRA site.");
    }

    public void testDefaultOptionIsForgotPassword() throws Exception {
        this.gotoForgotLoginDetails();
        TestForgotLoginDetails.assertEquals((String)"checked", (String)this.xpath("//*[@id='forgot-login-rb-forgot-password']/attribute::checked").getText());
    }

    public void testForgotPasswordValidatesNonExistingUserNamesAndEmails() {
        this.gotoForgotLoginDetails();
        this.tester.setFormElement("forgotten", "forgotPassword");
        this.tester.setFormElement("username", "nobody");
        this.tester.submit();
        this.tester.assertTextPresent("No user with that username exists");
        this.tester.setFormElement("forgotten", "forgotUserName");
        this.tester.setFormElement("email", "nobody");
        this.tester.submit();
        this.tester.assertTextPresent("No user with that email address exists");
        this.tester.gotoPage("secure/ForgotLoginDetails.jspa");
        this.tester.assertTextPresent("If you can't access JIRA, fill in this form and an email will be sent to you with the details to access your account again.");
    }

    public void testEmailGeneratedAndResetWhileLoggedOut() throws InterruptedException, IOException, MessagingException {
        String tokenUrl = this.generateTokenAndGotoResetPage("admin", 1);
        this.navigation.logout();
        this.tester.gotoPage(tokenUrl);
        this.text.assertTextPresent(this.locator.id("reset-password-user-name"), "admin");
        this.tester.setFormElement("password", "");
        this.tester.setFormElement("confirm", "");
        this.tester.submit("Reset");
        this.tester.assertTextPresent("The password must not be blank");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "FAIL");
        this.tester.submit("Reset");
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.assertTextPresent("Reset Password");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.submit("Reset");
        this.tester.assertTextPresent("Your password has been reset");
        this.tester.clickLinkWithText("log in");
    }

    public void testEmailGeneratedAndResetWhileLoggedIn() throws InterruptedException, IOException, MessagingException {
        String tokenUrl = this.generateTokenAndGotoResetPage("admin", 1);
        this.tester.gotoPage(tokenUrl);
        this.text.assertTextPresent(this.locator.id("reset-password-user-name"), "admin");
        this.tester.assertTextPresent("Reset Password");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.submit("Reset");
        this.tester.assertTextPresent("Your password has been reset");
        this.tester.clickLinkWithText("use JIRA");
    }

    public void testResetPasswordEmailIsSentToUserNamesWithSpaces() throws MessagingException, IOException, InterruptedException {
        String user = "joe t";
        this.administration.usersAndGroups().addUser("joe t", "joe t", "Joe Thomas", "joet@example.com");
        this.checkEmailFor_joe_t(1);
        this.navigation.login("joe t");
        this.gotoForgotLoginDetails();
        this.tester.setFormElement("forgotten", "forgotPassword");
        this.tester.setFormElement("username", "joe t");
        this.tester.submit();
        this.checkEmailFor_joe_t(2);
    }

    private void checkEmailFor_joe_t(int messages) throws InterruptedException, IOException, MessagingException {
        this.navigation.login("admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestForgotLoginDetails.assertEquals((int)messages, (int)mimeMessages.length);
        String body = mimeMessages[messages - 1].getContent().toString();
        TestForgotLoginDetails.assertTrue((boolean)body.contains("ResetPassword!default.jspa?os_username=joe+t"));
        TestForgotLoginDetails.assertTrue((boolean)body.contains("ForgotLoginDetails.jspa?username=joe+t"));
    }

    public void testBadInputOnResetPasswordAction() throws IOException, MessagingException, InterruptedException {
        this.tester.gotoPage("secure/ResetPassword!default.jspa?os_username=baduser&token=3DB7FA2C8DF56A3128B5692B2C7652D");
        this.tester.assertTextPresent("The user cannot be found");
        this.tester.submit("Reset");
        this.tester.assertTextPresent("The user cannot be found");
        this.tester.assertTextPresent("The password must not be blank");
        this.tester.gotoPage("secure/ResetPassword!default.jspa?os_username=admin&token=3DB7FA2C8DF56A3128B5692B2C7652D");
        this.tester.assertTextPresent("The reset password token you have provided has timed out.");
        this.text.assertTextPresent(this.locator.id("reset-password-get-new-token"), "You can get a new token here.");
        this.tester.clickLink("reset-password-get-new-token-link");
        this.tester.assertTextPresent("Can't access your account?");
        this.tester.assertTextPresent("If you can't access JIRA, fill in this form and an email will be sent to you with the details to access your account again.");
        String tokenUrl1 = this.generateTokenAndGotoResetPage("admin", 1);
        this.generateTokenAndGotoResetPage("admin", 2);
        this.tester.gotoPage(tokenUrl1);
        this.tester.assertTextPresent("The reset password token you have provided is no longer valid");
        this.tester.clickLink("reset-password-get-new-token-link");
        this.tester.assertTextPresent("Can't access your account?");
        this.tester.assertTextPresent("If you can't access JIRA, fill in this form and an email will be sent to you with the details to access your account again.");
    }

    private String generateTokenAndGotoResetPage(String userName, int expectedMails) throws InterruptedException, IOException, MessagingException {
        this.gotoForgotLoginDetails();
        this.tester.setFormElement("forgotten", "forgotPassword");
        this.tester.setFormElement("username", userName);
        this.tester.submit();
        this.tester.assertTextPresent("A reset password link has been sent to you via email.");
        this.navigation.login("admin");
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.getGreenMail().getReceivedMessages();
        TestForgotLoginDetails.assertEquals((int)expectedMails, (int)mimeMessages.length);
        String body = mimeMessages[expectedMails - 1].getContent().toString();
        TestForgotLoginDetails.assertTrue((boolean)body.contains("you will be able to personally reset your password"));
        Pattern urlPattern = Pattern.compile("(secure/ResetPassword!default\\.jspa\\?os_username=" + userName + "&token=.*)", 8);
        Matcher matcher = urlPattern.matcher(body);
        TestForgotLoginDetails.assertTrue((boolean)matcher.find());
        TestForgotLoginDetails.assertEquals((int)1, (int)matcher.groupCount());
        return matcher.group(0);
    }

    private void gotoForgotLoginDetails() {
        this.navigation.logout();
        this.tester.gotoPage("login.jsp");
        this.tester.clickLinkWithText("Can't access your account?");
        this.tester.assertTextPresent("Can't access your account?");
        this.tester.assertTextPresent("If you can't access JIRA, fill in this form and an email will be sent to you with the details to access your account again.");
    }
}

