/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.license;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.LicenseKeys;

public class TestViewLicense
extends FuncTestCase {
    private static final String LICENSE_INPUT_FIELD = "license";
    private static final String INVALID_LICENSE = "abc";

    public void testUpdateLicenseWithBlankLicense() {
        this.gotoViewLicense();
        this.submitLicense("");
        this.tester.assertTextPresent("Invalid license key specified.");
        this.tester.assertFormElementEquals(LICENSE_INPUT_FIELD, "");
    }

    public void testUpdateLicenseWithInvalidLicense() {
        this.gotoViewLicense();
        this.submitLicense(INVALID_LICENSE);
        this.tester.assertTextPresent("Invalid license key specified.");
        this.tester.assertFormElementEquals(LICENSE_INPUT_FIELD, INVALID_LICENSE);
    }

    public void testUpdateLicenseV1Enterprise() {
        this.assertLicenseVersion1NotAccepted(LicenseKeys.V1_ENTERPRISE);
    }

    public void testUpdateLicenseV2Commercial() {
        this.assertLicenseVersion2Accepted(LicenseKeys.V2_COMMERCIAL);
    }

    public void testUpdateLicenseV2Starter() {
        this.assertLicenseVersion2Accepted(LicenseKeys.V2_STARTER);
    }

    public void testUpdateLicenseV2OpenSource() {
        this.assertLicenseVersion2Accepted(LicenseKeys.V2_OPEN_SOURCE);
    }

    public void testUpdateLicenseV2Developer() {
        this.assertLicenseVersion2Accepted(LicenseKeys.V2_DEVELOPER_LIMITED);
    }

    private void assertLicenseVersion2Accepted(LicenseKeys.License license) {
        this.gotoViewLicense();
        this.submitLicense(license.getLicenseString());
        this.tester.setWorkingForm("jiraform");
        XPathLocator locator = new XPathLocator(this.tester, "//span[@class='errMsg']");
        TestViewLicense.assertEquals((String)"There should not be any error messages", (int)0, (int)locator.getNodes().length);
        String licenseString = this.tester.getDialog().getForm().getParameterValue(LICENSE_INPUT_FIELD);
        TestViewLicense.assertEquals((String)"The license input field should be reset to blank", (String)"", (String)licenseString);
        locator = new XPathLocator(this.tester, "//table[@id='license_table']");
        this.text.assertTextSequence(locator, "Organisation", license.getOrganisation());
        this.text.assertTextSequence(locator, "License Type", license.getDescription());
        this.text.assertTextSequence(locator, "Support Entitlement Number", license.getSen());
    }

    private void assertLicenseVersion1NotAccepted(LicenseKeys.License license) {
        this.gotoViewLicense();
        this.submitLicense(license.getLicenseString());
        this.tester.setWorkingForm("jiraform");
        XPathLocator locator = new XPathLocator(this.tester, "//span[@class='errMsg']");
        TestViewLicense.assertEquals((String)"There should be 1 error message", (int)1, (int)locator.getNodes().length);
        this.text.assertTextPresent(locator, "This license version (v1) is incompatible with this JIRA installation. Please get a new license or generate an evaluation license");
        String licenseString = this.tester.getDialog().getForm().getParameterValue(LICENSE_INPUT_FIELD);
        TestViewLicense.assertEquals((String)"The license input field should be the input licensed", (String)license.getLicenseString(), (String)licenseString);
    }

    private void gotoViewLicense() {
        this.navigation.gotoAdmin();
        this.tester.clickLink("license_details");
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextSequence(locator, new String[]{"Copy and paste the license key below.", "You can access your license key on", "My Account"});
    }

    private void submitLicense(String license) {
        this.tester.setWorkingForm("jiraform");
        this.tester.setFormElement(LICENSE_INPUT_FIELD, license);
        this.tester.submit();
    }
}

