/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue.move;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestRedirectToMovedIssues
extends JIRAWebTest {
    public TestRedirectToMovedIssues(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestRedirectToMovedIssues.xml");
    }

    public void testRedirectToMovedIssueBrowse() {
        this.gotoPage("/browse/MKY-1");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/browse/HSP-2"));
        this.assertTextPresent("Create Issue");
        this.assertTextPresent("Test Bug 2");
    }

    public void testRedirectToMovedIssueXML() {
        this.gotoPage("/si/jira.issueviews:issue-xml/MKY-1/MKY-1.xml");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/si/jira.issueviews:issue-xml/HSP-2/HSP-2.xml"));
        this.assertTextPresent("This file is an XML representation of an issue");
        this.assertTextPresent("Test Bug 2");
    }

    public void testRedirectToMovedIssuePrintable() {
        this.gotoPage("/si/jira.issueviews:issue-html/MKY-1/MKY-1.html");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/si/jira.issueviews:issue-html/HSP-2/HSP-2.html"));
        this.assertTextPresent("&lt;&lt; Back to previous view");
        this.assertTextPresent("Test Bug 2");
    }

    public void testRedirectToMovedIssueWord() {
        this.gotoPage("/si/jira.issueviews:issue-word/MKY-1/MKY-1.doc");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/si/jira.issueviews:issue-word/HSP-2/HSP-2.doc"));
        this.assertTextPresent("application/vnd.ms-word");
        this.assertTextPresent("Test Bug 2");
    }

    public void testRedirectToTwiceMovedIssue() {
        this.gotoPage("/browse/HSP-1");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/browse/HSP-3"));
        this.gotoPage("/browse/MKY-2");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/browse/HSP-3"));
        this.gotoPage("/si/jira.issueviews:issue-xml/HSP-1/HSP-1.xml");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/si/jira.issueviews:issue-xml/HSP-3/HSP-3.xml"));
        this.gotoPage("/si/jira.issueviews:issue-xml/MKY-2/MKY-2.xml");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/si/jira.issueviews:issue-xml/HSP-3/HSP-3.xml"));
    }

    public void testRedirectToMovedIssueBrowseWithQueryString() {
        this.gotoPage("/browse/MKY-1?key=value");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/browse/HSP-2?key=value"));
    }

    public void testRedirectToMovedIssueXMLWithQueryString() {
        this.gotoPage("/si/jira.issueviews:issue-html/MKY-1/MKY-1.html?key1=value1&key2=value2");
        TestRedirectToMovedIssues.assertTrue((boolean)this.getRedirect().endsWith("/si/jira.issueviews:issue-html/HSP-2/HSP-2.html?key1=value1&key2=value2"));
    }
}

