/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.sourceforge.jwebunit.WebTester;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class TestSearchXmlView
extends FuncTestCase {
    public void testFilterAllIssues() throws IOException, DocumentException {
        this.administration.restoreData("TestXMLIssueView.xml");
        long filterId = this.createFilterForAllIssues();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=200");
        Document doc = this.getDocument(this.tester);
        XPath xpath = DocumentHelper.createXPath((String)"//item/title");
        List nodes = xpath.selectNodes((Object)doc);
        TestSearchXmlView.assertEquals((int)3, (int)nodes.size());
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(0)).getText().startsWith("[MKY-1]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(1)).getText().startsWith("[HSP-2]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(2)).getText().startsWith("[HSP-1]"));
    }

    public void testFilterAllIssuesWithCustomSort() throws IOException, DocumentException {
        this.administration.restoreData("TestXMLIssueView.xml");
        long filterId = this.createFilterForAllIssues();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=200&sorter/field=issuekey&sorter/order=ASC");
        Document doc = this.getDocument(this.tester);
        XPath xpath = DocumentHelper.createXPath((String)"//item/title");
        List nodes = xpath.selectNodes((Object)doc);
        TestSearchXmlView.assertEquals((int)3, (int)nodes.size());
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(0)).getText().startsWith("[HSP-1]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(1)).getText().startsWith("[HSP-2]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(2)).getText().startsWith("[MKY-1]"));
    }

    public void testFilterAllIssuesWithCustomSortAndPaging() throws IOException, DocumentException {
        this.administration.restoreData("TestXMLIssueView.xml");
        long filterId = this.createFilterForAllIssues();
        this.tester.gotoPage("/sr/jira.issueviews:searchrequest-xml/" + filterId + "/SearchRequest-" + filterId + ".xml?tempMax=2&sorter/field=issuekey&sorter/order=ASC&pager/start=1");
        Document doc = this.getDocument(this.tester);
        XPath xpath = DocumentHelper.createXPath((String)"//item/title");
        List nodes = xpath.selectNodes((Object)doc);
        TestSearchXmlView.assertEquals((int)2, (int)nodes.size());
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(0)).getText().startsWith("[HSP-2]"));
        TestSearchXmlView.assertTrue((boolean)((Element)nodes.get(1)).getText().startsWith("[MKY-1]"));
    }

    private long createFilterForAllIssues() {
        IssueNavigatorNavigation issueNav = this.navigation.issueNavigator();
        issueNav.createSearch(new NavigatorSearch(Collections.EMPTY_LIST));
        return issueNav.saveCurrentAsNewFilter("All Issues", "Shows all issues", false, Collections.singleton(new GroupTestSharingPermission("jira-users")));
    }

    private Document getDocument(WebTester tester) throws IOException, DocumentException {
        SAXReader reader = new SAXReader();
        return reader.read(tester.getDialog().getResponse().getInputStream());
    }
}

