/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;

public class TestNextPreviousPager
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("BigIssueSet.xml");
    }

    public void testPager() {
        this.navigation.issueNavigator().loadFilter(10011L, null);
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Issue Navigator \u2014 No Issues");
        this.text.assertTextPresent(locator, "No matching issues found.");
        this.navigation.issue().viewIssue("TEST-1");
        locator = new WebPageLocator(this.tester);
        this.tester.assertLinkNotPresent("previous-issue");
        this.tester.clickLink("find_link");
        locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Issue Navigator \u2014 No Issues");
        this.text.assertTextPresent(locator, "No matching issues found.");
        this.navigation.issueNavigator().loadFilter(10012L, null);
        locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Issue Navigator \u2014 11 Issues");
        this.text.assertTextPresent(locator, "Displaying issues 1 to 11 of 11 matching issues.");
        this.assertPagerListForwards("11 Issues", "TEST-99", "TEST-990", "TEST-991", "TEST-992", "TEST-993", "TEST-994", "TEST-995", "TEST-996", "TEST-997", "TEST-998", "TEST-999");
        this.navigation.issueNavigator().loadFilter(10011L, null);
        this.navigation.issue().viewIssue("TEST-99");
        this.navigation.issueNavigator().loadFilter(10012L, null);
        this.assertPagerListBackwards("11 Issues", "TEST-99", "TEST-990", "TEST-991", "TEST-992", "TEST-993", "TEST-994", "TEST-995", "TEST-996", "TEST-997", "TEST-998", "TEST-999");
        this.tester.gotoPage("/secure/EditIssue!default.jspa?id=11168");
        this.tester.setFormElement("summary", "NEW SUMMARY for TEST-99");
        this.assertPagerListForwards("11 Issues", "TEST-99", "TEST-990", "TEST-991", "TEST-992", "TEST-993", "TEST-994", "TEST-995", "TEST-996", "TEST-997", "TEST-998", "TEST-999");
        this.navigation.issueNavigator().loadFilter(10013L, null);
        this.navigation.issue().viewIssue("TEST-1");
        this.assertPager("TEST-1", "57 Issues", 57, 1);
        this.navigation.issue().viewIssue("TEST-163");
        this.assertPager("TEST-163", "57 Issues", 57, 20);
        this.tester.clickLink("next-issue");
        this.navigation.issue().viewIssue("TEST-164");
        this.assertPager("TEST-164", "57 Issues", 57, 21);
        this.navigation.issueNavigator().loadFilter(10011L, null);
        this.navigation.issue().viewIssue("TEST-99");
        this.navigation.issueNavigator().loadFilter(10013L, null);
        this.navigation.issue().viewIssue("TEST-1");
        this.assertPager("TEST-1", "57 Issues", 57, 1);
        this.tester.gotoPage("/secure/EditIssue!default.jspa?id=11168");
        this.tester.setFormElement("summary", "Yet Another NEW SUMMARY for TEST-99");
        this.navigation.issue().viewIssue("TEST-183");
        this.assertPager("TEST-183", "57 Issues", 57, 40);
    }

    private void assertPagerListForwards(String filterName, String ... keys) {
        int i;
        this.navigation.issue().viewIssue(keys[0]);
        for (i = 0; i < keys.length; ++i) {
            this.assertPager(keys[i], filterName, keys.length, i + 1);
            if (i == keys.length - 1) continue;
            this.tester.clickLink("next-issue");
        }
        for (i = keys.length; i > 0; --i) {
            this.assertPager(keys[i - 1], filterName, keys.length, i);
            if (i == 1) continue;
            this.tester.clickLink("previous-issue");
        }
    }

    private void assertPagerListBackwards(String filterName, String ... keys) {
        int i;
        this.navigation.issue().viewIssue(keys[keys.length - 1]);
        for (i = keys.length; i > 0; --i) {
            this.assertPager(keys[i - 1], filterName, keys.length, i);
            if (i == 1) continue;
            this.tester.clickLink("previous-issue");
        }
        for (i = 0; i < keys.length; ++i) {
            this.assertPager(keys[i], filterName, keys.length, i + 1);
            if (i == keys.length - 1) continue;
            this.tester.clickLink("next-issue");
        }
    }

    private void assertPager(String key, String filter, int total, int position) {
        WebPageLocator locator = new WebPageLocator(this.tester);
        this.text.assertTextPresent(locator, "Test issue " + key);
        this.tester.assertLinkPresent("return-to-search");
        if (position == 1) {
            this.tester.assertLinkNotPresent("previous-issue");
        } else {
            this.text.assertTextSequence(locator, "Previous Issue", position + " of " + total);
            this.tester.assertLinkPresent("previous-issue");
        }
        if (position == total) {
            this.tester.assertLinkNotPresent("next-issue");
        } else {
            this.text.assertTextSequence(locator, position + " of " + total, "Next Issue");
            this.tester.assertLinkPresent("next-issue");
        }
    }
}

