/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueViews
extends JIRAWebTest {
    public TestIssueViews(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueViews.xml");
    }

    public void testViewLinksChangeForModifiedFilter() {
        this.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10000");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-printable/10000/SearchRequest-10000.html");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-fullcontent/10000/SearchRequest-10000.html");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.xml?");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-word/temp/SearchRequest.xml?");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.xml?");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xml?");
        this.gotoPage("/secure/IssueNavigator.jspa?mode=hide&requestId=10000&sorter/field=summary&sorter/order=DESC");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-rss/10000/SearchRequest-10000.xml");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-comments-rss/10000/SearchRequest-10000.xml");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-printable/10000/SearchRequest-10000.html");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-word/10000/SearchRequest-10000.doc");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-fullcontent/10000/SearchRequest-10000.html");
        this.assertTextNotPresent("/sr/jira.issueviews:searchrequest-excel-current-fields/10000/SearchRequest-10000.xls");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-xml/temp/SearchRequest.xml?");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-rss/temp/SearchRequest.xml?");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-comments-rss/temp/SearchRequest.xml?");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-printable/temp/SearchRequest.html?");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-word/temp/SearchRequest.doc?");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-fullcontent/temp/SearchRequest.html?");
        this.assertTextPresent("/sr/jira.issueviews:searchrequest-excel-current-fields/temp/SearchRequest.xls?");
    }

    public void testPermissionErrorWithGzipEnabled() {
        this.getAdministration().generalConfiguration().turnOnGZipCompression();
        this.getNavigation().issue().viewIssue("HSP-1");
        this.getNavigation().logout();
        this.getNavigation().gotoPage("/si/jira.issueviews:issue-html/HSP-1/HSP-1.html");
        this.assertTextPresent("You cannot view this page as a guest.");
    }

    public void testEnableDisableIssueViewsPlugin() {
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertLinkPresent("rssIssues");
        this.assertLinkPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertLinkPresent("allExcelFields");
        this.assertLinkPresent("currentExcelFields");
        this.togglePluginModule(false, "printable");
        this.displayAllIssues();
        this.assertLinkNotPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertLinkPresent("rssIssues");
        this.assertLinkPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertLinkPresent("allExcelFields");
        this.assertLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "printable");
        this.togglePluginModule(false, "fullcontent");
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkNotPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertLinkPresent("rssIssues");
        this.assertLinkPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertLinkPresent("allExcelFields");
        this.assertLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "fullcontent");
        this.togglePluginModule(false, "xml");
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkNotPresent("xml");
        this.assertLinkPresent("rssIssues");
        this.assertLinkPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertLinkPresent("allExcelFields");
        this.assertLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "xml");
        this.togglePluginModule(false, "rss");
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertLinkNotPresent("rssIssues");
        this.assertLinkPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertLinkPresent("allExcelFields");
        this.assertLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "rss");
        this.togglePluginModule(false, "comments-rss");
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertLinkPresent("rssIssues");
        this.assertLinkNotPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertLinkPresent("allExcelFields");
        this.assertLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "comments-rss");
        this.togglePluginModule(false, "word");
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertLinkPresent("rssIssues");
        this.assertLinkPresent("rssComments");
        this.assertLinkNotPresent("word");
        this.assertLinkPresent("allExcelFields");
        this.assertLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "word");
        this.togglePluginModule(false, "excel-all-fields");
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertLinkPresent("rssIssues");
        this.assertLinkPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertLinkNotPresent("allExcelFields");
        this.assertLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "excel-all-fields");
        this.togglePluginModule(false, "excel-current-fields");
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertLinkPresent("rssIssues");
        this.assertLinkPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertLinkPresent("allExcelFields");
        this.assertLinkNotPresent("currentExcelFields");
        this.togglePluginModule(true, "excel-current-fields");
        this.togglePluginModule(false, "rss");
        this.togglePluginModule(false, "comments-rss");
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertTextNotPresent("| RSS");
        this.assertLinkNotPresent("rssIssues");
        this.assertLinkNotPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertLinkPresent("allExcelFields");
        this.assertLinkPresent("currentExcelFields");
        this.togglePluginModule(true, "rss");
        this.togglePluginModule(true, "comments-rss");
        this.togglePluginModule(false, "excel-all-fields");
        this.togglePluginModule(false, "excel-current-fields");
        this.displayAllIssues();
        this.assertLinkPresent("printable");
        this.assertLinkPresent("fullContent");
        this.assertLinkPresent("xml");
        this.assertLinkPresent("rssIssues");
        this.assertLinkPresent("rssComments");
        this.assertLinkPresent("word");
        this.assertTextNotPresent("| Excel");
        this.assertLinkNotPresent("allExcelFields");
        this.assertLinkNotPresent("currentExcelFields");
        this.togglePluginModule(true, "excel-all-fields");
        this.togglePluginModule(true, "excel-current-fields");
    }

    private void togglePluginModule(boolean enable, String module) {
        if (enable) {
            this.administration.plugins().enablePluginModule("jira.issueviews", "jira.issueviews:searchrequest-" + module);
        } else {
            this.administration.plugins().disablePluginModule("jira.issueviews", "jira.issueviews:searchrequest-" + module);
        }
    }
}

