/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.util.env.EnvironmentUtils;

public class TestIssueTabPanels
extends FuncTestCase {
    private final String commentLorem = "Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.";
    private static final String SORT_ICON_CONTAINER_LOCATOR = "//*[@id='activitymodule']//div[contains(concat(' ', normalize-space(@class), ' '), ' sortwrap ')]";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueTabPanels.xml");
    }

    public void testShouldDefaultToCommentsTab() {
        this.navigation.issue().viewIssue("MKY-1");
        this.text.assertTextPresent(this.locator.page(), "Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.");
    }

    public void testSelectedTabPanelIsStickyDuringTheSession() {
        this.navigation.issue().viewIssue("MKY-1");
        this.tester.clickLinkWithText("History");
        this.navigation.issue().viewIssue("MKY-1");
        TestIssueTabPanels.assertTrue((String)"Did not remember that we clicked on the 'History' panel.", (boolean)this.locator.css("#changehistory-tabpanel.active").exists());
        TestIssueTabPanels.assertFalse((String)"The comments panel should not be active.", (boolean)this.locator.css("#comment-tabpanel.active").exists());
    }

    public void testViewDefaultPanelWhenRequestedPanelDoesNotExist() {
        this.tester.gotoPage("browse/MKY-1?page=unknown");
        this.text.assertTextPresent(this.locator.id("issue_actions_container"), "Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.");
        this.text.assertTextNotPresent(this.locator.page(), "An unknown error occurred - actions == null. Please see logs for more details.");
    }

    public void testViewDefaultPanelWhenPanelPermissionsChange() {
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.clickLinkWithText("Version Control");
        this.navigation.issue().gotoIssue("HSP-1");
        this.text.assertTextPresent(this.locator.page(), "There are no comments yet on this issue.");
    }

    public void testSortOrdering() throws Exception {
        boolean isOracle = new EnvironmentUtils(this.tester, this.getEnvironmentData(), this.navigation).isOracle();
        String[] ascComments = new String[]{"This is the first comment.", "This is the second comment.", "This is the third comment."};
        String[] descComments = new String[]{"This is the third comment.", "This is the second comment.", "This is the first comment."};
        String[] ascChangeItems = new String[]{"Status", "Open", "In Progress", "Status", "In Progress", "Open"};
        String[] descChangeItems = new String[]{"Status", "In Progress", "Open", "Status", "Open", "In Progress"};
        for (String comment : ascComments) {
            this.navigation.issue().addComment("HSP-1", comment);
            if (!isOracle) continue;
            Thread.sleep(2000L);
        }
        this.tester.clickLinkWithText("Start Progress");
        if (isOracle) {
            Thread.sleep(2000L);
        }
        this.tester.clickLinkWithText("Stop Progress");
        this.text.assertTextSequence(this.locator.page(), ascComments);
        this.tester.clickLinkWithText("History");
        this.text.assertTextSequence(this.locator.page(), ascChangeItems);
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLinkWithText("Ascending order");
        this.text.assertTextSequence(this.locator.page(), descChangeItems);
        this.tester.clickLinkWithText("Comments");
        this.text.assertTextSequence(this.locator.page(), descComments);
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLinkWithText("Descending order");
        this.text.assertTextSequence(this.locator.page(), ascComments);
        this.tester.clickLinkWithText("History");
        this.text.assertTextSequence(this.locator.page(), ascChangeItems);
    }

    public void testSortOrderIsShownForIssueTabs() {
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aall-tabpanel");
        this.text.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Ascending order");
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Achangehistory-tabpanel");
        this.text.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Ascending order");
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel");
        this.text.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Ascending order");
        this.tester.gotoPage("browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel");
        this.text.assertTextPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Ascending order");
        this.tester.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aall-tabpanel");
        this.text.assertTextNotPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Ascending order");
        this.tester.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Achangehistory-tabpanel");
        this.text.assertTextNotPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Ascending order");
        this.tester.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel");
        this.text.assertTextNotPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Ascending order");
        this.tester.gotoPage("browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel");
        this.text.assertTextNotPresent(this.locator.xpath(SORT_ICON_CONTAINER_LOCATOR), "Ascending order");
    }

    public void testPermalinking() {
        this.navigation.gotoDashboard();
        this.navigation.logout();
        String worklogPermalink = "/browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel#worklog-10001";
        String worklogLorem = "Cras hendrerit porta tortor. Ut varius";
        String commentPermalink = "/browse/MKY-1?focusedCommentId=10001&page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel#comment-10001";
        this.tester.gotoPage("/browse/MKY-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aworklog-tabpanel#worklog-10001");
        this.text.assertTextPresent(this.locator.page(), "Cras hendrerit porta tortor. Ut varius");
        this.navigation.gotoDashboard();
        this.tester.gotoPage("/browse/MKY-1?focusedCommentId=10001&page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel#comment-10001");
        this.text.assertTextPresent(this.locator.page(), "Nulla pulvinar leo et eros. Vestibulum tortor. Aenean aliquam odio a neque.");
    }
}

