/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueSecurityWithRoles
extends JIRAWebTest {
    private static final String HSP_ISSUE_NO_SECURITY = "HSP-1";
    private static final String HSP_ISSUE_DEV_ROLE_SECURITY = "HSP-2";
    private static final String HSP_ISSUE_ADMIN_ROLE_SECURITY = "HSP-3";
    private static final String MKY_ISSUE_NO_SECURITY = "MKY-1";
    private static final String MKY_ISSUE_DEV_ROLE_SECURITY = "MKY-2";
    private static final String ELE_ISSUE_NO_SECURITY = "ELE-1";
    private static final String ELE_ISSUE_DEV_ROLE_SECURITY = "ELE-2";

    public TestIssueSecurityWithRoles(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueSecurityWithRoles.xml");
    }

    public void testIssueSecurityWithRolesIssueNavigator() {
        this.displayAllIssues();
        this.assertLinkPresentWithText(HSP_ISSUE_NO_SECURITY);
        this.assertLinkPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.gotoIssue(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.assertTextNotPresent("Permission Violation");
        this.logout();
        this.login("fred", "fred");
        this.displayAllIssues();
        this.assertLinkPresentWithText(HSP_ISSUE_NO_SECURITY);
        this.assertLinkNotPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.gotoIssue(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.assertTextPresent("Permission Violation");
    }

    public void testIssueSecurityWithRolesMultiProject() {
        this.displayAllIssues();
        this.assertLinkPresentWithText(HSP_ISSUE_NO_SECURITY);
        this.assertLinkPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.assertLinkPresentWithText(MKY_ISSUE_NO_SECURITY);
        this.assertLinkPresentWithText(MKY_ISSUE_DEV_ROLE_SECURITY);
        this.assertLinkPresentWithText(ELE_ISSUE_NO_SECURITY);
        this.assertLinkPresentWithText(ELE_ISSUE_DEV_ROLE_SECURITY);
        this.gotoIssue(ELE_ISSUE_DEV_ROLE_SECURITY);
        this.assertTextNotPresent("Permission Violation");
        this.logout();
        this.login("fred", "fred");
        this.displayAllIssues();
        this.assertLinkPresentWithText(HSP_ISSUE_NO_SECURITY);
        this.assertLinkNotPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.assertLinkPresentWithText(MKY_ISSUE_NO_SECURITY);
        this.assertLinkNotPresentWithText(MKY_ISSUE_DEV_ROLE_SECURITY);
        this.assertLinkPresentWithText(ELE_ISSUE_NO_SECURITY);
        this.assertLinkNotPresentWithText(ELE_ISSUE_DEV_ROLE_SECURITY);
        this.gotoIssue(ELE_ISSUE_DEV_ROLE_SECURITY);
        this.assertTextPresent("Permission Violation");
    }

    public void testIssueSecurityWithRolesEditIssueFields() {
        this.displayAllIssues();
        this.assertLinkPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.assertLinkPresentWithText(HSP_ISSUE_ADMIN_ROLE_SECURITY);
        this.gotoIssue(HSP_ISSUE_ADMIN_ROLE_SECURITY);
        this.clickLink("editIssue");
        this.setWorkingForm("issue-edit");
        this.assertOptionsEqualIgnoreOrder("security", new String[]{"None", "My Security Level", "Administrators Security Level"});
        this.removeUserFromProjectRole("admin", "homosapien", "Developers");
        this.displayAllIssues();
        this.assertLinkNotPresentWithText(HSP_ISSUE_DEV_ROLE_SECURITY);
        this.assertLinkPresentWithText(HSP_ISSUE_ADMIN_ROLE_SECURITY);
        this.gotoIssue(HSP_ISSUE_ADMIN_ROLE_SECURITY);
        this.clickLink("editIssue");
        this.setWorkingForm("issue-edit");
        this.assertOptionsEqualIgnoreOrder("security", new String[]{"None", "Administrators Security Level"});
    }

    public void testIssueSecurityWithRolesEditIssueFieldsDirectly() {
        this.gotoPage("/secure/EditIssue!default.jspa?id=10020");
        this.setWorkingForm("issue-edit");
        this.assertOptionsEqualIgnoreOrder("security", new String[]{"None", "My Security Level", "Administrators Security Level"});
        this.removeUserFromProjectRole("admin", "homosapien", "Developers");
        this.gotoPage("/secure/EditIssue!default.jspa?id=10020");
        this.setWorkingForm("issue-edit");
        this.assertOptionsEqualIgnoreOrder("security", new String[]{"None", "Administrators Security Level"});
    }
}

