/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssueSecurityWithGroupsAndRoles
extends JIRAWebTest {
    private static final String[] EXPECTED_SECURITY_LEVEL_NONE = new String[]{"None"};
    private static final String[] EXPECTED_SECURITY_LEVEL_RED = new String[]{"None", "Red"};
    private static final String[] EXPECTED_SECURITY_LEVEL_GREEN = new String[]{"None", "Green"};
    private static final String NEW_PROJECT_NAME = "New Project";
    private static final String NEW_GROUP_NAME = "securityGroup";
    private static final String NEW_SECURITY_SCHEME_NAME = "security scheme copy";

    public TestIssueSecurityWithGroupsAndRoles(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestIssueSecurityWithGroupsAndRoles.xml");
    }

    public void testAddingAndRemovingUserFromGroupFlushesSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToProjectRole("jira-developers", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.removeUserFromGroup("admin", "jira-developers");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addUserToGroup("admin", "jira-developers");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
    }

    public void testAddingAndRemovingUserFromRolesFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addUserToProjectRole("admin", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.removeUserFromProjectRole("admin", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testAddingAndRemovingGroupRolesFromProjectFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToProjectRole("jira-users", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.removeGroupFromProjectRole("jira-users", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testRemovingRoleFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToProjectRole("jira-users", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.gotoProjectRolesScreen();
        this.clickLink("delete_Administrators");
        this.submit("Delete");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testRemovingGroupFlushesIssueSecurityCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.createGroup(NEW_GROUP_NAME);
        this.addGroupToSecurityLevel("New Security Scheme", "Red", NEW_GROUP_NAME, new String[]{"", "jira-administrators", "jira-developers", "jira-users", NEW_GROUP_NAME});
        this.addUserToGroup("admin", NEW_GROUP_NAME);
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.removeGroup(NEW_GROUP_NAME);
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel1() {
        this.addProject(NEW_PROJECT_NAME, "NEW", "", "admin", "new project with default roles");
        this.associateSecuritySchemeToProject(NEW_PROJECT_NAME, "New Security Scheme");
        this._testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel();
    }

    public void testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel2() {
        this.addProject(NEW_PROJECT_NAME, "NEW", "", "admin", "new project with default roles", "New Security Scheme");
        this._testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel();
    }

    public void testRenamingSecuritySchemeFlushesCache() {
        this.addGroupToProjectRole("jira-users", "homosapien", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
        this.clickLink("admin_link");
        this.clickLink("security_schemes");
        this.clickLinkWithText("Edit");
        this.setFormElement("name", "New Security Schemeedited");
        this.submit("Update");
        this.assertLinkWithTextExists("New Security Schemeedited");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
    }

    public void testAddingAndRemovingSecuritySchemeFromProject() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.removeAssociationOfSecuritySchemeFromProject("homosapien");
        this.createIssueStep1();
        this.getDialog().setWorkingForm("issue-create");
        this.assertFormElementNotPresent("security");
        this.associateSecuritySchemeToProject("homosapien", "New Security Scheme");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testSwappingSecuritySchemeFlushesCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.createSecurityScheme(NEW_SECURITY_SCHEME_NAME, "new scheme for testing");
        this.createSecurityLevel(NEW_SECURITY_SCHEME_NAME, "Orange", "Middle Level");
        this.addGroupToSecurityLevel(NEW_SECURITY_SCHEME_NAME, "Orange", "jira-users");
        this.createSecurityLevel(NEW_SECURITY_SCHEME_NAME, "Green", "Lowest Level");
        this.addGroupToSecurityLevel(NEW_SECURITY_SCHEME_NAME, "Green", "jira-developers");
        this.associateSecuritySchemeToProject("homosapien", NEW_SECURITY_SCHEME_NAME);
        this.assertIssueSecurityLevelOptions(new String[]{"None", "Green", "Orange"});
        this.associateSecuritySchemeToProject("homosapien", "New Security Scheme");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testAddingAndRemovingSecurityLevelFlushesCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.createSecurityLevel("New Security Scheme", "Green", "Lowest Level");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.addGroupToSecurityLevel("New Security Scheme", "Green", "jira-users");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_GREEN);
        this.createSecurityLevel("New Security Scheme", "Orange", "Middle Level");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_GREEN);
        this.addRoleToSecurityLevel("New Security Scheme", "Green", "Administrators");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_GREEN);
        this.deleteSecurityLevel("New Security Scheme", "Green");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.deleteSecurityLevel("New Security Scheme", "Orange");
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
    }

    public void testGroupToRoleMappingSchemeToolFlushesCache() {
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.mapGroupToRoles("permission schemes", "Default Permission Scheme", EasyMap.build((Object)"jira-developers", (Object)"Developers", (Object)"jira-administrators", (Object)"Developers"));
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_NONE);
        this.mapGroupToRoles("permission schemes", "Default Permission Scheme", EasyMap.build((Object)"jira-users", (Object)"Administrators"));
        this.assertIssueSecurityLevelOptions(EXPECTED_SECURITY_LEVEL_RED);
    }

    private void _testNewProjectsWithDefaultRolesHaveCorrectSecurityLevel() {
        this.assertIssueSecurityLevelOptions(NEW_PROJECT_NAME, "Bug", EXPECTED_SECURITY_LEVEL_RED);
        this.logout();
        this.login("fred", "fred");
        this.assertIssueSecurityLevelOptions(NEW_PROJECT_NAME, "Bug", EXPECTED_SECURITY_LEVEL_NONE);
    }

    private void assertIssueSecurityLevelOptions(String[] expectedSecurityLevels) {
        this.assertIssueSecurityLevelOptions("homosapien", "Bug", expectedSecurityLevels);
    }

    private void assertIssueSecurityLevelOptions(String projectName, String issueType, String[] expectedSecurityLevels) {
        this.createIssueStep1(projectName, issueType);
        this.getDialog().setWorkingForm("issue-create");
        this.assertOptionsEqual("security", expectedSecurityLevels);
        this.assertOptionSelected("security", "None");
    }
}

