/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.issue;

import com.atlassian.jira.webtests.JIRAWebTest;

public class TestIssuePrintableView
extends JIRAWebTest {
    public TestIssuePrintableView(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreData("TestTimeTrackingAggregates.xml");
    }

    @Override
    public void tearDown() {
        super.tearDown();
    }

    public void testPrintableView() {
        this.gotoIssue("HSP-10");
        this.clickLinkWithText("Printable");
        this.assertTextSequence(new String[]{"parent 2", "HSP-9", "HSP-10", "sub 3"});
        this.assertTextPresentBeforeText("Status:", "Open");
        this.assertTextPresentBeforeText("Project:", "homosapien");
        this.assertTextPresentBeforeText("Component/s:", "None");
        this.assertTextPresentBeforeText("Affects Version/s:", "None");
        this.assertTextPresentBeforeText("Fix Version/s:", "None");
        this.assertTextSequence(new String[]{"Type:", "Sub-task", "Priority:", "Major"});
        this.assertTextSequence(new String[]{"Reporter:", "Administrator", "Assignee:", "Administrator"});
        this.assertTextSequence(new String[]{"Resolution:", "Unresolved", "Votes:", "0"});
        this.assertTextSequence(new String[]{"Remaining Estimate:", "1 day", "Time Spent:", "1 day", "Original Estimate:", "1 day"});
        this.assertTableNotPresent(" Remaining Estimate:");
        this.assertTableNotPresent(" Time Spent:");
        this.assertTableNotPresent(" Original Estimate:");
        this.assertTableNotPresent("Sub-Tasks:");
        this.gotoPage("/browse/HSP-9");
        this.clickLinkWithText("Printable");
        this.assertTextPresentBeforeText("HSP-9", "parent 2");
        this.assertTextPresentBeforeText("Status:", "Open");
        this.assertTextPresentBeforeText("Project:", "homosapien");
        this.assertTextPresentBeforeText("Component/s:", "None");
        this.assertTextPresentBeforeText("Affects Version/s:", "None");
        this.assertTextPresentBeforeText("Fix Version/s:", "None");
        this.assertTextSequence(new String[]{"Type:", "Bug", "Priority:", "Major"});
        this.assertTextSequence(new String[]{"Reporter:", "Administrator", "Assignee:", "Administrator"});
        this.assertTextSequence(new String[]{"Resolution:", "Unresolved", "Votes:", "0"});
        this.assertTextSequence(new String[]{" Remaining Estimate:", "3 days", "Remaining Estimate:", "Not Specified", " Time Spent:", "1 day", "Time Spent:", "Not Specified", " Original Estimate:", "3 days", "Original Estimate:", "Not Specified"});
        this.assertTextSequence(new String[]{"Sub-Tasks:", "HSP-10", "sub 3", "HSP-11", "sub 4"});
    }

    public void testProperHtmlEscaping() {
        this.clickOnUserProfile();
        this.clickLink("edit_profile_lnk");
        this.setFormElement("fullName", "Administrator &trade;");
        this.submit();
        this.putTradeMarkIntoIssue("HSP-10");
        this.putTradeMarkIntoIssue("HSP-9");
        String linkTypeId = this.createIssueLinkType("related", "is related to", "relates to");
        this.linkIssueWithComment("HSP-9", "relates to", "HSP-10", null, null);
        this.clickLinkWithText("Printable");
        this.assertTradeMarkIsEscaped();
        this.gotoPage("/");
        this.displayAllIssues();
        this.clickLinkWithText("Printable");
        this.assertTradeMarkIsEscaped();
        this.gotoPage("/");
        this.displayAllIssues();
        this.clickLinkWithText("Full Content");
        this.assertTradeMarkIsEscaped();
        this.gotoPage("/");
    }

    private void putTradeMarkIntoIssue(String issueKey) {
        this.gotoIssue(issueKey);
        this.clickLink("editIssue");
        this.setFormElement("summary", "Issue " + issueKey + " &trade;");
        this.setFormElement("environment", "&trade;");
        this.setFormElement("description", "&trade;");
        this.setFormElement("comment", "&trade;");
        this.submit("Update");
    }

    private void assertTradeMarkIsEscaped() {
        this.assertTextNotPresent("&trade;");
        this.assertTextPresent("&amp;trade;");
    }
}

