/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.FilterNavigation;
import com.atlassian.jira.functest.framework.parser.filter.FilterItem;
import com.atlassian.jira.functest.framework.parser.filter.WebTestSharePermission;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.Assert;
import org.apache.commons.collections.Closure;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TestSearchFilters
extends FuncTestCase {
    private static final Logger log = Logger.getLogger(TestSearchFilters.class);
    List expectedList;
    List actualList;
    String currentUserName;
    private static final int DEV_ID_1 = 10040;
    private static final List GLOBAL_SHARE = Collections.singletonList(new WebTestSharePermission("global", null, null));
    private static final String DEVELOPER_THE_GREAT = "developer the great and wise (developer)";
    private static final String ADMINISTRATOR_ADMIN = "Administrator (admin)";
    private static final String SEARCH_TABLE_ID = "mf_browse";
    private static final DecimalFormat ZEROZERO_FORMAT = new DecimalFormat("00");
    private static final String PREVIOUS = "<< Previous";
    private static final String NEXT = "Next >>";
    private static final String DEVELOPER_FILTER = "developer filter";
    private FilterNavigation[] navigations;
    static final String[] SORT_COL_NAMES = new String[]{"Name", "Author", "Popularity"};
    static final String[] SORT_PARAM_VALUES = new String[]{"name", "owner", "favcount"};
    static final int[] SORT_TD_OFFSETS = new int[]{1, 3, 6};
    static final boolean[] SORT_DEFAULT_SORTING = new boolean[]{true, true, false};

    @Override
    protected void setUpTest() {
        this.currentUserName = "admin";
        this.navigations = new FilterNavigation[]{this.navigation.manageFilters(), this.navigation.filterPickerPopup()};
    }

    @Override
    protected void tearDownTest() {
        this.currentUserName = null;
        this.actualList = null;
        this.expectedList = null;
        this.navigations = null;
        super.tearDownTest();
    }

    public void testInitialScreenAppearance() throws Exception {
        for (int i = 0; i < this.navigations.length; ++i) {
            this.testInitialScreenAppearance(this.navigations[i]);
        }
    }

    public void testNoSearchYet() {
        for (int i = 0; i < this.navigations.length; ++i) {
            this.testNoSearchYet(this.navigations[i]);
        }
    }

    public void testBasicNameSearch() throws Exception {
        for (int i = 0; i < this.navigations.length; ++i) {
            this.testBasicNameSearch(this.navigations[i]);
        }
    }

    public void testUserNameSearch() throws Exception {
        for (int i = 0; i < this.navigations.length; ++i) {
            this.testUserNameSearch(this.navigations[i]);
        }
    }

    public void testBasicPaging() throws Exception {
        for (int i = 0; i < this.navigations.length; ++i) {
            this.testBasicPaging(this.navigations[i]);
        }
    }

    public void testMultiPageSort() throws Exception {
        for (int i = 0; i < this.navigations.length; ++i) {
            this.testMultiPageSort(this.navigations[i]);
        }
    }

    public void testBasicSorting() throws Exception {
        for (int i = 0; i < this.navigations.length; ++i) {
            this.testBasicSorting(this.navigations[i]);
        }
    }

    public void testSortingByUserName() throws Exception {
        for (int i = 0; i < this.navigations.length; ++i) {
            this.testSortingByUserName(this.navigations[i]);
        }
    }

    public void testInitialScreenAppearance(FilterNavigation filterNavigation) throws Exception {
        this.administration.restoreData("BaseProfessionalFilters.xml");
        filterNavigation.searchFilters();
        this.assertInputSearchFormHasThisShape("", "");
        this.submitSimpleSearch("", "", filterNavigation);
        this.submitSimpleSearch("cat", "weasel", filterNavigation);
        this.submitSimpleSearch("dog", "trumpet", filterNavigation);
        this.text.assertTextPresent(this.xPathLocator("//table[@class='filterSearchInput']//span[@class='errMsg']"), "The user 'trumpet' does not exist");
    }

    public void testNoSearchYet(FilterNavigation filterNavigation) {
        this.administration.restoreBlankInstance();
        filterNavigation.searchFilters();
        this.submitSimpleSearch("zz", "", filterNavigation);
        this.tester.assertTextPresent("Your search criteria did not match any filters.");
    }

    public void testUrlHacking() throws Exception {
        this.administration.restoreData("BaseProfessionalFiltersWithXSS.xml");
        this.navigation.manageFilters().searchFilters();
        String baseURL = "ManageFilters.jspa?filterView=search&searchName=&searchOwnerUserName=&searchShareType=&groupShare=&projectShare=&roleShare=&Search=Search";
        String url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=group&");
        url = StringUtils.replace((String)url, (String)"groupShare=&", (String)"groupShare=nodelonghere&");
        this.tester.gotoPage(url);
        this.text.assertTextPresent(this.xPathLocator("//table[@class='filterSearchInput']//span[@class='errMsg']"), "Group: 'nodelonghere' does not exist.");
        url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=project&");
        url = StringUtils.replace((String)url, (String)"projectShare=&", (String)"projectShare=666&");
        this.tester.gotoPage(url);
        this.text.assertTextPresent(this.xPathLocator("//table[@class='filterSearchInput']//span[@class='errMsg']"), "The project with identifier '666' does not exist.");
        url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=project&");
        url = StringUtils.replace((String)url, (String)"projectShare=&", (String)"projectShare=666x666&");
        this.tester.gotoPage(url);
        this.text.assertTextPresent(this.xPathLocator("//table[@class='filterSearchInput']//span[@class='errMsg']"), "Illegal search parameters.");
        url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=project&");
        url = StringUtils.replace((String)url, (String)"projectShare=&", (String)"projectShare=10000&");
        url = StringUtils.replace((String)url, (String)"roleShare=&", (String)"roleShare=666&");
        this.tester.gotoPage(url);
        this.text.assertTextPresent(this.xPathLocator("//table[@class='filterSearchInput']//span[@class='errMsg']"), "The project role with identifier '666' does not exist.");
    }

    public void testXss() throws Exception {
        for (FilterNavigation navigation1 : this.navigations) {
            this.testXss(navigation1);
        }
    }

    public void testXss(FilterNavigation filterNavigation) throws Exception {
        log.info((Object)("doing testXss with " + filterNavigation));
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFiltersWithXSS.xml");
        filterNavigation.searchFilters();
        String baseURL = filterNavigation.getActionBaseUrl() + "?filterView=search&searchName=&searchOwnerUserName=&searchShareType=&groupShare=&projectShare=&roleShare=&Search=Search";
        String url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=group&");
        url = StringUtils.replace((String)url, (String)"groupShare=&", (String)"groupShare=<script>alert('XSSGroup')</script>&");
        this.tester.gotoPage(url);
        this.actualList = this.parse.filter().parseFilterList(SEARCH_TABLE_ID).getFilterItems();
        List<FilterItem> expectedFilters = new ArrayList<FilterItem>();
        WebTestSharePermission groupShare = new WebTestSharePermission("group", "<script>alert('XSSGroup')</script>", null);
        FilterItem groupFilterItem = new FilterItem(10040L, "xss group filter", "", ADMINISTRATOR_ADMIN, 0L, Collections.singletonList(groupShare), true, 0L, null, 1L);
        expectedFilters.add(groupFilterItem);
        expectedFilters = filterNavigation.sanitiseSearchFilterItems(expectedFilters);
        this.assertions.assertEquals("Filter List is wrongo", expectedFilters, this.actualList);
        url = StringUtils.replace((String)baseURL, (String)"searchShareType=&", (String)"searchShareType=project&");
        url = StringUtils.replace((String)url, (String)"projectShare=&", (String)"projectShare=10000&");
        url = StringUtils.replace((String)url, (String)"roleShare=&", (String)"roleShare=10020&");
        this.tester.gotoPage(url);
        this.actualList = this.parse.filter().parseFilterList(SEARCH_TABLE_ID).getFilterItems();
        WebTestSharePermission roleShare = new WebTestSharePermission("project", "homosapien", "<script>alert('XSSRole')</script>");
        expectedFilters = new ArrayList();
        FilterItem roleFilterItem = new FilterItem(10041L, "xss project role filter", "", ADMINISTRATOR_ADMIN, 0L, Collections.singletonList(roleShare), true, 0L, null, 1L);
        expectedFilters.add(roleFilterItem);
        expectedFilters = filterNavigation.sanitiseSearchFilterItems(expectedFilters);
        this.assertions.assertEquals("Filter list is wrong", expectedFilters, this.actualList);
    }

    public void testBasicNameSearch(final FilterNavigation filterNavigation) throws Exception {
        this.administration.restoreData("BaseProfessionalFilters.xml");
        Closure basicNameSearchTest1 = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("z", "", filterNavigation);
                TestSearchFilters.this.expectedList = EasyList.build((Object)TestSearchFilters.this.newFI('z'));
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.submitSimpleSearch("b", "admin", filterNavigation);
                TestSearchFilters.this.expectedList = EasyList.build((Object)TestSearchFilters.this.newFI('b'));
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.submitSimpleSearch("the evil zurg", "admin", filterNavigation);
                TestSearchFilters.this.assertInputSearchFormHasThisShape("the evil zurg", "admin");
                Assert.assertNull((String)"Should have found nothing", (Object)TestSearchFilters.this.parse.filter().parseFilterList(TestSearchFilters.SEARCH_TABLE_ID));
                TestSearchFilters.this.submitSimpleSearch("b m w", "admin", filterNavigation);
                TestSearchFilters.this.expectedList = EasyList.build((Object)TestSearchFilters.this.newFI('b'), (Object)TestSearchFilters.this.newFI('m'), (Object)TestSearchFilters.this.newFI('w'));
                TestSearchFilters.this.assertFilterItemLists();
            }
        };
        basicNameSearchTest1.execute(null);
        basicNameSearchTest1.execute((Object)"admin");
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloper.xml");
        final AtomicBoolean favFlag = new AtomicBoolean(false);
        final AtomicBoolean devFavFlag = new AtomicBoolean(false);
        Closure basicNameSearchTest2 = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("b d* m z", "", filterNavigation);
                boolean isFav = favFlag.get();
                boolean isDevFav = devFavFlag.get();
                TestSearchFilters.this.expectedList = EasyList.build((Object)TestSearchFilters.this.newFI('b').setFav(isFav), (Object)TestSearchFilters.this.newFI('d').setFav(isFav), (Object)TestSearchFilters.this.newFI(10040L, TestSearchFilters.DEVELOPER_FILTER, TestSearchFilters.DEVELOPER_THE_GREAT).setFav(isDevFav), (Object)TestSearchFilters.this.newFI('m').setFav(isFav), (Object)TestSearchFilters.this.newFI('z').setFav(isFav));
                TestSearchFilters.this.assertFilterItemLists();
            }
        };
        favFlag.set(false);
        devFavFlag.set(false);
        basicNameSearchTest2.execute(null);
        favFlag.set(false);
        devFavFlag.set(true);
        basicNameSearchTest2.execute((Object)"developer");
        favFlag.set(true);
        devFavFlag.set(false);
        basicNameSearchTest2.execute((Object)"admin");
    }

    public void testUserNameSearch(FilterNavigation filterNavigation) throws Exception {
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloper.xml");
        this.navigation.manageFilters().searchFilters();
        this.submitSimpleSearch("d*", "", filterNavigation);
        this.expectedList = EasyList.build((Object)this.newFI('d'), (Object)this.newFI(10040L, DEVELOPER_FILTER, DEVELOPER_THE_GREAT).setFav(false));
        this.assertFilterItemLists();
        this.submitSimpleSearch("d*", "admin", filterNavigation);
        this.expectedList = EasyList.build((Object)this.newFI('d'));
        this.assertFilterItemLists();
        this.submitSimpleSearch("d*", "", filterNavigation);
        this.expectedList = EasyList.build((Object)this.newFI('d'), (Object)this.newFI(10040L, DEVELOPER_FILTER, DEVELOPER_THE_GREAT).setFav(false));
        this.assertFilterItemLists();
        this.submitSimpleSearch("d*", "developer", filterNavigation);
        this.expectedList = EasyList.build((Object)this.newFI(10040L, DEVELOPER_FILTER, DEVELOPER_THE_GREAT).setFav(false));
        this.assertFilterItemLists();
    }

    public void testBasicPaging(final FilterNavigation filterNavigation) throws Exception {
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFilters.xml");
        Closure basicPagingTest = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("", "admin", filterNavigation);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                String pageURL = TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.NEXT, "1 - 20 of 26", "", "admin");
                TestSearchFilters.this.tester.gotoPage(pageURL);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.assertFilterItemLists();
                pageURL = TestSearchFilters.this.assertSinglePagingLinksPresent(0, 2, TestSearchFilters.PREVIOUS, "21 - 26 of 26", "", "admin");
                TestSearchFilters.this.tester.gotoPage(pageURL);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                pageURL = TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.NEXT, "1 - 20 of 26", "", "admin");
                TestSearchFilters.this.tester.gotoPage(pageURL);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertSinglePagingLinksPresent(0, 2, TestSearchFilters.PREVIOUS, "21 - 26 of 26", "", "admin");
            }
        };
        basicPagingTest.execute(null);
        basicPagingTest.execute((Object)"admin");
    }

    public void testMultiPageSort(final FilterNavigation filterNavigation) throws Exception {
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloperZFilters.xml");
        Closure multiPageSortTest = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("", "", filterNavigation);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.NEXT, "1 - 20 of 45", "", "");
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.NEXT);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.addDeveloperZSeriesFilters(TestSearchFilters.this.expectedList, 0, 13);
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertDualPagingLinksPresent(2, 2, "21 - 40 of 45", "", "");
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.NEXT);
                TestSearchFilters.this.expectedList = new ArrayList();
                TestSearchFilters.this.addDeveloperZSeriesFilters(TestSearchFilters.this.expectedList, 14, 18);
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.PREVIOUS, "41 - 45 of 45", "", "");
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.PREVIOUS);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.addDeveloperZSeriesFilters(TestSearchFilters.this.expectedList, 0, 13);
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertDualPagingLinksPresent(2, 2, "21 - 40 of 45", "", "");
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.PREVIOUS);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.assertSinglePagingLinksPresent(1, 2, TestSearchFilters.NEXT, "1 - 20 of 45", "", "");
            }
        };
        multiPageSortTest.execute(null);
        multiPageSortTest.execute((Object)"admin");
    }

    public void testBasicSorting(FilterNavigation filterNavigation) throws Exception {
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFilters.xml");
        this.navigation.manageFilters().searchFilters();
        this.submitSimpleSearch("", "admin", filterNavigation);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        String sortURL = this.assertSortUrls("Name", false, "", "admin");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('z', 'g');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Name", true, "", "admin");
        TestSearchFilters.assertNotNull((Object)sortURL);
        sortURL = this.getSortURL("Author");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Author", false, "", "admin");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Author", true, "", "admin");
        TestSearchFilters.assertNotNull((Object)sortURL);
        sortURL = this.getSortURL("Popularity");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Popularity", true, "", "admin");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('a', 't');
        this.assertFilterItemLists();
        sortURL = this.assertSortUrls("Popularity", false, "", "admin");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.navigation.manageFilters().removeFavourite(this.getEntityId('a'));
        this.navigation.manageFilters().searchFilters();
        this.submitSimpleSearch("", "admin", filterNavigation);
        sortURL = this.getSortURL("Popularity");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        this.tester.gotoPage(sortURL);
        this.expectedList = this.buildExpectedList('b', 'u');
        this.assertFilterItemLists();
        this.tester.clickLinkWithText(NEXT);
        List suffixList = EasyList.build((Object)this.newFI('a').setFav(false).setFavCount(0L));
        this.expectedList = this.buildExpectedList(null, 'v', 'z', suffixList);
        this.assertFilterItemLists();
        this.tester.clickLinkWithText(PREVIOUS);
        this.expectedList = this.buildExpectedList('b', 'u');
        this.assertFilterItemLists();
        sortURL = this.getSortURL("Popularity");
        TestSearchFilters.assertNotNull((Object)sortURL);
        this.tester.gotoPage(sortURL);
        List prependList = EasyList.build((Object)this.newFI('a').setFav(false).setFavCount(0L));
        this.expectedList = this.buildExpectedList(prependList, 'b', 't', null);
        this.assertFilterItemLists();
        this.tester.clickLinkWithText(NEXT);
        this.expectedList = this.buildExpectedList('u', 'z');
        this.assertFilterItemLists();
    }

    public void testSortingByUserName(final FilterNavigation filterNavigation) throws Exception {
        this.navigation.gotoDashboard();
        this.administration.restoreData("BaseProfessionalFiltersWithDeveloper.xml");
        Closure sortingByUserNameTest1 = new Closure(){

            public void execute(Object userNameObj) {
                TestSearchFilters.this.login(userNameObj);
                TestSearchFilters.this.navigation.manageFilters().searchFilters();
                TestSearchFilters.this.submitSimpleSearch("", "", filterNavigation);
                FilterItem developerFI = TestSearchFilters.this.newFI(10040L, TestSearchFilters.DEVELOPER_FILTER, TestSearchFilters.DEVELOPER_THE_GREAT).setFav(false);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 'd');
                TestSearchFilters.this.expectedList.add(developerFI);
                TestSearchFilters.this.expectedList.addAll(TestSearchFilters.this.buildExpectedList('e', 's'));
                TestSearchFilters.this.assertFilterItemLists();
                String sortURL = TestSearchFilters.this.assertSortUrls("Name", false, "", "");
                Assert.assertNotNull((Object)sortURL);
                sortURL = TestSearchFilters.this.getSortURL("Author");
                TestSearchFilters.this.tester.gotoPage(sortURL);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('a', 't');
                TestSearchFilters.this.assertFilterItemLists();
                TestSearchFilters.this.tester.clickLinkWithText(TestSearchFilters.NEXT);
                TestSearchFilters.this.expectedList = TestSearchFilters.this.buildExpectedList('u', 'z');
                TestSearchFilters.this.expectedList.add(developerFI);
                TestSearchFilters.this.assertFilterItemLists();
                sortURL = TestSearchFilters.this.getSortURL("Author");
                TestSearchFilters.this.tester.gotoPage(sortURL);
                TestSearchFilters.this.expectedList = new ArrayList();
                TestSearchFilters.this.expectedList.add(developerFI);
                TestSearchFilters.this.expectedList.addAll(TestSearchFilters.this.buildExpectedList('a', 's'));
                TestSearchFilters.this.assertFilterItemLists();
            }
        };
        sortingByUserNameTest1.execute(null);
        sortingByUserNameTest1.execute((Object)"admin");
    }

    public void testDummyXmlResponse() throws IOException, ParserConfigurationException, SAXException, TransformerException {
        this.administration.restoreData("TestSearchRequestURLHandler.xml");
        this.navigation.login("fred", "fred");
        String searchURL = "/sr/jira.issueviews:searchrequest-xml/10000/SearchRequest-10000.xml?tempMax=1000";
        this.tester.gotoPage(searchURL);
        String responseText = this.tester.getDialog().getResponseText();
        Document doc = XMLUnit.buildControlDocument((String)responseText);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/version", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/build-number", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/build-date", (Document)doc);
        XMLAssert.assertXpathExists((String)"/rss/channel/build-info/edition", (Document)doc);
    }

    private void assertDualPagingLinksPresent(int expectedNextPageOffset, int expectedLinks, String expectedXOfY, String searchName, String searchOwnerUserName) {
        int i;
        XPathLocator pageLocator = this.xPathLocator("//p[@class='pagination']/a/span[text() = 'Next >>']");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            TestSearchFilters.assertEquals((String)NEXT, (String)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        pageLocator = this.xPathLocator("//p[@class='pagination']/a/span[text() = '<< Previous']");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            TestSearchFilters.assertEquals((String)PREVIOUS, (String)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        pageLocator = this.xPathLocator("//p[@class='pagination']/span");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            String actualXOfY = pageLocator.getText(pageLocator.getNodes()[i]);
            TestSearchFilters.assertEquals((String)expectedXOfY, (String)actualXOfY);
        }
        this.assertSortUrls("Name", false, searchName, searchOwnerUserName);
        pageLocator = this.xPathLocator("//p[@class='pagination']/a[contains(@class, 'icon-next')]/@href");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            String hrefUrl = pageLocator.getText(pageLocator.getNodes()[i]);
            TestSearchFilters.assertNotNull((Object)hrefUrl);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&filterView=search") >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((String)("Next URL does not have right page offset : " + expectedNextPageOffset), (hrefUrl.indexOf("&pagingOffset=" + expectedNextPageOffset) >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&pagingOffset=" + expectedNextPageOffset) >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&searchName=" + searchName + "&") >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&searchOwnerUserName=" + searchOwnerUserName + "&") >= 0 ? 1 : 0) != 0);
        }
        pageLocator = this.xPathLocator("//p[@class='pagination']/a[contains(@class, 'icon-previous')]/@href");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        int expectedPrevOffset = expectedNextPageOffset - 2;
        for (int i2 = 0; i2 < expectedLinks; ++i2) {
            String hrefUrl = pageLocator.getText(pageLocator.getNodes()[i2]);
            TestSearchFilters.assertNotNull((Object)hrefUrl);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&filterView=search") >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((String)("Previous URL does not have right page offset : " + expectedPrevOffset), (hrefUrl.indexOf("&pagingOffset=" + expectedPrevOffset) >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&searchName=" + searchName + "&") >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&searchOwnerUserName=" + searchOwnerUserName + "&") >= 0 ? 1 : 0) != 0);
        }
    }

    private String assertSinglePagingLinksPresent(int expectedPageOffset, int expectedLinks, String expectedLinkText, String expectedXOfY, String searchName, String searchOwnerUserName) {
        int i;
        String returnURL = "/this/will/fail/unless/it/changes";
        XPathLocator pageLocator = this.xPathLocator("//p[@class='pagination']//a");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            TestSearchFilters.assertEquals((String)expectedLinkText, (String)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        pageLocator = this.xPathLocator("//p[@class='pagination']/span");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            TestSearchFilters.assertEquals((String)expectedXOfY, (String)pageLocator.getText(pageLocator.getNodes()[i]));
        }
        this.assertSortUrls("Name", false, searchName, searchOwnerUserName);
        pageLocator = this.xPathLocator("//p[@class='pagination']//a/@href");
        TestSearchFilters.assertEquals((int)expectedLinks, (int)pageLocator.getNodes().length);
        for (i = 0; i < expectedLinks; ++i) {
            String hrefUrl;
            returnURL = hrefUrl = pageLocator.getText(pageLocator.getNodes()[i]);
            TestSearchFilters.assertNotNull((Object)hrefUrl);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&filterView=search") >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((String)("Does not have expected pagingOffset : " + expectedPageOffset), (hrefUrl.indexOf("&pagingOffset=" + expectedPageOffset) >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&searchName=" + searchName + "&") >= 0 ? 1 : 0) != 0);
            TestSearchFilters.assertTrue((hrefUrl.indexOf("&searchOwnerUserName=" + searchOwnerUserName + "&") >= 0 ? 1 : 0) != 0);
        }
        return returnURL;
    }

    private String getSortURL(String selectedColumnName) {
        int offset = 0;
        for (int i = 0; i < SORT_COL_NAMES.length; ++i) {
            if (!SORT_COL_NAMES[i].equalsIgnoreCase(selectedColumnName)) continue;
            offset = SORT_TD_OFFSETS[i];
            break;
        }
        XPathLocator colNameLocator = this.xPathLocator("//table[@id='mf_browse']/thead/tr/th[" + offset + "]/a");
        TestSearchFilters.assertEquals((String)selectedColumnName, (String)colNameLocator.getText());
        return ((Element)colNameLocator.getNode()).getAttribute("href");
    }

    private String assertSortUrls(String selectedColumnName, boolean selectedSortAscending, String searchName, String searchOwnerUserName) {
        String returnURL = "/this/will/fail/unless/set";
        for (int i = 0; i < SORT_COL_NAMES.length; ++i) {
            String columnName = SORT_COL_NAMES[i];
            XPathLocator colNameLocator = this.xPathLocator("//table[@id='mf_browse']/thead/tr/th[" + SORT_TD_OFFSETS[i] + "]/a");
            TestSearchFilters.assertEquals((String)columnName, (String)colNameLocator.getText());
            String hrefUrl = ((Element)colNameLocator.getNode()).getAttribute("href");
            TestSearchFilters.assertNotNull((Object)hrefUrl);
            this.text.assertTextPresent(hrefUrl, "filterView=search");
            this.text.assertTextPresent(hrefUrl, "pagingOffset=0");
            this.text.assertTextPresent(hrefUrl, "pagingOffset=0");
            this.text.assertTextPresent(hrefUrl, "searchName=" + searchName + "&");
            this.text.assertTextPresent(hrefUrl, "searchOwnerUserName=" + searchOwnerUserName + "&");
            this.text.assertTextPresent(hrefUrl, "sortColumn=" + SORT_PARAM_VALUES[i]);
            if (columnName.equalsIgnoreCase(selectedColumnName)) {
                this.text.assertTextPresent(hrefUrl, "sortAscending=" + String.valueOf(selectedSortAscending));
                returnURL = hrefUrl;
                continue;
            }
            this.text.assertTextPresent(hrefUrl, "sortAscending=" + String.valueOf(SORT_DEFAULT_SORTING[i]));
        }
        return returnURL;
    }

    private List buildExpectedList(char startC, char endCInclusive) {
        return this.buildExpectedList(null, startC, endCInclusive, null);
    }

    private List buildExpectedList(List prependList, char startC, char endCInclusive, List suffixList) {
        ArrayList finalList = new ArrayList();
        if (prependList != null) {
            finalList.addAll(prependList);
        }
        ArrayList<FilterItem> expectedList = new ArrayList<FilterItem>();
        int sC = startC;
        int eC = endCInclusive;
        if (startC > endCInclusive) {
            sC = endCInclusive;
            eC = startC;
        }
        for (int i = sC; i <= eC; ++i) {
            expectedList.add(this.newFI((char)i));
        }
        if (startC > endCInclusive) {
            Collections.reverse(expectedList);
        }
        finalList.addAll(expectedList);
        if (suffixList != null) {
            finalList.addAll(suffixList);
        }
        return finalList;
    }

    private void submitSimpleSearch(String searchName, String searchOwnerUserName, FilterNavigation filterNavigation) {
        filterNavigation.findFilters(searchName, searchOwnerUserName);
        this.assertInputSearchFormHasThisShape(searchName, searchOwnerUserName);
    }

    private void assertInputSearchFormHasThisShape(String searchName, String searchOwnerUserName) {
        this.text.assertTextPresent(this.xPathLocator("//table[@class='filterSearchInput']//td"), "Search:");
        TestSearchFilters.assertTrue((boolean)this.xPathLocator("//table[@class='filterSearchInput']//input[@name='searchName']").hasNodes());
        TestSearchFilters.assertEquals((String)searchName, (String)this.tester.getDialog().getFormParameterValue("searchName"));
        this.text.assertTextPresent(this.xPathLocator("//table[@class='filterSearchInput']//td"), "Author:");
        TestSearchFilters.assertTrue((boolean)this.xPathLocator("//table[@class='filterSearchInput']//input[@name='searchOwnerUserName']").hasNodes());
        TestSearchFilters.assertEquals((String)searchOwnerUserName, (String)this.tester.getDialog().getFormParameterValue("searchOwnerUserName"));
        if (this.currentUserName != null) {
            TestSearchFilters.assertTrue((boolean)this.xPathLocator("//table[@class='filterSearchInput']//select[@name='searchShareType']").hasNodes());
            TestSearchFilters.assertTrue((boolean)this.xPathLocator("//table[@class='filterSearchInput']//select[@name='groupShare']").hasNodes());
            TestSearchFilters.assertTrue((boolean)this.xPathLocator("//table[@class='filterSearchInput']//select[@name='projectShare']").hasNodes());
            TestSearchFilters.assertTrue((boolean)this.xPathLocator("//table[@class='filterSearchInput']//select[@name='roleShare']").hasNodes());
        }
        TestSearchFilters.assertTrue((boolean)this.xPathLocator("//table[@class='filterSearchInput']//input[@name='Search']").hasNodes());
    }

    private void assertFilterItemLists() {
        this.actualList = this.parse.filter().parseFilterList(SEARCH_TABLE_ID).getFilterItems();
        if (this.expectedList == null || this.actualList == null) {
            TestSearchFilters.assertTrue((String)"If one filter list is null they both should be", (this.actualList == null && this.expectedList == null ? 1 : 0) != 0);
            return;
        }
        TestSearchFilters.assertEquals((String)"The filter lists should have the same size", (int)this.expectedList.size(), (int)this.actualList.size());
        if (this.currentUserName == null) {
            for (FilterItem filterItem : this.expectedList) {
                filterItem.setFav(false);
            }
        }
        int index = 0;
        for (FilterItem expectedFI : this.expectedList) {
            FilterItem actualFI = (FilterItem)this.actualList.get(index++);
            TestSearchFilters.assertEquals((String)"The FitlerItems are not equal", (Object)expectedFI, (Object)actualFI);
        }
    }

    private int getEntityId(char filterName) {
        return 10005 + Math.abs(97 - filterName);
    }

    private XPathLocator xPathLocator(String xpathStr) {
        return new XPathLocator(this.tester, xpathStr);
    }

    private FilterItem newFI(long filterId, String filterName, String authorName) {
        return new FilterItem(filterId, filterName, "", authorName, 0L, GLOBAL_SHARE, Boolean.TRUE, 0L, null, 1L);
    }

    private FilterItem newFI(char filterName) {
        return this.newFI(filterName, ADMINISTRATOR_ADMIN, Boolean.TRUE);
    }

    private FilterItem newFI(char filterName, String authorName, Boolean isFavourited) {
        Long id = this.getEntityId(filterName);
        return new FilterItem(id, Character.toString(filterName), "", authorName, 0L, GLOBAL_SHARE, isFavourited, 0L, null, 1L);
    }

    private void addDeveloperZSeriesFilters(List expectedList, int startFilterNum, int endFilterNumInclusive) {
        for (int i = startFilterNum; i <= endFilterNumInclusive; ++i) {
            String filterName = "z" + ZEROZERO_FORMAT.format(i);
            long id = 10040 + i;
            expectedList.add(this.newFI(id, filterName, DEVELOPER_THE_GREAT).setFav(false));
        }
    }

    private void login(Object userNameObj) {
        this.logout();
        if (userNameObj != null) {
            this.currentUserName = String.valueOf(userNameObj);
            this.navigation.login(this.currentUserName, this.currentUserName);
        }
    }

    private void logout() {
        this.navigation.logout();
        this.currentUserName = null;
    }
}

