/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import org.apache.commons.lang.StringUtils;

public class TestFilterHoldsItsSorting
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestFilterHoldsItsSorting.xml");
    }

    public void testThatItHoldsItSorting() {
        this.navigation.issueNavigator().loadFilter(10000L, null);
        this.assertNavigatorKeyOrder(new String[]{"HSP-2", "HSP-4", "HSP-1", "HSP-3"});
        this.tester.gotoPage("secure/IssueNavigator.jspa?sorter/field=issuekey&sorter/order=ASC'");
        this.assertNavigatorKeyOrder(new String[]{"HSP-1", "HSP-2", "HSP-3", "HSP-4"});
        this.navigation.issueNavigator().loadFilter(10000L, null);
        this.assertNavigatorKeyOrder(new String[]{"HSP-2", "HSP-4", "HSP-1", "HSP-3"});
    }

    private void assertNavigatorKeyOrder(String[] issueKeys) {
        TableLocator tableLocator = new TableLocator(this.tester, "issuetable");
        for (int i = 0; i < issueKeys.length; ++i) {
            String key = issueKeys[i];
            TestFilterHoldsItsSorting.assertTrue((boolean)this.contains(tableLocator.getTable().getCellAsText(i + 1, 1), key));
        }
    }

    private boolean contains(String cellAsText, String s) {
        if (!StringUtils.isBlank((String)cellAsText)) {
            return cellAsText.indexOf(s) != -1;
        }
        return false;
    }
}

