/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.webtests.CustomFieldValue;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.xml.sax.SAXException;

public class TestFilterActions
extends JIRAWebTest {
    private static final String NO_COLUMN_ORDER = "has <b>no</b> associated Column Order";
    private static final String REMOVE_COLUMN_ORDER = "Remove Filter's Column Order";
    private static final String LOGIN = "log in";
    private static final int numberOfIssues = 10;
    private static Collection issues = new ArrayList();
    private static final String COLUMN_NAME_VOTES = "Votes";
    private static final String COLUMN_NAME_CREATED = "Created";
    private static final String FILTER_NAME_PREFIX = "filter with ";
    private static final String FILTER_NAME_WITH_VOTE_COL = "filter with a vote column";
    private static final String FILTER_NAME_WITHOUT_VOTE_COL = "filter without a vote column";
    private static final String TEST_FILTER = "test filter";
    private static final String CUSTOM_FIELD_NAME_SELECT = "Custom Field Select";
    private static final String CUSTOM_FIELD_NAME_RADIO = "Custom Field Radio";
    private static final String CUSTOM_FIELD_NAME_MULTI_SELECT = "Custom Field Multi Select";
    private static final String CUSTOM_FIELD_NAME_MULTI_CHECKBOX = "Custom Field Multi Checkbox";
    private static final String CUSTOM_FIELD_NAME_TEXT_FIELD = "Custom Field Text Fields";
    private static final String FILTER_PRIVATE = "/secure/IssueNavigator.jspa?requestId=10000";
    private static final String FILTER_PUBLIC = "/secure/IssueNavigator.jspa?requestId=10001";
    private static final String FILTER_DEV = "/secure/IssueNavigator.jspa?requestId=10030";
    private static final String FILTER_INVALID = "/secure/IssueNavigator.jspa?requestId=10005";
    private static final String DELETE_FILTER_DEV = "/secure/DeleteFilter.jspa?filterId=10030";
    private static final String DELETE_FILTER_DEV_URL_HACK = "/secure/DeleteFilter.jspa?filterId=10030&Delete=delete";
    private static final String DELETE_FILTER_PUBLIC = "/secure/DeleteFilter.jspa?filterId=10001";
    private static final String DELETE_FILTER_PUBLIC_URL_HACK = "/secure/DeleteFilter.jspa?filterId=10001&Delete=delete";
    private static final String ERROR_MSG_NO_PERM_TO_VIEW_FILTER = "The selected filter with id '10000' does not exist.";
    private static final String ERROR_MSG_FILTER_DOES_NOT_EXIST = "The selected filter with id '10005' does not exist.";
    private static final String ERROR_MSG_CANNOT_DELETE_FILTER = "You do not have permission to delete this filter or this filter may not exist.";

    public TestFilterActions(String name) {
        super(name);
    }

    public void testSaveAsFilterWithDefaultColumnOrder() {
        this.restoreData("TestFilterActions.xml");
        this.addIssue("homosapien", "HSP", "Bug", "summary", "Major", null, null, null, "Bob The Builder", "", "", null, null, null);
        TestFilterActions.log("creating filter with no column order");
        this.createFilterWithFields(null, null, null);
        this.saveFilter(FILTER_NAME_WITHOUT_VOTE_COL, "filter with NO custom column order");
        TestFilterActions.log("copying filter with no column order");
        int id = this.saveFilterAs(FILTER_NAME_WITHOUT_VOTE_COL, "Copy of filter without a vote column", "copy - 2", "ignore");
        this.gotoManageFilterColumnOrder(id);
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//table[@id='issuetable']//th"), COLUMN_NAME_VOTES);
        this.assertTextPresent(NO_COLUMN_ORDER);
        this.restoreBlankInstance();
    }

    public void testSaveAsFilterWithCustomColumnOrder() {
        this.restoreData("TestFilterActions.xml");
        this.addIssue("homosapien", "HSP", "Bug", "summary", "Major", null, null, null, "Bob The Builder", "", "", null, null, null);
        TestFilterActions.log("creating new filter F2 with a column order");
        this.createFilterWithFields(null, null, null);
        int id = this.saveFilter(FILTER_NAME_WITH_VOTE_COL, "filter with a custom column order");
        this.addColumnOrder(id, COLUMN_NAME_VOTES, COLUMN_NAME_VOTES);
        this.configureColumnOrder(id, COLUMN_NAME_CREATED, "remove");
        TestFilterActions.log("copying the filter F2 directly");
        id = this.saveFilterAs(FILTER_NAME_WITH_VOTE_COL, "Copy 1 of filter with a vote column", "copy directly", "ignore");
        this.gotoManageFilterColumnOrder(id);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='issuetable']//th"), COLUMN_NAME_VOTES);
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//table[@id='issuetable']//th"), COLUMN_NAME_CREATED);
        this.assertTextPresent(REMOVE_COLUMN_ORDER);
        TestFilterActions.log("copying the filter F2 without the column order");
        id = this.saveFilterAs(FILTER_NAME_WITH_VOTE_COL, "Copy 2 of filter with a vote column", "copy none", "3");
        this.gotoManageFilterColumnOrder(id);
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//table[@id='issuetable']//th"), COLUMN_NAME_VOTES);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='issuetable']//th"), COLUMN_NAME_CREATED);
        this.assertTextPresent(NO_COLUMN_ORDER);
        TestFilterActions.log("copying the filter F2 with the filter's column order");
        id = this.saveFilterAs(FILTER_NAME_WITH_VOTE_COL, "Copy 3 of filter with a vote column", "copy Filters", "2");
        this.gotoManageFilterColumnOrder(id);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='issuetable']//th"), COLUMN_NAME_VOTES);
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//table[@id='issuetable']//th"), COLUMN_NAME_CREATED);
        this.assertTextPresent(REMOVE_COLUMN_ORDER);
        TestFilterActions.log("copying the filter F2 with the user's column order");
        id = this.saveFilterAs(FILTER_NAME_WITH_VOTE_COL, "Copy 4 of filter with a vote column", "copy users", "1");
        this.gotoManageFilterColumnOrder(id);
        this.text.assertTextNotPresent(new XPathLocator(this.tester, "//table[@id='issuetable']//th"), COLUMN_NAME_VOTES);
        this.text.assertTextPresent(new XPathLocator(this.tester, "//table[@id='issuetable']//th"), COLUMN_NAME_CREATED);
        this.assertTextNotPresent(NO_COLUMN_ORDER);
        this.restoreBlankInstance();
    }

    public void testCustomFilterActions() throws IOException, SAXException {
        this.restoreData("TestFilterActionsCustomFilterActions.xml");
        for (int key = 1; key <= 20; ++key) {
            issues.add("HSP-" + key);
        }
        this.filterActionsWitCustomFields();
        this.restoreBlankInstance();
    }

    public void testFilterResultVisibility() {
        this.restoreData("TestFilterResultVisibility.xml");
        this.logout();
        this.assertTextPresentOnFilterView(FILTER_PRIVATE, ERROR_MSG_NO_PERM_TO_VIEW_FILTER, LOGIN);
        this.assertTextPresentOnFilterView(FILTER_PUBLIC, "all public", "HSP-1");
        this.assertTextPresentOnFilterView(FILTER_DEV, "The selected filter with id '10030' does not exist.", LOGIN);
        this.assertTextPresentOnFilterView(FILTER_INVALID, ERROR_MSG_FILTER_DOES_NOT_EXIST, LOGIN);
        this.login("dev", "dev");
        this.beginAt(FILTER_PRIVATE);
        this.assertTextPresent(ERROR_MSG_NO_PERM_TO_VIEW_FILTER);
        this.assertLinkNotPresentWithText(LOGIN);
        this.assertTextPresentOnFilterView(FILTER_PUBLIC, "all public", "HSP-1");
        this.assertTextPresentOnFilterView(FILTER_DEV, "all dev", "HSP-1");
        this.beginAt(FILTER_INVALID);
        this.assertTextPresent(ERROR_MSG_FILTER_DOES_NOT_EXIST);
        this.assertLinkNotPresentWithText(LOGIN);
        this.login("admin", "admin");
        this.assertTextPresentOnFilterView(FILTER_PRIVATE, "all private", "HSP-1");
        this.assertTextPresentOnFilterView(FILTER_PUBLIC, "all public", "HSP-1");
        this.assertTextPresentOnFilterView(FILTER_DEV, "all dev", "HSP-1");
        this.beginAt(FILTER_INVALID);
        this.assertTextPresent(ERROR_MSG_FILTER_DOES_NOT_EXIST);
        this.assertLinkNotPresentWithText(LOGIN);
        this.restoreBlankInstance();
    }

    public void testDeleteFilterPermissions() {
        this.restoreData("TestFilterResultVisibility.xml");
        this.login("dev", "dev");
        this.assertCannotDeleteFilter(DELETE_FILTER_DEV);
        this.assertCannotDeleteFilter(DELETE_FILTER_DEV_URL_HACK);
        this.assertCannotDeleteFilter(DELETE_FILTER_PUBLIC);
        this.assertCannotDeleteFilter(DELETE_FILTER_PUBLIC_URL_HACK);
        this.login("admin", "admin");
        this.restoreBlankInstance();
    }

    private void assertCannotDeleteFilter(String filterUrl) {
        this.gotoPage(filterUrl);
        this.assertTextPresent(ERROR_MSG_CANNOT_DELETE_FILTER);
    }

    private void assertTextPresentOnFilterView(String filterURL, String expectedMessage, String expectedLink) {
        this.beginAt(filterURL);
        this.assertTextPresent(expectedMessage);
        this.assertLinkPresentWithText(expectedLink);
    }

    private void filterActionsWitCustomFields() throws SAXException, IOException {
        String radioCfId = "10000";
        String selectCfId = "10001";
        String multiselectCfId = "10002";
        String checkboxCfId = "10003";
        String textfieldCfId = "10004";
        ArrayList<CustomFieldValue> cfList = new ArrayList<CustomFieldValue>();
        CustomFieldValue radioCustomField = new CustomFieldValue(radioCfId, "radiobuttons", "blue");
        CustomFieldValue selectCustomField = new CustomFieldValue(selectCfId, "select", "abc");
        CustomFieldValue multiSelectCustomField = new CustomFieldValue(multiselectCfId, "multiselect", "batman");
        CustomFieldValue checkBoxCustomField = new CustomFieldValue(checkboxCfId, "multicheckboxes", "happy");
        CustomFieldValue textFieldCustomField = new CustomFieldValue(textfieldCfId, "textfield", "release 1");
        cfList.add(radioCustomField);
        cfList.add(selectCustomField);
        cfList.add(multiSelectCustomField);
        cfList.add(checkBoxCustomField);
        cfList.add(textFieldCustomField);
        String[] customFieldNames = new String[]{CUSTOM_FIELD_NAME_RADIO, CUSTOM_FIELD_NAME_SELECT, CUSTOM_FIELD_NAME_TEXT_FIELD, CUSTOM_FIELD_NAME_MULTI_CHECKBOX, CUSTOM_FIELD_NAME_MULTI_SELECT};
        this.addFieldsToFieldScreen("Default Screen", customFieldNames);
        int i = 0;
        for (String issue : issues) {
            TestFilterActions.log("editing issues to include custom fields for issue: " + issue);
            if (++i % 2 != 0) continue;
            this.editIssueWithCustomFields(issue, cfList);
        }
        this.removeFieldFromFieldScreen("Default Screen", customFieldNames);
        for (CustomFieldValue cfValue : cfList) {
            TestFilterActions.log("Checking portlets for " + cfValue.getCfType());
            this.createFilterWithFields(cfValue.getCfId(), cfValue.getCfValue(), cfValue.getCfType());
            this.sortIssues("issuekey", "ASC");
            this.assertIssuesPresent(10, 2);
        }
    }

    public void filterActionsPortletWithInvalidFilter() {
        TestFilterActions.log("Test for the appropriate error if the related filter of a portlet is removed");
        this.gotoIssue("");
        String filterId = Integer.toString(this.saveFilter(TEST_FILTER, ""));
        this.addPortlet("filterstats");
        this.setFormElement("filterid", filterId);
        this.submit("Save");
        this.clickLink("home_link");
        this.assertTextPresent("test filter</a>");
        this.deleteFilter(TEST_FILTER);
        this.clickLink("home_link");
        this.assertLinkNotPresentWithText("test filter</a>");
        this.assertTextPresent("This portlet is not valid as the associated filter or field could not be retrieved");
    }

    private void addColumnOrder(int filterId, String columnName, String columnVal) {
        this.gotoManageFilterColumnOrder(filterId);
        this.selectOption("fieldId", columnVal);
        this.submit("add");
        this.assertTextPresent(columnName);
    }

    private void configureColumnOrder(int filterId, String columnName, String operation) {
        this.gotoManageFilterColumnOrder(filterId);
        try {
            WebTable fieldTable = this.getDialog().getResponse().getTableWithID("issuetable");
            for (int i = 0; i < fieldTable.getColumnCount(); ++i) {
                String field = fieldTable.getCellAsText(0, i);
                if (field.indexOf(columnName) == -1) continue;
                TableCell linkCell = fieldTable.getTableCell(1, i);
                WebLink link = linkCell.getLinkWithImageText(operation);
                if (link == null) {
                    TestFilterActions.fail((String)("No link with image '" + operation + "'."));
                }
                link.click();
                return;
            }
            TestFilterActions.log("Field '" + columnName + "' not in table.");
        }
        catch (SAXException e) {
            TestFilterActions.fail((String)"Cannot find table with id 'issuetable'.");
        }
        catch (IOException e) {
            TestFilterActions.fail((String)("Could not click link with image '" + operation + "'."));
        }
    }

    public void gotoManageFilterColumnOrder(int filterId) {
        this.getNavigation().manageFilters().myFilters();
        this.clickLink("colOrder_" + filterId);
    }

    private void createFilterWithFields(String fieldId, String fieldValue, String fieldType) {
        this.clickLink("find_link");
        try {
            this.clickLink("new_filter");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if ("select".equals(fieldType)) {
            this.selectOption("customfield_" + fieldId, fieldValue);
            this.assertTextPresent(CUSTOM_FIELD_NAME_SELECT);
        } else if ("radiobuttons".equals(fieldType)) {
            this.getDialog().setFormParameter("customfield_" + fieldId, fieldValue);
            this.assertRadioOptionSelected("customfield_" + fieldId, fieldValue);
        } else if ("textfield".equals(fieldType)) {
            this.setFormElement("customfield_" + fieldId, fieldValue);
        } else if ("multiselect".equals(fieldType)) {
            this.selectOption("customfield_" + fieldId, fieldValue);
        } else if ("multicheckboxes".equals(fieldType)) {
            this.checkCheckbox("customfield_" + fieldId, fieldValue);
        }
        this.submit("show");
    }

    private void assertIssuesPresent(int numberOfIssues, int gap) {
        TestFilterActions.log("checking if all issues are present in filter");
        int i = 0;
        for (String issue : issues) {
            if (++i >= numberOfIssues || i % gap != 0) continue;
            this.assertLinkPresentWithText(issue);
        }
    }
}

