/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.filter;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.navigation.IssueNavigatorNavigation;
import com.atlassian.jira.functest.framework.navigator.IssueTypeCondition;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearch;
import com.atlassian.jira.functest.framework.navigator.NavigatorSearchBuilder;
import com.atlassian.jira.functest.framework.navigator.QuerySearchCondition;
import com.atlassian.jira.functest.framework.sharing.GlobalTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.GroupTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.ProjectTestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.SharedEntityInfo;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermission;
import com.atlassian.jira.functest.framework.sharing.TestSharingPermissionUtils;
import com.atlassian.jira.functest.framework.util.json.TestJSONException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TestEditFilterInvalidShares
extends FuncTestCase {
    private static final Pattern FILTER_PATTERN = Pattern.compile("requestId=(\\d+)");
    private static final String NO_SHARE_USER = "user_cant_share_filters";
    private static final String SHARE_USER = "user_can_share_filters";
    private static final int GROUP_FILTER_ID = 10020;
    private static final SharedEntityInfo GROUP_FILTER_INFO = new SharedEntityInfo("Group Removed Search", "A search where the group share will be removed.", true, null);
    private static final int PROJECT_FILTER_ID = 10021;
    private static final SharedEntityInfo PROJECT_FILTER_INFO = new SharedEntityInfo("Browse permission Removed", "A search where the browse permission has been removed.", true, null);
    private static final int ROLE_FILTER_ID = 10022;
    private static final SharedEntityInfo ROLE_FILTER_INFO = new SharedEntityInfo("Remove From Role Filter", null, true, null);
    private static final int REMOVE_FILTER_ID = 10023;
    private static final SharedEntityInfo REMOVE_FILTER_INFO = new SharedEntityInfo("Remove Share Permission", null, true, null);
    private static final int MULTIPLE_FILTER_ID = 10024;
    private static final SharedEntityInfo MULTIPLE_FILTER_INFO = new SharedEntityInfo("Multiple Invalid Shares", null, true, null);
    private static final NavigatorSearch SHARE_SEARCH;
    private static final NavigatorSearch NOSHARE_SEARCH;
    private static final GroupTestSharingPermission GROUP_SHARE;
    private static final String EDITSHARES_LINK_ID = "filtereditshares";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("sharedfilters/TestInvalidFilterSharing.xml");
    }

    public void testEditFilterRemoveGroup() {
        this.loginAsUser(SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10020L, null);
        this.tester.clickLink(EDITSHARES_LINK_ID);
        this.text.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Group\\: '.+'\\.");
        this.tester.submit("Save");
        this.text.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Group\\: '.+'\\.");
        this.assertEditScreenCorrect(GROUP_FILTER_INFO, Collections.singleton(new GroupTestSharingPermission("group_delete_me")));
        long id = this.editFilter(10020L, GROUP_FILTER_INFO, Collections.<TestSharingPermission>emptySet());
        TestEditFilterInvalidShares.assertEquals((long)10020L, (long)id);
        this.assertSearchEditCorrectly(GROUP_FILTER_INFO, SHARE_SEARCH, Collections.EMPTY_SET);
    }

    public void testEditFilterRemoveBrowse() {
        this.loginAsUser(SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10021L, null);
        this.tester.clickLink(EDITSHARES_LINK_ID);
        this.text.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project\\: '.+'\\.");
        this.tester.submit("Save");
        this.text.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project\\: '.+'\\.");
        this.assertEditScreenCorrect(PROJECT_FILTER_INFO, Collections.singleton(new ProjectTestSharingPermission(10002L)));
        Set<TestSharingPermission> pub = Collections.singleton(GlobalTestSharingPermission.GLOBAL_PERMISSION);
        long id = this.editFilter(10021L, PROJECT_FILTER_INFO, pub);
        TestEditFilterInvalidShares.assertEquals((long)10021L, (long)id);
        this.assertSearchEditCorrectly(PROJECT_FILTER_INFO, SHARE_SEARCH, pub);
    }

    public void testEditFilterRemoveRole() {
        HashSet<ProjectTestSharingPermission> rolePerms = new HashSet<ProjectTestSharingPermission>();
        rolePerms.add(new ProjectTestSharingPermission(10000L, 10002L));
        rolePerms.add(new ProjectTestSharingPermission(10000L, 10001L));
        this.loginAsUser(SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10022L, null);
        this.tester.clickLink(EDITSHARES_LINK_ID);
        this.text.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project\\: '.+'\\ Role\\: '.+'\\.");
        this.tester.submit("Save");
        this.text.assertRegexMatch(new WebPageLocator(this.tester), "You do not have permission to share with Project\\: '.+'\\ Role\\: '.+'\\.");
        this.assertEditScreenCorrect(ROLE_FILTER_INFO, rolePerms);
        Set<TestSharingPermission> shares = Collections.singleton(GROUP_SHARE);
        long id = this.editFilter(10022L, ROLE_FILTER_INFO, shares);
        TestEditFilterInvalidShares.assertEquals((long)10022L, (long)id);
        this.assertSearchEditCorrectly(ROLE_FILTER_INFO, SHARE_SEARCH, shares);
    }

    public void testEditFilterGlobalShareRemove() {
        this.loginAsUser(NO_SHARE_USER);
        this.navigation.issueNavigator().loadFilter(10023L, null);
        this.tester.clickLink(EDITSHARES_LINK_ID);
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share. All shares are invalid.");
        this.tester.submit("Save");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share. All shares are invalid.");
        this.assertEditScreenCorrect(REMOVE_FILTER_INFO, Collections.singleton(GlobalTestSharingPermission.GLOBAL_PERMISSION));
        long id = this.editFilter(10023L, REMOVE_FILTER_INFO, Collections.<TestSharingPermission>emptySet());
        TestEditFilterInvalidShares.assertEquals((long)10023L, (long)id);
        this.assertSearchEditCorrectly(REMOVE_FILTER_INFO, NOSHARE_SEARCH, null);
    }

    public void testEditFilterMultipleProblems() {
        this.loginAsUser(SHARE_USER);
        LinkedList<TestSharingPermission> shares = new LinkedList<TestSharingPermission>();
        shares.add(new GroupTestSharingPermission("group_delete_me"));
        shares.add(new ProjectTestSharingPermission(10000L, 10001L));
        shares.add(new ProjectTestSharingPermission(10000L));
        SharedEntityInfo testinfo = new SharedEntityInfo("testEditFilterMultipleProblems", "description", false, null);
        this.navigation.issueNavigator().loadFilter(10024L, null);
        this.tester.clickLink(EDITSHARES_LINK_ID);
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share");
        this.tester.submit("Save");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share");
        this.assertEditScreenCorrect(MULTIPLE_FILTER_INFO, new HashSet(shares));
        shares.remove(0);
        this.editFilterNoId(10024L, testinfo, new HashSet<TestSharingPermission>(shares));
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You do not have permission to share");
        this.assertEditScreenCorrect(testinfo, new HashSet(shares));
        shares.remove(0);
        long id = this.editFilter(10024L, MULTIPLE_FILTER_INFO, new HashSet<TestSharingPermission>(shares));
        TestEditFilterInvalidShares.assertEquals((long)10024L, (long)id);
        this.assertSearchEditCorrectly(MULTIPLE_FILTER_INFO, SHARE_SEARCH, new HashSet(shares));
    }

    private void loginAsUser(String user) {
        this.navigation.login(user, user);
    }

    private long editFilter(long id, String name, String description, boolean favourite, Set<TestSharingPermission> permissions) {
        this.editFilterNoId(id, name, description, favourite, permissions);
        return this.getFilterIdAfterEdit();
    }

    private long editFilter(long id, SharedEntityInfo info, Set<TestSharingPermission> permissions) {
        return this.editFilter(id, info.getName(), info.getDescription(), info.isFavourite(), permissions);
    }

    private void editFilterNoId(long id, SharedEntityInfo info, Set<TestSharingPermission> permissions) {
        this.editFilterNoId(id, info.getName(), info.getDescription(), info.isFavourite(), permissions);
    }

    private void editFilterNoId(long id, String name, String description, boolean favourite, Set<TestSharingPermission> permissions) {
        this.tester.gotoPage(this.createEditUrl(id, name, description, favourite, permissions));
    }

    private String createEditUrl(long id, String name, String description, boolean favourite, Set<TestSharingPermission> permissions) {
        StringBuffer buffer = new StringBuffer("secure/EditFilter.jspa?submit=Save&filterId=" + id);
        if (!StringUtils.isBlank((String)name)) {
            buffer.append("&filterName=").append(this.encode(name));
        }
        if (!StringUtils.isBlank((String)description)) {
            buffer.append("&filterDescription=").append(this.encode(description));
        }
        if (permissions != null) {
            buffer.append("&shareValues=").append(this.encode(TestSharingPermissionUtils.createJsonString(permissions)));
        }
        buffer.append("&favourite=").append(String.valueOf(favourite));
        return buffer.toString();
    }

    private String encode(String data) {
        try {
            return URLEncoder.encode(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private long getFilterIdAfterEdit() {
        URL url = this.tester.getDialog().getResponse().getURL();
        if (url.getQuery() == null) {
            TestEditFilterInvalidShares.fail((String)"Unable to save filter: Not redirected to navigator.");
        } else if (url.getPath() == null || !url.getPath().endsWith("IssueNavigator.jspa")) {
            TestEditFilterInvalidShares.fail((String)"Unable to save filter: Not redirected to navigator.");
        } else {
            Matcher matcher = FILTER_PATTERN.matcher(url.getQuery());
            if (matcher.find()) {
                return Long.parseLong(matcher.group(1));
            }
            TestEditFilterInvalidShares.fail((String)"Unable to save filter: Not redirected to navigator.");
        }
        return Long.MIN_VALUE;
    }

    private void assertSearchEditCorrectly(SharedEntityInfo info, NavigatorSearch expectedSearch, Set expectedPermissions) {
        this.navigation.issueNavigator().gotoEditMode(IssueNavigatorNavigation.NavigatorEditMode.SIMPLE);
        this.assertions.getIssueNavigatorAssertions().assertSimpleSearch(expectedSearch, this.tester);
        this.assertions.getIssueNavigatorAssertions().assertSearchInfo(info);
        this.tester.gotoPage("secure/EditFilter!default.jspa");
        TestEditFilterInvalidShares.assertEquals((String)"Expected and actual permissions did not match.", (Object)expectedPermissions, (Object)this.parsePermissions());
    }

    private void assertEditScreenCorrect(SharedEntityInfo expectedInfo, Set expectedPermissions) {
        this.tester.assertFormElementEquals("filterName", expectedInfo.getName());
        this.tester.assertFormElementEquals("filterDescription", expectedInfo.getDescription());
        this.tester.assertFormElementEquals("favourite", String.valueOf(expectedInfo.isFavourite()));
        TestEditFilterInvalidShares.assertEquals((Object)expectedPermissions, (Object)this.parsePermissions());
    }

    private Set parsePermissions() {
        XPathLocator xpath = new XPathLocator(this.tester, "//span[@id='shares_data']");
        String value = xpath.getText();
        try {
            return TestSharingPermissionUtils.parsePermissions(value);
        }
        catch (TestJSONException e) {
            TestEditFilterInvalidShares.fail((String)("Unable to parse shares: " + e.getMessage()));
            return null;
        }
    }

    static {
        GROUP_SHARE = new GroupTestSharingPermission("jira-users");
        NavigatorSearchBuilder builder = new NavigatorSearchBuilder();
        builder.addIssueType(IssueTypeCondition.IssueType.BUG).addIssueType(IssueTypeCondition.IssueType.IMPROVEMENT);
        builder.addQueryField(QuerySearchCondition.QueryField.COMMENTS).addQueryField(QuerySearchCondition.QueryField.DESCRIPTION);
        builder.addQueryField(QuerySearchCondition.QueryField.ENVIRONMENT).addQueryField(QuerySearchCondition.QueryField.SUMMARY);
        builder.addQueryString("SimpleTest");
        SHARE_SEARCH = builder.createSearch();
        builder = new NavigatorSearchBuilder();
        builder.addIssueType(IssueTypeCondition.IssueType.BUG).addProject("deleteme");
        NOSHARE_SEARCH = builder.createSearch();
    }
}

