/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;

public class TestUserSignup
extends EmailFuncTestCase {
    private static final String FULL_NAME = "full name";
    private static final String SECRET_PASSWORD = "secretpassword";
    private static final String USER1 = "user1";
    private static final String USER1_EMAIL = "user1@example.com";
    private static final String USER2 = "user2";
    private static final String USER2_EMAIL = "user2@example.org";

    public void testUserSignup() throws InterruptedException, MessagingException, IOException {
        this.administration.restoreBlankInstance();
        this.configureAndStartSmtpServer();
        this.signupAs(USER1, USER1_EMAIL);
        this.assertSignupEmail(this.flushAndGetLastMessage(1), USER1, USER1_EMAIL);
        this.signupAs(USER2, USER2_EMAIL);
        this.assertSignupEmail(this.flushAndGetLastMessage(2), USER2, USER2_EMAIL);
    }

    private MimeMessage flushAndGetLastMessage(int emailCount) throws InterruptedException {
        this.flushMailQueueAndWait(emailCount);
        MimeMessage[] messages = this.getGreenMail().getReceivedMessages();
        TestUserSignup.assertTrue((String)"We expect 1 email in the queue", (messages.length == emailCount ? 1 : 0) != 0);
        return messages[emailCount - 1];
    }

    private void assertSignupEmail(MimeMessage message, String userName, String emailAddress) throws MessagingException, IOException {
        String toAddr = message.getHeader("To", "XXX");
        String body = message.getContent().toString();
        this.text.assertTextSequence(toAddr, emailAddress, new String[0]);
        this.text.assertTextSequence(body, "Username:", userName);
        this.text.assertTextSequence(body, "Email:", emailAddress);
        this.text.assertTextSequence(body, "Full Name:", userName + FULL_NAME);
        this.text.assertTextNotPresent(body, SECRET_PASSWORD);
    }

    private void signupAs(String userName, String emailAddress) {
        this.tester.gotoPage("secure/Signup!default.jspa");
        this.tester.setFormElement("username", userName);
        this.tester.setFormElement("password", SECRET_PASSWORD);
        this.tester.setFormElement("confirm", SECRET_PASSWORD);
        this.tester.setFormElement("fullname", userName + FULL_NAME);
        this.tester.setFormElement("email", emailAddress);
        this.tester.submit();
        this.text.assertTextPresent(new WebPageLocator(this.tester), "You have successfully signed up. If you forget your password, you can have it emailed to you.");
        this.navigation.gotoPage("/");
    }
}

