/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.email;

import com.atlassian.jira.webtests.JIRAWebTest;
import java.util.HashMap;
import java.util.Map;

public class TestSendBulkMail
extends JIRAWebTest {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_FROM = "from";
    private static final String FIELD_PREFIX = "prefix";
    private static final String FIELD_SERVER_NAME = "serverName";
    private static final String FIELD_USERNAME = "username";
    private static final String FIELD_PASSWORD = "password";
    private static final String VALUE_NAME_SMTP = "name SMTP";
    private static final String VALUE_FROM = "from@atlassian.com";
    private static final String VALUE_PREFIX = "prefix";
    private static final String VALUE_SERVER_NAME = "server name";
    private static final String VALUE_USERNAME = "username";
    private static final String VALUE_PASSWORD = "password";
    private static final String LINK_TEXT_CONFIG_NEW_SMTP = "Configure new SMTP mail server";
    private static final String LINK_SUBJECT_GLOBAL_SETTINGS = "admin.globalsettings";
    private static final String LINK_PAGE_MAIL_SERVER = "mail_servers";
    private static final String BUTTON_ADD = " Add ";
    private static final String ADMINISTRATOR_ROLEID = "10002";
    private static final String DEVELOPER_ROLEID = "10001";
    private static final String USER_ROLEID = "10000";
    private static final String ADMINISTRATORS = "Administrators";
    private static final String DEVELOPERS = "Developers";
    private static final String USERS = "Users";
    private static final Map ROLE_TO_ID = new HashMap();
    private static final String TEST_ROLES_PROJECT = "Test Roles Project";
    private static final String TEST_ROLES_PROJECT_KEY = "admin";
    private static final String TEST_GROUP = "testGroup";

    public TestSendBulkMail(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
        this.clickOnAdminPanel(LINK_SUBJECT_GLOBAL_SETTINGS, LINK_PAGE_MAIL_SERVER);
        this.clickLinkWithText(LINK_TEXT_CONFIG_NEW_SMTP);
        this.setFormElement(FIELD_NAME, VALUE_NAME_SMTP);
        this.setFormElement(FIELD_FROM, VALUE_FROM);
        this.setFormElement("prefix", "prefix");
        this.setFormElement(FIELD_SERVER_NAME, VALUE_SERVER_NAME);
        this.setFormElement("username", "username");
        this.setFormElement("password", "password");
        this.submit(BUTTON_ADD);
    }

    @Override
    public void tearDown() {
        this.restoreBlankInstance();
        super.tearDown();
    }

    public void testRolesSelectedAsDefault() {
        this.gotoSendBulkMail();
        this.assertRadioOptionSelected("sendToRoles", "true");
    }

    public void testErrors() {
        String projId = this.addProject(TEST_ROLES_PROJECT, TEST_ROLES_PROJECT_KEY, "", TEST_ROLES_PROJECT_KEY, "");
        this.createUserAndAddToRole("bob", TEST_ROLES_PROJECT, projId, DEVELOPERS);
        this.gotoSendBulkMail();
        this.setFormElement("replyTo", "TEST@TEST.NET");
        this.setFormElement("subject", "TEST");
        this.setFormElement("message", "TEST");
        this.submit("Send");
        this.assertTextPresent("Please select at least one project and one role.");
        this.selectOption("projects", "homosapien");
        this.submit("Send");
        this.assertTextPresent("Please select at least one role.");
        this.gotoSendBulkMail();
        this.selectOption("roles", ADMINISTRATORS);
        this.submit("Send");
        this.assertTextPresent("Please select at least one project.");
        this.selectOption("projects", "homosapien");
        this.submit("Send");
        this.assertTextPresent("The chosen project/role combination(s) have no members.");
        this.createGroup(TEST_GROUP);
        this.gotoSendBulkMail();
        this.selectRadioButton("sendToRoles", "false");
        this.setFormElement("replyTo", "TEST@TEST.NET");
        this.setFormElement("subject", "TEST");
        this.setFormElement("message", "TEST");
        this.submit("Send");
        this.assertTextPresent("Please select at least one group.");
        this.selectOption("groups", TEST_GROUP);
        this.submit("Send");
        this.assertTextPresent("The chosen group(s) have no members.");
        this.gotoSendBulkMail();
        this.selectOption("projects", "homosapien");
        this.selectOption("roles", ADMINISTRATORS);
        this.setFormElement("replyTo", "not a valid e-mail address");
        this.submit("Send");
        this.assertTextPresent("Invalid email address format.");
        this.assertTextPresent("Please specify a subject.");
        this.assertTextPresent("Please provide a message body.");
    }

    private void createUserAndAddToRole(String username, String projectname, String projId, String role) {
        this.addUser(username, username, username, username + "@atlassian.com");
        this.navigateToUser(username);
        this.clickLink("viewprojectroles_link");
        this.clickLinkWithText("Edit Project Roles");
        if (this.getDialog().isLinkPresent(projectname)) {
            this.clickLinkWithText(projectname);
        }
        String targetCheckboxId = projId + "_" + ROLE_TO_ID.get(role);
        this.checkCheckbox(targetCheckboxId, "on");
        this.submit("Save");
    }

    private void gotoSendBulkMail() {
        this.gotoAdmin();
        this.clickLink("send_email");
    }

    private void selectRadioButton(String groupName, String value) {
        this.checkCheckbox(groupName, value);
    }

    static {
        ROLE_TO_ID.put(ADMINISTRATORS, ADMINISTRATOR_ROLEID);
        ROLE_TO_ID.put(DEVELOPERS, DEVELOPER_ROLEID);
        ROLE_TO_ID.put(USERS, USER_ROLEID);
    }
}

