/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.dashboard.reports;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebImage;
import com.meterware.httpunit.WebTable;
import org.xml.sax.SAXException;

public class TestSingleLevelGroupByReport
extends FuncTestCase {
    public void testRunReportLoggedIn() {
        this.administration.restoreData("TestFullAnonymousPermissions.xml");
        this.navigation.login("admin", "admin");
        this.runReport();
    }

    public void testRunReportAnonymously() {
        this.administration.restoreData("TestFullAnonymousPermissions.xml");
        this.navigation.logout();
        this.tester.clickLinkWithText("Log in again.");
        this.runReport();
    }

    public void runReport() {
        this.navigation.runReport(10000L, "com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.text.assertTextPresent("Select a filter to display");
        this.text.assertTextPresent("Select a field to group by");
        this.tester.setFormElement("filterid", "10000");
        this.tester.submit("Next");
        this.text.assertTextPresent("Single Level Group By Report");
        this.text.assertTextPresent("MKY-2");
        this.text.assertTextPresent("MKY-1");
        this.text.assertTextPresent("0 of 2 issues have been resolved");
    }

    public void testVersionIsEncoded() {
        this.administration.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.text.assertTextPresent("&quot;version&lt;input &gt;");
        this.text.assertTextNotPresent("\"version<input >");
    }

    public void testFieldVisibility() {
        this.administration.restoreData("TestVersionAndComponentsWithHTMLNames.xml");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, true);
        this.gotoFieldConfigurationDefault();
        this.tester.clickLink("hide_12");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(false, true);
        this.gotoFieldConfigurationDefault();
        this.tester.clickLink("hide_14");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(false, false);
        this.gotoFieldConfigurationDefault();
        this.tester.clickLink("show_12");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, false);
        this.gotoFieldConfigurationDefault();
        this.tester.clickLink("show_14");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisible(true, true);
        this.createIssueStep1("homosapien", "Improvement");
        this.tester.setFormElement("summary", "This is a test to see if field is shown");
        this.tester.submit();
        this.navigation.gotoAdmin();
        this.tester.clickLink("field_configuration");
        this.tester.setFormElement("fieldLayoutName", "Many Hidden Fields");
        this.tester.submit("Add");
        this.tester.clickLink("configure-Many Hidden Fields");
        this.tester.clickLink("hide_4");
        this.tester.clickLink("hide_8");
        this.tester.clickLink("hide_12");
        this.tester.clickLink("hide_14");
        this.tester.clickLink("issue_fields");
        this.tester.setFormElement("fieldLayoutSchemeName", "All Fields Hidden Scheme");
        this.tester.submit("Add");
        this.tester.clickLinkWithText("Configure");
        this.tester.selectOption("issueTypeId", "Bug");
        this.tester.selectOption("fieldConfigurationId", "Many Hidden Fields");
        this.tester.submit("Add");
        this.tester.clickLink("view_projects");
        this.tester.clickLinkWithText("homosapien");
        this.tester.clickLink("select_fieldlayoutscheme");
        this.tester.selectOption("schemeId", "All Fields Hidden Scheme");
        this.tester.submit("Associate");
        this.gotoSinglelevelGroupByReportAllFixForVersions();
        this.assertFieldsVisibleEnt();
    }

    public void testFilterIdRequired() {
        this.administration.restoreBlankInstance();
        this.navigation.runReport(10000L, "com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.tester.submit("Next");
        this.text.assertTextPresent("Filter is a required field");
    }

    private void gotoSinglelevelGroupByReportAllFixForVersions() {
        this.navigation.runReport(10000L, "com.atlassian.jira.plugin.system.reports:singlelevelgroupby");
        this.tester.setFormElement("filterid", "10000");
        this.tester.selectOption("mapper", "Fix For Versions (all)");
        this.tester.submit("Next");
    }

    private void assertFieldsVisibleEnt() {
        try {
            WebTable table = this.tester.getDialog().getResponse().getTableWithID("single_groupby_report_table");
            int rowCount = table.getRowCount();
            TestSingleLevelGroupByReport.assertEquals((int)9, (int)rowCount);
            for (int i = 2; i < rowCount; i += 2) {
                TableCell priorityCell = table.getTableCell(i, 5);
                if (i == 8) {
                    this.assertTableCellContainsPriorityIcon(priorityCell);
                } else {
                    this.assertTableCellContainsNoPriorityIcon(priorityCell);
                }
                TableCell resolutioCell = table.getTableCell(i, 3);
                if (i == 8) {
                    TestSingleLevelGroupByReport.assertTrue((resolutioCell.asText().indexOf("Unresolved") >= 0 ? 1 : 0) != 0);
                    continue;
                }
                TestSingleLevelGroupByReport.assertFalse((resolutioCell.asText().indexOf("Unresolved") >= 0 ? 1 : 0) != 0);
            }
        }
        catch (SAXException e) {
            TestSingleLevelGroupByReport.fail((String)("SAX Exception:" + e.getMessage()));
        }
    }

    private void assertFieldsVisible(boolean priorityVisible, boolean resolutionVisible) {
        try {
            WebTable table = this.tester.getDialog().getResponse().getTableWithID("single_groupby_report_table");
            int rowCount = table.getRowCount();
            TestSingleLevelGroupByReport.assertEquals((int)7, (int)rowCount);
            for (int i = 2; i < rowCount; i += 2) {
                TableCell priorityCell = table.getTableCell(i, 5);
                if (priorityVisible) {
                    this.assertTableCellContainsPriorityIcon(priorityCell);
                } else {
                    this.assertTableCellContainsNoPriorityIcon(priorityCell);
                }
                TableCell resolutioCell = table.getTableCell(i, 3);
                if (resolutionVisible) {
                    TestSingleLevelGroupByReport.assertTrue((resolutioCell.asText().indexOf("Unresolved") >= 0 ? 1 : 0) != 0);
                    continue;
                }
                TestSingleLevelGroupByReport.assertFalse((resolutioCell.asText().indexOf("Unresolved") >= 0 ? 1 : 0) != 0);
            }
        }
        catch (SAXException e) {
            TestSingleLevelGroupByReport.fail((String)("SAX Exception:" + e.getMessage()));
        }
    }

    private void gotoFieldConfigurationDefault() {
        this.navigation.gotoAdminSection("field_configuration");
        this.tester.clickLink("configure-Default Field Configuration");
        this.text.assertTextPresent("View Field Configuration");
    }

    private void createIssueStep1(String project, String issueType) {
        this.tester.clickLink("create_link");
        this.text.assertTextPresent("Create Issue");
        this.tester.selectOption("pid", project);
        this.tester.selectOption("issuetype", issueType);
        this.tester.setWorkingForm("issue-create");
        this.tester.submit();
        this.text.assertTextPresent("CreateIssueDetails.jspa");
    }

    private void assertTableCellContainsPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        TestSingleLevelGroupByReport.assertNotNull((Object)images);
        TestSingleLevelGroupByReport.assertEquals((int)1, (int)images.length);
        WebImage icon = images[0];
        TestSingleLevelGroupByReport.assertTrue((icon.getSource().indexOf("/images/icons") >= 0 ? 1 : 0) != 0);
    }

    private void assertTableCellContainsNoPriorityIcon(TableCell tableCell) {
        WebImage[] images = tableCell.getImages();
        TestSingleLevelGroupByReport.assertTrue((images == null || images.length == 0 ? 1 : 0) != 0);
    }
}

